/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.localsvc;

import com.sas.batch.core.DateParser;
import com.sas.batch.localsvc.RB;
import com.sas.services.information.search.DateFilter;
import com.sas.services.information.search.ExtendedAttributesFilter;
import com.sas.services.information.search.KeywordFilter;
import com.sas.services.information.search.NotesFilter;
import com.sas.services.information.search.ObjectNameFilter;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.ResponsibilitiesFilter;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchOperator;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class FilterOptions {
    private static final String NEW_LINE = "\r\n";
    public static final String OPTION_FOLDER = "folder";
    public static final String OPTION_FOLDER_TREE = "folderTree";
    public static final String OPTION_TYPES = "types";
    public static final String OPTION_EXCLUDE_SUBTYPES = "excludeSubTypes";
    public static final String OPTION_NAME = "name";
    public static final String OPTION_NAME_MATCH_TYPE = "nameMatchType";
    public static final String OPTION_INCLUDE_DESCRIPTION = "includeDesc";
    public static final String OPTION_CREATED_DATE = "created";
    public static final String OPTION_MODIFIED_DATE = "modified";
    public static final String OPTION_SINCE_DATE = "since";
    public static final String OPTION_BEFORE_DATE = "before";
    public static final String OPTION_KEYWORDS = "keywords";
    public static final String OPTION_NOTES = "notes";
    public static final String OPTION_EXTENSIONS_NAME = "extName";
    public static final String OPTION_EXTENSIONS_VALUE = "extValue";
    public static final String OPTION_RESP_USERNAME = "respName";
    public static final String OPTION_RESP_ROLE = "respRole";
    private List<SearchFilter> filters;
    private String filterFolder;
    private String filterFolderTree;

    public void addFilter(SearchFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<SearchFilter>(2);
        }
        this.filters.add(filter);
    }

    public List<SearchFilter> getFilters() {
        if (this.filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.filters);
    }

    public void setFilterFolder(String folderName) {
        this.filterFolder = folderName;
    }

    public String getFilterFolder() {
        return this.filterFolder;
    }

    public void setFilterFolderTree(String folderName) {
        this.filterFolderTree = folderName;
    }

    public String getFilterFolderTree() {
        return this.filterFolderTree;
    }

    public void addToOptions(Options options) {
        Option option = new Option(OPTION_FOLDER, true, RB.getStringResource("FilterOptions.Folder.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.Folder.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_FOLDER_TREE, true, RB.getStringResource("FilterOptions.FolderTree.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.FolderTree.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_TYPES, true, RB.getStringResource("FilterOptions.Types.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.Types.ArgName.txt"));
        option.setArgs(-2);
        options.addOption(option);
        option = new Option(OPTION_EXCLUDE_SUBTYPES, RB.getStringResource("FilterOptions.ExcludeSubTypes.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_NAME, true, RB.getStringResource("FilterOptions.Name.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.Name.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_NAME_MATCH_TYPE, true, RB.getStringResource("FilterOptions.NameMatchType.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.NameMatchType.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_INCLUDE_DESCRIPTION, RB.getStringResource("FilterOptions.IncludeDescription.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_CREATED_DATE, RB.getStringResource("FilterOptions.CreatedDate.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_MODIFIED_DATE, RB.getStringResource("FilterOptions.ModifiedDate.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_SINCE_DATE, true, FilterOptions.getSinceDateDescriptor());
        option.setArgName(RB.getStringResource("FilterOptions.SinceDate.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_BEFORE_DATE, true, RB.getStringResource("FilterOptions.BeforeDate.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.BeforeDate.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_KEYWORDS, true, RB.getStringResource("FilterOptions.Keywords.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.Keywords.ArgName.txt"));
        option.setArgs(-2);
        options.addOption(option);
        option = new Option(OPTION_NOTES, true, RB.getStringResource("FilterOptions.Notes.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.Notes.ArgName.txt"));
        option.setArgs(-2);
        options.addOption(option);
        option = new Option(OPTION_EXTENSIONS_NAME, true, RB.getStringResource("FilterOptions.ExtensionsName.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.ExtensionsName.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_EXTENSIONS_VALUE, true, RB.getStringResource("FilterOptions.ExtensionsValue.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.ExtensionsValue.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_RESP_USERNAME, true, RB.getStringResource("FilterOptions.RespName.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.RespName.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_RESP_ROLE, true, RB.getStringResource("FilterOptions.RespRole.Desc.txt"));
        option.setArgName(RB.getStringResource("FilterOptions.RespRole.ArgName.txt"));
        options.addOption(option);
    }

    public void parse(CommandLine commandLine) {
        String[] notes;
        String[] keywords;
        String name;
        String[] types;
        if (commandLine.hasOption(OPTION_FOLDER)) {
            this.filterFolder = commandLine.getOptionValue(OPTION_FOLDER);
        }
        if (commandLine.hasOption(OPTION_FOLDER_TREE)) {
            this.filterFolderTree = commandLine.getOptionValue(OPTION_FOLDER_TREE);
        }
        if ((types = commandLine.getOptionValues(OPTION_TYPES)) != null && types.length > 0) {
            this.addFilter((SearchFilter)new PublicTypeFilter(Arrays.asList(types), !commandLine.hasOption(OPTION_EXCLUDE_SUBTYPES)));
        }
        String sinceDate = commandLine.getOptionValue(OPTION_SINCE_DATE);
        String beforeDate = commandLine.getOptionValue(OPTION_BEFORE_DATE);
        if (sinceDate != null || beforeDate != null) {
            DateFilter filter;
            boolean createdDate = commandLine.hasOption(OPTION_CREATED_DATE);
            boolean modifiedDate = commandLine.hasOption(OPTION_MODIFIED_DATE);
            if (modifiedDate || !modifiedDate && !createdDate) {
                filter = FilterOptions.createDateFilter(DateFilter.DateType.MODIFIED_DATE, sinceDate, beforeDate);
                this.addFilter((SearchFilter)filter);
            } else if (createdDate) {
                filter = FilterOptions.createDateFilter(DateFilter.DateType.CREATED_DATE, sinceDate, beforeDate);
                this.addFilter((SearchFilter)filter);
            }
        }
        if ((name = commandLine.getOptionValue(OPTION_NAME)) != null && name.length() > 0) {
            boolean includeDescription = commandLine.hasOption(OPTION_INCLUDE_DESCRIPTION);
            SearchOperator operator = null;
            String operatorValue = commandLine.getOptionValue(OPTION_NAME_MATCH_TYPE);
            if (operatorValue != null && operatorValue.length() > 0) {
                operator = SearchOperator.getSearchOperatorForValue((String)operatorValue);
            }
            if (operator == null) {
                operator = ObjectNameFilter.getDefaultOperator();
            }
            this.addFilter((SearchFilter)new ObjectNameFilter(name, includeDescription, operator));
        }
        if ((keywords = commandLine.getOptionValues(OPTION_KEYWORDS)) != null && keywords.length > 0) {
            this.addFilter((SearchFilter)new KeywordFilter(Arrays.asList(keywords)));
        }
        if ((notes = commandLine.getOptionValues(OPTION_NOTES)) != null && notes.length > 0) {
            this.addFilter((SearchFilter)new NotesFilter(Arrays.asList(notes)));
        }
        String extName = commandLine.getOptionValue(OPTION_EXTENSIONS_NAME);
        String value = commandLine.getOptionValue(OPTION_EXTENSIONS_VALUE);
        if (extName != null && extName.length() > 0) {
            HashMap<String, String> attrs = new HashMap<String, String>(1);
            attrs.put(extName, value);
            this.addFilter((SearchFilter)new ExtendedAttributesFilter(attrs));
        } else if (value != null && value.length() > 0) {
            throw new IllegalArgumentException(RB.getStringResource("FilterOptions.NoExtAttrName.txt"));
        }
        String respUserName = commandLine.getOptionValue(OPTION_RESP_USERNAME);
        String role = commandLine.getOptionValue(OPTION_RESP_ROLE);
        if (respUserName != null && respUserName.length() > 0) {
            this.addFilter((SearchFilter)new ResponsibilitiesFilter(respUserName, role));
        } else if (role != null && role.length() > 0) {
            throw new IllegalArgumentException(RB.getStringResource("FilterOptions.NoRespUserName.txt"));
        }
    }

    private static String getSinceDateDescriptor() {
        DateParser parser = DateParser.getInstance();
        String[] absoluteDatePatterns = parser.getAbsoluteDatePatterns();
        String[] relativeDatePatterns = parser.getRelativeDatePatterns();
        String dateInfo = Message.format((ResourceBundle)RB.getResources(), (String)"FilterOptions.DateInfo.fmt.txt", (Object)FilterOptions.getDisplayTextForPatterns(absoluteDatePatterns), (Object)FilterOptions.getDisplayTextForPatterns(relativeDatePatterns));
        StringBuffer desc = new StringBuffer();
        desc.append(RB.getStringResource("FilterOptions.SinceDate.Desc.txt"));
        desc.append(NEW_LINE).append(dateInfo);
        return desc.toString();
    }

    private static String getDisplayTextForPatterns(String[] patterns) {
        StringBuffer sb = new StringBuffer();
        if (patterns != null && patterns.length > 0) {
            sb.append(NEW_LINE);
            int length = patterns.length;
            for (int i = 0; i < length; ++i) {
                sb.append("\"").append(patterns[i]).append("\"");
                if (i == length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    private static DateFilter createDateFilter(DateFilter.DateType type, String sinceDate, String beforeDate) throws IllegalArgumentException {
        DateParser parser = DateParser.getInstance();
        Date beginDate = parser.parseDate(sinceDate);
        Date endDate = parser.parseDate(beforeDate);
        if (beginDate != null && endDate != null && endDate.before(beginDate)) {
            throw new IllegalArgumentException(RB.getStringResource("FilterOptions.InvalidDateRange.txt"));
        }
        return new DateFilter(type, beginDate, endDate);
    }
}

