/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.policy.builders;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.rampart.policy.builders.OptimizePartsBuilder;
import org.apache.rampart.policy.builders.SSLConfigBuilder;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.OptimizePartsConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.policy.model.SSLConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RampartConfigBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        RampartConfig rampartConfig = new RampartConfig();
        OMElement childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "user"));
        if (childElement != null) {
            rampartConfig.setUser(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "userCertAlias"))) != null) {
            rampartConfig.setUserCertAlias(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "encryptionUser"))) != null) {
            rampartConfig.setEncryptionUser(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "stsAlias"))) != null) {
            rampartConfig.setStsAlias(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "passwordCallbackClass"))) != null) {
            rampartConfig.setPwCbClass(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "policyValidatorCbClass"))) != null) {
            rampartConfig.setPolicyValidatorCbClass(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "rampartConfigCallbackClass"))) != null) {
            rampartConfig.setRampartConfigCbClass(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "sslConfig"))) != null) {
            SSLConfig sslConfig = (SSLConfig)new SSLConfigBuilder().build(childElement, factory);
            rampartConfig.setSSLConfig(sslConfig);
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "signatureCrypto"))) != null) {
            rampartConfig.setSigCryptoConfig((CryptoConfig)factory.build((Object)childElement.getFirstElement()));
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "encryptionCrypto"))) != null) {
            rampartConfig.setEncrCryptoConfig((CryptoConfig)factory.build((Object)childElement.getFirstElement()));
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "decryptionCrypto"))) != null) {
            rampartConfig.setDecCryptoConfig((CryptoConfig)factory.build((Object)childElement.getFirstElement()));
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "stsCrypto"))) != null) {
            rampartConfig.setStsCryptoConfig((CryptoConfig)factory.build((Object)childElement.getFirstElement()));
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "timestampPrecisionInMilliseconds"))) != null) {
            rampartConfig.setTimestampPrecisionInMilliseconds(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "timestampTTL"))) != null) {
            rampartConfig.setTimestampTTL(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "timestampMaxSkew"))) != null) {
            rampartConfig.setTimestampMaxSkew(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "nonceLifeTime"))) != null) {
            rampartConfig.setNonceLifeTime(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "tokenStoreClass"))) != null) {
            rampartConfig.setTokenStoreClass(childElement.getText().trim());
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "optimizeParts"))) != null) {
            OptimizePartsConfig config = (OptimizePartsConfig)new OptimizePartsBuilder().build(childElement, factory);
            rampartConfig.setOptimizeParts(config);
        }
        if ((childElement = element.getFirstChildWithName(new QName("http://ws.apache.org/rampart/policy", "timestampStrict"))) != null) {
            rampartConfig.setTimeStampStrict(childElement.getText().trim());
        }
        return rampartConfig;
    }

    public QName[] getKnownElements() {
        return new QName[]{new QName("http://ws.apache.org/rampart/policy", "RampartConfig")};
    }
}

