/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.internal.inet.LocalHostUtil;

public class LocatorConfigurationParser {
    public static List<HostAndPort> parseLocators(String locatorsString, String bindAddress) throws MembershipConfigurationException {
        InetAddress addr = null;
        try {
            addr = bindAddress == null || bindAddress.trim().length() == 0 ? LocalHostUtil.getLocalHost() : InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return LocatorConfigurationParser.parseLocators(locatorsString, addr);
    }

    public static List<HostAndPort> parseLocators(String locatorsString, InetAddress bindAddress) throws MembershipConfigurationException {
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>(2);
        HashSet<InetSocketAddress> inetAddresses = new HashSet<InetSocketAddress>();
        boolean isLoopback = bindAddress != null && bindAddress.isLoopbackAddress();
        StringTokenizer parts = new StringTokenizer(locatorsString, ",");
        while (parts.hasMoreTokens()) {
            String str = parts.nextToken();
            HostAndPort hostAndPort = LocatorConfigurationParser.parseLocator(str);
            String host = hostAndPort.getHostName();
            InetSocketAddress isa = new InetSocketAddress(host, hostAndPort.getPort());
            if (isLoopback) {
                InetAddress locatorAddress = isa.getAddress();
                if (locatorAddress == null) {
                    throw new MembershipConfigurationException("This process is attempting to use a locator at an unknown address or FQDN: " + host);
                }
                if (!locatorAddress.isLoopbackAddress()) {
                    throw new MembershipConfigurationException("This process is attempting to join with a loopback address (" + String.valueOf(bindAddress) + ") using a locator that does not have a local address (" + String.valueOf(isa) + ").  On Unix this usually means that /etc/hosts is misconfigured.");
                }
            }
            if (inetAddresses.contains(isa)) continue;
            inetAddresses.add(isa);
            result.add(hostAndPort);
        }
        return result;
    }

    public static HostAndPort parseLocator(String locatorHostAndPort) throws MembershipConfigurationException {
        int port;
        String start;
        int portSpecificationStart = locatorHostAndPort.indexOf(91);
        if (portSpecificationStart == -1) {
            throw LocatorConfigurationParser.createBadPortException(locatorHostAndPort);
        }
        String host = locatorHostAndPort.substring(0, portSpecificationStart);
        int idx = host.lastIndexOf(64);
        if (idx < 0) {
            idx = host.lastIndexOf(58);
        }
        if ((start = host.substring(0, idx > -1 ? idx : host.length())).indexOf(58) >= 0) {
            idx = host.lastIndexOf(64);
        }
        if (idx >= 0) {
            host = host.substring(idx + 1);
        }
        int startIdx = portSpecificationStart + 1;
        int endIdx = locatorHostAndPort.indexOf(93);
        if (endIdx == -1) {
            throw LocatorConfigurationParser.createBadPortException(locatorHostAndPort);
        }
        try {
            port = Integer.parseInt(locatorHostAndPort.substring(startIdx, endIdx));
        }
        catch (NumberFormatException e) {
            throw LocatorConfigurationParser.createBadPortException(locatorHostAndPort);
        }
        return new HostAndPort(host, port);
    }

    private static MembershipConfigurationException createBadPortException(String str) {
        return new MembershipConfigurationException("This process is attempting to use a locator with a malformed port specification: " + str);
    }
}

