/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.ColorParse;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class TextParser
implements ElementParserInterface {
    TextStyleInterface instance;

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        if (instance != null && instance instanceof TextStyleInterface) {
            this.instance = (TextStyleInterface)instance;
        }
        this.instance = TextParser.parseTextElement(element, this.instance);
        return this.instance;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return this.putToXML(context, instance, null, "Text");
    }

    public Element putToXML(Hashtable context, Object instance, String tagName) {
        return this.putToXML(context, instance, null, tagName);
    }

    public Element putToXML(Hashtable context, Object instance, Element element) {
        return this.putToXML(context, instance, element, "Text");
    }

    public Element putToXML(Hashtable context, Object instance, Element element, String tagName) {
        Object textValue;
        Object color;
        Object o;
        Element rc;
        PropertyInterface text = null;
        if (!(instance instanceof PropertyInterface)) {
            return null;
        }
        text = (PropertyInterface)instance;
        if (tagName == null) {
            tagName = "Text";
        }
        if ((rc = element) == null) {
            rc = ParserUtils.newElement((Hashtable)context, (String)tagName);
        }
        Object obj = text.getPropertyValue(9002);
        Font f = null;
        if (obj instanceof Font) {
            f = (Font)obj;
        }
        if (f != null && text.hasUserSetValue(9002)) {
            if (f.isItalic()) {
                rc.setAttribute("fontStyle", "italic");
            }
            if (f.isBold()) {
                rc.setAttribute("fontWeight", "bold");
            }
            rc.setAttribute("fontFamily", f.getFamily());
            rc.setAttribute("fontSize", f.getSize() + "pt");
        }
        if ((o = text.getPropertyValue(9009)) != null && o instanceof Boolean && ((Boolean)o).booleanValue() && text.hasUserSetValue(9009)) {
            rc.setAttribute("textDecoration", "underline");
        }
        if ((o = text.getPropertyValue(9010)) != null && o instanceof Boolean && ((Boolean)o).booleanValue() && text.hasUserSetValue(9010)) {
            if (rc.hasAttribute("textDecoration")) {
                rc.setAttribute("textDecoration", rc.getAttribute("textDecoration") + ",line-through");
            } else {
                rc.setAttribute("textDecoration", "line-through");
            }
        }
        if (text.hasUserSetValue(9001) && (color = text.getPropertyValue(9001)) instanceof Color) {
            rc.setAttribute("textColor", ColorParse.getColorStrg((Color)((Color)color), (boolean)false));
        }
        if (text.hasUserSetValue(9006) && (obj = text.getPropertyValue(9006)) instanceof Number) {
            int hjust = ((Number)obj).intValue();
            String horizJ = "None";
            if (hjust == 1) {
                horizJ = "Left";
            } else if (hjust == 0) {
                horizJ = "Center";
            } else if (hjust == 2) {
                horizJ = "Right";
            }
            rc.setAttribute("textAlign", horizJ);
        }
        if (text.hasUserSetValue(9007) && (obj = text.getPropertyValue(9007)) instanceof Number) {
            int vjust = ((Number)obj).intValue();
            String vertJ = "None";
            if (vjust == 4) {
                vertJ = "Top";
            } else if (vjust == 0) {
                vertJ = "Middle";
            } else if (vjust == 8) {
                vertJ = "Bottom";
            }
            rc.setAttribute("verticalAlign", vertJ);
        }
        if (text.hasUserSetValue(9003)) {
            rc.setAttribute("textDropShadowEnabled", text.getPropertyValue(9003) + "");
        }
        if (text.hasUserSetValue(9005) && (color = text.getPropertyValue(9005)) instanceof Color) {
            rc.setAttribute("textDropShadowColor", ColorParse.getColorStrg((Color)((Color)color), (boolean)false));
        }
        if (text.hasUserSetValue(9004)) {
            rc.setAttribute("textDropShadowSoftnesss", text.getPropertyValue(9004) + "");
        }
        if (text.hasUserSetValue(9017)) {
            rc.setAttribute("textDropShadowOffset", text.getPropertyValue(9017) + "");
        }
        if (text.hasUserSetValue(9000)) {
            rc.setAttribute("textVisible", text.getPropertyValue(9000) + "");
        }
        SASFormat fmt = null;
        o = text.getPropertyValue(9008);
        if (o != null && o instanceof SASFormat) {
            fmt = (SASFormat)o;
        }
        if (fmt != null && text.hasUserSetValue(9008)) {
            rc.setAttribute("SASFormat", fmt.getName());
        }
        if (text.hasUserSetValue(9015) && (textValue = text.getPropertyValue(9015)) != null && textValue.toString().trim().length() > 0) {
            rc.appendChild(ParserUtils.newTextNode((Hashtable)context, (String)ParserUtils.buildValidXMLString((String)text.getPropertyValue(9015).toString())));
        }
        if (rc.getAttributes().getLength() == 0 && rc.getChildNodes().getLength() == 0) {
            return null;
        }
        return rc;
    }

    public Object getObject() {
        return this.instance;
    }

    public static TextStyleInterface parseTextElement(Element element) {
        return TextParser.parseTextElement(element, new Text());
    }

    public static TextStyleInterface parseTextElement(Element element, TextStyleInterface textIn) {
        String textVisible;
        String textDropShadowOffset;
        String textDropShadowSoftness;
        String textDropShadowColor;
        String verticalAlign;
        int len;
        String text;
        String elemText;
        TextStyleInterface rc = new Text();
        if (textIn != null) {
            rc = textIn;
        }
        if ((elemText = ParserUtils.getElementText((Element)element)) != null && elemText.length() > 0 && (text = ParserUtils.convertValidXMLString((String)elemText)) != null) {
            rc.setText(text.trim());
        }
        String fontStyle = null;
        if (element.hasAttribute("style")) {
            fontStyle = element.getAttribute("style");
        } else if (element.hasAttribute("fontStyle")) {
            fontStyle = element.getAttribute("fontStyle");
        }
        String fontWeight = null;
        if (element.hasAttribute("weight")) {
            fontWeight = element.getAttribute("weight");
        } else if (element.hasAttribute("fontWeight")) {
            fontWeight = element.getAttribute("fontWeight");
        }
        String fontFamily = null;
        if (element.hasAttribute("family")) {
            fontFamily = element.getAttribute("family");
        } else if (element.hasAttribute("fontFamily")) {
            fontFamily = element.getAttribute("fontFamily");
        }
        String fontSize = null;
        if (element.hasAttribute("size")) {
            fontSize = element.getAttribute("size");
        } else if (element.hasAttribute("fontSize")) {
            fontSize = element.getAttribute("fontSize");
        }
        boolean defaultFont = true;
        String fmtName = element.getAttribute("SASFormat");
        SASFormat fmt = null;
        if (fmtName != null && fmtName.length() > 0) {
            fmt = SASFormat.getInstance((String)fmtName);
        }
        if (fmt != null) {
            textIn.setFormat(fmt);
        }
        int style = 0;
        if (fontStyle != null && fontStyle.equalsIgnoreCase("italic")) {
            style += 2;
            defaultFont = false;
        }
        if (fontWeight != null && fontWeight.toLowerCase().indexOf("bold") >= 0) {
            ++style;
            defaultFont = false;
        }
        int size = rc.getFont().getSize();
        int n = len = fontSize == null ? 0 : fontSize.trim().length();
        if (fontSize != null && len > 0) {
            if (fontSize.endsWith("pt")) {
                fontSize = fontSize.substring(0, fontSize.indexOf("pt"));
            }
            size = ParserUtils.getIntValue((String)fontSize);
            defaultFont = false;
        }
        if (fontFamily == null || fontFamily.length() == 0) {
            fontFamily = rc.getFont().getName();
        } else {
            defaultFont = false;
        }
        Font font = FontManager.getFont((String)fontFamily, (int)style, (int)size);
        if (!defaultFont) {
            rc.setFont(font);
        }
        String textColor = null;
        if (element.hasAttribute("color")) {
            textColor = element.getAttribute("color");
        } else if (element.hasAttribute("textColor")) {
            textColor = element.getAttribute("textColor");
        }
        if (textColor != null && textColor.length() > 0) {
            rc.setColor(ColorParse.getColorFromString((String)textColor));
        }
        if (rc instanceof PropertyInterface) {
            PropertyInterface prop = (PropertyInterface)rc;
            String textDecoration = element.getAttribute("textDecoration");
            String[] decs = ParserUtils.parseStringArray((String)textDecoration, (String)",");
            for (int i = 0; i < decs.length; ++i) {
                String td = decs[i];
                if (td == null || td.length() <= 0) continue;
                if (td.equalsIgnoreCase("underline")) {
                    prop.setPropertyValue(9009, (Object)new Boolean(true));
                }
                if (td.equalsIgnoreCase("line-through")) {
                    prop.setPropertyValue(9010, (Object)new Boolean(true));
                }
                prop.applyPropertyChanges();
            }
        }
        int hJust = rc.getHorizontalJustification();
        int vJust = rc.getVerticalJustification();
        String textAlign = element.getAttribute("textAlign");
        if (textAlign != null && textAlign.length() > 0) {
            if (textAlign.equalsIgnoreCase("None") || textAlign.equalsIgnoreCase("Left")) {
                hJust = 1;
            } else if (textAlign.equalsIgnoreCase("Center")) {
                hJust = 0;
            } else if (textAlign.equalsIgnoreCase("Right")) {
                hJust = 2;
            }
        }
        if ((verticalAlign = element.getAttribute("verticalAlign")) != null && verticalAlign.length() > 0) {
            if (verticalAlign.equalsIgnoreCase("None") || verticalAlign.equalsIgnoreCase("Middle")) {
                vJust = 0;
            } else if (verticalAlign.equalsIgnoreCase("Top")) {
                vJust = 4;
            } else if (verticalAlign.equalsIgnoreCase("Bottom")) {
                vJust = 8;
            }
        }
        rc.setJustification(hJust, vJust);
        String textDropShadowEnabled = element.getAttribute("textDropShadowEnabled");
        if (textDropShadowEnabled != null && textDropShadowEnabled.length() > 0) {
            rc.setShadowsOn(ParserUtils.getBooleanValue((String)textDropShadowEnabled));
        }
        if ((textDropShadowColor = element.getAttribute("textDropShadowColor")) != null && textDropShadowColor.length() > 0) {
            rc.setShadowColor(ColorParse.getColorFromString((String)textDropShadowColor));
        }
        if ((textDropShadowSoftness = element.getAttribute("textDropShadowSoftness")) != null && textDropShadowSoftness.length() > 0) {
            rc.setShadowSoftness(ParserUtils.getDoubleValue((String)textDropShadowSoftness));
        }
        if ((textDropShadowOffset = element.getAttribute("textDropShadowOffset")) != null && textDropShadowOffset.length() > 0) {
            rc.setShadowOffset(ParserUtils.getIntValue((String)textDropShadowOffset));
        }
        if ((textVisible = element.getAttribute("textVisible")) != null && textVisible.length() > 0) {
            rc.setVisible(ParserUtils.getBooleanValue((String)textVisible));
        }
        return rc;
    }

    public static void parseLabelAttrs(Element element, StyleElement overrides) {
        if (element == null || overrides == null) {
            return;
        }
        if (element.hasAttribute("size")) {
            overrides.setAttribute("fontSize", element.getAttribute("size"));
        }
        if (element.hasAttribute("weight")) {
            overrides.setAttribute("fontWeight", element.getAttribute("weight"));
        }
        if (element.hasAttribute("family")) {
            overrides.setAttribute("fontFamily", element.getAttribute("family"));
        }
        if (element.hasAttribute("style")) {
            overrides.setAttribute("fontStyle", element.getAttribute("style"));
        }
        if (element.hasAttribute("color")) {
            overrides.setAttribute("textColor", element.getAttribute("color"));
        }
    }
}

