/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.EntryTitleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class StatGraphParser
implements ElementParserInterface {
    public static final String STATGRAPH_ROOT_CHART = "STATGRAPH_ROOT_CHART";

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        StyleCollection sc;
        if (element.hasAttribute("version")) {
            context.put("XML_VERSION", element.getAttribute("version"));
        }
        boolean silkCompat = false;
        if (element.hasAttribute("silkCompat") && ParserUtils.getBooleanValue((String)element.getAttribute("silkCompat"))) {
            silkCompat = true;
        }
        if (!silkCompat) {
            SILKGlobal.getInstance().setPropertyValue(56, Boolean.TRUE);
            SILKGlobal.getInstance().applyPropertyChanges();
            SILKGlobal.setFlag(4);
            SILKGlobal.setFlag(6);
        }
        if (element.hasAttribute("border") && !ParserUtils.getBooleanValue((String)element.getAttribute("border"))) {
            SILKGlobal.clearFlag(6);
        }
        Style graphStyle = null;
        String style = element.getAttribute("style:style");
        if (style == null || style.length() == 0) {
            style = element.getAttribute("style:style");
        }
        if (style != null && style.length() > 0 && (graphStyle = (sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48)).getStyle(style)) != null) {
            SILKGlobal.getInstance().setPropertyValue(29, graphStyle);
            SILKGlobal.getInstance().applyPropertyChanges();
        }
        SILKParser.load(context, element);
        Object rootChart = context.get(STATGRAPH_ROOT_CHART);
        if (rootChart != null) {
            Element title = null;
            int index = 1;
            while ((title = ParserUtils.getChildWithTagName((String)"EntryTitle", (Element)element, (int)index++)) != null) {
                if (!(rootChart instanceof ComponentInterface)) continue;
                EntryTitleParser.parseEntryStyle(title, ((ComponentInterface)rootChart).getTitle(index - 1));
            }
            index = 1;
            while ((title = ParserUtils.getChildWithTagName((String)"EntryFootnote", (Element)element, (int)index++)) != null) {
                if (!(rootChart instanceof ComponentInterface)) continue;
                EntryTitleParser.parseEntryStyle(title, ((ComponentInterface)rootChart).getFootnote(index - 1));
            }
            if (rootChart instanceof PropertyInterface) {
                PropertyInterface prop = (PropertyInterface)rootChart;
                if (element.hasAttribute("backgroundColor") && !prop.hasUserSetValue(21)) {
                    prop.setPropertyValue(21, (Object)element.getAttribute("backgroundColor"));
                    prop.applyPropertyChanges();
                }
            }
            context.remove(STATGRAPH_ROOT_CHART);
        }
        return null;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return null;
    }

    public Object getObject() {
        return null;
    }

    public static Element wrapElementWithStatgraph(Hashtable context, Element e) {
        Object obj;
        if (context.containsKey("SCRIPT_STATGRAPH") && (obj = context.get("SCRIPT_STATGRAPH")) instanceof Boolean && !((Boolean)obj).booleanValue()) {
            return e;
        }
        Element sg = ParserUtils.newElement((Hashtable)context, (String)"StatGraph");
        if (sg == null) {
            return e;
        }
        if (!SILKGlobal.isFlagSet(4)) {
            sg.setAttribute("silkCompat", "true");
        }
        sg.setAttribute("version", SILKParser.getCurrentXMLVersion());
        sg.appendChild(e);
        return sg;
    }
}

