/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.xml.parsers.LineStyleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.util.ColorParse;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class ReferenceValuesParser
implements ElementParserInterface {
    protected RangeModel rangeModel = null;

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String name = element.getAttribute("name");
        if (name == null || name.length() == 0) {
            name = "RangeModel";
        }
        this.parseReferenceValues(element, null);
        Object o = this.getObject();
        if (context != null) {
            context.put(name, o);
        }
        return o;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return null;
    }

    public Object getObject() {
        return this.rangeModel;
    }

    public RangeModel parseReferenceValues(Element element, Object rModel) {
        String visibleMaximum;
        String visibleMinimum;
        String maximum;
        String minimum;
        String overlap;
        String bounded;
        if (rModel == null) {
            this.rangeModel = new RangeModel();
        } else if (rModel instanceof RangeModel) {
            this.rangeModel = (RangeModel)rModel;
        }
        String precision = element.getAttribute("precision");
        if (precision != null && precision.length() > 0) {
            this.rangeModel.setPrecision(new Double(ParserUtils.getDoubleValue((String)precision)));
        }
        if ((bounded = element.getAttribute("bounded")) != null && bounded.length() > 0) {
            this.rangeModel.setBounded(ParserUtils.getBooleanValue((String)bounded));
        }
        if ((overlap = element.getAttribute("overlap")) != null && overlap.length() > 0) {
            this.rangeModel.setOverlap(ParserUtils.getBooleanValue((String)overlap));
        }
        if ((minimum = element.getAttribute("minimum")) != null && minimum.length() > 0) {
            this.rangeModel.setMinimum(new Double(ParserUtils.getDoubleValue((String)minimum)));
        }
        if ((maximum = element.getAttribute("maximum")) != null && maximum.length() > 0) {
            this.rangeModel.setMaximum(new Double(ParserUtils.getDoubleValue((String)maximum)));
        }
        if ((visibleMinimum = element.getAttribute("visibleMinimum")) != null && visibleMinimum.length() > 0) {
            this.rangeModel.setVisibleMinimum(new Double(ParserUtils.getDoubleValue((String)visibleMinimum)));
        }
        if ((visibleMaximum = element.getAttribute("visibleMaximum")) != null && visibleMaximum.length() > 0) {
            this.rangeModel.setVisibleMaximum(new Double(ParserUtils.getDoubleValue((String)visibleMaximum)));
        }
        int i = 1;
        Element range = null;
        while ((range = ParserUtils.getChildWithTagName((String)"Range", (Element)element, (int)i)) != null) {
            ReferenceValuesParser.parseReferenceRange(range, this.rangeModel);
            ++i;
        }
        return this.rangeModel;
    }

    private static void parseReferenceRange(Element rangeElement, RangeModel rangeModel) {
        Element highLine;
        Element lowLine;
        Element label;
        String fillColor;
        String highInclusive;
        String highValue;
        String lowInclusive;
        ReferenceRange range = new ReferenceRange();
        String lowValue = rangeElement.getAttribute("lowValue");
        if (lowValue != null && lowValue.length() > 0) {
            range.setLowValue(new Double(ParserUtils.getDoubleValue((String)lowValue)));
        }
        if ((lowInclusive = rangeElement.getAttribute("lowInclusive")) != null && lowInclusive.length() > 0) {
            range.setLowInclusive(ParserUtils.getBooleanValue((String)lowInclusive));
        }
        if ((highValue = rangeElement.getAttribute("highValue")) != null && highValue.length() > 0) {
            range.setHighValue(new Double(ParserUtils.getDoubleValue((String)highValue)));
        }
        if ((highInclusive = rangeElement.getAttribute("highInclusive")) != null && highInclusive.length() > 0) {
            range.setHighInclusive(ParserUtils.getBooleanValue((String)highInclusive));
        }
        if ((fillColor = rangeElement.getAttribute("fillColor")) != null && fillColor.length() > 0) {
            range.setFillColor(ColorParse.getColorFromString((String)fillColor));
        }
        if ((label = ParserUtils.getChildWithTagName((String)"Label", (Element)rangeElement)) != null) {
            TextParser.parseTextElement(label, range.getLabel());
        }
        if ((lowLine = ParserUtils.getChildWithTagName((String)"LowLine", (Element)rangeElement)) != null) {
            LineStyleParser.parseLineStyle(lowLine, range.getLowLine());
        }
        if ((highLine = ParserUtils.getChildWithTagName((String)"highLine", (Element)rangeElement)) != null) {
            LineStyleParser.parseLineStyle(highLine, range.getHighLine());
        }
        rangeModel.add(range);
    }
}

