/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.base.SILKEquatedXYComponent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.ToolPallet;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.SILKParserFactory;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ContinuousLegendParser;
import com.sas.graphics.silk.xml.parsers.DiscreteLegendParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.util.ColorParse;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class OverlayParser
extends ChartParser {
    protected BaseElementComponent overlay = null;

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        int i;
        Vector previous;
        if (this.overlay == null) {
            this.overlay = element.getTagName().equalsIgnoreCase("LayoutOverlayEquated") ? new SILKEquatedXYComponent() : new BaseElementComponent();
        }
        if (element.hasAttribute("cycleAttrs")) {
            this.overlay.setCycleAttrs(ParserUtils.getBooleanValue((String)element.getAttribute("cycleAttrs")));
        }
        if (element.hasAttribute("palletVisible")) {
            this.overlay.setPropertyValue(69, ParserUtils.getBooleanValue((String)element.getAttribute("palletVisible")));
        }
        if (element.hasAttribute("palletPosition")) {
            this.overlay.setPropertyValue(68, element.getAttribute("palletPosition"));
        }
        this.overlay.applyPropertyChanges();
        Object statgraphRoot = context.get("STATGRAPH_ROOT_CHART");
        if (statgraphRoot == null) {
            if (SILKGlobal.isFlagSet(4) && SILKGlobal.isFlagSet(6)) {
                this.overlay.setPropertyValue(63, Boolean.TRUE);
            }
            this.overlay.setPropertyValue(66, Boolean.TRUE);
            this.overlay.applyPropertyChanges();
            context.put("STATGRAPH_ROOT_CHART", this.overlay);
        }
        if ((previous = (Vector)context.get("CHART_LIST")) == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i2 = 0; i2 < prev.length; ++i2) {
            SILKParser.removeChart(context, (String)prev[i2]);
        }
        context.put("OVERLAY_ACTIVE", Boolean.TRUE);
        context.put("CURRENT_OVERLAY", this.overlay);
        SILKParser.load(context, element);
        context.remove("CURRENT_OVERLAY");
        context.put("OVERLAY_ACTIVE", Boolean.FALSE);
        Object[] charts = SILKParser.getCharts(context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec == null) {
            return;
        }
        Object[] chartNames = new String[vec.size()];
        vec.copyInto(chartNames);
        for (i = 0; i < charts.length; ++i) {
            Object obj = charts[i];
            if (!(obj instanceof BaseElement)) continue;
            this.overlay.addChart((BaseElement)obj);
            SILKParser.removeChart(context, (String)chartNames[i]);
        }
        for (i = 0; i < prev.length; ++i) {
            SILKParser.addChart(context, (String)prev[i]);
        }
        Element axisOpts = ParserUtils.getChildWithTagName((String)"XAxisOpts", (Element)element);
        if (axisOpts != null) {
            this.parseAxisOpts(this.overlay, "X", axisOpts);
        }
        if ((axisOpts = ParserUtils.getChildWithTagName((String)"YAxisOpts", (Element)element)) != null) {
            this.parseAxisOpts(this.overlay, "Y", axisOpts);
        }
        if ((axisOpts = ParserUtils.getChildWithTagName((String)"X2AxisOpts", (Element)element)) != null) {
            this.parseAxisOpts(this.overlay, "X2", axisOpts);
        }
        if ((axisOpts = ParserUtils.getChildWithTagName((String)"Y2AxisOpts", (Element)element)) != null) {
            this.parseAxisOpts(this.overlay, "Y2", axisOpts);
        }
        Element referenceLine = null;
        int index = 1;
        while ((referenceLine = ParserUtils.getChildWithTagName((String)"ReferenceLine", (Element)element, (int)index++)) != null) {
            Element curveLabelAttrs;
            Element lineAttrs;
            int which = 0;
            if (referenceLine.hasAttribute("x")) {
                if (referenceLine.hasAttribute("xAxis") && "x2".equalsIgnoreCase(referenceLine.getAttribute("xAxis"))) {
                    which = 3;
                }
            } else if (referenceLine.hasAttribute("y")) {
                which = referenceLine.hasAttribute("yAxis") ? ("y2".equalsIgnoreCase(referenceLine.getAttribute("yAxis")) ? 4 : 1) : 1;
            }
            AxisInterface ai = this.overlay.getAxis(new Integer(which));
            ReferenceLineInterface rli = null;
            if (referenceLine.hasAttribute("x")) {
                rli = ai.addReferenceLine(new Double(ParserUtils.getDoubleValue((String)referenceLine.getAttribute("x"))), referenceLine.getAttribute("curveLabel"));
            } else if (referenceLine.hasAttribute("y")) {
                rli = ai.addReferenceLine(new Double(ParserUtils.getDoubleValue((String)referenceLine.getAttribute("y"))), referenceLine.getAttribute("curveLabel"));
            }
            if (referenceLine.hasAttribute("curveLabelLocation") && "inside".equalsIgnoreCase(referenceLine.getAttribute("curveLabelLocation"))) {
                rli.setOutsideLabel(false);
            }
            if (referenceLine.hasAttribute("curveLabelPosition") && "min".equalsIgnoreCase(referenceLine.getAttribute("curveLabelPosition"))) {
                rli.setSameLabelSide(true);
            }
            if (referenceLine.hasAttribute("dataTransparency")) {
                rli.getLine().setTransparency(1.0 - ParserUtils.getDoubleValue((String)referenceLine.getAttribute("dataTransparency")));
            }
            if ((lineAttrs = ParserUtils.getChildWithTagName((String)"LineAttrs", (Element)referenceLine)) != null) {
                if (lineAttrs.hasAttribute("thickness")) {
                    rli.getLine().setWidth(ParserUtils.getIntValue((String)lineAttrs.getAttribute("thickness")));
                }
                if (lineAttrs.hasAttribute("color")) {
                    rli.getLine().setColor(ColorParse.getColorFromString((String)lineAttrs.getAttribute("color")));
                }
                if (lineAttrs.hasAttribute("pattern")) {
                    rli.getLine().setPattern(ParserUtils.getIntValue((String)lineAttrs.getAttribute("pattern")));
                }
            }
            if ((curveLabelAttrs = ParserUtils.getChildWithTagName((String)"CurveLabelAttrs", (Element)referenceLine)) == null) continue;
            TextParser.parseTextElement(curveLabelAttrs, rli.getLabel());
        }
        Element discreteLegend = null;
        index = 1;
        while ((discreteLegend = ParserUtils.getChildWithTagName((String)"DiscreteLegend", (Element)element, (int)index++)) != null) {
            LegendObjectJ2D legend = DiscreteLegendParser.parseDiscreteLegend(discreteLegend, context);
            if (legend == null) continue;
            this.overlay.addUserLegend(legend);
        }
        Element continuousLegend = null;
        index = 1;
        while ((continuousLegend = ParserUtils.getChildWithTagName((String)"ContinuousLegend", (Element)element, (int)index++)) != null) {
            LegendObjectJ2D legend = ContinuousLegendParser.parseContinuousLegend(continuousLegend, context);
            if (legend == null) continue;
            this.overlay.addUserLegend(legend);
        }
        String n = element.getAttribute("name");
        this.name = n == null || n.length() == 0 ? ParserUtils.getUniqueChartName(context) : n;
        context.put(this.name, this.overlay);
    }

    private void parseAxisOpts(BaseElementComponent overlay, Object which, Element axisOpts) {
        AxisInterface axis = overlay.getAxis(which);
        if (axis != null) {
            ParserUtils.parseAxisOpts(axis, axisOpts);
        }
        Axes a = null;
        if (axis instanceof Axes) {
            a = (Axes)axis;
        }
        if (a != null) {
            Element discreteOpts;
            Element linearOpts = ParserUtils.getChildWithTagName((String)"LinearOpts", (Element)axisOpts);
            if (linearOpts != null) {
                this.parseLinearOpts(overlay, a, linearOpts);
            }
            if ((discreteOpts = ParserUtils.getChildWithTagName((String)"DiscreteOpts", (Element)axisOpts)) != null) {
                this.parseDiscreteOpts(overlay, a, which, discreteOpts);
            }
        }
    }

    private void parseLinearOpts(BaseElementComponent overlay, Axes axis, Element linearOpts) {
        Element tickValues;
        if (linearOpts.hasAttribute("viewMin")) {
            axis.setUserMin(ParserUtils.getDoubleValue((String)linearOpts.getAttribute("viewMin")));
        }
        if (linearOpts.hasAttribute("viewMax")) {
            axis.setUserMax(ParserUtils.getDoubleValue((String)linearOpts.getAttribute("viewMax")));
        }
        if ((tickValues = ParserUtils.getChildWithTagName((String)"TickValues", (Element)linearOpts)) != null) {
            Vector<Double> v = new Vector<Double>();
            int tick = 1;
            Element tickValue = null;
            do {
                if ((tickValue = ParserUtils.getChildWithTagName((String)"Value", (Element)tickValues, (int)tick)) != null) {
                    String val = tickValue.getTextContent();
                    try {
                        double d = Double.parseDouble(val);
                        v.add(d);
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                }
                ++tick;
            } while (tickValue != null);
            if (v.size() > 0) {
                axis.setTickValueList(v.toArray());
            }
        }
        Element tickDisplays = ParserUtils.getChildWithTagName((String)"TickDisplays", (Element)linearOpts);
        if (tickValues != null && tickDisplays != null) {
            Vector<String> v = new Vector<String>();
            int tick = 1;
            Element tickDisplay = null;
            do {
                if ((tickDisplay = ParserUtils.getChildWithTagName((String)"Value", (Element)tickDisplays, (int)tick)) != null && tickDisplay.getTextContent() != null) {
                    v.add(tickDisplay.getTextContent());
                }
                ++tick;
            } while (tickDisplay != null);
            if (v.size() > 0) {
                String[] arr = new String[v.size()];
                for (int i = 0; i < arr.length; ++i) {
                    if (v.elementAt(i) == null) continue;
                    arr[i] = v.elementAt(i).toString();
                }
                axis.setTickDisplayList(arr);
            }
        }
    }

    private void parseDiscreteOpts(BaseElementComponent overlay, Axes axis, Object which, Element discreteOpts) {
        int dim = 1;
        if ("Y".equals(which)) {
            dim = 2;
        } else if ("X2".equals(which)) {
            dim = 5;
        } else if ("Y2".equals(which)) {
            dim = 6;
        }
        double viewportMin = Double.NaN;
        double viewportMax = Double.NaN;
        if (discreteOpts.hasAttribute("viewportMin")) {
            viewportMin = ParserUtils.getDoubleValue((String)discreteOpts.getAttribute("viewportMin"));
        }
        if (discreteOpts.hasAttribute("viewportMax")) {
            viewportMax = ParserUtils.getDoubleValue((String)discreteOpts.getAttribute("viewportMax"));
        }
        if (!Double.isNaN(viewportMin) && !Double.isNaN(viewportMax)) {
            overlay.setViewport(1, dim, viewportMin - 1.5, viewportMax - 0.5);
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Object pv;
        BaseElementComponent o = this.overlay;
        if (object instanceof BaseElementComponent) {
            o = (BaseElementComponent)object;
        }
        if (o == null) {
            o = new BaseElementComponent();
        }
        Element e = null;
        e = o instanceof SILKEquatedXYComponent ? ParserUtils.newElement((Hashtable)context, (String)"LayoutOverlayEquated") : ParserUtils.newElement((Hashtable)context, (String)"LayoutOverlay");
        if (o.isCycleAttrs()) {
            e.setAttribute("cycleAttrs", "true");
        }
        Object toolPaletteVisible = o.getPropertyValue(69);
        boolean vis = false;
        if (toolPaletteVisible instanceof Boolean) {
            vis = (Boolean)toolPaletteVisible;
        }
        if (vis) {
            e.setAttribute("palletVisible", Boolean.valueOf(vis).toString());
        }
        if ((pv = o.getPropertyValue(68)) != null && !ToolPallet.getStringPosition(-1000089).equals(pv)) {
            e.setAttribute("palletPosition", ToolPallet.getEnglishStringPosition(pv.toString()));
        }
        BaseElement[] layers = o.getCharts();
        for (int i = 0; i < layers.length; ++i) {
            ElementParserInterface parser = SILKParserFactory.loadParser((Object)layers[i]);
            if (parser == null) continue;
            Element element = parser.putToXML(context, (Object)layers[i]);
            e.appendChild(element);
        }
        return e;
    }

    @Override
    public Object getObject() {
        if (this.overlay == null) {
            this.overlay = new BaseElementComponent();
        }
        return this.overlay;
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof BaseElementComponent)) {
            return false;
        }
        this.overlay = (BaseElementComponent)instance;
        return true;
    }
}

