/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class LineStyleParser
implements ElementParserInterface {
    LineStyleInterface line = null;

    public LineStyleParser() {
        this(null);
    }

    public LineStyleParser(LineStyleInterface lsIn) {
        if (lsIn != null) {
            this.line = lsIn;
        }
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        if (instance != null && instance instanceof LineStyleInterface) {
            return LineStyleParser.parseLineStyle(element, (LineStyleInterface)instance);
        }
        return LineStyleParser.parseLineStyle(element, this.line);
    }

    public static LineStyleInterface parseLineStyle(Element element, LineStyleInterface lsIn) {
        String width;
        String color;
        String visible;
        LineStyleInterface lsi = new LineAttrib();
        if (lsIn != null && lsIn instanceof LineStyleInterface) {
            lsi = lsIn;
        }
        if ((visible = element.getAttribute("visible")) != null && visible.length() > 0) {
            lsi.setVisible(ParserUtils.getBooleanValue((String)visible));
        }
        if ((color = element.getAttribute("color")) != null && color.length() > 0) {
            lsi.setColor(ColorParse.getColorFromString((String)color));
        }
        if ((width = element.getAttribute("width")) != null && width.length() > 0) {
            lsi.setWidth(ParserUtils.getIntValue((String)width));
        }
        if (element.hasAttribute("pattern")) {
            lsi.setPattern(ParserUtils.getIntValue((String)element.getAttribute("pattern")));
        }
        return lsi;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return this.putToXML(context, instance, null, "Line");
    }

    public Element putToXML(Hashtable context, Object instance, String tagName) {
        return this.putToXML(context, instance, null, tagName);
    }

    public Element putToXML(Hashtable context, Object instance, Element element) {
        return this.putToXML(context, instance, element, "Line");
    }

    public Element putToXML(Hashtable context, Object instance, Element element, String tagName) {
        Object obj;
        PropertyInterface line = null;
        if (!(instance instanceof PropertyInterface)) {
            return null;
        }
        line = (PropertyInterface)instance;
        Element rc = element;
        if (rc == null) {
            rc = ParserUtils.newElement((Hashtable)context, (String)tagName);
        }
        if (line.hasUserSetValue(9501)) {
            rc.setAttribute("visible", line.getPropertyValue(9501) + "");
        }
        if (line.hasUserSetValue(9502) && (obj = line.getPropertyValue(9502)) instanceof Color) {
            rc.setAttribute("color", ColorParse.getColorStrg((Color)((Color)obj), (boolean)false));
        }
        if (line.hasUserSetValue(9503)) {
            rc.setAttribute("width", line.getPropertyValue(9503) + "");
        }
        if (rc.getAttributes().getLength() == 0) {
            return null;
        }
        return rc;
    }

    public Object getObject() {
        return null;
    }
}

