/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.LinePlotElement;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.LineStyleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import com.sas.graphics.util.Extract;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class LineParser
extends ChartParser {
    SILKElementInfoReader lineInfo = null;

    public LineParser() {
        this(null);
    }

    public LineParser(PropertyInterface sc) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/line.config";
        this.lineInfo = new SILKElementInfoReader(configFile);
        this.lineInfo.setInstance(sc);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        Object obj;
        Element markerAttrs;
        Object obj2;
        Element lineAttrs;
        ParserUtils.parseElement(context, element, this.lineInfo);
        if (element.hasAttribute("display")) {
            String display = element.getAttribute("display").toUpperCase();
            Object obj3 = this.getObject();
            if (obj3 instanceof PropertyInterface) {
                if (display.indexOf("MARKERS") >= 0 || display.indexOf("ALL") >= 0) {
                    ((PropertyInterface)obj3).setPropertyValue(2036, (Object)Boolean.TRUE);
                }
                ((PropertyInterface)obj3).applyPropertyChanges();
            }
        }
        if (element.hasAttribute("connectOrder")) {
            LinePlotElement lpe = (LinePlotElement)this.getObject();
            String co = element.getAttribute("connectOrder");
            if ("xValues".equalsIgnoreCase(co)) {
                lpe.setConnectOrder(1);
            } else {
                lpe.setConnectOrder(2);
            }
        }
        int index = 1;
        Element lp = null;
        while ((lp = ParserUtils.getChildWithTagName((String)"LineProperties", (Element)element, (int)index++)) != null) {
            Object ls;
            Object obj4 = this.getObject();
            if (!(obj4 instanceof PropertyInterface)) continue;
            PropertyInterface pi = (PropertyInterface)obj4;
            if (lp.hasAttribute("response")) {
                pi.setPropertyValue(18503, (Object)lp.getAttribute("response"));
            }
            if (lp.hasAttribute("group")) {
                pi.setPropertyValue(18504, (Object)lp.getAttribute("group"));
            }
            if ((ls = pi.getPropertyValue(18507)) == null) {
                ls = pi.getPropertyValue(18508);
            }
            if (!(ls instanceof LineStyleInterface)) continue;
            LineStyleParser.parseLineStyle(lp, (LineStyleInterface)ls);
        }
        if (element.hasAttribute("lineAttrs") && this.getObject() instanceof LinePlotElement) {
            ((LinePlotElement)this.getObject()).setStyleElement("LINE_ATTRS", element.getAttribute("lineAttrs"));
        }
        if ((lineAttrs = ParserUtils.getChildWithTagName((String)"LineAttrs", (Element)element)) != null && this.getObject() instanceof PropertyInterface && (obj2 = ((PropertyInterface)this.getObject()).getPropertyValue(19009)) instanceof StyleElementAttrs) {
            ParserUtils.parseLineAttrs(lineAttrs, ((StyleElementAttrs)obj2).getOverrides(true));
        }
        if (element.hasAttribute("markerAttrs") && this.getObject() instanceof LinePlotElement) {
            ((LinePlotElement)this.getObject()).setStyleElement("MARKER_ATTRS", element.getAttribute("markerAttrs"));
        }
        if ((markerAttrs = ParserUtils.getChildWithTagName((String)"MarkerAttrs", (Element)element)) != null && this.getObject() instanceof PropertyInterface && (obj = ((PropertyInterface)this.getObject()).getPropertyValue(19011)) instanceof StyleElementAttrs) {
            ParserUtils.parseMarkerAttrs(markerAttrs, ((StyleElementAttrs)obj).getOverrides(true));
        }
        if (SILKGlobal.isFlagSet(4)) {
            Element tipLabels;
            Element tipFormats;
            LinePlotElement lpe = (LinePlotElement)this.getObject();
            Element roles = ParserUtils.getChildWithTagName((String)"Roles", (Element)element, (int)1);
            if (roles != null) {
                ParserUtils.parseUserDefinedRoles(roles, lpe, lpe.getRoleManager());
            }
            if ((tipFormats = ParserUtils.getChildWithTagName((String)"TipFormats", (Element)element, (int)1)) != null) {
                ParserUtils.parseTipFormats(tipFormats, lpe);
            }
            if ((tipLabels = ParserUtils.getChildWithTagName((String)"TipLabels", (Element)element, (int)1)) != null) {
                ParserUtils.parseTipLabels(tipLabels, lpe);
            }
            ParserUtils.parseCustomTip(element, lpe);
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.toXML(this.getTagName(), context, object, this.lineInfo);
        if (object instanceof PropertyInterface) {
            PropertyInterface pi = (PropertyInterface)object;
            Object oldCurrentResponse = pi.getPropertyValue(18503);
            Object oldCurrentGroup = pi.getPropertyValue(18504);
            Object responseList = pi.getPropertyValue(18501);
            Object groupList = pi.getPropertyValue(18502);
            Enumeration responses = Extract.elements((Object)responseList);
            while (responses.hasMoreElements()) {
                LineStyleParser parser;
                Element e;
                Object currentResponse = responses.nextElement();
                if (groupList != null) {
                    Enumeration groups = Extract.elements((Object)groupList);
                    while (groups.hasMoreElements()) {
                        LineStyleParser parser2;
                        Element e2;
                        Object groupValue = groups.nextElement();
                        pi.setPropertyValue(18503, currentResponse);
                        pi.setPropertyValue(18504, groupValue);
                        Object line = pi.getPropertyValue(18507);
                        if (line == null || (e2 = (parser2 = new LineStyleParser()).putToXML(context, line, null, "LineProperties")) == null) continue;
                        e2.setAttribute("response", currentResponse.toString());
                        e2.setAttribute("group", groupValue.toString());
                        rc.appendChild(e2);
                    }
                    continue;
                }
                pi.setPropertyValue(18503, currentResponse);
                Object line = pi.getPropertyValue(18507);
                if (line == null || (e = (parser = new LineStyleParser()).putToXML(context, line, null, "LineProperties")) == null) continue;
                e.setAttribute("response", currentResponse.toString());
                rc.appendChild(e);
            }
            pi.setPropertyValue(18503, oldCurrentResponse);
            pi.setPropertyValue(18504, oldCurrentGroup);
            if (pi.hasUserSetValue(9505)) {
                String connectOrder = "xAxis";
                Object o = pi.getPropertyValue(9505);
                if (o instanceof Number) {
                    switch (((Number)o).intValue()) {
                        case 1: {
                            connectOrder = "xValues";
                            break;
                        }
                        default: {
                            connectOrder = "xAxis";
                        }
                    }
                }
                rc.setAttribute("connectOrder", connectOrder);
            }
        }
        return rc;
    }

    @Override
    public String getTagName() {
        return "LinePlot";
    }

    @Override
    public Object getObject() {
        return this.lineInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.lineInfo != null) {
            this.lineInfo.setInstance(instance);
        }
        return true;
    }
}

