/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.xml.parsers.LineStyleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class LegendParser
implements ElementParserInterface {
    LegendInterface legend = null;

    public LegendParser() {
        this(new LegendObjectJ2D());
    }

    public LegendParser(LegendInterface legendIn) {
        if (legendIn != null) {
            this.legend = legendIn;
        }
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        LegendInterface li = this.legend;
        if (instance != null && instance instanceof LegendInterface) {
            li = (LegendInterface)instance;
        }
        return LegendParser.parseLegend(element, li);
    }

    public static LegendInterface parseLegend(Element element, LegendInterface li) {
        String visible;
        Element border;
        Element label;
        Element title;
        String backgroundColor;
        String backgroundOpacity;
        String bStyle;
        String down;
        String across;
        String position;
        if (li == null) {
            return null;
        }
        String inside = element.getAttribute("inside");
        if (inside != null && inside.length() > 0) {
            li.setInside(ParserUtils.getBooleanValue((String)inside));
        }
        if ((position = element.getAttribute("position")) != null && position.length() > 0) {
            if (position.equalsIgnoreCase("East")) {
                li.setPosition(3);
            } else if (position.equalsIgnoreCase("NorthEast")) {
                li.setPosition(6);
            } else if (position.equalsIgnoreCase("NorthWest")) {
                li.setPosition(7);
            } else if (position.equalsIgnoreCase("West")) {
                li.setPosition(4);
            } else if (position.equalsIgnoreCase("North")) {
                li.setPosition(1);
            } else if (position.equalsIgnoreCase("SouthEast")) {
                li.setPosition(8);
            } else if (position.equalsIgnoreCase("SouthWest")) {
                li.setPosition(9);
            } else {
                li.setPosition(2);
            }
        }
        if ((across = element.getAttribute("across")) != null && across.length() > 0) {
            li.setAcross(ParserUtils.getIntValue((String)across));
        }
        if ((down = element.getAttribute("down")) != null && down.length() > 0) {
            li.setDown(ParserUtils.getIntValue((String)down));
        }
        if ((bStyle = element.getAttribute("borderStyle")) != null && bStyle.length() > 0) {
            if (bStyle.equalsIgnoreCase("None")) {
                li.setBorderStyle(100);
            } else if (bStyle.equalsIgnoreCase("DropShadow")) {
                li.setBorderStyle(102);
            } else if (bStyle.equalsIgnoreCase("Line")) {
                li.setBorderStyle(101);
            }
        }
        if ((backgroundOpacity = element.getAttribute("backgroundOpacity")) != null && backgroundOpacity.length() > 0) {
            li.setBackgroundOpacity(ParserUtils.getDoubleValue((String)backgroundOpacity));
        }
        if ((backgroundColor = element.getAttribute("backgroundColor")) != null && backgroundColor.length() > 0) {
            li.setBackgroundColor(ColorParse.getColorFromString((String)backgroundColor));
        }
        if ((title = ParserUtils.getChildWithTagName((String)"Title", (Element)element)) != null) {
            TextParser.parseTextElement(title, li.getTitle());
        }
        if ((label = ParserUtils.getChildWithTagName((String)"Labels", (Element)element)) != null) {
            TextParser.parseTextElement(label, li.getLabel());
        }
        if ((border = ParserUtils.getChildWithTagName((String)"Border", (Element)element)) != null) {
            LineStyleParser.parseLineStyle(border, li.getBorder());
        }
        if (li instanceof RenderInterface && (visible = element.getAttribute("visible")) != null && visible.length() > 0) {
            ((RenderInterface)((Object)li)).setVisible(ParserUtils.getBooleanValue((String)visible));
        }
        return li;
    }

    public Element putToXML(Hashtable context, Object instance) {
        Object border;
        LineStyleParser lp;
        Object labels;
        Object title;
        TextParser tp;
        Element e;
        Object obj;
        Object obj2;
        PropertyInterface leg = null;
        if (instance instanceof PropertyInterface) {
            leg = (PropertyInterface)instance;
        }
        if (leg == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"Legend");
        if (leg.hasUserSetValue(401)) {
            String position = "South";
            obj2 = leg.getPropertyValue(401);
            int pos = 2;
            if (obj2 instanceof Number) {
                pos = ((Number)obj2).intValue();
            }
            if (pos == 3) {
                position = "East";
            } else if (pos == 1) {
                position = "North";
            } else if (pos == 4) {
                position = "West";
            } else if (pos == 6) {
                position = "NorthEast";
            } else if (pos == 7) {
                position = "NorthWest";
            } else if (pos == 8) {
                position = "SouthEast";
            } else if (pos == 9) {
                position = "SouthWest";
            }
            rc.setAttribute("position", position);
        }
        if (leg.hasUserSetValue(432)) {
            rc.setAttribute("inside", leg.getPropertyValue(432) + "");
        }
        if (leg.hasUserSetValue(435)) {
            rc.setAttribute("across", leg.getPropertyValue(435) + "");
        }
        if (leg.hasUserSetValue(436)) {
            rc.setAttribute("down", leg.getPropertyValue(436) + "");
        }
        if (leg.hasUserSetValue(424)) {
            String borderstyle = "Line";
            obj2 = leg.getPropertyValue(424);
            int bs = 101;
            if (obj2 instanceof Number) {
                bs = ((Number)obj2).intValue();
            }
            if (bs == 100) {
                borderstyle = "None";
            } else if (bs == 102) {
                borderstyle = "DropShadow";
            }
            rc.setAttribute("borderStyle", borderstyle);
        }
        if (leg.hasUserSetValue(422)) {
            rc.setAttribute("backgroundOpacity", leg.getPropertyValue(422) + "");
        }
        if (leg.hasUserSetValue(421) && (obj = leg.getPropertyValue(421)) instanceof Color) {
            rc.setAttribute("backgroundColor", ColorParse.getColorStrg((Color)((Color)obj), (boolean)false));
        }
        if (leg.hasUserSetValue(420)) {
            rc.setAttribute("visible", leg.getPropertyValue(420) + "");
        }
        if ((e = (tp = new TextParser()).putToXML(context, title = leg.getPropertyValue(427), "Title")) != null) {
            rc.appendChild(e);
        }
        if ((e = tp.putToXML(context, labels = leg.getPropertyValue(428), "Labels")) != null) {
            rc.appendChild(e);
        }
        if ((e = (lp = new LineStyleParser()).putToXML(context, border = leg.getPropertyValue(440), "Border")) != null) {
            rc.appendChild(e);
        }
        if (rc.getAttributes().getLength() == 0 && rc.getChildNodes().getLength() == 0) {
            return null;
        }
        return rc;
    }

    public Object getObject() {
        return this.legend;
    }
}

