/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.HistElement;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class HistogramParser
extends ChartParser {
    SILKElementInfoReader histogramInfo = null;

    public HistogramParser() {
        this(null);
    }

    public HistogramParser(Object instance) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/histogram.config";
        this.histogramInfo = new SILKElementInfoReader(configFile);
        this.histogramInfo.setInstance(instance);
    }

    @Override
    public Object getFromXML(Hashtable context, Element element, Object instance) {
        if (element != null && element.hasAttribute("orient")) {
            String orient = element.getAttribute("orient");
            this.histogramInfo = "HORIZONTAL".equalsIgnoreCase(orient) ? new SILKElementInfoReader("com/sas/graphics/silk/xml/parsers/config/hhistogram.config") : new SILKElementInfoReader("com/sas/graphics/silk/xml/parsers/config/histogram.config");
        }
        return super.getFromXML(context, element, instance);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement(context, element, this.histogramInfo);
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        HistElement he;
        Element elem = ParserUtils.toXML("Histogram", context, object, this.histogramInfo);
        if (object instanceof HistElement && (he = (HistElement)object).hasUserSetValue(832)) {
            String rc = null;
            int b = he.getBoundary();
            switch (b) {
                case 0: {
                    rc = "Upper";
                    break;
                }
                case 1: {
                    rc = "Lower";
                    break;
                }
            }
            if (rc != null) {
                elem.setAttribute("boundary", rc);
            }
        }
        return elem;
    }

    @Override
    public Object getObject() {
        return this.histogramInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        this.histogramInfo.setInstance(instance);
        return true;
    }
}

