/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.util.GraphGroup;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class GraphGroupParser
implements ElementParserInterface {
    GraphGroup graphGroup = null;

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String graphs;
        if (instance instanceof GraphGroup) {
            this.graphGroup = (GraphGroup)instance;
        }
        if (this.graphGroup == null) {
            this.graphGroup = new GraphGroup();
        }
        if ((graphs = element.getAttribute("graphs")) == null || graphs.length() == 0) {
            return this.graphGroup;
        }
        String[] list = ParserUtils.parseStringArray((String)graphs, (String)",");
        for (int i = 0; i < list.length; ++i) {
            Object chart = context.get(list[i]);
            if (chart == null) continue;
            this.graphGroup.addChart(chart);
        }
        String equalize = element.getAttribute("equalize");
        if (equalize != null && equalize.length() > 0) {
            if (equalize.equalsIgnoreCase("Horizontal") || equalize.equalsIgnoreCase("X")) {
                this.graphGroup.mergeRanges(1);
            } else if (equalize.equalsIgnoreCase("Vertical") || equalize.equalsIgnoreCase("Y")) {
                this.graphGroup.mergeRanges(2);
            } else if (equalize.equalsIgnoreCase("Z")) {
                this.graphGroup.mergeRanges(3);
            } else if (equalize.equalsIgnoreCase("All")) {
                this.graphGroup.mergeRanges(-1);
            }
        }
        return this.graphGroup;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return null;
    }

    public Object getObject() {
        return this.graphGroup;
    }
}

