/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class ColorRampParser
implements ElementParserInterface {
    private ColorInterface ramp = null;

    public ColorRampParser() {
        this(new ColorRamp());
    }

    public ColorRampParser(ColorInterface instance) {
        this.ramp = instance;
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String missingColor;
        String overflowColor;
        String name;
        if (instance != null && instance instanceof ColorInterface) {
            this.ramp = (ColorInterface)instance;
        }
        if ((name = element.getAttribute("name")) == null || name.length() == 0) {
            name = "ColorRamp";
        }
        if (context != null) {
            context.put(name, this.ramp);
        }
        SILKParser.addColorRamp(context, name);
        String underflowColor = element.getAttribute("underflowColor");
        if (underflowColor != null && underflowColor.length() > 0) {
            this.ramp.setUnderflowColor(ColorParse.getColorFromString((String)underflowColor));
        }
        if ((overflowColor = element.getAttribute("overflowColor")) != null && overflowColor.length() > 0) {
            this.ramp.setOverflowColor(ColorParse.getColorFromString((String)overflowColor));
        }
        if ((missingColor = element.getAttribute("missingColor")) != null && missingColor.length() > 0) {
            this.ramp.setMissingColor(ColorParse.getColorFromString((String)missingColor));
        }
        String low = element.getAttribute("low");
        String high = element.getAttribute("high");
        double min = 0.0;
        double max = 1.0;
        if (low != null && low.length() > 0) {
            min = ParserUtils.getDoubleValue((String)low);
        }
        if (high != null && high.length() > 0) {
            max = ParserUtils.getDoubleValue((String)high);
        }
        this.ramp.setRange(min, max);
        String beginColor = element.getAttribute("beginColor");
        String endColor = element.getAttribute("endColor");
        Color start = Color.white;
        Color end = Color.black;
        if (beginColor != null && beginColor.length() > 0) {
            start = ColorParse.getColorFromString((String)beginColor);
        }
        if (endColor != null && endColor.length() > 0) {
            end = ColorParse.getColorFromString((String)endColor);
        }
        this.ramp.setColors(new Color[]{start, end});
        int i = 1;
        Element breakpoint = null;
        while ((breakpoint = ParserUtils.getChildWithTagName((String)"Break", (Element)element, (int)i)) != null) {
            Double val = new Double(Double.NaN);
            String value = breakpoint.getAttribute("value");
            if (value != null && value.length() > 0) {
                val = new Double(ParserUtils.getDoubleValue((String)value));
            }
            Color c = Color.black;
            String color = breakpoint.getAttribute("color");
            if (color != null && color.length() > 0) {
                c = ColorParse.getColorFromString((String)color);
            }
            if (i == 1) {
                Object[] breaks = this.ramp.getBreaks();
                for (int j = 0; j < breaks.length; ++j) {
                    this.ramp.removeBreakPoint(-3, breaks[j], true);
                }
            }
            this.ramp.setBreakPoint(-3, val, c);
            ++i;
        }
        Element exception = null;
        while ((exception = ParserUtils.getChildWithTagName((String)"Exception", (Element)element, (int)i)) != null) {
            Double val = new Double(Double.NaN);
            String value = exception.getAttribute("value");
            if (value != null && value.length() > 0) {
                val = new Double(ParserUtils.getDoubleValue((String)value));
            }
            Color c = Color.black;
            String color = exception.getAttribute("color");
            if (color != null && color.length() > 0) {
                c = ColorParse.getColorFromString((String)color);
            }
            this.ramp.setExceptionBreakPoint(-3, val, c);
            ++i;
        }
        return this.getObject();
    }

    public Element putToXML(Hashtable context, Object instance) {
        Element b;
        int i;
        if (instance != null && instance instanceof ColorInterface) {
            this.ramp = (ColorInterface)instance;
        }
        if (this.ramp == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"ColorRamp");
        rc.setAttribute("name", "ColorRamp" + this.ramp.hashCode());
        rc.setAttribute("underflowColor", ColorParse.getColorStrg((Color)this.ramp.getUnderflowColor(), (boolean)true));
        rc.setAttribute("overflowColor", ColorParse.getColorStrg((Color)this.ramp.getOverflowColor(), (boolean)true));
        rc.setAttribute("missingColor", ColorParse.getColorStrg((Color)this.ramp.getMissingColor(), (boolean)true));
        Object[] breaks = this.ramp.getBreaks();
        Color[] breakColors = this.ramp.getColors();
        if (breaks != null && breakColors != null && breaks.length == breakColors.length) {
            for (i = 0; i < breaks.length; ++i) {
                if (breaks[i] == null || breakColors[i] == null) continue;
                b = ParserUtils.newElement((Hashtable)context, (String)"Break");
                b.setAttribute("value", breaks[i].toString());
                b.setAttribute("color", ColorParse.getColorStrg((Color)breakColors[i], (boolean)true));
                rc.appendChild(b);
            }
        }
        breaks = this.ramp.getExceptions();
        breakColors = this.ramp.getExceptionColors();
        if (breaks != null && breakColors != null && breaks.length == breakColors.length) {
            for (i = 0; i < breaks.length; ++i) {
                if (breaks[i] == null || breakColors[i] == null) continue;
                b = ParserUtils.newElement((Hashtable)context, (String)"Exception");
                b.setAttribute("value", breaks[i].toString());
                b.setAttribute("color", ColorParse.getColorStrg((Color)breakColors[i], (boolean)true));
                rc.appendChild(b);
            }
        }
        return rc;
    }

    public Object getObject() {
        return this.ramp;
    }
}

