/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.xml.parsers.BackgroundParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class ChartTipParser
implements ElementParserInterface {
    TipInterface instance;

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        if (instance != null && instance instanceof TipInterface) {
            this.instance = (TipInterface)instance;
        }
        this.instance = ChartTipParser.parseTipElement(element, this.instance, context);
        return this.instance;
    }

    public Element putToXML(Hashtable context, Object instance) {
        BackgroundParser bg;
        Element e;
        Object obj;
        PropertyInterface tip = null;
        if (instance instanceof PropertyInterface) {
            tip = (PropertyInterface)instance;
        }
        if (tip == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"ChartTip");
        if (tip.hasUserSetValue(8)) {
            rc.setAttribute("tipOpacity", tip.getPropertyValue(8) + "");
        }
        if (tip.hasUserSetValue(5) && (obj = tip.getPropertyValue(5)) instanceof Color) {
            rc.setAttribute("borderColor", ColorParse.getColorStrg((Color)((Color)obj), (boolean)false));
        }
        if (tip.hasUserSetValue(4) && (obj = tip.getPropertyValue(4)) instanceof Color) {
            rc.setAttribute("textColor", ColorParse.getColorStrg((Color)((Color)obj), (boolean)false));
        }
        if (tip.hasUserSetValue(3)) {
            obj = tip.getPropertyValue(3);
            Font f = null;
            if (obj instanceof Font) {
                f = (Font)obj;
            }
            if (f != null) {
                rc.setAttribute("fontName", f.getFamily());
                String style = "";
                if (f.isBold()) {
                    style = style + "bold";
                }
                if (f.isItalic()) {
                    style = style + "italic";
                }
                if (style.length() > 0) {
                    rc.setAttribute("fontStyle", style);
                }
                rc.setAttribute("fontSize", f.getSize() + "");
            }
        }
        if ((e = (bg = new BackgroundParser()).putToXML(context, tip.getPropertyValue(7))) != null) {
            rc.appendChild(e);
        }
        return rc;
    }

    public Object getObject() {
        return null;
    }

    public static TipInterface parseTipElement(Element element, TipInterface instance, Hashtable context) {
        int style;
        String textColor;
        String borderColor;
        if (instance == null || element == null) {
            return null;
        }
        String tipOpacity = element.getAttribute("tipOpacity");
        if (tipOpacity != null && tipOpacity.length() > 0) {
            instance.setChartTipOpacity(ParserUtils.getDoubleValue((String)tipOpacity));
        }
        if ((borderColor = element.getAttribute("borderColor")) != null && borderColor.length() > 0) {
            instance.setChartTipBorderColor(ColorParse.getColorFromString((String)borderColor));
        }
        if ((textColor = element.getAttribute("textColor")) != null && textColor.length() > 0) {
            instance.setChartTipTextColor(ColorParse.getColorFromString((String)textColor));
        }
        String fontName = element.hasAttribute("fontFamily") ? element.getAttribute("fontFamily") : element.getAttribute("fontName");
        String fontSize = element.getAttribute("fontSize");
        String fontStyle = element.getAttribute("fontStyle");
        Font f = instance.getFontObject();
        int size = f == null ? 12 : f.getSize();
        int n = style = f == null ? 0 : f.getStyle();
        if (fontName == null || fontName.length() == 0) {
            String string = fontName = f == null ? "Dialog" : f.getFontName();
        }
        if (fontSize != null && fontSize.length() > 0) {
            size = ParserUtils.getIntValue((String)fontSize);
        }
        if (fontStyle != null && fontStyle.length() > 0) {
            style = fontStyle.equalsIgnoreCase("bold") ? 1 : (fontStyle.equalsIgnoreCase("italic") ? 2 : (fontStyle.equalsIgnoreCase("bolditalic") ? 3 : 0));
        }
        instance.setFontObject(FontManager.getFont((String)fontName, (int)style, (int)size));
        Element bg = ParserUtils.getChildWithTagName((String)"Background", (Element)element);
        if (bg != null) {
            BackgroundParser.parseBackgroundElement(bg, instance.getChartTipBackground(), context);
        }
        return instance;
    }
}

