/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.AbstractBarElement;
import com.sas.graphics.silk.base.BarNonParmElement;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class BarParser
extends ChartParser {
    protected SILKElementInfoReader barInfo = null;

    public BarParser() {
        this(null);
    }

    public BarParser(PropertyInterface instance) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/bar.config";
        this.barInfo = new SILKElementInfoReader(configFile);
        this.barInfo.setInstance(instance);
    }

    @Override
    public Object getFromXML(Hashtable context, Element element, Object instance) {
        if (element != null && element.hasAttribute("orient")) {
            String orient = element.getAttribute("orient");
            this.barInfo = "HORIZONTAL".equalsIgnoreCase(orient) ? new SILKElementInfoReader("com/sas/graphics/silk/xml/parsers/config/hBar.config") : new SILKElementInfoReader("com/sas/graphics/silk/xml/parsers/config/bar.config");
        }
        return super.getFromXML(context, element, instance);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement(context, element, this.barInfo);
        if (this.barInfo.getXmlTarget() instanceof PropertyInterface) {
            int end;
            int start;
            PropertyInterface bar = (PropertyInterface)this.barInfo.getXmlTarget();
            String displayBarRangeStart = element.getAttribute("displayBarRangeStart");
            String displayBarRangeEnd = element.getAttribute("displayBarRangeEnd");
            if (displayBarRangeStart != null && displayBarRangeStart.length() > 0 && displayBarRangeEnd != null && displayBarRangeEnd.length() > 0 && (start = ParserUtils.getIntValue((String)displayBarRangeStart)) < (end = ParserUtils.getIntValue((String)displayBarRangeEnd))) {
                bar.setPropertyValue(809, (Object)new int[]{start, end});
            }
        }
        if (element.hasAttribute("barLabel") && this.getObject() instanceof AbstractBarElement) {
            ((AbstractBarElement)this.getObject()).setShowLabel(ParserUtils.getBooleanValue((String)element.getAttribute("barLabel")));
        }
        if (element.hasAttribute("responseStatDisplay") && this.getObject() instanceof AbstractBarElement) {
            String value = ParserUtils.getString((Object)element.getAttribute("responseStatDisplay"));
            if (value.equalsIgnoreCase("AUTO")) {
                ((BarNonParmElement)this.getObject()).setResponseStatDisplay(0);
            } else if (value.equalsIgnoreCase("OFF")) {
                ((BarNonParmElement)this.getObject()).setResponseStatDisplay(1);
            }
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.toXML("BarChart", context, object, this.barInfo);
        this.getChartXML(rc, object);
        return rc;
    }

    protected void getChartXML(Element elem, Object object) {
        Number val;
        int[] range;
        PropertyInterface bar = null;
        bar = object != null && object instanceof PropertyInterface ? (PropertyInterface)object : (PropertyInterface)this.barInfo.getXmlTarget();
        if (bar.hasUserSetValue(809) && object != null && (range = (int[])bar.getPropertyValue(809)) != null && range.length == 2) {
            elem.setAttribute("displayBarRangeStart", Integer.toString(range[0]));
            elem.setAttribute("displayBarRangeEnd", Integer.toString(range[1]));
        }
        if (object != null && bar.hasUserSetValue(818)) {
            val = (Integer)bar.getPropertyValue(818);
            if (val != null && (Integer)val == 1) {
                elem.setAttribute("responseStatDisplay", "OFF");
            } else {
                elem.removeAttribute("responseStatDisplay");
            }
        }
        if (object != null && bar.hasUserSetValue(820)) {
            val = (Integer)bar.getPropertyValue(820);
            if (val != null && (Integer)val == 1) {
                elem.setAttribute("groupDisplayType", "Clustered");
            } else {
                elem.removeAttribute("groupDisplayType");
            }
        }
        if (object != null && bar.hasUserSetValue(832) && (val = (Integer)bar.getPropertyValue(832)) != null) {
            bar.setPropertyValue(832, (Object)((Integer)val));
        }
        if (object != null && bar.hasUserSetValue(833) && (val = (Double)bar.getPropertyValue(833)) != null) {
            bar.setPropertyValue(833, (Object)((Double)val));
        }
    }

    @Override
    public Object getObject() {
        return this.barInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        this.barInfo.setInstance(instance);
        return true;
    }
}

