/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceLine;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.xml.parsers.LineStyleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AxisParser
implements ElementParserInterface {
    AxisInterface axis = null;

    public AxisParser() {
        this(new Axes());
    }

    public AxisParser(AxisInterface axisIn) {
        if (axisIn != null) {
            this.axis = axisIn;
        }
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String thresholdVal;
        String visible;
        Element gridlines;
        Element minorTicks;
        Element majorTicks;
        Element vals;
        Element label;
        Element line;
        String axisTransform;
        AxisInterface ai = this.axis;
        if (instance != null && instance instanceof AxisInterface) {
            ai = (AxisInterface)instance;
        }
        if (ai == null) {
            return null;
        }
        boolean equallySpacedDiscrete = false;
        String esd = element.getAttribute("equallySpacedDiscrete");
        if (esd != null && esd.length() > 0) {
            equallySpacedDiscrete = ParserUtils.getBooleanValue((String)esd);
        }
        String pAxisRange = element.getAttribute("parseAxisRange");
        boolean parseAxisRange = true;
        if (pAxisRange != null && pAxisRange.length() > 0) {
            parseAxisRange = ParserUtils.getBooleanValue((String)pAxisRange);
        }
        if (parseAxisRange) {
            String values = element.getAttribute("values");
            if (values != null && values.length() > 0) {
                Object[] valueList = ParserUtils.parseStringArray((String)values, (String)",");
                String discrete = element.getAttribute("discrete");
                if (discrete != null && discrete.length() > 0 && discrete.equalsIgnoreCase("true")) {
                    ai.setAxis(null, null, 0, 0, valueList, new Boolean(false), new Boolean(equallySpacedDiscrete));
                } else {
                    Object[] vals2 = new Double[valueList.length];
                    for (int i = 0; i < vals2.length; ++i) {
                        vals2[i] = new Double(ParserUtils.getDoubleValue((String)valueList[i]));
                    }
                    ai.setAxis(null, null, 0, 0, vals2, new Boolean(false), new Boolean(equallySpacedDiscrete));
                }
            } else {
                String nMajor = element.getAttribute("nMajor");
                int numMajor = -1;
                if (nMajor != null && nMajor.length() > 0) {
                    numMajor = ParserUtils.getIntValue((String)nMajor);
                }
                String nMinor = element.getAttribute("nMinor");
                int numMinor = -1;
                if (nMinor != null && nMinor.length() > 0) {
                    numMinor = ParserUtils.getIntValue((String)nMinor);
                }
                String low = element.getAttribute("low");
                Integer lowValue = null;
                if (low != null && low.length() > 0) {
                    lowValue = new Integer(ParserUtils.getIntValue((String)low));
                }
                String high = element.getAttribute("high");
                Integer highValue = null;
                if (high != null && high.length() > 0) {
                    highValue = new Integer(ParserUtils.getIntValue((String)high));
                }
                String auto = element.getAttribute("autocalculate");
                boolean autoCalc = true;
                if (auto != null && auto.length() > 0) {
                    autoCalc = ParserUtils.getBooleanValue((String)auto);
                }
                ai.setAxis(lowValue, highValue, numMajor, numMinor, null, new Boolean(autoCalc), new Boolean(equallySpacedDiscrete));
            }
        }
        if ((axisTransform = element.getAttribute("axisTransform")) != null && axisTransform.length() > 0 && "Log".equalsIgnoreCase(axisTransform.trim())) {
            double lb;
            String logBase = element.getAttribute("logBase");
            Object base = ai.getTransformInfo(2);
            if (logBase != null && logBase.length() > 0 && !Double.isNaN(lb = ParserUtils.getDoubleValue((String)logBase))) {
                base = new Double(lb);
            }
            ai.setTransformType(2, base);
        }
        if ((line = ParserUtils.getChildWithTagName((String)"Line", (Element)element)) != null) {
            LineStyleParser.parseLineStyle(line, ai.getLine());
        }
        if ((label = ParserUtils.getChildWithTagName((String)"Label", (Element)element)) != null) {
            ai.setLabel(TextParser.parseTextElement(label, ai.getLabel()));
        }
        if ((vals = ParserUtils.getChildWithTagName((String)"Values", (Element)element)) != null) {
            ai.setValues(TextParser.parseTextElement(vals, ai.getValues()));
        }
        if ((majorTicks = ParserUtils.getChildWithTagName((String)"MajorTicks", (Element)element)) != null) {
            ai.setMajorTicks(LineStyleParser.parseLineStyle(majorTicks, ai.getMajorTicks()));
        }
        if ((minorTicks = ParserUtils.getChildWithTagName((String)"MinorTicks", (Element)element)) != null) {
            ai.setMinorTicks(LineStyleParser.parseLineStyle(minorTicks, ai.getMinorTicks()));
        }
        if ((gridlines = ParserUtils.getChildWithTagName((String)"GridLines", (Element)element)) != null) {
            ai.setGridLines(LineStyleParser.parseLineStyle(gridlines, ai.getGridLines()));
        }
        if ((visible = element.getAttribute("visible")) != null && visible.length() > 0 && ai instanceof PropertyInterface) {
            ((PropertyInterface)ai).setPropertyValue(237, (Object)new Boolean(ParserUtils.getBooleanValue((String)visible)));
        }
        if ((thresholdVal = element.getAttribute("thresh")) != null && thresholdVal.length() > 0 && ai instanceof PropertyInterface) {
            ((PropertyInterface)ai).setPropertyValue(247, (Object)new Double(ParserUtils.getDoubleValue((String)thresholdVal)));
        }
        if (element.hasAttribute("reverse")) {
            ((PropertyInterface)ai).setPropertyValue(246, (Object)new Boolean(ParserUtils.getBooleanValue((String)element.getAttribute("reverse"))));
        }
        if (element.hasAttribute("rotated") && ParserUtils.getBooleanValue((String)element.getAttribute("rotated"))) {
            ((PropertyInterface)ai).setPropertyValue(267, (Object)4);
        }
        if (element.hasAttribute("viewMin")) {
            ((PropertyInterface)ai).setPropertyValue(258, (Object)new Double(ParserUtils.getDoubleValue((String)element.getAttribute("viewMin"))));
        }
        if (element.hasAttribute("viewMax")) {
            ((PropertyInterface)ai).setPropertyValue(259, (Object)new Double(ParserUtils.getDoubleValue((String)element.getAttribute("viewMax"))));
        }
        ((PropertyInterface)ai).applyPropertyChanges();
        Element refline = null;
        int index = 1;
        while ((refline = ParserUtils.getChildWithTagName((String)"ReferenceLine", (Element)element, (int)index)) != null) {
            String sameSideLabel;
            String lbl;
            String value = refline.getAttribute("value");
            if (value == null || value.trim().length() == 0) continue;
            ReferenceLine rLine = new ReferenceLine(new Double(ParserUtils.getDoubleValue((String)value)));
            LineStyleInterface lsi = LineStyleParser.parseLineStyle(refline, null);
            rLine.setLine(lsi);
            String textColor = null;
            if (refline.hasAttribute("color")) {
                textColor = refline.getAttribute("color");
            }
            if (textColor != null) {
                refline.removeAttribute("color");
            }
            TextStyleInterface tsi = TextParser.parseTextElement(refline, rLine.getLabel());
            rLine.setLabel(tsi);
            if (textColor != null) {
                refline.setAttribute("color", textColor);
            }
            if ((lbl = refline.getAttribute("label")) != null && lbl.length() > 0) {
                rLine.setLabel(lbl);
            }
            if ((sameSideLabel = element.getAttribute("sameSideLabel")) != null && sameSideLabel.length() > 0) {
                rLine.setSameLabelSide(ParserUtils.getBooleanValue((String)sameSideLabel));
            }
            ai.addReferenceLine(rLine, lbl);
            ++index;
        }
        String referenceValues = element.getAttribute("referenceValues");
        if (referenceValues != null && referenceValues.length() > 0) {
            RangeModel rangeModel = (RangeModel)context.get(referenceValues);
            this.axis.setRangeModel(rangeModel);
        }
        Element referenceRange = null;
        index = 1;
        while ((referenceRange = ParserUtils.getChildWithTagName((String)"ReferenceRange", (Element)element, (int)index++)) != null) {
            ReferenceRange rr = new ReferenceRange();
            if (referenceRange.hasAttribute("low")) {
                rr.setLowValue(new Double(ParserUtils.getDoubleValue((String)referenceRange.getAttribute("low"))));
            }
            if (referenceRange.hasAttribute("lowInclusive")) {
                rr.setLowInclusive(ParserUtils.getBooleanValue((String)referenceRange.getAttribute("lowInclusive")));
            }
            if (referenceRange.hasAttribute("high")) {
                rr.setHighValue(new Double(ParserUtils.getDoubleValue((String)referenceRange.getAttribute("high"))));
            }
            if (referenceRange.hasAttribute("highInclusive")) {
                rr.setHighInclusive(ParserUtils.getBooleanValue((String)referenceRange.getAttribute("highInclusive")));
            }
            RangeModel model = (RangeModel)ai.getRangeModel(true);
            model.add(rr);
        }
        return ai;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return this.putToXML(context, instance, "Axis");
    }

    public Element putToXML(Hashtable context, Object instance, String tagName) {
        Object r;
        TextParser textParser;
        LineStyleParser lineParser;
        Element e;
        AxisInterface axis = null;
        if (instance instanceof AxisInterface) {
            axis = (AxisInterface)instance;
        }
        if (axis == null) {
            return null;
        }
        if (tagName == null) {
            tagName = "Axis";
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)tagName);
        if (!axis.isAxisAutoCalculated()) {
            Object[] values = axis.getTickMarkValues(false);
            String vals = "";
            for (int i = 0; i < values.length; ++i) {
                vals = vals + values[i];
                if (i >= values.length - 1) continue;
                vals = vals + ",";
            }
            rc.setAttribute("values", vals);
            boolean discrete = ((Axes)axis).isDiscrete();
            rc.setAttribute("discrete", new Boolean(discrete).toString());
        }
        if ((e = (lineParser = new LineStyleParser()).putToXML(context, (Object)axis.getLine(), "Line")) != null) {
            rc.appendChild(e);
        }
        if ((e = (textParser = new TextParser()).putToXML(context, (Object)axis.getLabel(), "Label")) != null) {
            rc.appendChild(e);
        }
        if ((e = textParser.putToXML(context, (Object)axis.getValues(), "Values")) != null) {
            rc.appendChild(e);
        }
        if ((e = lineParser.putToXML(context, (Object)axis.getMajorTicks(), "MajorTicks")) != null) {
            rc.appendChild(e);
        }
        if ((e = lineParser.putToXML(context, (Object)axis.getMinorTicks(), "MinorTicks")) != null) {
            rc.appendChild(e);
        }
        if ((e = lineParser.putToXML(context, (Object)axis.getGridLines(), "GridLines")) != null) {
            rc.appendChild(e);
        }
        int num = axis.getNumberReferenceLines();
        for (int i = 0; i < num; ++i) {
            ReferenceLineInterface rli = axis.getReferenceLine(i);
            r = ParserUtils.newElement((Hashtable)context, (String)"ReferenceLine");
            r.setAttribute("value", rli.getValue().toString());
            LineStyleParser lParser = new LineStyleParser();
            lParser.putToXML(context, (Object)rli.getLine(), (Element)r);
            TextParser tParser = new TextParser();
            tParser.putToXML(context, (Object)rli, (Element)r);
            r.setAttribute("label", rli.getLabelString());
            r.setAttribute("sameSideLabel", rli.getSameLabelSide() + "");
            if (r == null) continue;
            rc.appendChild((Node)r);
        }
        RangeModel rm = (RangeModel)axis.getRangeModel(false);
        if (rm != null) {
            for (int i = 0; i < rm.ranges(); ++i) {
                r = rm.getRangeAt(i);
                Element rr = ParserUtils.newElement((Hashtable)context, (String)"ReferenceRange");
                rr.setAttribute("low", ((ReferenceRange)r).getLowValue().toString());
                rr.setAttribute("lowInclusive", ((ReferenceRange)r).getLowInclusive() + "");
                rr.setAttribute("high", ((ReferenceRange)r).getHighValue().toString());
                rr.setAttribute("highInclusive", ((ReferenceRange)r).getHighInclusive() + "");
                rc.appendChild(rr);
            }
        }
        int transformType = axis.getTransformType();
        switch (transformType) {
            default: {
                break;
            }
            case 2: {
                rc.setAttribute("axisTransform", "Log");
                Object o = axis.getTransformInfo(transformType);
                if (!(o instanceof Number)) break;
                rc.setAttribute("logBase", o.toString());
            }
        }
        if (axis instanceof PropertyInterface) {
            Object uMax;
            Object uMin;
            int pv;
            PropertyInterface pi = (PropertyInterface)axis;
            if (pi.hasUserSetValue(237)) {
                rc.setAttribute("visible", pi.getPropertyValue(237).toString());
            }
            if (pi.hasUserSetValue(247)) {
                rc.setAttribute("threshold", pi.getPropertyValue(247).toString());
            }
            if (pi.hasUserSetValue(246)) {
                rc.setAttribute("reverse", pi.getPropertyValue(246).toString());
            }
            if (pi.hasUserSetValue(267) && ((pv = ((Number)pi.getPropertyValue(267)).intValue()) == 4 || pv == 5)) {
                rc.setAttribute("rotated", "true");
            }
            if ((uMin = pi.getPropertyValue(258)) instanceof Number && !Double.isNaN(((Number)uMin).doubleValue())) {
                rc.setAttribute("viewMin", ((Number)uMin).doubleValue() + "");
            }
            if ((uMax = pi.getPropertyValue(259)) instanceof Number && !Double.isNaN(((Number)uMax).doubleValue())) {
                rc.setAttribute("viewMax", ((Number)uMax).doubleValue() + "");
            }
        }
        if (rc.getAttributes().getLength() == 0 && rc.getChildNodes().getLength() == 0) {
            return null;
        }
        return rc;
    }

    public Object getObject() {
        return null;
    }
}

