/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml;

import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.xml.GraphParser;
import com.sas.graphics.xml.GraphParserFactory;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SILKXMLParser
extends GraphParser {
    private static SILKXMLParser instance = null;

    protected SILKXMLParser() {
    }

    public static SILKXMLParser getInstance() {
        if (instance == null) {
            instance = new SILKXMLParser();
        }
        return instance;
    }

    public void load(Hashtable context, Element element) {
        NodeList children = element.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element e = (Element)child;
            String tagName = e.getTagName();
            ElementParserInterface loader = GraphParserFactory.loadParser((String)tagName);
            if (loader != null) {
                Object instance = null;
                if (context.containsKey("OVERLAY_ACTIVE") && Boolean.TRUE.equals(context.get("OVERLAY_ACTIVE"))) {
                    String name = e.getAttribute("name");
                    Object o = context.get("CURRENT_OVERLAY");
                    if (o != null && o instanceof BaseElementComponent) {
                        instance = ((BaseElementComponent)o).getChart(name);
                    }
                }
                loader.getFromXML(context, e, instance);
                continue;
            }
            this.load(context, e);
        }
    }

    public double getCurrentVersion(Hashtable context) {
        if (context == null || !context.containsKey("XML_VERSION")) {
            return VERSION_PRE_9_2;
        }
        String ver = context.get("XML_VERSION").toString();
        if (ver.equalsIgnoreCase("9.2C")) {
            return VERSION_9_2_C;
        }
        if (ver.equalsIgnoreCase("9.2")) {
            return VERSION_9_2;
        }
        if (ver.equalsIgnoreCase("9.2_S2DVR")) {
            return VERSION_9_2_S2DVR;
        }
        return VERSION_PRE_9_2;
    }

    public Element getXMLElement(Hashtable context, Object object) {
        Element sg = super.getXMLElement(context, object);
        if (sg != null && !SILKGlobal.isFlagSet(4)) {
            sg.setAttribute("silkCompat", "true");
        }
        return sg;
    }
}

