/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml;

import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKXMLParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.Extract;
import com.sas.graphics.xml.GraphParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SILKParser {
    protected static SILKXMLParser xmlParser;
    public static final int XML_TYPE_STATGRAPH = 0;
    public static final int XML_TYPE_ODS = 1;
    public static final String CONTEXT_KEY_XMLTYPE = "XML_TYPE";
    public static final String CONTEXT_KEY_DATALIST = "DATA_LIST";
    public static final String CONTEXT_KEY_CHARTLIST = "CHART_LIST";
    public static final String CONTEXT_KEY_STYLELIST = "STYLE_LIST";
    public static final String CONTEXT_KEY_COLORRAMPLIST = "COLOR_RAMP_LIST";
    public static final String CONTEXT_KEY_DEFAULT_STYLE = "DEFAULT_STYLE";
    public static final String CONTEXT_KEY_APPLET_CONTEXT = "APPLET_CONTEXT";
    public static final String CONTEXT_KEY_SCRIPT_ROLES = "SCRIPT_ROLES";
    public static final String CONTEXT_KEY_SILK_DESKTOP = "SILK_DESKTOP";
    public static final String CONTEXT_KEY_META_TABLE = "META_TABLE";
    public static final String CONTEXT_KEY_XML_DOCUMENT = "XML_DOCUMENT";
    public static final String CONTEXT_KEY_SAVE_VIEW_STATE = "SAVE_VIEW_STATE";
    public static final String CONTEXT_KEY_OVERLAY_ACTIVE = "OVERLAY_ACTIVE";
    public static final String CONTEXT_KEY_CURRENT_OVERLAY = "CURRENT_OVERLAY";
    public static final String CONTEXT_KEY_ROLE_INDEX = "ROLE_INDEX";
    public static final String CONTEXT_KEY_SCRIPT_STATGRAPH_WRAPPER = "SCRIPT_STATGRAPH";
    public static final String CONTEXT_KEY_XML_VERSION = "XML_VERSION";
    public static final String CONTEXT_KEY_STYLE_COLLECTION = "STYLE_COLLECTION";
    public static final String XML_VERSION_9_2 = "9.2";
    public static final String XML_VERSION_9_2_C = "9.2C";
    public static double VERSION_PRE_9_2;
    public static double VERSION_9_2_C;
    public static double VERSION_9_2;
    public static final String XML_CURRENT_VERSION = "9.2";
    public static final double CURRENT_VERSION;

    public static void load(Hashtable context, Element element) {
        xmlParser.load(context, element);
    }

    public static boolean addColorRamp(Hashtable context, String colorRamp) {
        if (context == null) {
            return false;
        }
        if (!context.containsKey(CONTEXT_KEY_COLORRAMPLIST)) {
            context.put(CONTEXT_KEY_COLORRAMPLIST, new Vector());
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_COLORRAMPLIST);
        if (colorRamp == null || vec.contains(colorRamp)) {
            return false;
        }
        vec.addElement(colorRamp);
        return true;
    }

    public static ColorInterface getColorRamp(Hashtable context, String rampName) {
        Object obj = context.get(rampName);
        if (obj == null || !(obj instanceof ColorInterface)) {
            return null;
        }
        return (ColorInterface)obj;
    }

    public static String getStandAloneXML(Hashtable context, Object object, boolean saveViewState) {
        if (context == null) {
            context = new Hashtable<String, StyleCollection>();
        }
        StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
        context.put(CONTEXT_KEY_STYLE_COLLECTION, sc);
        return xmlParser.getStandAloneXML(context, object, saveViewState);
    }

    private static String getXMLString(File file) {
        String xml;
        block6: {
            xml = "";
            String prop = System.getProperty("os.name");
            if (prop != null && prop.toUpperCase().contains("Z/OS")) {
                try {
                    FileReader fr = new FileReader(file);
                    Element e = GraphParser.getElement((Reader)fr);
                    xml = ParserUtils.toString((Node)e);
                    fr.close();
                }
                catch (Exception e) {
                    if (SILKXMLParser.getErrorStream() != null) {
                        e.printStackTrace(SILKXMLParser.getErrorStream());
                    }
                    break block6;
                }
            }
            try {
                FileInputStream fis = new FileInputStream(file);
                Element e = GraphParser.getElement((InputStream)fis);
                xml = ParserUtils.toString((Node)e);
                fis.close();
            }
            catch (Exception e) {
                if (SILKXMLParser.getErrorStream() == null) break block6;
                e.printStackTrace(SILKXMLParser.getErrorStream());
            }
        }
        return xml;
    }

    public static Hashtable parse(File file) {
        return SILKParser.parse(new Hashtable(), file);
    }

    public static Hashtable parse(Hashtable context, File file) {
        String xml;
        block3: {
            xml = "";
            if (file == null || !file.exists()) {
                return context;
            }
            try {
                xml = SILKParser.getXMLString(file);
            }
            catch (Exception e) {
                if (SILKXMLParser.getErrorStream() == null) break block3;
                e.printStackTrace(SILKXMLParser.getErrorStream());
            }
        }
        return SILKParser.parse(context, xml);
    }

    public static Hashtable parse(String xml) {
        Hashtable context = new Hashtable();
        return SILKParser.parse(context, xml);
    }

    public static Hashtable parse(Hashtable context, String xml) {
        String view;
        if (context == null) {
            context = new Hashtable();
        }
        SILKParser.determineXMLType(context, xml);
        String data = SILKParser.getData(xml);
        if (data != null) {
            data = data.trim();
        }
        if ((view = SILKParser.getView(xml)) != null) {
            view = view.trim();
        }
        if (view != null && view.startsWith("<?") && view.endsWith("?>")) {
            view = null;
        }
        String formats = SILKParser.getFormats(xml);
        return SILKParser.parse(context, data, view, formats);
    }

    public static Hashtable parse(File data, File view) {
        String viewXML;
        String dataXML;
        block4: {
            dataXML = "";
            viewXML = "";
            try {
                if (data != null && data.exists()) {
                    dataXML = SILKParser.getXMLString(data);
                }
                if (view != null && view.exists()) {
                    viewXML = SILKParser.getXMLString(view);
                }
            }
            catch (Exception e) {
                if (SILKXMLParser.getErrorStream() == null) break block4;
                e.printStackTrace(SILKXMLParser.getErrorStream());
            }
        }
        return SILKParser.parse(dataXML, viewXML);
    }

    public static Hashtable parse(String data, String view) {
        Hashtable context = new Hashtable();
        return SILKParser.parse(context, data, view);
    }

    public static Hashtable parse(Hashtable context, String data, String view) {
        String formats = SILKParser.getFormats(data);
        if (formats == null || formats.length() == 0) {
            formats = SILKParser.getFormats(view);
        }
        return SILKParser.parse(context, data, view, formats);
    }

    public static Hashtable parse(Hashtable context, String data, String view, String formats) {
        return xmlParser.parse(context, data, view, formats);
    }

    public static String getXML(Object object) {
        return SILKParser.getXML(new Hashtable(), object);
    }

    public static String getXML(Hashtable context, Object object, boolean saveViewState) {
        return xmlParser.getXML(context, object, saveViewState);
    }

    public static String getXML(Hashtable context, Object object) {
        return SILKParser.getXML(context, object, false);
    }

    public static Element getXMLElement(Object object) {
        return SILKParser.getXMLElement(new Hashtable(), object);
    }

    public static Element getXMLElement(Hashtable context, Object object) {
        return xmlParser.getXMLElement(context, object);
    }

    public static Element getXMLElement(Hashtable context, Object object, boolean saveViewState) {
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        context.put(CONTEXT_KEY_SAVE_VIEW_STATE, new Boolean(saveViewState));
        return SILKParser.getXMLElement(context, object);
    }

    public static String getStandAloneXML(Object object) {
        return SILKParser.getStandAloneXML(new Hashtable(), object);
    }

    public static String getStandAloneXML(Hashtable context, Object object) {
        return SILKParser.getStandAloneXML(context, object, false);
    }

    public static boolean initComponentFromXML(Object component, String xml, Hashtable context) {
        if (component == null || xml == null) {
            return false;
        }
        xml = xml.trim();
        Element element = SILKParser.getElement(xml);
        return SILKParser.initComponentFromXML(component, element, context);
    }

    public static boolean initComponentFromXML(Object component, Element element, Hashtable context) {
        return xmlParser.initComponentFromXML(component, element, context);
    }

    public static Element getElement(String xml) {
        return GraphParser.getElement((Reader)new StringReader(xml));
    }

    public static Element getElement(InputStream xml) {
        return SILKXMLParser.getElement((InputStream)xml);
    }

    public static boolean addChart(Hashtable context, String chart) {
        return GraphParser.addChart((Hashtable)context, (String)chart);
    }

    public static boolean removeChart(Hashtable context, String chart) {
        return xmlParser.removeChart(context, chart);
    }

    public static boolean addData(Hashtable context, String data) {
        return SILKXMLParser.addData((Hashtable)context, (String)data);
    }

    public static boolean addStyle(Hashtable context, String style) {
        return xmlParser.addStyle(context, style);
    }

    public static Object[] getDataModels(Hashtable context) {
        return xmlParser.getDataModels(context);
    }

    public static Object[] getCharts(Hashtable context) {
        return xmlParser.getCharts(context);
    }

    public static int getXMLType(Hashtable context) {
        return xmlParser.getXMLType(context);
    }

    public static boolean setAppletContext(Hashtable context, Object applet) {
        return xmlParser.setAppletContext(context, applet);
    }

    public static Hashtable getMetaData(Object obj, Hashtable context) {
        return xmlParser.getMetaData(obj, context);
    }

    public static boolean addMetaData(Object obj, Hashtable context, Hashtable metaData) {
        return xmlParser.addMetaData(obj, context, metaData);
    }

    public static boolean setDataRepository(SourceInterface dri, Hashtable context) {
        return xmlParser.setDataRepository(dri, context);
    }

    public static SourceInterface getDataRepository(Hashtable context) {
        return SILKXMLParser.getDataRepository((Hashtable)context);
    }

    public static Object getData(String name, Hashtable context) {
        return GraphParser.getData((String)name, (Hashtable)context);
    }

    public static boolean saveAsXML(Object objToSave, Hashtable context, boolean standAlone) {
        return xmlParser.saveAsXML(objToSave, context, standAlone);
    }

    public static final String getCurrentXMLVersion() {
        return xmlParser.getCurrentXMLVersion();
    }

    public static void setErrorStream(PrintStream err) {
        SILKXMLParser.setErrorStream((PrintStream)err);
    }

    public static void setOutputStream(PrintStream out) {
        SILKXMLParser.setOutputStream((PrintStream)out);
    }

    public static void setQuietMode(boolean on) {
        xmlParser.setQuietMode(on);
    }

    public static double getCurrentVersion(Hashtable context) {
        return xmlParser.getCurrentVersion(context);
    }

    private static void determineXMLType(Hashtable context, String xml) {
        context.put(CONTEXT_KEY_XMLTYPE, new Integer(0));
    }

    private static String getFormats(String xml) {
        if (xml == null || xml.trim().length() == 0) {
            return null;
        }
        int formatStart = xml.indexOf("<Formats");
        int temp = xml.lastIndexOf("</Formats");
        int formatsEnd = xml.indexOf(62, temp) + 1;
        if (formatStart < 0 || formatsEnd < 0 || formatStart > formatsEnd) {
            return null;
        }
        return xml.substring(formatStart, formatsEnd);
    }

    private static String getData(String xml) {
        if (xml == null || xml.trim().length() == 0) {
            return null;
        }
        int dataStart = xml.indexOf("<Data");
        int temp = xml.lastIndexOf("</Data");
        int dataEnd = xml.indexOf(62, temp) + 1;
        if (dataStart < 0 || dataEnd < 0 || dataStart > dataEnd) {
            return null;
        }
        return xml.substring(dataStart, dataEnd);
    }

    private static String getView(String xml) {
        int formatEnd;
        int temp;
        int dataEnd;
        if (xml == null) {
            return null;
        }
        int dataStart = xml.indexOf("<Data ");
        if (dataStart < 0) {
            dataStart = xml.indexOf("<Data>");
        }
        if (dataStart > (dataEnd = xml.indexOf(62, temp = xml.lastIndexOf("</Data")) + 1)) {
            return null;
        }
        if (dataStart < 0 || dataEnd < 0) {
            return xml;
        }
        String rc = xml.substring(0, dataStart) + xml.substring(dataEnd);
        int formatStart = rc.indexOf("<Formats");
        if (formatStart > (formatEnd = rc.indexOf(62, temp = rc.lastIndexOf("</Formats")) + 1)) {
            return null;
        }
        if (formatStart < 0 || formatEnd < 0) {
            return rc;
        }
        return rc.substring(0, formatStart) + rc.substring(formatEnd);
    }

    public static Object[] getAssignedVariables(Object component) {
        RoleInterface ri;
        Object[] supportedRoles;
        Class<?> rgClass = null;
        Class<?> matrixClass = null;
        Method method = null;
        try {
            rgClass = Class.forName("com.sas.graphics.silk.RegularGridComponent");
            matrixClass = Class.forName("com.sas.graphics.silk.BaseMatrixComponent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (rgClass != null && rgClass.isInstance(component)) {
            Object rc = null;
            try {
                method = rgClass.getMethod("getAssignedVariables", null);
                rc = method.invoke(component, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (rc instanceof Object[]) {
                return (Object[])rc;
            }
        } else if (matrixClass != null && matrixClass.isInstance(component)) {
            Object rc = null;
            try {
                method = matrixClass.getMethod("getAssignedVariables", null);
                rc = method.invoke(component, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (rc instanceof Object[]) {
                return (Object[])rc;
            }
        } else if (component instanceof RoleInterface && (supportedRoles = (ri = (RoleInterface)component).getSupportedRoles(null, true)) != null) {
            Vector vars = new Vector();
            for (int i = 0; i < supportedRoles.length; ++i) {
                Object allVars = ri.getAllVariables(supportedRoles[i]);
                if (allVars == null) continue;
                Enumeration e = Extract.elements((Object)allVars);
                while (e.hasMoreElements()) {
                    Object var = e.nextElement();
                    if (vars.contains(var)) continue;
                    vars.add(var);
                }
            }
            if (vars.size() > 0) {
                return vars.toArray();
            }
        }
        return null;
    }

    static {
        SILKGlobal.loadSILKParsers();
        xmlParser = SILKXMLParser.getInstance();
        VERSION_PRE_9_2 = GraphParser.VERSION_PRE_9_2;
        VERSION_9_2_C = GraphParser.VERSION_9_2_C;
        CURRENT_VERSION = VERSION_9_2 = GraphParser.VERSION_9_2;
    }
}

