/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import com.sas.graphics.data.Filter2TableModel;
import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.TableConstants;
import java.awt.Color;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableMap
extends AbstractTableModel
implements TableModelListener {
    private static final long serialVersionUID = -6457303129537437193L;
    public static final int SUM = 0;
    public static final int MEAN = 1;
    public static final int MEDIAN = 2;
    public static final int MODE = 3;
    public static final int STD = 4;
    public static final int N = 5;
    public static final int NUM_META = 6;
    protected static String META_HEADER;
    protected static String[] META_NAME;
    protected TableModel model;
    protected String whereClause;
    protected String[] displayColumns;
    protected Vector rowIndexMap;
    protected Vector columnIndexMap;
    protected int numMeta;
    protected boolean[] metaFlag;
    protected Object[][][] columnMeta;
    protected String byVariable;
    protected Vector byNames;
    protected boolean obsNumberColumnVisible = false;
    public static String OBS_HEADER;
    public static String OBS_HEADER_KEY;
    protected ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.util.table.Table");

    public TableMap() {
        TableMap.META_NAME[0] = this.GRS(this.resourceBundle, "Stat.Label.Sum.txt", "Sum");
        TableMap.META_NAME[1] = this.GRS(this.resourceBundle, "Stat.Label.Mean.txt", "Mean");
        TableMap.META_NAME[2] = this.GRS(this.resourceBundle, "Stat.Label.Median.txt", "Median");
        TableMap.META_NAME[3] = this.GRS(this.resourceBundle, "Stat.Label.Mode.txt", "Mode");
        TableMap.META_NAME[4] = this.GRS(this.resourceBundle, "Stat.Label.STD.txt", "STD");
        TableMap.META_NAME[5] = this.GRS(this.resourceBundle, "Stat.Label.N.txt", "N");
        META_HEADER = this.GRS(this.resourceBundle, "Stat.Label.Summary.txt", "Summary");
        OBS_HEADER_KEY = "ObsNumber";
        OBS_HEADER = this.GRS(this.resourceBundle, "ObsNumber.txt", "Obs #");
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.model = model;
        model.addTableModelListener(this);
        this.rowIndexMap = new Vector();
        this.columnIndexMap = new Vector();
        this.metaFlag = new boolean[6];
        this.columnMeta = new Object[6][][];
        for (int i = 0; i < 6; ++i) {
            this.metaFlag[i] = false;
        }
        this.numMeta = 0;
        this.byVariable = null;
        this.byNames = new Vector();
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return new Integer(this.getRowIndexInModel(aRow + 1));
        }
        if (aRow < this.getRowCount() - this.getMetaRowCount() && aColumn >= this.getMetaColumnCount()) {
            return this.model.getValueAt(this.getRowIndexInModel(aRow), this.getColumnIndexInModel(aColumn));
        }
        if (aRow < this.getRowCount() - this.getMetaRowCount() && aColumn < this.getMetaColumnCount()) {
            return "";
        }
        if (aRow >= this.getRowCount() - this.getMetaRowCount() && aColumn >= this.getMetaColumnCount()) {
            return this.columnMeta[this.getMetaTypeIndex(aRow)][this.getMetaRowIndex(aRow)][this.getMetaColumnIndex(aColumn)];
        }
        return this.getMetaRowName(aRow);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.model.setValueAt(aValue, aRow, aColumn);
    }

    public String getLink(int aRow, int aColumn) {
        if (aRow >= this.getRowCount() - this.getMetaRowCount() || aColumn < this.getMetaColumnCount()) {
            return null;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getLink(this.getRowIndexInModel(aRow), this.getColumnIndexInModel(aColumn));
        }
        return null;
    }

    public Color getCellItemColor(int aRow, int aColumn) {
        if (aRow >= this.getRowCount() - this.getMetaRowCount() || aColumn < this.getMetaColumnCount()) {
            return null;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getCellItemColor(this.getRowIndexInModel(aRow), this.getColumnIndexInModel(aColumn));
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.rowIndexMap.size() == 0) {
            return this.model == null ? 0 : this.model.getRowCount() + this.getMetaRowCount();
        }
        return this.rowIndexMap.size() + this.getMetaRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.columnIndexMap == null) {
            return 0;
        }
        if (this.columnIndexMap.size() == 0) {
            if (this.model == null) {
                return 0;
            }
            if (this.obsNumberColumnVisible) {
                return this.model.getColumnCount() + 1;
            }
            return this.model.getColumnCount() + this.getMetaColumnCount();
        }
        if (this.obsNumberColumnVisible) {
            return this.columnIndexMap.size() + 1;
        }
        return this.columnIndexMap.size() + this.getMetaColumnCount();
    }

    @Override
    public String getColumnName(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return OBS_HEADER;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return META_HEADER;
        }
        return this.model.getColumnName(this.getColumnIndexInModel(aColumn));
    }

    public Class getColumnClass(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return Integer.class;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return String.class;
        }
        int colIdx = this.getColumnIndexInModel(aColumn);
        if (colIdx >= 0) {
            return this.model.getColumnClass(colIdx);
        }
        return String.class;
    }

    public String getColumnFormat(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return "NONE";
        }
        if (aColumn < this.getMetaColumnCount()) {
            return "NONE";
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getColumnFormat(this.getColumnIndexInModel(aColumn));
        }
        return null;
    }

    public String getColumnLink(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return null;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return null;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getColumnLink(this.getColumnIndexInModel(aColumn));
        }
        return null;
    }

    public int getColumnWidth(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return -1;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return -1;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getColumnWidth(this.getColumnIndexInModel(aColumn));
        }
        return 0;
    }

    public boolean getColumnWrap(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return false;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return false;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getColumnWrap(this.getColumnIndexInModel(aColumn));
        }
        return false;
    }

    public boolean isHeaderWrapped() {
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).isHeaderWrapped();
        }
        return false;
    }

    public int getFullModelColumnCount() {
        if (this.model == null) {
            return 0;
        }
        if (this.obsNumberColumnVisible) {
            return this.model.getColumnCount() + 1;
        }
        return this.model.getColumnCount() + this.getMetaColumnCount();
    }

    public Object getObsNumberValueAt(int aRow) {
        if (this.model == null) {
            return null;
        }
        return new Integer(this.getRowIndexInModel(aRow));
    }

    public Object getFullModelValueAt(int aRow, int aColumn) {
        if (this.model == null) {
            return null;
        }
        int metaColumnCount = this.getMetaColumnCount();
        int metaRowCount = this.getMetaRowCount();
        if (aRow < this.getRowCount() - metaRowCount && aColumn >= metaColumnCount) {
            return this.model.getValueAt(this.getRowIndexInModel(aRow), aColumn - metaColumnCount);
        }
        if (aRow < this.getRowCount() - metaRowCount && aColumn < metaColumnCount) {
            return "";
        }
        if (aRow >= this.getRowCount() - metaRowCount && aColumn >= metaColumnCount) {
            return this.columnMeta[this.getMetaTypeIndex(aRow)][this.getMetaRowIndex(aRow)][this.getMetaColumnIndex(aColumn)];
        }
        return this.getMetaRowName(aRow);
    }

    public Class getFullModelColumnClass(int aColumn) {
        int metaColumnCount;
        if (this.obsNumberColumnVisible) {
            if (aColumn == 0) {
                return Integer.class;
            }
            --aColumn;
        }
        if (aColumn < (metaColumnCount = this.getMetaColumnCount())) {
            return String.class;
        }
        return this.model.getColumnClass(aColumn - metaColumnCount);
    }

    public int getRenderMode(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return TableConstants.RENDERMODE_TEXT;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return TableConstants.RENDERMODE_TEXT;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getRenderMode(this.getColumnIndexInModel(aColumn));
        }
        return -1;
    }

    public String getColumnDescription(int aColumn) {
        if (this.obsNumberColumnVisible && aColumn == 0) {
            return null;
        }
        if (aColumn < this.getMetaColumnCount()) {
            return null;
        }
        if (this.model instanceof GTableModel) {
            return ((GTableModel)this.model).getColumnDescription(this.getColumnIndexInModel(aColumn));
        }
        return null;
    }

    public String getMetaHeaderString() {
        return META_HEADER;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (row >= this.getRowCount() - this.getMetaRowCount()) {
            return false;
        }
        return this.model.isCellEditable(this.getRowIndexInModel(row), this.getColumnIndexInModel(column));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() instanceof Filter2TableModel && this.model instanceof GTableModel) {
            ((GTableModel)this.model).setDataChanged(true);
        }
        this.fireTableChanged(e);
        if (e.getSource() instanceof Filter2TableModel && this.model instanceof GTableModel) {
            ((GTableModel)this.model).setDataChanged(false);
        }
    }

    public int getMetaRowCount() {
        return this.byVariable == null ? this.numMeta : this.numMeta * this.byNames.size();
    }

    public int getMetaColumnCount() {
        return this.numMeta == 0 ? 0 : 1;
    }

    public String getMetaName(int i) {
        if (i < 0 || i >= META_NAME.length) {
            return null;
        }
        return META_NAME[i];
    }

    protected String getMetaRowName(int aRow) {
        int idx = this.getMetaRowIndex(aRow);
        if (this.byNames.size() == 0) {
            return META_NAME[this.getMetaTypeIndex(aRow)];
        }
        return META_NAME[this.getMetaTypeIndex(aRow)] + "(" + this.byNames.elementAt(idx) + ")";
    }

    protected int getMetaTypeIndex(int aRow) {
        int i;
        int idx = aRow - (this.getRowCount() - this.getMetaRowCount());
        int numItems = this.byVariable == null ? 1 : this.byNames.size();
        idx /= numItems;
        int n = -1;
        for (i = 0; i < this.metaFlag.length; ++i) {
            if (this.metaFlag[i]) {
                ++n;
            }
            if (n == idx) break;
        }
        return i;
    }

    protected int getMetaRowIndex(int aRow) {
        int idx = aRow - (this.getRowCount() - this.getMetaRowCount());
        int numItems = this.byVariable == null ? 1 : this.byNames.size();
        return idx %= numItems;
    }

    protected int getMetaColumnIndex(int aColumn) {
        return aColumn - this.getMetaColumnCount();
    }

    public String getByVariable() {
        return this.byVariable;
    }

    public void setByVariable(String by) {
        if (this.byVariable == null && by == null) {
            return;
        }
        if (this.byVariable != null && this.byVariable.equals(by)) {
            return;
        }
        this.byVariable = by;
        this.updateByNames();
        if (this.numMeta > 0) {
            this.tableChanged(new TableModelEvent(this.model, -1));
        }
    }

    protected void updateByNames() {
        this.byNames.removeAllElements();
        if (this.byVariable == null) {
            return;
        }
        int col = -1;
        if (this.model instanceof GTableModel) {
            col = ((GTableModel)this.model).getColumnIndex(this.byVariable);
        }
        if (col < 0) {
            return;
        }
        if (this.model.getColumnClass(col) != String.class) {
            return;
        }
        int rowCount = this.getRowCount() - this.getMetaRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int row = this.getRowIndexInModel(i);
            String value = (String)this.model.getValueAt(row, col);
            if (this.byNames.contains(value)) continue;
            this.byNames.addElement(value);
        }
    }

    public Vector getByNames() {
        return this.byNames;
    }

    public void showSummary(int type) {
        boolean fire;
        if (type < 0 || type >= 6) {
            return;
        }
        boolean bl = fire = this.numMeta == 0;
        if (!this.metaFlag[type]) {
            ++this.numMeta;
        }
        this.metaFlag[type] = true;
        if (fire) {
            this.tableChanged(new TableModelEvent(this.model, -1));
        } else {
            this.tableChanged(new TableModelEvent(this.model));
        }
    }

    public void hideSummary(int type) {
        if (type < 0 || type >= 6) {
            return;
        }
        int numMeta_old = this.numMeta--;
        if (this.metaFlag[type]) {
            // empty if block
        }
        this.metaFlag[type] = false;
        if (numMeta_old > 0 && this.numMeta <= 0) {
            this.tableChanged(new TableModelEvent(this.model, -1));
        } else {
            this.tableChanged(new TableModelEvent(this.model));
        }
    }

    public void removeFilter() {
        this.rowIndexMap.removeAllElements();
        this.tableChanged(new TableModelEvent(this.model, -1));
    }

    public String[] getDisplayColumns() {
        return this.displayColumns;
    }

    public void setDisplayColumns(String[] columnNames) {
        this.displayColumns = columnNames;
        this.columnIndexMap.removeAllElements();
        for (int i = 0; i < columnNames.length; ++i) {
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                if (!columnNames[i].equals(this.model.getColumnName(j))) continue;
                this.columnIndexMap.addElement(new Integer(j));
            }
        }
        this.tableChanged(new TableModelEvent(this.model, -1));
    }

    public void setHiddenColumn(int aCol) {
        if (aCol < 0) {
            return;
        }
        if (this.obsNumberColumnVisible && aCol != 0) {
            --aCol;
        }
        if (this.model.getColumnCount() <= 1) {
            return;
        }
        if (this.columnIndexMap.size() == 1) {
            return;
        }
        aCol -= this.getMetaColumnCount();
        if (this.columnIndexMap.size() == 0) {
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                if (j == aCol) continue;
                this.columnIndexMap.addElement(new Integer(j));
            }
        } else {
            this.columnIndexMap.removeElementAt(aCol);
        }
        this.updateColumnMetadata();
        this.tableChanged(new TableModelEvent(this.model, -1));
    }

    public boolean isColumnVisible(String colName) {
        int i;
        if (colName == null) {
            return false;
        }
        if (this.columnIndexMap.size() == 0) {
            return true;
        }
        int modelColumnIndex = -1;
        for (i = 0; i < this.model.getColumnCount(); ++i) {
            if (!colName.equalsIgnoreCase(this.model.getColumnName(i))) continue;
            modelColumnIndex = i;
            break;
        }
        if (modelColumnIndex >= 0) {
            for (i = 0; i < this.columnIndexMap.size(); ++i) {
                int col = ((Number)this.columnIndexMap.elementAt(i)).intValue();
                if (modelColumnIndex != col) continue;
                return true;
            }
        }
        return false;
    }

    public void showAllColumns() {
        this.columnIndexMap.removeAllElements();
        this.updateColumnMetadata();
        this.tableChanged(new TableModelEvent(this.model, -1));
    }

    protected void updateColumnMetadata() {
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String where) {
        this.whereClause = where;
        this.parseWhereClause();
        this.updateByNames();
        this.tableChanged(new TableModelEvent(this.model));
    }

    protected void parseWhereClause() {
        String delimiter = new String("__&,");
        int idx = this.whereClause.indexOf(">=");
        if (idx < 0) {
            idx = this.whereClause.indexOf("<=");
        }
        if (idx < 0) {
            idx = this.whereClause.indexOf("=");
        }
        if (idx < 0) {
            return;
        }
        String colName = this.whereClause.substring(0, idx - 1).trim();
        String leftStr = this.whereClause.substring(idx).trim();
        if (leftStr.startsWith("=")) {
            Vector<String> values = new Vector<String>();
            if (leftStr.length() >= 2) {
                leftStr = leftStr.substring(2);
                while (leftStr.length() > 0) {
                    String valStr;
                    idx = leftStr.indexOf(delimiter);
                    if (idx < 0) {
                        valStr = leftStr.trim();
                        values.addElement(valStr);
                        break;
                    }
                    valStr = leftStr.substring(0, idx).trim();
                    values.addElement(valStr);
                    leftStr = leftStr.substring(idx + delimiter.length()).trim();
                }
            }
            this.processWhereClause(colName, values);
        } else if (leftStr.startsWith(">=")) {
            String start = leftStr.substring(2).trim();
            start = start.substring(0, start.indexOf(" ")).trim();
            String end = null;
            idx = leftStr.indexOf("<=");
            if (idx >= 0) {
                end = leftStr.substring(idx + 2).trim();
            }
            this.processWhereClause(colName, start, end);
        } else if (leftStr.startsWith("<=")) {
            String end = leftStr.substring(2).trim();
            end = end.substring(0, end.indexOf(" ")).trim();
            this.processWhereClause(colName, null, end);
        }
    }

    private void processWhereClause(String colName, String start, String end) {
        Object obj;
        double startValue = -1.7976931348623157E308;
        double endValue = Double.MAX_VALUE;
        if (start != null && (obj = this.parseValue(start, Double.class)) != null) {
            startValue = (Double)obj;
        }
        if (end != null && (obj = this.parseValue(end, Double.class)) != null) {
            endValue = (Double)obj;
        }
        this.rowIndexMap.removeAllElements();
        int col = ((GTableModel)this.model).getColumnIndex(colName);
        if (col < 0) {
            return;
        }
        if (this.model.getColumnClass(col).getSuperclass() == Number.class) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                double d;
                Object obj2 = this.model.getValueAt(i, col);
                if (obj2 == null || !((d = ((Number)obj2).doubleValue()) >= startValue) || !(d <= endValue)) continue;
                this.rowIndexMap.addElement(new Integer(i));
            }
        }
    }

    private void processWhereClause(String colName, Vector values) {
        this.rowIndexMap.removeAllElements();
        int col = ((GTableModel)this.model).getColumnIndex(colName);
        if (col < 0) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            Object obj = this.parseValue((String)values.elementAt(i), null);
            if (obj == null) continue;
            if (obj instanceof Number && this.model.getColumnClass(col).getSuperclass() == Number.class) {
                double d1 = ((Number)obj).doubleValue();
                for (int j = 0; j < this.model.getRowCount(); ++j) {
                    Object obj2 = this.model.getValueAt(j, col);
                    double d2 = ((Number)obj2).doubleValue();
                    if (d1 != d2) continue;
                    this.rowIndexMap.addElement(new Integer(j));
                }
                continue;
            }
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                Object obj2 = this.model.getValueAt(j, col);
                if (!obj.equals(obj2)) continue;
                this.rowIndexMap.addElement(new Integer(j));
            }
        }
    }

    private Object parseValue(String value, Class retType) {
        Object retValue;
        value = value.trim();
        if (retType == null && value.startsWith("'") && value.endsWith("'")) {
            retValue = value.substring(1, value.length() - 1);
        } else {
            try {
                retValue = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                retValue = null;
            }
        }
        return retValue;
    }

    public int getRowIndexInModel(int aRow) {
        int idx = this.rowIndexMap.size() == 0 ? aRow : (Integer)this.rowIndexMap.elementAt(aRow);
        return idx;
    }

    public int getColumnIndexInModel(int aCol) {
        if (aCol < 0) {
            return -1;
        }
        int mapSize = this.columnIndexMap.size();
        if (this.obsNumberColumnVisible) {
            if (aCol == 0) {
                return aCol;
            }
            if (mapSize == 0) {
                return aCol - 1;
            }
            if (aCol - 1 < mapSize) {
                return (Integer)this.columnIndexMap.elementAt(aCol - 1);
            }
        }
        int idx = aCol -= this.getMetaColumnCount();
        if (mapSize == 0) {
            idx = aCol;
        } else if (aCol < mapSize && aCol >= 0) {
            idx = (Integer)this.columnIndexMap.elementAt(aCol);
        }
        return idx;
    }

    public int getColumnIndexInVisibleModel(int aCol) {
        int idx;
        if ((aCol -= this.getMetaColumnCount()) < 0) {
            return -1;
        }
        if (this.columnIndexMap.size() == 0) {
            idx = aCol;
        } else {
            idx = -1;
            for (int i = 0; i < this.columnIndexMap.size(); ++i) {
                if (aCol != (Integer)this.columnIndexMap.elementAt(i)) continue;
                idx = i;
                break;
            }
        }
        if (idx >= 0) {
            idx += this.getMetaColumnCount();
            if (this.obsNumberColumnVisible) {
                ++idx;
            }
        }
        return idx;
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    public String getMetaHeader() {
        return META_HEADER;
    }

    public boolean isObsNumberColumnVisible() {
        return this.obsNumberColumnVisible;
    }

    public void setObsNumberColumnVisible(boolean obsNumberColumnVisible) {
        this.obsNumberColumnVisible = obsNumberColumnVisible;
    }

    public void setObsColumnHeader(String obsHeader) {
        if (obsHeader == null) {
            return;
        }
        OBS_HEADER = obsHeader;
    }

    public String getObsColumnHeader() {
        return OBS_HEADER;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        this.model = null;
    }

    static {
        META_NAME = new String[6];
    }
}

