/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.TableMap;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.TableModel;

public class GTableSummary {
    protected TableMap model;
    private int frequency;

    public GTableSummary(TableModel m) {
        this.model = (TableMap)m;
    }

    public Object getColumnSum(int aColumn) {
        Class columnClass = this.model.getColumnClass(aColumn);
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        boolean dateTime = false;
        String fmtString = this.model.getColumnFormat(aColumn);
        SASFormat format = SASFormat.getInstance((String)fmtString);
        if (format instanceof SASDateTimeFormat) {
            dateTime = true;
        }
        this.frequency = 0;
        if (columnClass == Integer.class && !dateTime) {
            int total = 0;
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                if (obj == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Integer value = (Integer)obj;
                total += value.intValue();
                ++this.frequency;
            }
            return new Integer(total);
        }
        if (columnClass == Double.class && !dateTime) {
            double total = 0.0;
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                if (obj == null || Double.isNaN((Double)obj)) continue;
                Double value = (Double)obj;
                total += value.doubleValue();
                ++this.frequency;
            }
            return new Double(total);
        }
        if (columnClass == Long.class && !dateTime) {
            long total = 0L;
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                if (obj == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Long value = (Long)obj;
                total += value.longValue();
                ++this.frequency;
            }
            return new Long(total);
        }
        if (columnClass == Float.class && !dateTime) {
            float total = 0.0f;
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                if (obj == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Float value = (Float)obj;
                total += value.floatValue();
                ++this.frequency;
            }
            return new Float(total);
        }
        return null;
    }

    public Object getColumnAverage(int aColumn) {
        Object obj = this.getColumnSum(aColumn);
        if (obj != null) {
            double avg = this.frequency == 0 ? 0.0 : ((Number)obj).doubleValue() / (double)this.frequency;
            return new Double(avg);
        }
        return null;
    }

    public Object getColumnNonMissingValues(int aColumn) {
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        int count = 0;
        for (int i = 0; i < rowCount; ++i) {
            Object obj = this.model.getValueAt(i, aColumn);
            boolean nan = obj instanceof Number ? Double.isNaN(((Number)obj).doubleValue()) : (obj != null ? obj.toString().trim().length() <= 0 : true);
            if (obj == null || nan) continue;
            ++count;
        }
        return new Integer(count);
    }

    public Object getColumnMedian(int aColumn) {
        Class columnClass = this.model.getColumnClass(aColumn);
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        boolean dateTime = false;
        String fmtString = this.model.getColumnFormat(aColumn);
        SASFormat format = SASFormat.getInstance((String)fmtString);
        if (format instanceof SASDateTimeFormat) {
            dateTime = true;
        }
        if (columnClass != null && columnClass.getSuperclass() == Number.class && !dateTime) {
            Vector values = new Vector();
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                if (obj == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                this.binarySearch(values, (Number)obj);
            }
            if (values.size() == 0) {
                return null;
            }
            int index = values.size() / 2;
            return values.elementAt(index);
        }
        return null;
    }

    public Object getColumnStandardDeviation(int aColumn) {
        Class columnClass = this.model.getColumnClass(aColumn);
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        boolean dateTime = false;
        String fmtString = this.model.getColumnFormat(aColumn);
        SASFormat format = SASFormat.getInstance((String)fmtString);
        if (format instanceof SASDateTimeFormat) {
            dateTime = true;
        }
        if (columnClass != null && columnClass.getSuperclass() == Number.class && !dateTime) {
            double mean = (Double)this.getColumnAverage(aColumn);
            double variance = 0.0;
            int obs = 0;
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                if (obj == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                double value = ((Number)obj).doubleValue();
                variance += (value - mean) * (value - mean);
                ++obs;
            }
            int divisor = Math.max(1, obs - 1);
            double std = Math.sqrt(variance / (double)divisor);
            return new Double(std);
        }
        return null;
    }

    public Object getColumnMode(int aColumn) {
        Class columnClass = this.model.getColumnClass(aColumn);
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        if (columnClass != null && (columnClass.getSuperclass() == Number.class || columnClass == String.class)) {
            Hashtable<Object, Integer> htable = new Hashtable<Object, Integer>();
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this.model.getValueAt(i, aColumn);
                boolean nan = obj instanceof Number ? Double.isNaN(((Number)obj).doubleValue()) : (obj != null ? obj.toString().trim().length() <= 0 : true);
                if (obj == null || nan) continue;
                if (htable.containsKey(obj)) {
                    int freq = (Integer)htable.get(obj);
                    htable.put(obj, new Integer(++freq));
                    continue;
                }
                htable.put(obj, new Integer(1));
            }
            Object mode = null;
            int max = -2147483647;
            Enumeration keys = htable.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                int v = (Integer)htable.get(key);
                if (v > max) {
                    max = v;
                    mode = key;
                    continue;
                }
                if (v != max) continue;
                if (columnClass.getSuperclass() == Number.class) {
                    double d1 = ((Number)mode).doubleValue();
                    double d2 = ((Number)key).doubleValue();
                    if (!(d2 < d1)) continue;
                    mode = key;
                    continue;
                }
                String s2 = (String)key;
                String s1 = mode;
                if (StringCompare.compareTo((String)s2, (String)s1) >= 0) continue;
                mode = key;
            }
            return mode;
        }
        return null;
    }

    public Object[] getSum() {
        int metaColumns = this.model.getMetaColumnCount();
        int count = this.model.getColumnCount() - metaColumns;
        Object[] sum = new Object[count];
        for (int i = 0; i < count; ++i) {
            sum[i] = this.getColumnSum(i + metaColumns);
        }
        return sum;
    }

    public Object[] getAverage() {
        int metaColumns = this.model.getMetaColumnCount();
        int count = this.model.getColumnCount() - metaColumns;
        Object[] average = new Object[count];
        for (int i = 0; i < count; ++i) {
            average[i] = this.getColumnAverage(i + metaColumns);
        }
        return average;
    }

    public Object[] getNonMissingValues() {
        int metaColumns = this.model.getMetaColumnCount();
        int count = this.model.getColumnCount() - metaColumns;
        Object[] N = new Object[count];
        for (int i = 0; i < count; ++i) {
            N[i] = this.getColumnNonMissingValues(i + metaColumns);
        }
        return N;
    }

    public Object[] getMedian() {
        int metaColumns = this.model.getMetaColumnCount();
        int count = this.model.getColumnCount() - metaColumns;
        Object[] median = new Object[count];
        for (int i = 0; i < count; ++i) {
            median[i] = this.getColumnMedian(i + metaColumns);
        }
        return median;
    }

    public Object[] getStandardDeviation() {
        int metaColumns = this.model.getMetaColumnCount();
        int count = this.model.getColumnCount() - metaColumns;
        Object[] STD = new Object[count];
        for (int i = 0; i < count; ++i) {
            STD[i] = this.getColumnStandardDeviation(i + metaColumns);
        }
        return STD;
    }

    public Object[] getMode() {
        int metaColumns = this.model.getMetaColumnCount();
        int count = this.model.getColumnCount() - metaColumns;
        Object[] mode = new Object[count];
        for (int i = 0; i < count; ++i) {
            mode[i] = this.getColumnMode(i + metaColumns);
        }
        return mode;
    }

    public Object getColumnSum(int aColumn, int byColumn, String item) {
        Class columnClass = this.model.getColumnClass(aColumn);
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        boolean dateTime = false;
        String fmtString = this.model.getColumnFormat(aColumn);
        SASFormat format = SASFormat.getInstance((String)fmtString);
        if (format instanceof SASDateTimeFormat) {
            dateTime = true;
        }
        GTableModel m = (GTableModel)this.model.getModel();
        int col = this.model.getColumnIndexInModel(aColumn);
        this.frequency = 0;
        if (columnClass == Integer.class && !dateTime) {
            int total = 0;
            for (int i = 0; i < rowCount; ++i) {
                Object obj;
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item) || (obj = m.getValueAt(row, col)) == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Integer value = (Integer)obj;
                total += value.intValue();
                ++this.frequency;
            }
            return new Integer(total);
        }
        if (columnClass == Double.class && !dateTime) {
            double total = 0.0;
            for (int i = 0; i < rowCount; ++i) {
                Object obj;
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item) || (obj = m.getValueAt(row, col)) == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Double value = (Double)obj;
                total += value.doubleValue();
                ++this.frequency;
            }
            return new Double(total);
        }
        if (columnClass == Long.class && !dateTime) {
            long total = 0L;
            for (int i = 0; i < rowCount; ++i) {
                Object obj;
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item) || (obj = m.getValueAt(row, col)) == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Long value = (Long)obj;
                total += value.longValue();
                ++this.frequency;
            }
            return new Long(total);
        }
        if (columnClass == Float.class && !dateTime) {
            float total = 0.0f;
            for (int i = 0; i < rowCount; ++i) {
                Object obj;
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item) || (obj = m.getValueAt(row, col)) == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                Float value = (Float)obj;
                total += value.floatValue();
                ++this.frequency;
            }
            return new Float(total);
        }
        return null;
    }

    public Object getColumnAverage(int aColumn, int byColumn, String item) {
        Object obj = this.getColumnSum(aColumn, byColumn, item);
        if (obj != null) {
            double avg = this.frequency == 0 ? 0.0 : ((Number)obj).doubleValue() / (double)this.frequency;
            return new Double(avg);
        }
        return null;
    }

    public Object getColumnNonMissingValues(int aColumn, int byColumn, String item) {
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        GTableModel m = (GTableModel)this.model.getModel();
        int col = this.model.getColumnIndexInModel(aColumn);
        int count = 0;
        for (int i = 0; i < rowCount; ++i) {
            int row = this.model.getRowIndexInModel(i);
            if (!m.getValueAt(row, byColumn).equals(item)) continue;
            Object obj = m.getValueAt(row, col);
            boolean nan = obj instanceof Number ? Double.isNaN(((Number)obj).doubleValue()) : (obj != null ? obj.toString().trim().length() <= 0 : true);
            if (obj == null || nan) continue;
            ++count;
        }
        return new Integer(count);
    }

    public Object getColumnMedian(int aColumn, int byColumn, String item) {
        Class columnClass = this.model.getColumnClass(aColumn);
        boolean dateTime = false;
        String fmtString = this.model.getColumnFormat(aColumn);
        SASFormat format = SASFormat.getInstance((String)fmtString);
        if (format instanceof SASDateTimeFormat) {
            dateTime = true;
        }
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        GTableModel m = (GTableModel)this.model.getModel();
        int col = this.model.getColumnIndexInModel(aColumn);
        if (columnClass != null && columnClass.getSuperclass() == Number.class && !dateTime) {
            Vector values = new Vector();
            for (int i = 0; i < rowCount; ++i) {
                Object obj;
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item) || (obj = m.getValueAt(row, col)) == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                this.binarySearch(values, (Number)obj);
            }
            if (values.size() == 0) {
                return null;
            }
            int index = (values.size() - 1) / 2;
            return values.elementAt(index);
        }
        return null;
    }

    public Object getColumnStandardDeviation(int aColumn, int byColumn, String item) {
        Class columnClass = this.model.getColumnClass(aColumn);
        boolean dateTime = false;
        String fmtString = this.model.getColumnFormat(aColumn);
        SASFormat format = SASFormat.getInstance((String)fmtString);
        if (format instanceof SASDateTimeFormat) {
            dateTime = true;
        }
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        GTableModel m = (GTableModel)this.model.getModel();
        int col = this.model.getColumnIndexInModel(aColumn);
        if (columnClass != null && columnClass.getSuperclass() == Number.class && !dateTime) {
            double mean = (Double)this.getColumnAverage(aColumn);
            double variance = 0.0;
            int obs = 0;
            for (int i = 0; i < rowCount; ++i) {
                Object obj;
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item) || (obj = m.getValueAt(row, col)) == null || Double.isNaN(((Number)obj).doubleValue())) continue;
                double value = ((Number)obj).doubleValue();
                variance += (value - mean) * (value - mean);
                ++obs;
            }
            int divisor = Math.max(1, obs - 1);
            double std = Math.sqrt(variance / (double)divisor);
            return new Double(std);
        }
        return null;
    }

    public Object getColumnMode(int aColumn, int byColumn, String item) {
        Class columnClass = this.model.getColumnClass(aColumn);
        int rowCount = this.model.getRowCount() - this.model.getMetaRowCount();
        GTableModel m = (GTableModel)this.model.getModel();
        int col = this.model.getColumnIndexInModel(aColumn);
        if (columnClass != null && (columnClass.getSuperclass() == Number.class || columnClass == String.class)) {
            Hashtable<Object, Integer> htable = new Hashtable<Object, Integer>();
            for (int i = 0; i < rowCount; ++i) {
                int row = this.model.getRowIndexInModel(i);
                if (!m.getValueAt(row, byColumn).equals(item)) continue;
                Object obj = m.getValueAt(row, col);
                boolean nan = obj instanceof Number ? Double.isNaN(((Number)obj).doubleValue()) : (obj != null ? obj.toString().trim().length() <= 0 : true);
                if (obj == null || nan) continue;
                if (htable.containsKey(obj)) {
                    int freq = (Integer)htable.get(obj);
                    htable.put(obj, new Integer(++freq));
                    continue;
                }
                htable.put(obj, new Integer(1));
            }
            Object mode = null;
            int max = -2147483647;
            Enumeration keys = htable.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                int v = (Integer)htable.get(key);
                if (v > max) {
                    max = v;
                    mode = key;
                    continue;
                }
                if (v != max) continue;
                if (columnClass.getSuperclass() == Number.class) {
                    double d1 = ((Number)mode).doubleValue();
                    double d2 = ((Number)key).doubleValue();
                    if (!(d2 < d1)) continue;
                    mode = key;
                    continue;
                }
                String s2 = (String)key;
                String s1 = mode;
                if (StringCompare.compareTo((String)s2, (String)s1) >= 0) continue;
                mode = key;
            }
            return mode;
        }
        return null;
    }

    public Object[][] getSum(String by) {
        Object[][] sum;
        Vector byNames = this.model.getByNames();
        int size = byNames.size();
        if (size == 0) {
            sum = new Object[][]{this.getSum()};
        } else {
            sum = new Object[size][];
            GTableModel m = (GTableModel)this.model.getModel();
            int byIdx = m.getColumnIndex(by);
            int metaColumns = this.model.getMetaColumnCount();
            int colCount = this.model.getColumnCount() - metaColumns;
            for (int i = 0; i < size; ++i) {
                sum[i] = new Object[colCount];
                String item = (String)byNames.elementAt(i);
                for (int c = 0; c < colCount; ++c) {
                    sum[i][c] = this.getColumnSum(c + metaColumns, byIdx, item);
                }
            }
        }
        return sum;
    }

    public Object[][] getAverage(String by) {
        Object[][] average;
        Vector byNames = this.model.getByNames();
        int size = byNames.size();
        if (size == 0) {
            average = new Object[][]{this.getAverage()};
        } else {
            average = new Object[size][];
            GTableModel m = (GTableModel)this.model.getModel();
            int byIdx = m.getColumnIndex(by);
            int metaColumns = this.model.getMetaColumnCount();
            int colCount = this.model.getColumnCount() - metaColumns;
            for (int i = 0; i < size; ++i) {
                average[i] = new Object[colCount];
                String item = (String)byNames.elementAt(i);
                for (int c = 0; c < colCount; ++c) {
                    average[i][c] = this.getColumnAverage(c + metaColumns, byIdx, item);
                }
            }
        }
        return average;
    }

    public Object[][] getNonMissingValues(String by) {
        Object[][] N;
        Vector byNames = this.model.getByNames();
        int size = byNames.size();
        if (size == 0) {
            N = new Object[][]{this.getNonMissingValues()};
        } else {
            N = new Object[size][];
            GTableModel m = (GTableModel)this.model.getModel();
            int byIdx = m.getColumnIndex(by);
            int metaColumns = this.model.getMetaColumnCount();
            int colCount = this.model.getColumnCount() - metaColumns;
            for (int i = 0; i < size; ++i) {
                N[i] = new Object[colCount];
                String item = (String)byNames.elementAt(i);
                for (int c = 0; c < colCount; ++c) {
                    N[i][c] = this.getColumnNonMissingValues(c + metaColumns, byIdx, item);
                }
            }
        }
        return N;
    }

    public Object[][] getMedian(String by) {
        Object[][] median;
        Vector byNames = this.model.getByNames();
        int size = byNames.size();
        if (size == 0) {
            median = new Object[][]{this.getMedian()};
        } else {
            median = new Object[size][];
            GTableModel m = (GTableModel)this.model.getModel();
            int byIdx = m.getColumnIndex(by);
            int metaColumns = this.model.getMetaColumnCount();
            int colCount = this.model.getColumnCount() - metaColumns;
            for (int i = 0; i < size; ++i) {
                median[i] = new Object[colCount];
                String item = (String)byNames.elementAt(i);
                for (int c = 0; c < colCount; ++c) {
                    median[i][c] = this.getColumnMedian(c + metaColumns, byIdx, item);
                }
            }
        }
        return median;
    }

    public Object[][] getStandardDeviation(String by) {
        Object[][] std;
        Vector byNames = this.model.getByNames();
        int size = byNames.size();
        if (size == 0) {
            std = new Object[][]{this.getStandardDeviation()};
        } else {
            std = new Object[size][];
            GTableModel m = (GTableModel)this.model.getModel();
            int byIdx = m.getColumnIndex(by);
            int metaColumns = this.model.getMetaColumnCount();
            int colCount = this.model.getColumnCount() - metaColumns;
            for (int i = 0; i < size; ++i) {
                std[i] = new Object[colCount];
                String item = (String)byNames.elementAt(i);
                for (int c = 0; c < colCount; ++c) {
                    std[i][c] = this.getColumnStandardDeviation(c + metaColumns, byIdx, item);
                }
            }
        }
        return std;
    }

    public Object[][] getMode(String by) {
        Object[][] mode;
        Vector byNames = this.model.getByNames();
        int size = byNames.size();
        if (size == 0) {
            mode = new Object[][]{this.getMode()};
        } else {
            mode = new Object[size][];
            GTableModel m = (GTableModel)this.model.getModel();
            int byIdx = m.getColumnIndex(by);
            int metaColumns = this.model.getMetaColumnCount();
            int colCount = this.model.getColumnCount() - metaColumns;
            for (int i = 0; i < size; ++i) {
                mode[i] = new Object[colCount];
                String item = (String)byNames.elementAt(i);
                for (int c = 0; c < colCount; ++c) {
                    mode[i][c] = this.getColumnMode(c + metaColumns, byIdx, item);
                }
            }
        }
        return mode;
    }

    protected void binarySearch(Vector values, Number obj) {
        double v = obj.doubleValue();
        int size = values.size();
        if (size == 0) {
            values.addElement(obj);
        } else {
            double mid_v;
            int left = 0;
            int right = size - 1;
            do {
                int i;
                if (v < (mid_v = ((Number)values.elementAt(i = (left + right) / 2)).doubleValue())) {
                    right = i - 1;
                    continue;
                }
                left = i + 1;
            } while (v != mid_v && left <= right);
            if (v != mid_v) {
                int index = Math.max(left, right);
                values.insertElementAt(obj, index);
            }
        }
    }
}

