/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector v;
    protected String text;
    protected int margin = 0;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this.renderer = renderer == null ? new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -5941335578854924412L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : renderer;
        this.text = text;
        this.v = new Vector();
    }

    public int getSize() {
        if (this.v == null) {
            return 0;
        }
        return this.v.size();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.v.addElement(obj);
    }

    public Vector getColumnGroups(TableColumn c, Vector g) {
        g.addElement(this);
        for (int i = 0; i < this.v.size(); ++i) {
            Object obj1 = this.v.elementAt(i);
            if (!(obj1 instanceof TableColumn) || !((TableColumn)obj1).getIdentifier().equals(c.getIdentifier())) continue;
            return g;
        }
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Vector groups;
            Object obj = e.nextElement();
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c, (Vector)g.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
                boolean validColumn = false;
                while (columns.hasMoreElements()) {
                    TableColumn col = columns.nextElement();
                    if (!col.getIdentifier().equals(aColumn.getIdentifier())) continue;
                    validColumn = true;
                    aColumn = col;
                }
                if (!validColumn) continue;
                width += aColumn.getWidth();
                width += this.margin;
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }
}

