/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.ToolTipDefaults;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.ZoomScrollBar;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class ZoomScrollBarLayout
implements ActionListener,
AdjustmentListener,
ViewportListenerInterface {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int DIMENSION_X = 1;
    public static final int DIMENSION_Y = 2;
    public static final int DIMENSION_Z = 3;
    public static final int DIMENSION_ALL = 4;
    public static final int BUTTON_RESET = 1;
    public static final int BUTTON_2X = 2;
    public static final int LINEAR_TRANSFORM = 1;
    public static final int LOG_TRANSFORM = 2;
    public static final int MIN_CHARTAREA_WIDTH = 100;
    public static final int MIN_CHARTAREA_HEIGHT = 100;
    public static final int ZOOM_CENTER = 1;
    public static final int ZOOM_START = 2;
    protected JComponent comp;
    protected GraphInterface graphInterface;
    protected ViewportInterface viewportInterface;
    protected AdjustmentListener adjustmentListener;
    protected ActionListener actionListener;
    protected ZoomScrollBar hScrollbar;
    protected ZoomScrollBar vScrollbar;
    protected JButton button2X;
    protected boolean addedVScrollbar;
    protected boolean addedHScrollbar;
    protected boolean addedButton;
    protected int buttonStatus;
    protected int zoomDimension;
    protected int zoomPoint;
    protected boolean hScrollbarOn;
    protected boolean vScrollbarOn;
    protected boolean buttonOn;
    protected int hScrollbarHeight;
    protected int vScrollbarWidth;
    protected int hScrollbarVisibleAmount;
    protected int vScrollbarVisibleAmount;
    protected double viewportXMin;
    protected double viewportXMax;
    protected double viewportYMin;
    protected double viewportYMax;
    protected double dataXMin;
    protected double dataXMax;
    protected double dataYMin;
    protected double dataYMax;
    protected double minXVRange;
    protected double minYVRange;
    protected Rectangle chartArea;
    protected boolean[][] thumb;
    protected TipInterface tip;
    protected int hTransform;
    protected int vTransform;
    protected boolean areaTooSmall = false;
    protected int hOffset;
    protected int vOffset;
    protected boolean fixedAspectRatio;
    protected GlobalDefaults gDefaults;
    protected boolean hReversed;
    protected boolean vReversed;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");

    public ZoomScrollBarLayout(boolean hbarOn, boolean vbarOn, JComponent parent, ViewportInterface viewport, GraphInterface graph) {
        this.hScrollbarOn = hbarOn;
        this.vScrollbarOn = vbarOn;
        this.viewportInterface = viewport;
        this.graphInterface = graph;
        this.comp = parent;
        this.comp.setLayout(null);
        this.adjustmentListener = this;
        this.actionListener = this;
        this.hScrollbarHeight = 10;
        this.vScrollbarWidth = 10;
        this.thumb = new boolean[2][3];
        for (int i = 0; i < 2; ++i) {
            this.thumb[i][0] = true;
            this.thumb[i][1] = true;
            this.thumb[i][2] = true;
        }
        this.zoomDimension = 4;
        this.zoomPoint = 1;
        this.dataXMin = 0.0;
        this.dataXMax = 10.0;
        this.dataYMin = 0.0;
        this.dataYMax = 10.0;
        this.viewportXMin = this.dataXMin;
        this.viewportXMax = this.dataXMax;
        this.viewportYMin = this.dataYMin;
        this.viewportYMax = this.dataYMax;
        this.minXVRange = 0.0;
        this.minYVRange = 0.0;
        this.hTransform = 1;
        this.vTransform = 1;
        this.hOffset = 0;
        this.vOffset = 0;
        this.fixedAspectRatio = false;
        this.hScrollbar = new ZoomScrollBar(0, false);
        this.vScrollbar = new ZoomScrollBar(1, false);
        this.addedHScrollbar = false;
        this.addedVScrollbar = false;
        this.button2X = this.createAButton();
        this.button2X.setSize(new Dimension(this.hScrollbarHeight, this.vScrollbarWidth));
        this.addedButton = false;
        this.hReversed = false;
        this.vReversed = true;
        this.gDefaults = new GlobalDefaults();
        if (this.graphInterface != null) {
            this.graphInterface.addViewportListener(this);
        }
    }

    public ZoomScrollBarLayout(boolean hbarOn, boolean vbarOn, JComponent parent, ViewportInterface viewport) {
        this(hbarOn, vbarOn, parent, viewport, parent instanceof GraphInterface ? (GraphInterface)((Object)parent) : null);
    }

    public ZoomScrollBarLayout(JComponent parent, ViewportInterface viewport) {
        this(true, true, parent, viewport);
    }

    public boolean isFixedAspectRatio() {
        return this.fixedAspectRatio;
    }

    public void setFixedAspectRatio(boolean aspect) {
        this.fixedAspectRatio = aspect;
    }

    public int getTransformType(int which) {
        switch (which) {
            default: {
                return this.hTransform;
            }
            case 2: 
        }
        return this.vTransform;
    }

    public void setTransformType(int which, int type) {
        switch (type) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        switch (which) {
            case 1: {
                this.hTransform = type;
                break;
            }
            case 2: {
                this.vTransform = type;
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setTip(TipInterface tip) {
        this.tip = tip;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            return;
        }
        float[] hsb = Color.RGBtoHSB(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), null);
        float fac = (double)hsb[2] > 0.5 ? 0.75f : 1.25f;
        Color thumbColor = Color.getHSBColor(hsb[0], hsb[1], Math.min(1.0f, hsb[2] * fac));
        Color bkColor = backgroundColor;
        if (UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            int r = (int)(0.5 * (double)(backgroundColor.getRed() + thumbColor.getRed()));
            int g = (int)(0.5 * (double)(backgroundColor.getGreen() + thumbColor.getGreen()));
            int b = (int)(0.5 * (double)(backgroundColor.getBlue() + thumbColor.getBlue()));
            r = Math.min(r, 255);
            g = Math.min(g, 255);
            b = Math.min(b, 255);
            bkColor = new Color(r, g, b);
        }
        if (this.hScrollbar != null) {
            this.hScrollbar.setBackground(bkColor);
            this.hScrollbar.setThumbColor(thumbColor);
        }
        if (this.vScrollbar != null) {
            this.vScrollbar.setBackground(bkColor);
            this.vScrollbar.setThumbColor(thumbColor);
        }
        if (this.button2X != null) {
            this.button2X.setBackground(thumbColor);
            Color shadow = thumbColor.darker();
            Color hitile = thumbColor.brighter();
            this.button2X.setBorder(BorderFactory.createEtchedBorder(1, hitile, shadow));
        }
    }

    public void setComponentSize(int width, int height) {
        if ((this.comp.getHeight() < 100 || this.comp.getWidth() < 100) && (this.hScrollbarOn || this.vScrollbarOn)) {
            this.areaTooSmall = true;
            if (this.hScrollbarOn && this.hScrollbar != null) {
                this.hScrollbar.setVisible(false);
            }
            if (this.vScrollbarOn && this.vScrollbar != null) {
                this.vScrollbar.setVisible(false);
            }
            if (this.buttonOn && this.button2X != null) {
                this.button2X.setVisible(false);
            }
        } else {
            if (this.areaTooSmall) {
                if (this.hScrollbarOn && this.hScrollbar != null) {
                    this.hScrollbar.setVisible(true);
                }
                if (this.vScrollbarOn && this.vScrollbar != null) {
                    this.vScrollbar.setVisible(true);
                }
                if (this.buttonOn && this.button2X != null) {
                    this.button2X.setVisible(true);
                }
                this.areaTooSmall = false;
            } else {
                this.buttonOn = this.button2X.isVisible();
            }
            int size = (int)((double)height * this.gDefaults.zoomScrollbarFraction);
            this.hScrollbarHeight = size = Math.max(this.gDefaults.minZoomScrollbarSize, Math.min(this.gDefaults.maxZoomScrollbarSize, size));
            this.vScrollbarWidth = size;
        }
    }

    public boolean setChartArea(Rectangle rect, int hoff, int voff) {
        this.chartArea = rect;
        this.hOffset = Math.max(0, hoff);
        this.vOffset = Math.max(0, voff);
        if (this.areaTooSmall) {
            return false;
        }
        this.layoutScrollBars();
        return true;
    }

    public boolean setChartArea(Rectangle rect) {
        return this.setChartArea(rect, 0, 0);
    }

    public void setScrollBarThumbBehaviour(int which, boolean move, boolean dragStart, boolean dragEnd) {
        ZoomScrollBar sb = null;
        int no = -1;
        switch (which) {
            case 1: {
                sb = this.hScrollbar;
                no = 0;
                break;
            }
            case 2: {
                sb = this.vScrollbar;
                no = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.thumb[no][0] = move;
        this.thumb[no][1] = dragStart;
        this.thumb[no][2] = dragEnd;
        if (sb != null) {
            sb.setThumbMoveEnabled(move);
            sb.setThumbStartEdgeDragEnabled(dragStart);
            sb.setThumbEndEdgeDragEnabled(dragEnd);
        }
    }

    public ZoomScrollBar getHorizontalScrollBar() {
        return this.hScrollbar;
    }

    public ZoomScrollBar getVerticalScrollBar() {
        return this.vScrollbar;
    }

    public JButton getButton() {
        return this.button2X;
    }

    public int getHorizontalScrollBarHeight() {
        return this.hScrollbarOn ? this.hScrollbarHeight : 0;
    }

    public void setHorizontalScrollBarHeight(int h) {
        this.hScrollbarHeight = h;
    }

    public int getVerticalScrollBarWidth() {
        return this.vScrollbarOn ? this.vScrollbarWidth : 0;
    }

    public void setVerticalScrollBarWidth(int w) {
        this.vScrollbarWidth = w;
    }

    public boolean isScrollBarOn(int which) {
        switch (which) {
            case 1: {
                return this.hScrollbarOn;
            }
            case 2: {
                return this.vScrollbarOn;
            }
        }
        return false;
    }

    public void setScrollBarOn(int which, boolean on) {
        switch (which) {
            case 1: {
                this.hScrollbarOn = on;
                if (this.hScrollbar == null || this.areaTooSmall) break;
                this.hScrollbar.setVisible(this.hScrollbarOn);
                break;
            }
            case 2: {
                this.vScrollbarOn = on;
                if (this.vScrollbar == null || this.areaTooSmall) break;
                this.vScrollbar.setVisible(this.vScrollbarOn);
                break;
            }
        }
        if (this.button2X != null) {
            if (!this.hScrollbarOn && !this.vScrollbarOn) {
                this.button2X.setVisible(false);
            } else if (this.hScrollbarOn && this.vScrollbarOn && !this.areaTooSmall) {
                this.button2X.setVisible(true);
            }
        }
    }

    public boolean isButtonOn() {
        return this.button2X.isVisible();
    }

    public void setButtonOn(boolean on) {
        if (this.button2X != null && !this.areaTooSmall) {
            this.button2X.setVisible(on);
        }
        this.buttonOn = on;
    }

    public boolean isReversed(int which) {
        switch (which) {
            case 1: {
                return this.hReversed;
            }
            case 2: {
                return this.vReversed;
            }
        }
        return false;
    }

    public void setReversed(int which, boolean reverse) {
        switch (which) {
            case 1: {
                this.hReversed = reverse;
                break;
            }
            case 2: {
                this.vReversed = reverse;
                break;
            }
        }
    }

    public void setDataRange(int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                this.dataXMin = min;
                this.dataXMax = max;
                break;
            }
            case 2: {
                this.dataYMin = min;
                this.dataYMax = max;
                break;
            }
        }
    }

    public double[] getViewport(int dimension) {
        double[] viewport = new double[2];
        switch (dimension) {
            case 1: {
                viewport[0] = this.viewportXMin;
                viewport[1] = this.viewportXMax;
                break;
            }
            case 2: {
                viewport[0] = this.viewportYMin;
                viewport[1] = this.viewportYMax;
                break;
            }
            default: {
                return null;
            }
        }
        return viewport;
    }

    public void setViewport(int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                this.viewportXMin = min;
                this.viewportXMax = max;
                break;
            }
            case 2: {
                this.viewportYMin = min;
                this.viewportYMax = max;
                break;
            }
        }
    }

    public void setMinimumViewportRange(int dimension, double range) {
        switch (dimension) {
            case 1: {
                this.minXVRange = range;
                break;
            }
            case 2: {
                this.minYVRange = range;
                break;
            }
        }
    }

    public int getButtonStatus() {
        return this.buttonStatus;
    }

    public void setButtonBehaviour(int dim, int point) {
        this.zoomDimension = dim;
        this.zoomPoint = point;
    }

    public void setAdjustmentListener(AdjustmentListener listener) {
        this.adjustmentListener = listener;
        if (this.hScrollbar != null) {
            this.hScrollbar.addAdjustmentListener(this.adjustmentListener);
        }
        if (this.vScrollbar != null) {
            this.vScrollbar.addAdjustmentListener(this.adjustmentListener);
        }
    }

    public void setActionListener(ActionListener listener) {
        this.actionListener = listener;
        if (this.button2X != null) {
            this.button2X.addActionListener(this.actionListener);
        }
    }

    public void updateScrollbars() {
        if (this.chartArea == null) {
            return;
        }
        if (this.viewportInterface != null) {
            double[] vport = this.viewportInterface.getViewport(1, 2, 1);
            if (vport == null) {
                return;
            }
            this.viewportXMin = vport[0];
            this.viewportXMax = vport[1];
            vport = this.viewportInterface.getViewport(1, 2, 2);
            if (vport == null) {
                return;
            }
            this.viewportYMin = vport[0];
            this.viewportYMax = vport[1];
        }
        if (this.hScrollbar != null) {
            this.updateHorizontalScrollbar();
        }
        if (this.vScrollbar != null) {
            this.updateVerticalScrollbar();
        }
    }

    protected void updateHorizontalScrollbar() {
        int minVisibleAmount;
        int vmax;
        int vmin;
        if (this.hScrollbar == null || this.chartArea == null) {
            return;
        }
        int min = 0;
        int max = this.chartArea.width;
        boolean addListener = true;
        if (this.dataXMax - this.dataXMin - this.minXVRange <= 0.0) {
            vmin = min;
            vmax = max;
            minVisibleAmount = vmax - vmin;
            addListener = false;
        } else if (this.hTransform == 1) {
            minVisibleAmount = this.minXVRange <= 0.0 ? -1 : (int)(this.minXVRange / (this.dataXMax - this.dataXMin) * (double)(max - min));
            int minTSize = this.minXVRange <= 0.0 ? 0 : Math.max(minVisibleAmount, 10);
            vmin = min + (int)((this.viewportXMin - this.dataXMin) / (this.dataXMax - this.dataXMin - this.minXVRange) * (double)(max - min - minTSize));
            vmax = min + minTSize + (int)((this.viewportXMax - this.dataXMin - this.minXVRange) / (this.dataXMax - this.dataXMin - this.minXVRange) * (double)(max - min - minTSize));
        } else {
            minVisibleAmount = this.minXVRange <= 0.0 ? -1 : (int)(Math.log(this.minXVRange + 1.0) / Math.log(this.dataXMax - this.dataXMin + 1.0) * (double)(max - min));
            int ts = (int)(Math.log(this.viewportXMax - this.viewportXMin + 1.0) / Math.log(this.dataXMax - this.dataXMin + 1.0) * (double)(max - min));
            vmax = min + (int)(Math.log(this.viewportXMax - this.dataXMin + 1.0) / Math.log(this.dataXMax - this.dataXMin + 1.0) * (double)(max - min));
            vmin = vmax - ts;
        }
        int incr = (int)((double)(max - min) / 10.0);
        if (this.adjustmentListener != null) {
            this.hScrollbar.removeAdjustmentListener(this.adjustmentListener);
        }
        this.hScrollbar.setMinimum(min);
        this.hScrollbar.setMaximum(max);
        this.hScrollbar.setVisibleAmount(Math.max(1, vmax - vmin));
        if (this.hReversed) {
            this.hScrollbar.setValue(min + max - vmax);
        } else {
            this.hScrollbar.setValue(vmin);
        }
        this.hScrollbar.setVisibleAmount(Math.max(1, vmax - vmin));
        if (this.thumb[0][0]) {
            this.hScrollbar.setBlockIncrement(vmax - vmin);
        } else {
            this.hScrollbar.setBlockIncrement(0);
        }
        this.hScrollbar.setUnitIncrement(incr);
        this.hScrollbar.setMinimumVisibleAmount(minVisibleAmount);
        if (this.adjustmentListener != null && addListener) {
            this.hScrollbar.addAdjustmentListener(this.adjustmentListener);
        }
        if (this.hScrollbarOn) {
            this.hScrollbar.repaint();
        }
    }

    protected void updateVerticalScrollbar() {
        int minVisibleAmount;
        int vmax;
        int vmin;
        if (this.vScrollbar == null || this.chartArea == null) {
            return;
        }
        int min = 0;
        int max = this.chartArea.height;
        boolean addListener = true;
        if (this.dataYMax - this.dataYMin - this.minYVRange <= 0.0) {
            vmin = min;
            vmax = max;
            minVisibleAmount = vmax - vmin;
            addListener = false;
        } else if (this.vTransform == 1) {
            minVisibleAmount = this.minYVRange <= 0.0 ? -1 : (int)(this.minYVRange / (this.dataYMax - this.dataYMin) * (double)(max - min));
            int minTSize = this.minYVRange <= 0.0 ? 0 : Math.max(minVisibleAmount, 10);
            vmin = min + (int)((this.viewportYMin - this.dataYMin) / (this.dataYMax - this.dataYMin - this.minYVRange) * (double)(max - min - minTSize));
            vmax = min + minTSize + (int)((this.viewportYMax - this.dataYMin - this.minYVRange) / (this.dataYMax - this.dataYMin - this.minYVRange) * (double)(max - min - minTSize));
        } else {
            minVisibleAmount = this.minYVRange <= 0.0 ? -1 : (int)(Math.log(this.minYVRange + 1.0) / Math.log(this.dataYMax - this.dataYMin + 1.0) * (double)(max - min));
            int ts = (int)(Math.log(this.viewportYMax - this.viewportYMin + 1.0) / Math.log(this.dataYMax - this.dataYMin + 1.0) * (double)(max - min));
            vmax = min + (int)(Math.log(this.viewportYMax - this.dataYMin + 1.0) / Math.log(this.dataYMax - this.dataYMin + 1.0) * (double)(max - min));
            vmin = vmax - ts;
        }
        int incr = (int)((double)(max - min) / 10.0);
        if (this.adjustmentListener != null) {
            this.vScrollbar.removeAdjustmentListener(this.adjustmentListener);
        }
        this.vScrollbar.setMinimum(min);
        this.vScrollbar.setMaximum(max);
        this.vScrollbar.setVisibleAmount(Math.max(1, vmax - vmin));
        if (this.vReversed) {
            this.vScrollbar.setValue(min + max - vmax);
        } else {
            this.vScrollbar.setValue(vmin);
        }
        this.vScrollbar.setVisibleAmount(Math.max(1, vmax - vmin));
        if (this.thumb[1][0]) {
            this.vScrollbar.setBlockIncrement(vmax - vmin);
        } else {
            this.vScrollbar.setBlockIncrement(0);
        }
        this.vScrollbar.setUnitIncrement(incr);
        this.vScrollbar.setMinimumVisibleAmount(minVisibleAmount);
        if (this.adjustmentListener != null && addListener) {
            this.vScrollbar.addAdjustmentListener(this.adjustmentListener);
        }
        if (this.vScrollbarOn) {
            this.vScrollbar.repaint();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Object source = evt.getSource();
        Adjustable adj = evt.getAdjustable();
        int vmin = adj.getValue();
        int vmax = vmin + adj.getVisibleAmount();
        if (source == this.hScrollbar) {
            double viewportXMin_prev = this.viewportXMin;
            double viewportXMax_prev = this.viewportXMax;
            double oldViewport = this.viewportXMax - this.viewportXMin;
            int min = 0;
            int max = this.chartArea.width;
            if (this.hReversed) {
                vmax = min + max - vmin;
                vmin = vmax - adj.getVisibleAmount();
            }
            if (this.hTransform == 1) {
                int minVisibleAmount = this.minXVRange <= 0.0 ? -1 : (int)(this.minXVRange / (this.dataXMax - this.dataXMin) * (double)(max - min));
                int minTSize = this.minXVRange <= 0.0 ? 0 : Math.max(minVisibleAmount, 10);
                this.viewportXMin = this.dataXMin + (double)(vmin - min) / (double)(max - min - minTSize) * (this.dataXMax - this.dataXMin - this.minXVRange);
                this.viewportXMax = this.dataXMin + this.minXVRange + (double)(vmax - min - minTSize) / (double)(max - min - minTSize) * (this.dataXMax - this.dataXMin - this.minXVRange);
            } else {
                double ln = Math.log(this.dataXMax - this.dataXMin + 1.0);
                double vp = vmax - vmin == max - min ? this.dataXMax - this.dataXMin : Math.exp((double)(vmax - vmin) / (double)(max - min) * ln) - 1.0;
                this.viewportXMax = vmax == max ? this.dataXMax : Math.exp((double)(vmax - min) / (double)(max - min) * ln) + this.dataXMin - 1.0;
                this.viewportXMin = this.viewportXMax - vp;
            }
            if (this.viewportInterface != null && (this.viewportXMin != viewportXMin_prev || this.viewportXMax != viewportXMax_prev)) {
                if (this.fixedAspectRatio && this.viewportXMax - this.viewportXMin != oldViewport) {
                    double dx = this.dataXMax - this.dataXMin;
                    if (dx > 0.0) {
                        double dy = this.dataYMax - this.dataYMin;
                        double vx = this.viewportXMax - this.viewportXMin;
                        double vy = vx * dy / dx;
                        this.viewportYMax = this.viewportYMin + vy;
                        if (this.viewportYMax > this.dataYMax) {
                            this.viewportYMin -= this.viewportYMax - this.dataYMax;
                            this.viewportYMax = this.dataYMax;
                        }
                        this.updateVerticalScrollbar();
                        this.viewportInterface.setViewport(1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
                    }
                } else {
                    this.viewportInterface.setViewport(1, 1, this.viewportXMin, this.viewportXMax);
                }
            }
        } else if (source == this.vScrollbar) {
            double viewportYMin_prev = this.viewportYMin;
            double viewportYMax_prev = this.viewportYMax;
            double oldViewport = this.viewportYMax - this.viewportYMin;
            int min = 0;
            int max = this.chartArea.height;
            if (this.vReversed) {
                vmax = min + max - vmin;
                vmin = vmax - adj.getVisibleAmount();
            }
            if (this.vTransform == 1) {
                int minVisibleAmount = this.minYVRange <= 0.0 ? -1 : (int)(this.minYVRange / (this.dataYMax - this.dataYMin) * (double)(max - min));
                int minTSize = this.minYVRange <= 0.0 ? 0 : Math.max(minVisibleAmount, 10);
                this.viewportYMin = this.dataYMin + (double)(vmin - min) / (double)(max - min - minTSize) * (this.dataYMax - this.dataYMin - this.minYVRange);
                this.viewportYMax = this.dataYMin + this.minYVRange + (double)(vmax - min - minTSize) / (double)(max - min - minTSize) * (this.dataYMax - this.dataYMin - this.minYVRange);
            } else {
                double ln = Math.log(this.dataYMax - this.dataYMin + 1.0);
                double vp = vmax - vmin == max - min ? this.dataYMax - this.dataYMin : Math.exp((double)(vmax - vmin) / (double)(max - min) * ln) - 1.0;
                this.viewportYMax = vmax == max ? this.dataYMax : Math.exp((double)(vmax - min) / (double)(max - min) * ln) + this.dataYMin - 1.0;
                this.viewportYMin = this.viewportYMax - vp;
            }
            if (this.viewportInterface != null && (this.viewportYMin != viewportYMin_prev || this.viewportYMax != viewportYMax_prev)) {
                if (this.fixedAspectRatio && this.viewportYMax - this.viewportYMin != oldViewport) {
                    double dy = this.dataYMax - this.dataYMin;
                    if (dy > 0.0) {
                        double dx = this.dataXMax - this.dataXMin;
                        double vy = this.viewportYMax - this.viewportYMin;
                        double vx = vy * dx / dy;
                        this.viewportXMax = this.viewportXMin + vx;
                        if (this.viewportXMax > this.dataXMax) {
                            this.viewportXMin -= this.viewportXMax - this.dataXMax;
                            this.viewportXMax = this.dataXMax;
                        }
                        this.updateHorizontalScrollbar();
                        this.viewportInterface.setViewport(1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
                    }
                } else {
                    this.viewportInterface.setViewport(1, 2, this.viewportYMin, this.viewportYMax);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.button2X && this.buttonStatus == 2) {
            if (this.viewportInterface != null) {
                double xmin = this.dataXMin;
                double xmax = this.dataXMax;
                double ymin = this.dataYMin;
                double ymax = this.dataYMax;
                if (this.zoomDimension == 1 || this.zoomDimension == 4) {
                    double xRange = this.dataXMax - this.dataXMin;
                    if (this.hReversed) {
                        xmin = this.zoomPoint == 1 ? this.dataXMin + 0.25 * xRange : this.dataXMin + 0.5 * xRange;
                        xmax = this.zoomPoint == 1 ? this.dataXMin + 0.75 * xRange : this.dataXMax;
                    } else {
                        xmin = this.zoomPoint == 1 ? this.dataXMin + 0.25 * xRange : this.dataXMin;
                        double d = xmax = this.zoomPoint == 1 ? this.dataXMin + 0.75 * xRange : this.dataXMin + 0.5 * xRange;
                    }
                    if (this.fixedAspectRatio && xRange > 0.0) {
                        double yRange = this.dataYMax - this.dataYMin;
                        double vx = xmax - xmin;
                        double vy = vx * yRange / xRange;
                        if (this.zoomPoint == 1) {
                            ymin = this.dataYMin + 0.5 * yRange - vy * 0.5;
                            ymin = this.dataYMin + 0.5 * yRange + vy * 0.5;
                        } else {
                            ymin = this.dataYMin;
                            ymin = this.dataYMin + vy;
                        }
                    }
                }
                if (!(this.zoomDimension != 2 && this.zoomDimension != 4 || this.fixedAspectRatio)) {
                    double yRange = this.dataYMax - this.dataYMin;
                    if (this.vReversed) {
                        ymin = this.zoomPoint == 1 ? this.dataYMin + 0.25 * yRange : this.dataYMin + 0.5 * yRange;
                        ymax = this.zoomPoint == 1 ? this.dataYMin + 0.75 * yRange : this.dataYMax;
                    } else {
                        ymin = this.zoomPoint == 1 ? this.dataYMin + 0.25 * yRange : this.dataYMin;
                        ymax = this.zoomPoint == 1 ? this.dataYMin + 0.75 * yRange : this.dataYMin + 0.5 * yRange;
                    }
                }
                this.viewportInterface.setViewport(1, xmin, xmax, ymin, ymax, Double.NaN, Double.NaN);
                if (this.hScrollbarOn && this.hScrollbar != null) {
                    this.updateHorizontalScrollbar();
                }
                if (this.vScrollbarOn && this.vScrollbar != null) {
                    this.updateVerticalScrollbar();
                }
            }
            this.button2X.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"ZoomScrollBarLayout.Reset.txt", (String)"Reset"));
            this.buttonStatus = 1;
        } else if (source == this.button2X && this.buttonStatus == 1) {
            if (this.viewportInterface != null) {
                this.viewportInterface.resetViewport();
            }
            this.button2X.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"ZoomScrollBarLayout.2X.txt", (String)"2X"));
            this.buttonStatus = 2;
        }
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        double vymax;
        if (evt.viewportAdjusting) {
            return;
        }
        double vxmin = Double.isNaN(evt.xMin) ? this.viewportXMin : evt.xMin;
        double vxmax = Double.isNaN(evt.xMax) ? this.viewportXMax : evt.xMax;
        double vymin = Double.isNaN(evt.yMin) ? this.viewportYMin : evt.yMin;
        double d = vymax = Double.isNaN(evt.yMax) ? this.viewportYMax : evt.yMax;
        if (vxmin != this.viewportXMin || vxmax != this.viewportXMax) {
            this.viewportXMin = vxmin;
            this.viewportXMax = vxmax;
            if (this.hScrollbar != null) {
                this.updateHorizontalScrollbar();
            }
        }
        if (vymin != this.viewportYMin || vymax != this.viewportYMax) {
            this.viewportYMin = vymin;
            this.viewportYMax = vymax;
            if (this.vScrollbar != null) {
                this.updateVerticalScrollbar();
            }
        }
    }

    public void dispose() {
        if (this.hScrollbar != null && this.adjustmentListener != null) {
            this.hScrollbar.removeAdjustmentListener(this.adjustmentListener);
            this.hScrollbar = null;
        }
        if (this.vScrollbar != null && this.adjustmentListener != null) {
            this.vScrollbar.removeAdjustmentListener(this.adjustmentListener);
            this.vScrollbar = null;
        }
        if (this.button2X != null && this.actionListener != null) {
            this.button2X.removeActionListener(this.actionListener);
            this.button2X = null;
        }
    }

    protected void layoutScrollBars() {
        int y;
        int x;
        if (this.chartArea == null) {
            return;
        }
        if (!this.hScrollbarOn && !this.vScrollbarOn || this.areaTooSmall) {
            return;
        }
        if (this.hScrollbarOn) {
            this.createHorizontalScrollbar();
        }
        if (this.vScrollbarOn) {
            this.createVerticalScrollbar();
        }
        if (this.button2X.isVisible()) {
            this.createButton2X();
        }
        if (this.button2X.isVisible()) {
            x = this.chartArea.x + this.chartArea.width + this.hOffset;
            y = this.chartArea.y - this.hScrollbarHeight - this.vOffset;
            this.button2X.setBounds(x, y, this.vScrollbarWidth, this.hScrollbarHeight);
        }
        if (this.hScrollbarOn) {
            x = this.chartArea.x;
            y = this.chartArea.y - this.hScrollbarHeight - this.vOffset;
            int wt = this.chartArea.width;
            this.hScrollbar.setBounds(x, y, wt + 1, this.hScrollbarHeight);
        }
        if (this.vScrollbarOn) {
            x = this.chartArea.x + this.chartArea.width + this.hOffset;
            y = this.chartArea.y;
            int ht = this.chartArea.height;
            this.vScrollbar.setBounds(x, y, this.vScrollbarWidth, ht + 1);
        }
        this.updateScrollbars();
    }

    protected void createHorizontalScrollbar() {
        if (this.addedHScrollbar) {
            return;
        }
        if (this.hScrollbar == null) {
            this.hScrollbar = new ZoomScrollBar(0, false);
        }
        this.comp.add((Component)this.hScrollbar);
        this.hScrollbar.setThumbMoveEnabled(this.thumb[0][0]);
        this.hScrollbar.setThumbStartEdgeDragEnabled(this.thumb[0][1]);
        this.hScrollbar.setThumbEndEdgeDragEnabled(this.thumb[0][2]);
        this.addedHScrollbar = true;
    }

    protected void createVerticalScrollbar() {
        if (this.addedVScrollbar) {
            return;
        }
        if (this.vScrollbar == null) {
            this.vScrollbar = new ZoomScrollBar(1, false);
        }
        this.comp.add((Component)this.vScrollbar);
        this.vScrollbar.setThumbMoveEnabled(this.thumb[1][0]);
        this.vScrollbar.setThumbStartEdgeDragEnabled(this.thumb[1][1]);
        this.vScrollbar.setThumbEndEdgeDragEnabled(this.thumb[1][2]);
        this.addedVScrollbar = true;
    }

    protected void createButton2X() {
        if (this.addedButton) {
            return;
        }
        if (this.button2X == null) {
            this.button2X = this.createAButton();
        }
        this.comp.add(this.button2X);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.registerComponent(this.button2X);
        ttm.setInitialDelay(0);
        if (this.actionListener != null) {
            this.button2X.addActionListener(this.actionListener);
        }
        this.addedButton = true;
    }

    private JButton createAButton() {
        JButton jb = new JButton(){
            private static final long serialVersionUID = -5132902407757203933L;

            @Override
            public JToolTip createToolTip() {
                if (ZoomScrollBarLayout.this.tip == null) {
                    return super.createToolTip();
                }
                JToolTip toolTip = new JToolTip();
                ToolTipDefaults defaults = new ToolTipDefaults();
                if (ZoomScrollBarLayout.this.tip.getChartTipBackground() != null && ZoomScrollBarLayout.this.tip.getChartTipBackground().getSolidBackground() != null) {
                    toolTip.setBackground(ZoomScrollBarLayout.this.tip.getChartTipBackground().getSolidBackground());
                } else {
                    toolTip.setBackground(new Color(245, 245, 220));
                }
                if (ZoomScrollBarLayout.this.tip.getChartTipTextColor() != null) {
                    toolTip.setForeground(ZoomScrollBarLayout.this.tip.getChartTipTextColor());
                } else {
                    toolTip.setForeground(Color.black);
                }
                if (ZoomScrollBarLayout.this.tip.getChartTipBorderColor() != null) {
                    toolTip.setBorder(new LineBorder(ZoomScrollBarLayout.this.tip.getChartTipBorderColor(), 1));
                } else {
                    toolTip.setBorder(new LineBorder(Color.black, 1));
                }
                if (ZoomScrollBarLayout.this.tip.getFontObject() != null) {
                    toolTip.setFont(ZoomScrollBarLayout.this.tip.getFontObject());
                } else {
                    ZoomScrollBarLayout.this.tip.setFontObject(FontManager.getFont((String)defaults.fontName, (int)defaults.fontType, (int)12));
                }
                return toolTip;
            }

            @Override
            public String getToolTipText() {
                String text = null;
                if (ZoomScrollBarLayout.this.viewportInterface != null) {
                    double[] vportx = ZoomScrollBarLayout.this.viewportInterface.getViewport(1, 2, 1);
                    double[] vporty = ZoomScrollBarLayout.this.viewportInterface.getViewport(1, 2, 2);
                    if (vportx == null || vporty == null) {
                        return text;
                    }
                    if (ZoomScrollBarLayout.this.dataXMin == vportx[0] && ZoomScrollBarLayout.this.dataXMax == vportx[1] && ZoomScrollBarLayout.this.dataYMin == vporty[0] && ZoomScrollBarLayout.this.dataYMax == vporty[1]) {
                        text = ResourceLoader.getResourceString((Object)ZoomScrollBarLayout.this.rb, (String)"ZoomScrollBarLayout.2X.txt", (String)"2X");
                        ZoomScrollBarLayout.this.buttonStatus = 2;
                    } else {
                        text = ResourceLoader.getResourceString((Object)ZoomScrollBarLayout.this.rb, (String)"ZoomScrollBarLayout.Reset.txt", (String)"Reset");
                        ZoomScrollBarLayout.this.buttonStatus = 1;
                    }
                }
                return text;
            }
        };
        return jb;
    }
}

