/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class ViewportWarningIcon {
    private Component comp = null;
    private static Image icon = null;
    private Vector zoomPanHandlers = new Vector();
    private static String userTooltipText = null;

    public ViewportWarningIcon(Component component) {
        this.comp = component;
        if (icon == null) {
            icon = ResourceLoader.getImage((Component)this.comp, (String)"icons/Warning_16.gif");
        }
    }

    public void addZoomPanHandler(AxisZoomPanHandler handler) {
        if (handler == null) {
            return;
        }
        this.zoomPanHandlers.addElement(handler);
    }

    private boolean hasViewport() {
        for (int i = 0; i < this.zoomPanHandlers.size(); ++i) {
            if (!((AxisZoomPanHandler)this.zoomPanHandlers.elementAt(i)).hasViewport()) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseOverIcon(int x, int y) {
        if (this.comp == null || !this.hasViewport()) {
            return false;
        }
        return x > this.comp.getWidth() - icon.getWidth(null) - 10 && x < this.comp.getWidth() - 10 && y > this.comp.getHeight() - icon.getHeight(null) - 10 && y < this.comp.getHeight() - 10;
    }

    public String getTooltipText() {
        if (userTooltipText != null) {
            return userTooltipText;
        }
        return ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.util.silk_util_NLS", (String)"Viewport.Warning.txt", (String)"The chart has a viewport. \nClick here to view all data.");
    }

    public void draw(Graphics g) {
        if (this.hasViewport()) {
            g.drawImage(icon, this.comp.getWidth() - icon.getWidth(null) - 10, this.comp.getHeight() - icon.getHeight(null) - 10, null);
        }
    }

    public void removeZoomPaneHandler(AxisZoomPanHandler handler) {
        if (this.zoomPanHandlers.contains(handler)) {
            this.zoomPanHandlers.remove(handler);
        }
    }

    public void removeAllZoomPanHandlers() {
        this.zoomPanHandlers.removeAllElements();
    }

    public static Image getImage() {
        return icon;
    }

    public static void setImage(Image i) {
        if (i != null) {
            icon = i;
        }
    }

    public static String getUserTooltipText() {
        return userTooltipText;
    }

    public static void setUserTooltipText(String text) {
        if (text != null) {
            userTooltipText = text;
        }
    }
}

