/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.CompoundText;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.TitleDefaults;
import java.awt.Color;

public class Title
extends CompoundText {
    public static final int NUM_TITLES = 5;
    public int MIN_TITLE_SIZE;
    public int MAX_TITLE_SIZE;
    public int MIN_SUBTITLE_SIZE;
    public int MAX_SUBTITLE_SIZE;
    public int TITLE_SUPPRESSION_SIZE;
    public int SUBTITLE_SUPPRESSION_SIZE;
    public double TITLE_FRACTION;
    public double SUBTITLE_FRACTION;
    public double adjustFactor;

    public Title(Color c) {
        super(c, 5, 0);
        TitleDefaults td = new TitleDefaults();
        this.adjustFactor = td.fontSizeAdjust;
        this.MIN_TITLE_SIZE = td.minAdjustedFontSize;
        this.MAX_TITLE_SIZE = td.maxAdjustedFontSize;
        this.MIN_SUBTITLE_SIZE = td.subMinAdjustedFontSize;
        this.MAX_SUBTITLE_SIZE = td.subMaxAdjustedFontSize;
        this.TITLE_SUPPRESSION_SIZE = td.titleSuppressSize;
        this.SUBTITLE_SUPPRESSION_SIZE = td.subtitleSuppressSize;
        this.TITLE_FRACTION = td.titleFraction;
        this.SUBTITLE_FRACTION = td.subtitleFraction;
        for (int i = 0; i < this.texts.length; ++i) {
            ((Text)this.texts[i]).setFormatSupported(false);
            this.texts[i].setVisible(false);
            ((Text)this.texts[i]).setCurrentValueAsDefault(9000);
        }
    }

    public Title() {
        this(null);
    }

    public TextStyleInterface getTitle(int idx) {
        return this.getText(idx);
    }

    public boolean setTitle(int idx, String textString) {
        if (idx < 0 || idx >= 5) {
            return false;
        }
        return this.setText(idx, textString);
    }

    public boolean setTitle(int idx, TextStyleInterface textObj) {
        if (idx < 0 || idx >= 5) {
            return false;
        }
        if (this.defaultFonts[idx] == null) {
            if (textObj != null && textObj instanceof Text && !((Text)textObj).isDefaultFont()) {
                this.userSetFont[idx] = true;
            }
        } else if (textObj != null && textObj.getFont() != null && !textObj.getFont().equals(this.defaultFonts[idx])) {
            this.userSetFont[idx] = true;
        }
        this.setText(idx, textObj);
        return true;
    }

    @Override
    protected int getFontSize(int idx, int originalSize) {
        int size = 0;
        if (this.compBounds == null || this.compBounds.height <= 0 || UIUtilities.useStyleFontSizes()) {
            size = originalSize;
        } else {
            int ht = this.compBounds.height;
            switch (idx) {
                case 0: {
                    size = (int)((double)ht * this.TITLE_FRACTION);
                    if (size < this.TITLE_SUPPRESSION_SIZE) {
                        size = -1;
                        break;
                    }
                    size = Math.max(this.MIN_TITLE_SIZE, Math.min(size, this.MAX_TITLE_SIZE));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    size = (int)((double)ht * this.SUBTITLE_FRACTION);
                    size = size < this.SUBTITLE_SUPPRESSION_SIZE ? -1 : Math.max(this.MIN_SUBTITLE_SIZE, Math.min(size, this.MAX_SUBTITLE_SIZE));
                }
            }
        }
        return size;
    }
}

