/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class TextAttrib
implements TextStyleInterface,
PropertyInterface {
    protected boolean visible;
    protected boolean shadowsOn;
    protected int justLR;
    protected int justTB;
    protected double shadowSoftness;
    protected Object text;
    protected Color color;
    protected Color shadowColor;
    protected Font font;
    protected SASFormat fmt;
    protected boolean defaultFont;
    protected boolean underline = false;
    protected boolean strikethru = false;
    protected int shadowOffset = 2;
    protected double transparency = 1.0;
    PropertyList pending = new PropertyList();
    Vector changeListeners = new Vector();
    boolean formatSupported = true;
    boolean justifySupported = true;
    boolean colorSupported = true;
    boolean effectsSupported = true;
    UserSetPropertyBitMask userSetProperties = null;
    protected String styleReference = null;
    public static int[] supportedProperties = new int[]{9000, 9001, 9002, 9003, 9004, 9005, 9006, 9007, 9008, 9009, 9010, 9011, 9012, 9013, 9014, 9015, 9016, 9017, 9018};

    public TextAttrib(TextStyleInterface attribs) {
        this.init(null, null, null);
        if (attribs == null) {
            return;
        }
        this.setVisible(attribs.isVisible());
        this.setShadowsOn(attribs.areShadowsOn());
        this.justLR = attribs.getHorizontalJustification();
        this.justTB = attribs.getVerticalJustification();
        this.setShadowSoftness(attribs.getShadowSoftness());
        this.setText(attribs.getText());
        this.setColor(attribs.getColor());
        this.setShadowColor(attribs.getColor());
        this.setFont(attribs.getFont());
        this.defaultFont = true;
        this.setFormat(attribs.getFormat());
        this.setShadowOffset(attribs.getShadowOffset());
        this.setTransparency(attribs.getTransparency());
        if (attribs instanceof TextAttrib) {
            TextAttrib ta = (TextAttrib)attribs;
            this.strikethru = ta.strikethru;
            this.underline = ta.underline;
            for (int i = 0; i < ta.userSetProperties.propertyIndexList.length; ++i) {
                if (ta.userSetProperties.get(ta.userSetProperties.propertyIndexList[i])) {
                    this.userSetProperties.set(ta.userSetProperties.propertyIndexList[i]);
                    continue;
                }
                this.userSetProperties.clear(ta.userSetProperties.propertyIndexList[i]);
            }
        }
    }

    public TextAttrib(Object text, Object font, Object color) {
        Color c = Color.black;
        if (color instanceof Color) {
            c = (Color)color;
        }
        Font f = null;
        if (font instanceof Font) {
            f = (Font)font;
        }
        this.init(text, f, c);
    }

    public TextAttrib(Object text, Object font) {
        this(text, font, Color.black);
    }

    public TextAttrib(Object text) {
        this(text, null);
    }

    public TextAttrib() {
        this(null);
    }

    protected void init(Object text, Font font, Color color) {
        this.userSetProperties = new UserSetPropertyBitMask(supportedProperties);
        this.visible = true;
        this.justTB = 0;
        this.justLR = 0;
        this.shadowsOn = false;
        this.shadowSoftness = 0.5;
        this.shadowColor = Color.black;
        this.text = text;
        this.font = font;
        this.color = color;
        this.fmt = null;
        this.defaultFont = true;
    }

    public void addTextListener(TextListenerInterface cl) {
        if (cl != null && !this.changeListeners.contains(cl)) {
            this.changeListeners.addElement(cl);
        }
    }

    public void removeTextListener(TextListenerInterface cl) {
        this.changeListeners.remove(cl);
    }

    public void applyStyle(Style s) {
        if (this.styleReference == null) {
            return;
        }
        TextStyleElement tse = s.getTextStyleElement(this.styleReference);
        if (!this.hasUserSetValue(9002)) {
            this.font = tse.getFont();
        }
        if (!this.hasUserSetValue(9001)) {
            this.color = tse.getTextColor();
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.userSetProperties.set(9000);
    }

    @Override
    public Object getText() {
        if (this.text == null || !this.userSetProperties.get(9015)) {
            return null;
        }
        return this.text;
    }

    @Override
    public boolean setText(Object text) {
        this.text = text;
        this.userSetProperties.set(9015);
        return true;
    }

    @Override
    public String getTextString() {
        if (this.text == null) {
            return null;
        }
        return this.text.toString();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean setColor(Object color) {
        Color c = null;
        if (color == null) {
            this.color = null;
            return true;
        }
        if (color instanceof Color) {
            c = (Color)color;
        } else if (color instanceof String) {
            c = ColorParse.getColorFromString((String)((String)color));
        }
        if (c == null) {
            return false;
        }
        if (c.equals(this.color)) {
            return true;
        }
        this.color = c;
        this.userSetProperties.set(9001);
        return true;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public boolean setFont(Object font) {
        int style = 0;
        int size = 12;
        Font oldFont = this.font;
        if (font == null) {
            this.font = null;
        } else if (font instanceof Font) {
            this.font = (Font)font;
        } else if (font instanceof String) {
            if (oldFont != null) {
                style = oldFont.getStyle();
                size = oldFont.getSize();
            }
            this.font = FontManager.getFont((String)((String)font), (int)style, (int)size);
        } else {
            return false;
        }
        this.defaultFont = false;
        this.userSetProperties.set(9002);
        return true;
    }

    @Override
    public boolean areShadowsOn() {
        return this.shadowsOn;
    }

    @Override
    public void setShadowsOn(boolean on) {
        if (this.shadowsOn == on) {
            return;
        }
        this.shadowsOn = on;
        this.userSetProperties.set(9003);
    }

    @Override
    public double getShadowSoftness() {
        return this.shadowSoftness;
    }

    @Override
    public boolean setShadowSoftness(double softness) {
        if (Double.isInfinite(softness) || Double.isNaN(softness) || softness < 0.0 || softness > 1.0) {
            return false;
        }
        if (this.shadowSoftness == softness) {
            return true;
        }
        this.shadowSoftness = softness;
        this.userSetProperties.set(9004);
        return true;
    }

    @Override
    public Color getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public boolean setShadowColor(Object color) {
        Color c = null;
        if (color == null) {
            return false;
        }
        if (color instanceof Color) {
            c = (Color)color;
        } else if (color instanceof String) {
            c = ColorParse.getColorFromString((String)((String)color));
        }
        if (c == null) {
            return false;
        }
        if (c.equals(this.shadowColor)) {
            return true;
        }
        this.shadowColor = c;
        this.userSetProperties.set(9005);
        return true;
    }

    @Override
    public int getHorizontalJustification() {
        return this.justLR;
    }

    @Override
    public int getVerticalJustification() {
        return this.justTB;
    }

    @Override
    public boolean setJustification(int horz, int vert) {
        switch (horz) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (vert) {
            case 0: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.justLR == horz && this.justTB == vert) {
            return true;
        }
        this.userSetProperties.set(9006);
        this.userSetProperties.set(9007);
        this.justLR = horz;
        this.justTB = vert;
        return true;
    }

    @Override
    public Object getFormat() {
        return this.fmt;
    }

    @Override
    public boolean setFormat(Object fmtIn) {
        SASFormat fmt = null;
        if (fmtIn == null) {
            fmt = null;
        } else if (fmtIn instanceof SASFormat) {
            fmt = (SASFormat)fmtIn;
        } else if (fmtIn instanceof String) {
            fmt = SASFormat.getInstance((String)((String)fmtIn));
            if (fmt == null) {
                return false;
            }
        } else {
            return false;
        }
        if (fmt != null && fmt.equals(this.fmt)) {
            return true;
        }
        this.fmt = fmt;
        this.userSetProperties.set(9008);
        return true;
    }

    @Override
    public int getShadowOffset() {
        return this.shadowOffset;
    }

    @Override
    public boolean setShadowOffset(int offset) {
        if (this.shadowOffset == offset) {
            return true;
        }
        this.shadowOffset = offset;
        this.userSetProperties.set(9017);
        return true;
    }

    @Override
    public double getTransparency() {
        return this.transparency;
    }

    @Override
    public boolean setTransparency(double d) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        if (this.transparency == d) {
            return true;
        }
        this.transparency = d;
        this.userSetProperties.set(9016);
        return true;
    }

    public boolean isDefaultFont() {
        return this.defaultFont;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        block21: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 9015: {
                    this.setText(value.toString());
                    this.fireChangeEvent();
                    continue block21;
                }
                case 9000: {
                    if (value instanceof Boolean) {
                        this.setVisible((Boolean)value);
                    }
                    this.fireChangeEvent();
                    continue block21;
                }
                case 9001: {
                    this.setColor(value);
                    continue block21;
                }
                case 9002: {
                    this.setFont(value);
                    continue block21;
                }
                case 9003: {
                    if (!(value instanceof Boolean)) continue block21;
                    this.setShadowsOn((Boolean)value);
                    continue block21;
                }
                case 9004: {
                    this.setShadowSoftness(((Number)value).doubleValue());
                    continue block21;
                }
                case 9005: {
                    this.setShadowColor(value);
                    continue block21;
                }
                case 9017: {
                    if (!(value instanceof Number)) continue block21;
                    this.setShadowOffset(((Number)value).intValue());
                    continue block21;
                }
                case 9006: {
                    if (!(value instanceof Number)) continue block21;
                    this.setJustification(((Number)value).intValue(), this.justTB);
                    continue block21;
                }
                case 9007: {
                    if (!(value instanceof Number)) continue block21;
                    this.setJustification(this.justLR, ((Number)value).intValue());
                    continue block21;
                }
                case 9008: {
                    this.setFormat(value);
                    continue block21;
                }
                case 9009: {
                    if (value instanceof Boolean) {
                        this.underline = (Boolean)value;
                        this.userSetProperties.set(9009);
                    }
                    this.fireChangeEvent();
                    continue block21;
                }
                case 9010: {
                    if (value instanceof Boolean) {
                        this.strikethru = (Boolean)value;
                        this.userSetProperties.set(9010);
                    }
                    this.fireChangeEvent();
                    continue block21;
                }
                case 9014: {
                    if (!(value instanceof Boolean)) continue block21;
                    this.setColorSupported((Boolean)value);
                    continue block21;
                }
                case 9013: {
                    if (!(value instanceof Boolean)) continue block21;
                    this.setEffectsSupported((Boolean)value);
                    continue block21;
                }
                case 9011: {
                    if (!(value instanceof Boolean)) continue block21;
                    this.setFormatSupported((Boolean)value);
                    continue block21;
                }
                case 9012: {
                    if (!(value instanceof Boolean)) continue block21;
                    this.setJustifySupported((Boolean)value);
                    continue block21;
                }
                case 9016: {
                    if (!(value instanceof Number)) continue block21;
                    this.setTransparency(((Number)value).doubleValue());
                    continue block21;
                }
                case 9018: {
                    if (value == null) continue block21;
                    this.styleReference = value.toString();
                    this.applyStyle((Style)SILKGlobal.getInstance().getPropertyValue(29));
                }
            }
        }
        this.fireChangeEvent();
        this.pending.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 9015: {
                rc = this.getText();
                break;
            }
            case 9000: {
                rc = new Boolean(this.visible);
                break;
            }
            case 9001: {
                rc = this.color;
                break;
            }
            case 9002: {
                rc = this.font;
                break;
            }
            case 9003: {
                rc = new Boolean(this.shadowsOn);
                break;
            }
            case 9004: {
                rc = new Double(this.shadowSoftness);
                break;
            }
            case 9005: {
                rc = this.shadowColor;
                break;
            }
            case 9017: {
                rc = new Integer(this.shadowOffset);
                break;
            }
            case 9006: {
                rc = new Integer(this.justLR);
                break;
            }
            case 9007: {
                rc = new Integer(this.justTB);
                break;
            }
            case 9008: {
                rc = this.fmt;
                break;
            }
            case 9009: {
                rc = new Boolean(this.underline);
                break;
            }
            case 9010: {
                rc = new Boolean(this.strikethru);
                break;
            }
            case 9014: {
                rc = new Boolean(this.colorSupported);
                break;
            }
            case 9013: {
                rc = new Boolean(this.effectsSupported);
                break;
            }
            case 9011: {
                rc = new Boolean(this.formatSupported);
                break;
            }
            case 9012: {
                rc = new Boolean(this.justifySupported);
                break;
            }
            case 9016: {
                rc = new Double(this.getTransparency());
            }
        }
        return rc;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        return this.pending.store(id, value);
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    public void setCurrentValueAsDefault(int id) {
        this.userSetProperties.clear(id);
    }

    protected void fireChangeEvent() {
        DvrTextEvent ce = new DvrTextEvent(this);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ((TextListenerInterface)this.changeListeners.elementAt(i)).textUpdated(ce);
        }
    }

    public boolean isColorSupported() {
        return this.colorSupported;
    }

    public boolean isEffectsSupported() {
        return this.effectsSupported;
    }

    public boolean isFormatSupported() {
        return this.formatSupported;
    }

    public boolean isJustifySupported() {
        return this.justifySupported;
    }

    public void setColorSupported(boolean colorSupported) {
        if (this.colorSupported == colorSupported) {
            return;
        }
        this.colorSupported = colorSupported;
        this.userSetProperties.set(9014);
    }

    public void setEffectsSupported(boolean effectsSupported) {
        if (this.effectsSupported == effectsSupported) {
            return;
        }
        this.effectsSupported = effectsSupported;
        this.userSetProperties.set(9013);
    }

    public void setFormatSupported(boolean formatSupported) {
        if (this.formatSupported == formatSupported) {
            return;
        }
        this.formatSupported = formatSupported;
        this.userSetProperties.set(9011);
    }

    public void setJustifySupported(boolean justifySupported) {
        if (this.justifySupported == justifySupported) {
            return;
        }
        this.justifySupported = justifySupported;
        this.userSetProperties.set(9012);
    }

    public String toString() {
        if (this.text != null) {
            return this.text.toString();
        }
        return super.toString();
    }
}

