/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import java.util.Vector;

public class Text
extends TextAttrib
implements PropertyInterface,
TextStyleInterface {
    public Text() {
        this("");
    }

    public Text(String string) {
        this.init(string, FontManager.getFont((String)"SansSerif", (int)0, (int)12), Color.black);
    }

    public Text(TextStyleInterface text) {
        super(text);
    }

    public Rectangle2D getStringBounds(String s, FontRenderContext frc) {
        if (s == null || s.trim().length() == 0) {
            return new Rectangle2D.Double();
        }
        Font dpiFont = this.font.deriveFont((float)SILKUtilities.adjustFontSize(this.font.getSize()));
        TextLayout textString = new TextLayout(s, dpiFont, frc);
        Rectangle2D d = textString.getBounds();
        if (this.shadowsOn) {
            return d;
        }
        return new Rectangle((int)d.getX(), (int)d.getY(), (int)(d.getWidth() + (double)this.shadowOffset), (int)(d.getHeight() + (double)this.shadowOffset));
    }

    public static int getFontStyleForString(String style) {
        int rc = 0;
        if (style == null) {
            return rc;
        }
        if (style.equalsIgnoreCase("Bold")) {
            rc = 1;
        } else if (style.equalsIgnoreCase("Italic")) {
            rc = 2;
        } else if (style.equalsIgnoreCase("BoldItalic")) {
            rc = 3;
        }
        return rc;
    }

    public String format(Object object) {
        if (this.isFormatSupported() && this.fmt != null) {
            try {
                String s = this.fmt.format(object);
                return s;
            }
            catch (IllegalArgumentException exception) {
                return object.toString();
            }
        }
        return object.toString();
    }

    public void drawText(Graphics2D g, String s, Point p) {
        this.drawText(g, s, p, false, null);
    }

    public void drawText(Graphics2D g, String s, Point p, boolean isEngraved, Color backgroundColor) {
        if (s == null || s.equals("")) {
            return;
        }
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        Font dpiFont = this.font.deriveFont((float)SILKUtilities.adjustFontSize(this.font.getSize()));
        g.setFont(dpiFont);
        RenderingHints rHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.addRenderingHints(rHints);
        String str = s.trim();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D d = dpiFont.getStringBounds(str, frc);
        LineMetrics lineMetrics = dpiFont.getLineMetrics(str, frc);
        int startx = p.x;
        int starty = p.y;
        if (this.justifySupported) {
            switch (this.justLR) {
                case 1: {
                    break;
                }
                case 0: {
                    startx = (int)((double)startx - d.getWidth() / 2.0);
                    break;
                }
                case 2: {
                    startx = (int)((double)startx - d.getWidth());
                }
            }
            switch (this.justTB) {
                case 4: {
                    starty = (int)((double)starty + d.getHeight());
                    break;
                }
                case 0: {
                    starty = (int)((double)starty + d.getHeight() / 2.0);
                    break;
                }
            }
        }
        if (this.shadowsOn) {
            int alpha = (int)(this.shadowSoftness * 255.0);
            g.setColor(new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), alpha));
            g.drawString(str, startx + this.shadowOffset, starty + this.shadowOffset);
        }
        if (!this.shadowsOn && isEngraved && backgroundColor != null) {
            g.setColor(ColorUtilities.brighter(backgroundColor, 0.2));
            int offset = this.getFont().getSize() >= 32 ? 2 : 1;
            g.drawString(str, startx + offset, starty + offset);
        }
        if (this.transparency < 1.0) {
            int trans = (int)(255.0 * this.transparency);
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), trans));
        } else {
            g.setColor(this.color);
        }
        g.drawString(str, startx, starty);
        if (this.underline) {
            g.drawLine(startx, starty, startx + (int)d.getWidth(), starty);
        }
        if (this.strikethru) {
            g.drawLine(startx, starty - (int)(d.getHeight() / 3.0), startx + (int)d.getWidth(), starty - (int)(d.getHeight() / 3.0));
        }
        if (SILKGlobal.isFlagSet(5)) {
            g.setColor(Color.RED);
            g.drawLine(startx, starty, startx + (int)d.getWidth(), starty);
            g.drawLine(startx, starty - (int)lineMetrics.getAscent(), startx + (int)d.getWidth(), starty - (int)lineMetrics.getAscent());
            g.drawLine(startx, starty + (int)lineMetrics.getDescent(), startx + (int)d.getWidth(), starty + (int)lineMetrics.getDescent());
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    public String[] wrap(String str, int maxWidth, int maxWrap, FontRenderContext frc) {
        if (str == null || maxWidth <= 0 || maxWrap < 2 || frc == null) {
            return null;
        }
        Rectangle2D r = this.getStringBounds(str, frc);
        if (r.getWidth() < (double)maxWidth) {
            return new String[]{str};
        }
        StringTokenizer st = new StringTokenizer(str);
        String[] rc = null;
        Vector<String> strings = new Vector<String>();
        if (st.countTokens() == 1) {
            int numNeeded = (int)(r.getWidth() / (double)maxWidth);
            rc = new String[Math.min(numNeeded, maxWrap)];
            String current = "";
            for (int i = 0; i < str.length(); ++i) {
                String temp = current + str.charAt(i);
                if (this.getStringBounds(temp, frc).getWidth() >= (double)maxWidth) {
                    strings.addElement(current);
                    current = "" + str.charAt(i);
                    continue;
                }
                current = temp;
            }
            strings.addElement(current);
        } else {
            String current = "";
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                String temp = current + " " + tk;
                if (this.getStringBounds(temp, frc).getWidth() > (double)maxWidth) {
                    strings.addElement(current);
                    current = tk;
                    continue;
                }
                current = temp;
            }
            strings.addElement(current);
        }
        rc = new String[Math.min(strings.size(), maxWrap)];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (String)strings.elementAt(i);
        }
        if (maxWrap < strings.size()) {
            String lineToTruncate = rc[maxWrap - 1];
            rc[maxWrap - 1] = lineToTruncate.substring(0, lineToTruncate.length() - 4) + "...";
        }
        return rc;
    }
}

