/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.SVGGraphics2D;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class Save {
    public static final int USE_FILE_EXTENSION = -1;
    public static final int BMP = 0;
    public static final int GIF = 1;
    public static final int SVG = 2;
    public static final int PNG = 3;
    protected static final String[] extensions = new String[]{"bmp", "gif", "svg", "png", "grf"};
    protected static final int[] values = new int[]{0, 1, 2, 3, 3};
    protected static final int BITMAPFILEHEADERSIZE = 14;
    protected static final int BITMAPINFOHEADERSIZE = 40;
    protected static final int PelsPerMeter = 2952;
    protected static final int BufferSize = 4096;
    protected static final byte[] pngSignature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    protected static final long MAX_SEQ_NUM = 10000L;
    protected static long seqNum = 0L;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;

    public static int getType(File file) {
        if (file == null) {
            return -999;
        }
        return Save.getType(file.getAbsolutePath());
    }

    public static int getType(String filename) {
        String ext = null;
        if (filename == null) {
            return -999;
        }
        int idx = filename.lastIndexOf(46);
        if (idx < 0 || idx >= filename.length() - 1) {
            return -999;
        }
        ext = filename.substring(idx + 1);
        for (idx = 0; idx < extensions.length && !ext.equalsIgnoreCase(extensions[idx]); ++idx) {
        }
        if (idx >= extensions.length) {
            return -999;
        }
        return values[idx];
    }

    public static String getFileExtension(int type) {
        int i;
        for (i = 0; i < values.length && type != values[i]; ++i) {
        }
        if (i >= values.length) {
            return null;
        }
        return extensions[i];
    }

    public static synchronized String getFilename(String prefix, int type) {
        String ext = Save.getFileExtension(type);
        if (ext == null) {
            return null;
        }
        return Save.getUniqueId(prefix) + "." + ext;
    }

    public static synchronized String getUniqueId(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        seqNum = seqNum >= 10000L ? 0L : ++seqNum;
        return prefix + System.currentTimeMillis() + "_" + seqNum;
    }

    public static boolean saveAsImage(Component comp, String fileName, int type) {
        File f = new File(fileName);
        return Save.saveAsImage(comp, f, type);
    }

    public static boolean saveAsImage(Component comp, File file, int type) {
        Image img = null;
        if (comp == null || file == null) {
            return false;
        }
        int saveType = type == -1 ? Save.getType(file) : type;
        Dimension d = comp.getSize();
        if (d == null) {
            return false;
        }
        int w = d.width;
        int h = d.height;
        if (w <= 0 || h <= 0) {
            return false;
        }
        if (saveType != 2 && (img = comp.createImage(w, h)) == null && (img = new BufferedImage(w, h, 1)) == null) {
            return false;
        }
        return Save.saveAsImage(comp, img, file, saveType);
    }

    public static boolean saveAsImage(Component comp, OutputStream out, int type) {
        Image img = null;
        if (comp == null || out == null) {
            return false;
        }
        int saveType = type == -1 ? 3 : type;
        Dimension d = comp.getSize();
        if (d == null) {
            return false;
        }
        int w = d.width;
        int h = d.height;
        if (w <= 0 || h <= 0) {
            return false;
        }
        if (saveType != 2 && (img = comp.createImage(w, h)) == null && (img = new BufferedImage(w, h, 1)) == null) {
            return false;
        }
        return Save.saveAsImage(comp, img, out, saveType, false);
    }

    public static boolean saveAsImage(Component comp, Image img, File file, int type) {
        FileOutputStream os = null;
        FileOutputStream fs = null;
        BufferedOutputStream bs = null;
        if (file == null) {
            return false;
        }
        block1 : switch (type) {
            case 0: 
            case 2: 
            case 3: {
                break;
            }
            case -1: {
                String s = file.getAbsolutePath();
                if (s == null) {
                    return false;
                }
                type = Save.getType(s);
                switch (type) {
                    case 0: 
                    case 2: 
                    case 3: {
                        break block1;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        if (type == 2) {
            return SVGGraphics2D.renderToSVG(comp, file);
        }
        if (img == null) {
            return false;
        }
        try {
            os = fs = new FileOutputStream(file);
            if (fs != null) {
                bs = new BufferedOutputStream(fs, 4096);
            }
            if (bs != null) {
                os = bs;
            }
        }
        catch (IOException e) {
            return false;
        }
        return Save.saveAsImage(comp, img, os, type, true);
    }

    public static boolean saveAsImage(Component comp, Image img, OutputStream os, int type, boolean closeStream) {
        Graphics g = null;
        if (img == null) {
            return false;
        }
        g = img.getGraphics();
        if (g == null) {
            return false;
        }
        comp.paint(g);
        g.dispose();
        return Save.saveImage(img, os, type, closeStream);
    }

    public static boolean saveImage(Image img, OutputStream os, int type, boolean closeStream) {
        boolean status = false;
        if (img == null) {
            return false;
        }
        switch (type) {
            default: {
                status = Save.saveBMP(os, img);
                break;
            }
            case 3: {
                status = Save.savePNG(os, img);
            }
        }
        try {
            if (closeStream) {
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        return status;
    }

    protected static boolean saveBMP(OutputStream fs, Image img) {
        int size = 0;
        int width = 0;
        int height = 0;
        int padBytes = 0;
        int biBitCount = 24;
        PixelGrabber pg = new PixelGrabber(img, 0, 0, -1, -1, true);
        byte[] buffer = new byte[4096];
        if (buffer == null) {
            return false;
        }
        try {
            if (!pg.grabPixels()) {
                return false;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        try {
            width = img.getWidth(null);
            int scanlineWidth = width * biBitCount + 31 >> 5 << 2;
            padBytes = scanlineWidth - width * (biBitCount >> 3);
            height = img.getHeight(null);
            size = 54 + scanlineWidth * height;
            buffer[0] = 66;
            buffer[1] = 77;
            buffer[2] = (byte)size;
            buffer[3] = (byte)(size >> 8);
            buffer[4] = (byte)(size >> 16);
            buffer[5] = (byte)(size >> 24);
            buffer[6] = 0;
            buffer[7] = 0;
            buffer[8] = 0;
            buffer[9] = 0;
            buffer[10] = 54;
            buffer[11] = 0;
            buffer[12] = 0;
            buffer[13] = 0;
            fs.write(buffer, 0, 14);
            buffer[0] = 40;
            buffer[1] = 0;
            buffer[2] = 0;
            buffer[3] = 0;
            buffer[4] = (byte)width;
            buffer[5] = (byte)(width >> 8);
            buffer[6] = (byte)(width >> 16);
            buffer[7] = (byte)(width >> 24);
            buffer[8] = (byte)height;
            buffer[9] = (byte)(height >> 8);
            buffer[10] = (byte)(height >> 16);
            buffer[11] = (byte)(height >> 24);
            buffer[12] = 1;
            buffer[13] = 0;
            buffer[14] = 24;
            buffer[15] = 0;
            buffer[16] = 0;
            buffer[17] = 0;
            buffer[18] = 0;
            buffer[19] = 0;
            size = width * height * 3;
            buffer[20] = (byte)size;
            buffer[21] = (byte)(size >> 8);
            buffer[22] = (byte)(size >> 16);
            buffer[23] = (byte)(size >> 24);
            buffer[24] = -120;
            buffer[25] = 11;
            buffer[26] = 0;
            buffer[27] = 0;
            buffer[28] = -120;
            buffer[29] = 11;
            buffer[30] = 0;
            buffer[31] = 0;
            buffer[32] = 0;
            buffer[33] = 0;
            buffer[34] = 0;
            buffer[35] = 0;
            buffer[36] = 0;
            buffer[37] = 0;
            buffer[38] = 0;
            buffer[39] = 0;
            fs.write(buffer, 0, 40);
            Object obj = pg.getPixels();
            if (!(obj instanceof int[])) {
                return false;
            }
            int[] pixels = (int[])obj;
            if (pixels.length != width * height) {
                return false;
            }
            ColorModel cm = pg.getColorModel();
            for (int iy = height - 1; iy >= 0; --iy) {
                for (int ix = 0; ix < width; ++ix) {
                    int idx = iy * width + ix;
                    byte b = (byte)cm.getBlue(pixels[idx]);
                    byte g = (byte)cm.getGreen(pixels[idx]);
                    byte r = (byte)cm.getRed(pixels[idx]);
                    fs.write(b);
                    fs.write(g);
                    fs.write(r);
                }
                for (int j = 0; j < padBytes; ++j) {
                    fs.write(0);
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected static final void toBigIndian(long intIn, byte[] buffer, int start) {
        buffer[start] = (byte)(intIn >> 24);
        buffer[start + 1] = (byte)(intIn >> 16);
        buffer[start + 2] = (byte)(intIn >> 8);
        buffer[start + 3] = (byte)intIn;
    }

    protected static final void composeChunkHeader(int len, String name, byte[] buffer) {
        Save.toBigIndian(len, buffer, 0);
        buffer[4] = (byte)name.charAt(0);
        buffer[5] = (byte)name.charAt(1);
        buffer[6] = (byte)name.charAt(2);
        buffer[7] = (byte)name.charAt(3);
    }

    protected static void filterSub(byte[] pixels, int startPos, int width, int bytesPerPixel, byte[] leftBytes) {
        int offset = bytesPerPixel;
        int actualStart = startPos + offset;
        int nBytes = width * bytesPerPixel;
        int leftInsert = offset;
        int leftExtract = 0;
        for (int i = actualStart; i < startPos + nBytes; ++i) {
            leftBytes[leftInsert] = pixels[i];
            pixels[i] = (byte)((pixels[i] - leftBytes[leftExtract]) % 256);
            leftInsert = (leftInsert + 1) % 15;
            leftExtract = (leftExtract + 1) % 15;
        }
    }

    protected static void filterUp(byte[] pixels, int startPos, int width, int bytesPerPixel, byte[] priorRow) {
        int nBytes = width * bytesPerPixel;
        for (int i = 0; i < nBytes; ++i) {
            byte current_byte = pixels[startPos + i];
            pixels[startPos + i] = (byte)((pixels[startPos + i] - priorRow[i]) % 256);
            priorRow[i] = current_byte;
        }
    }

    protected static boolean writeImageData(OutputStream fs, byte[] buffer, int[] pixels, int width, int height, boolean encodeAlpha, int compressionLevel, int filter) {
        int startRow = 0;
        CRC32 crc = new CRC32();
        Deflater scrunch = null;
        ByteArrayOutputStream outBytes = null;
        DeflaterOutputStream compBytes = null;
        byte[] leftBytes = null;
        byte[] priorRow = null;
        int bytesPerPixel = encodeAlpha ? 4 : 3;
        scrunch = new Deflater(compressionLevel);
        if (scrunch == null) {
            return false;
        }
        outBytes = new ByteArrayOutputStream(1024);
        if (outBytes == null) {
            return false;
        }
        compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch);
        if (compBytes == null) {
            return false;
        }
        try {
            int nRows;
            for (int rowsLeft = height; rowsLeft > 0; rowsLeft -= nRows) {
                nRows = Math.min(Short.MAX_VALUE / (width * (bytesPerPixel + 1)), rowsLeft);
                nRows = rowsLeft;
                byte[] scanLines = new byte[width * nRows * bytesPerPixel + nRows];
                if (filter == 1) {
                    leftBytes = new byte[16];
                }
                if (filter == 2) {
                    priorRow = new byte[width * bytesPerPixel];
                }
                int scanPos = 0;
                int startPos = 1;
                for (int i = 0; i < width * nRows; ++i) {
                    if (i % width == 0) {
                        scanLines[scanPos++] = (byte)filter;
                        startPos = scanPos;
                    }
                    scanLines[scanPos++] = (byte)(pixels[i + width * startRow] >> 16);
                    scanLines[scanPos++] = (byte)(pixels[i + width * startRow] >> 8);
                    scanLines[scanPos++] = (byte)pixels[i + width * startRow];
                    if (encodeAlpha) {
                        scanLines[scanPos++] = (byte)(pixels[i + width * startRow] >> 24);
                    }
                    if (i % width != width - 1 || filter == 0) continue;
                    if (filter == 1) {
                        Save.filterSub(scanLines, startPos, width, bytesPerPixel, leftBytes);
                    }
                    if (filter != 2) continue;
                    Save.filterUp(scanLines, startPos, width, bytesPerPixel, priorRow);
                }
                compBytes.write(scanLines, 0, scanPos);
                startRow += nRows;
            }
            compBytes.close();
            byte[] compressedLines = outBytes.toByteArray();
            int nCompressed = compressedLines.length;
            crc.reset();
            Save.composeChunkHeader(nCompressed, "IDAT", buffer);
            crc.update(buffer, 4, 4);
            fs.write(buffer, 0, 8);
            fs.write(compressedLines, 0, nCompressed);
            crc.update(compressedLines, 0, nCompressed);
            long crcOut = crc.getValue();
            Save.toBigIndian(crcOut, buffer, 0);
            fs.write(buffer, 0, 4);
            scrunch.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected static boolean savePNG(OutputStream fs, Image img) {
        CRC32 crc = new CRC32();
        int[] pixels = null;
        byte[] buffer = new byte[4096];
        if (fs == null || img == null || buffer == null || crc == null) {
            return false;
        }
        PixelGrabber pg = new PixelGrabber(img, 0, 0, -1, -1, true);
        if (pg == null) {
            return false;
        }
        try {
            if (!pg.grabPixels()) {
                return false;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        Object obj = pg.getPixels();
        if (!(obj instanceof int[])) {
            return false;
        }
        pixels = (int[])obj;
        if (pixels.length != width * height) {
            return false;
        }
        try {
            fs.write(pngSignature);
            crc.reset();
            Save.composeChunkHeader(13, "IHDR", buffer);
            crc.update(buffer, 4, 4);
            Save.toBigIndian(width, buffer, 8);
            Save.toBigIndian(height, buffer, 12);
            buffer[16] = 8;
            buffer[17] = 2;
            buffer[18] = 0;
            buffer[19] = 0;
            buffer[20] = 0;
            crc.update(buffer, 8, 13);
            long crcOut = crc.getValue();
            Save.toBigIndian(crcOut, buffer, 21);
            fs.write(buffer, 0, 25);
            if (!Save.writeImageData(fs, buffer, pixels, width, height, false, 9, 0)) {
                return false;
            }
            Save.composeChunkHeader(0, "IEND", buffer);
            crc.reset();
            crc.update(buffer, 4, 4);
            crcOut = crc.getValue();
            Save.toBigIndian(crcOut, buffer, 8);
            fs.write(buffer, 0, 12);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

