/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.util.FontManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Vector;

public class SVGGraphics2D
extends Graphics2D
implements URLConsumerInterface {
    protected static final int BUFSIZE = 1024;
    protected static final int indentSpacing = 2;
    protected static final double deg2rad = Math.PI / 180;
    protected static final double rad2deg = 57.29577951308232;
    protected boolean closeWriter;
    protected boolean linkOpen;
    protected int groupNesting;
    protected int curIndent;
    protected int width;
    protected int height;
    protected long seqNum;
    protected Object writer;
    protected Color curColor;
    protected Color curBgColor;
    protected Paint curPaint;
    protected Stroke curStroke;
    protected Composite curComposite;
    protected String curColorString;
    protected String curPaintDef;
    protected String curFontDef;
    protected String curFontTransDef;
    protected String curClipPath;
    protected Font curFont;
    protected Shape curClip;
    protected AffineTransform curTransform;
    protected double[] m;
    protected Graphics g;
    protected BufferedImage bi;

    public SVGGraphics2D(Component comp, Writer output) {
        this.init(comp, output);
    }

    public SVGGraphics2D(Writer output) {
        this(null, output);
    }

    public SVGGraphics2D(Component comp, String outputFile) {
        this(comp, new File(outputFile));
    }

    public SVGGraphics2D(Component comp, File outputFile) {
        BufferedWriter fw = null;
        if (outputFile != null) {
            try {
                fw = new BufferedWriter(new FileWriter(outputFile));
            }
            catch (IOException e) {
                e.printStackTrace();
                fw = null;
            }
        }
        this.init(comp, fw);
        this.closeWriter = true;
    }

    public SVGGraphics2D(String outputFile) {
        this(null, outputFile);
    }

    public SVGGraphics2D() {
        this((Component)null, (Writer)null);
    }

    public SVGGraphics2D(Component comp, Vector output) {
        this.init(comp, output);
    }

    public SVGGraphics2D(Vector output) {
        this(null, output);
    }

    public SVGGraphics2D(Component comp) {
        this.init(comp, null);
    }

    protected SVGGraphics2D(SVGGraphics2D g) {
        this.bi = null;
        this.closeWriter = false;
        this.curBgColor = g.curBgColor;
        this.curClip = g.curClip;
        this.curClipPath = g.curClipPath;
        this.curColor = g.curColor;
        this.curColorString = g.curColorString;
        this.curComposite = g.curComposite;
        this.curFont = g.curFont;
        this.curFontDef = g.curFontDef;
        this.curFontTransDef = g.curFontTransDef;
        this.curIndent = g.curIndent;
        this.curPaint = g.curPaint;
        this.curPaintDef = g.curPaintDef;
        this.curStroke = g.curStroke;
        this.curTransform = g.curTransform == null ? null : new AffineTransform(g.curTransform);
        this.g = g.g.create();
        this.groupNesting = 0;
        this.height = g.height;
        this.linkOpen = g.linkOpen;
        this.m = new double[6];
        this.seqNum = g.seqNum;
        this.width = g.width;
        this.writer = g.writer;
    }

    public static boolean addComponentToOutput(SVGGraphics2D g, Component comp) {
        boolean save = true;
        if (g == null || comp == null) {
            return false;
        }
        if (comp instanceof GraphInterface) {
            save = ((GraphInterface)((Object)comp)).isBackBufferDrawEnabled();
            ((GraphInterface)((Object)comp)).setBackBufferDrawEnabled(false);
        }
        if (comp instanceof URLSourceInterface) {
            ((URLSourceInterface)((Object)comp)).addURLConsumer(null, g);
        }
        comp.paint(g);
        if (comp instanceof URLSourceInterface) {
            ((URLSourceInterface)((Object)comp)).removeURLConsumer(g);
        }
        if (comp instanceof GraphInterface) {
            ((GraphInterface)((Object)comp)).setBackBufferDrawEnabled(save);
        }
        return true;
    }

    protected static boolean doRender(SVGGraphics2D g, Component comp, boolean optimizeForSpeed, boolean includeHeader) {
        boolean out = false;
        g.begin(optimizeForSpeed, includeHeader);
        out = SVGGraphics2D.addComponentToOutput(g, comp);
        g.end();
        return out;
    }

    public static boolean renderToSVG(Component comp, File file) {
        return SVGGraphics2D.renderToSVG(comp, file, false);
    }

    public static boolean renderToSVG(Component comp, File file, boolean optimizeForSpeed, boolean includeHeader) {
        if (comp == null || file == null) {
            return false;
        }
        return SVGGraphics2D.doRender(new SVGGraphics2D(comp, file), comp, optimizeForSpeed, includeHeader);
    }

    public static boolean renderToSVG(Component comp, File file, boolean optimizeForSpeed) {
        return SVGGraphics2D.renderToSVG(comp, file, optimizeForSpeed, false);
    }

    public static boolean renderToSVG(Component comp, Writer writer) {
        return SVGGraphics2D.renderToSVG(comp, writer, false, false);
    }

    public static boolean renderToSVG(Component comp, Writer writer, boolean optimizeForSpeed, boolean includeHeader) {
        if (comp == null || writer == null) {
            return false;
        }
        return SVGGraphics2D.doRender(new SVGGraphics2D(comp, writer), comp, optimizeForSpeed, includeHeader);
    }

    public static boolean renderToSVG(Component comp, String file) {
        return SVGGraphics2D.renderToSVG(comp, new File(file));
    }

    protected void init(Component comp, Object output) {
        this.m = new double[6];
        this.linkOpen = false;
        this.seqNum = 0L;
        this.groupNesting = 0;
        this.closeWriter = false;
        this.curIndent = 0;
        if (comp != null) {
            this.setSize(comp.getWidth(), comp.getHeight());
            this.g = comp.getGraphics();
            if (this.g == null && (this.bi = new BufferedImage(this.width, this.height, 1)) != null) {
                this.g = this.bi.getGraphics();
            }
        } else {
            this.setSize(640, 480);
        }
        this.curColor = this.g != null ? this.g.getColor() : Color.black;
        this.curColorString = this.colorToString(this.curColor);
        this.curBgColor = Color.gray;
        this.curPaint = null;
        this.curPaintDef = null;
        this.curFontDef = null;
        this.curFontTransDef = null;
        this.curStroke = null;
        this.curComposite = null;
        this.curClipPath = null;
        this.curFont = FontManager.getFont((String)"Dialog", (int)0, (int)12);
        this.curTransform = new AffineTransform();
        this.writer = output;
        if (this.writer == null) {
            this.writer = new Vector();
        }
    }

    protected String colorToString(Color c) {
        String bs;
        String gs;
        String rs;
        if (c == null) {
            return null;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        try {
            rs = Integer.toHexString(r);
            if (rs == null) {
                return null;
            }
            gs = Integer.toHexString(g);
            if (gs == null) {
                return null;
            }
            bs = Integer.toHexString(b);
            if (bs == null) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (rs.length() < 2) {
            rs = "0" + rs;
        }
        if (gs.length() < 2) {
            gs = "0" + gs;
        }
        if (bs.length() < 2) {
            bs = "0" + bs;
        }
        return "#" + rs + gs + bs;
    }

    protected String getCurFill() {
        String s;
        int ia = 255;
        float a2 = 1.0f;
        float a1 = 1.0f;
        if (this.curPaint != null && this.curPaintDef != null) {
            s = "fill=\"url(#" + this.curPaintDef + ")\"";
        } else if (this.curColorString != null) {
            s = "fill=\"" + this.curColorString + "\"";
            if (this.curColor != null && (ia = this.curColor.getAlpha()) < 255) {
                a1 = (float)ia / 255.0f;
            }
        } else {
            s = "fill=\"#000000\"";
        }
        if (this.curComposite != null) {
            a2 = ((AlphaComposite)this.curComposite).getAlpha();
        }
        if (a1 < 1.0f || a2 < 1.0f) {
            s = s + " opacity=\"" + a1 * a2 + "\"";
        }
        return s;
    }

    protected String getCurStroke() {
        String s;
        int ia = 255;
        float a2 = 1.0f;
        float a1 = 1.0f;
        if (this.curPaint != null && this.curPaintDef != null) {
            s = "stroke=\"url(#" + this.curPaintDef + ")\"";
        } else if (this.curColorString != null) {
            s = "stroke=\"" + this.curColorString + "\"";
            if (this.curColor != null && (ia = this.curColor.getAlpha()) < 255) {
                a1 = (float)ia / 255.0f;
            }
        } else {
            s = "stroke=\"#000000\"";
        }
        if (this.curComposite != null) {
            a2 = ((AlphaComposite)this.curComposite).getAlpha();
        }
        if (a1 < 1.0f || a2 < 1.0f) {
            s = s + " opacity=\"" + a1 * a2 + "\"";
        }
        return s;
    }

    protected String getCurClipPath() {
        return null;
    }

    protected boolean writeString(String s) {
        String out = "";
        if (this.writer == null) {
            return false;
        }
        for (int i = 0; i < this.curIndent; ++i) {
            out = out + " ";
        }
        out = out + s;
        if (this.writer instanceof Vector) {
            ((Vector)this.writer).addElement(out);
            return true;
        }
        try {
            ((Writer)this.writer).write(out + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleRect(Shape shape, boolean fill, String extra, boolean bare) {
        double h;
        double w;
        double y;
        double x;
        double aw = 0.0;
        double ah = 0.0;
        if (shape == null) {
            return;
        }
        if (shape instanceof Rectangle2D) {
            if (shape instanceof Rectangle2D.Double) {
                Rectangle2D.Double r2d = (Rectangle2D.Double)shape;
                x = r2d.x;
                y = r2d.y;
                w = r2d.width;
                h = r2d.height;
            } else if (shape instanceof Rectangle2D.Float) {
                Rectangle2D.Float r2f = (Rectangle2D.Float)shape;
                x = r2f.x;
                y = r2f.y;
                w = r2f.width;
                h = r2f.height;
            } else {
                Rectangle rect = shape.getBounds();
                if (rect == null) return;
                x = rect.x;
                y = rect.y;
                w = rect.width;
                h = rect.height;
            }
        } else {
            if (!(shape instanceof RoundRectangle2D)) return;
            if (shape instanceof RoundRectangle2D.Double) {
                RoundRectangle2D.Double rr2d = (RoundRectangle2D.Double)shape;
                x = rr2d.x;
                y = rr2d.y;
                w = rr2d.width;
                h = rr2d.height;
                aw = rr2d.getArcWidth();
                ah = rr2d.getArcHeight();
            } else if (shape instanceof RoundRectangle2D.Float) {
                RoundRectangle2D.Float rr2f = (RoundRectangle2D.Float)shape;
                x = rr2f.x;
                y = rr2f.y;
                w = rr2f.width;
                h = rr2f.height;
                aw = rr2f.getArcWidth();
                ah = rr2f.getArcHeight();
            } else {
                Rectangle rect = shape.getBounds();
                if (rect == null) return;
                x = rect.x;
                y = rect.y;
                w = rect.width;
                h = rect.height;
            }
        }
        this.handleRect(x, y, w, h, aw, ah, fill, extra, bare);
    }

    protected void handleRect(double x, double y, double w, double h, double arcWidth, double arcHeight, boolean fill, String extra, boolean bare) {
        String clip;
        clip = bare || (clip = this.getCurClipPath()) == null ? "" : clip + " ";
        String s = "<rect " + clip + "x=\"" + x + "\" y=\"" + y + "\" width=\"" + w + "\" height=\"" + h + "\"";
        if (arcWidth > 0.0 && arcHeight > 0.0) {
            s = s + " rx = \"" + arcWidth / 2.0 + "\" ry = \"" + arcHeight / 2.0 + "\"";
        }
        if (extra != null) {
            s = s + " " + extra;
        }
        s = bare ? s + " />" : (!fill ? s + " fill=\"none\" " + this.getCurStroke() + " />" : s + " " + this.getCurFill() + " />");
        this.writeString(s);
    }

    protected void handleOval(Shape shape, boolean fill, boolean bare) {
        double h;
        double w;
        double y;
        double x;
        if (shape == null) {
            return;
        }
        if (shape instanceof Ellipse2D.Double) {
            Ellipse2D.Double e2d = (Ellipse2D.Double)shape;
            x = e2d.x;
            y = e2d.y;
            w = e2d.width;
            h = e2d.height;
        } else if (shape instanceof Ellipse2D.Float) {
            Ellipse2D.Float e2f = (Ellipse2D.Float)shape;
            x = e2f.x;
            y = e2f.y;
            w = e2f.width;
            h = e2f.height;
        } else {
            Rectangle rect = shape.getBounds();
            if (rect != null) {
                x = rect.x;
                y = rect.y;
                w = rect.width;
                h = rect.height;
            } else {
                return;
            }
        }
        this.handleOval(x, y, w, h, fill, bare);
    }

    protected void handleOval(double x, double y, double w, double h, boolean fill, boolean bare) {
        String clip;
        clip = bare || (clip = this.getCurClipPath()) == null ? "" : clip + " ";
        String s = "<ellipse " + clip + "cx=\"" + (x + w / 2.0) + "\" cy=\"" + (y + h / 2.0) + "\" rx=\"" + w / 2.0 + "\" ry=\"" + h / 2.0 + "\"";
        s = bare ? s + " />" : (!fill ? s + " fill=\"none\" " + this.getCurStroke() + " />" : s + " " + this.getCurFill() + " />");
        this.writeString(s);
    }

    protected void handlePolygons(int[] xPoints, int[] yPoints, int n, boolean close, boolean fill, boolean bare) {
        String clip;
        if (xPoints == null || yPoints == null || n <= 0) {
            return;
        }
        clip = bare || (clip = this.getCurClipPath()) == null ? "" : clip + " ";
        String s = close ? "<polygon " : "<polyline ";
        s = bare ? s + " points=\"" : (!fill ? s + clip + " fill=\"none\" " + this.getCurStroke() + " points=\"" : s + clip + " " + this.getCurFill() + " points=\"");
        this.writeString(s);
        this.curIndent += 33;
        for (int i = 0; i < n; ++i) {
            this.writeString(xPoints[i] + "," + yPoints[i]);
        }
        this.curIndent = Math.max(this.curIndent - 33, 0);
        this.writeString("\" />");
    }

    protected void handleClipShape(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Rectangle2D || shape instanceof RoundRectangle2D) {
            RectangularShape rect = (RectangularShape)shape;
            if (shape instanceof RoundRectangle2D) {
                this.handleRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), ((RoundRectangle2D)shape).getArcWidth() / 2.0, ((RoundRectangle2D)shape).getArcHeight() / 2.0, false, null, true);
            } else {
                this.handleRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), 0.0, 0.0, false, null, true);
            }
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellip = (Ellipse2D)shape;
            this.handleOval(ellip.getX(), ellip.getY(), ellip.getWidth(), ellip.getHeight(), false, true);
        } else if (shape instanceof Polygon) {
            Polygon poly = (Polygon)shape;
            this.handlePolygons(poly.xpoints, poly.ypoints, poly.npoints, true, false, true);
        } else if (shape instanceof GeneralPath) {
            this.handlePath(shape, false, true);
        }
    }

    protected void handleCurve(Shape curve, boolean fill, boolean bare) {
        String clip;
        String fillString = bare ? "" : (fill ? this.getCurFill() : "fill=\"none\" " + this.getCurStroke());
        clip = bare || (clip = this.getCurClipPath()) == null ? "" : clip + " ";
        if (curve == null) {
            return;
        }
        if (curve instanceof CubicCurve2D) {
            CubicCurve2D cubic = (CubicCurve2D)curve;
            this.writeString("<path " + clip + fillString + " d=\"M" + cubic.getX1() + "," + cubic.getY1() + " C" + cubic.getCtrlX1() + "," + cubic.getCtrlY1() + " " + cubic.getCtrlX2() + "," + cubic.getCtrlY2() + " " + cubic.getX2() + "," + cubic.getY2() + "\" />");
        } else if (curve instanceof QuadCurve2D) {
            QuadCurve2D quad = (QuadCurve2D)curve;
            this.writeString("<path " + clip + fillString + " d=\"M" + quad.getX1() + "," + quad.getY1() + " Q" + quad.getCtrlX() + "," + quad.getCtrlY() + " " + quad.getX2() + "," + quad.getY2() + "\" />");
        }
    }

    protected void handlePath(Shape path, boolean fill, boolean bare) {
        String clip;
        boolean isArea = false;
        double lastx = Double.NaN;
        double lasty = Double.NaN;
        String s = null;
        if (path == null) {
            return;
        }
        isArea = path instanceof Area;
        PathIterator pi = path.getPathIterator(null);
        if (pi == null) {
            return;
        }
        double[] d = new double[6];
        if (d == null) {
            return;
        }
        String fillString = bare ? "" : (fill ? this.getCurFill() : "fill=\"none\" " + this.getCurStroke());
        clip = bare || (clip = this.getCurClipPath()) == null ? "" : clip + " ";
        while (!pi.isDone()) {
            if (s == null) {
                s = "<path " + clip + fillString + " d=\"";
            }
            int type = pi.currentSegment(d);
            pi.next();
            switch (type) {
                case 4: {
                    if (isArea) {
                        s = s + "Z ";
                        break;
                    }
                    s = s + "Z\" />";
                    this.writeString(s);
                    s = "<path " + clip + fillString + " d=\"";
                    if (Double.isNaN(lastx) || Double.isNaN(lasty)) break;
                    s = s + "M" + lastx + "," + lasty + " ";
                    break;
                }
                case 0: {
                    s = s + "M" + d[0] + "," + d[1] + " ";
                    lastx = d[0];
                    lasty = d[0];
                    break;
                }
                case 1: {
                    s = s + "L" + d[0] + "," + d[1] + " ";
                    lastx = d[0];
                    lasty = d[0];
                    break;
                }
                case 3: {
                    s = s + "C" + d[0] + "," + d[1] + " " + d[2] + "," + d[3] + " " + d[4] + "," + d[5] + " ";
                    lastx = d[4];
                    lasty = d[5];
                    break;
                }
                case 2: {
                    s = s + "Q" + d[0] + "," + d[1] + " " + d[2] + "," + d[3] + " ";
                    lastx = d[2];
                    lasty = d[3];
                }
            }
        }
        if (s != null) {
            s = s + "\" />";
            this.writeString(s);
        }
    }

    protected void handleFont(Font f) {
        String style;
        switch (f.getStyle()) {
            default: {
                style = "normal";
                break;
            }
            case 2: {
                style = "italic";
            }
        }
        this.curFontDef = "font-family=\"" + f.getFamily() + "\" font-style=\"" + style + "\" font-size=\"" + f.getSize() + "\"";
        if (f.isBold()) {
            this.curFontDef = this.curFontDef + " font-weight=\"bold\"";
        }
        if (f.isTransformed()) {
            AffineTransform af = f.getTransform();
            af.getMatrix(this.m);
            this.curFontTransDef = "matrix(" + this.m[0] + "," + this.m[1] + "," + this.m[2] + "," + this.m[3] + "," + this.m[4] + "," + this.m[5] + ")";
        } else {
            this.curFontTransDef = null;
        }
    }

    protected void handleArc(int x, int y, int w, int h, int startAngle, int arcAngle, boolean fill, int type, boolean bare) {
        String s;
        String clip;
        int largeArc = 0;
        int sweepFlag = 0;
        int rx = w / 2;
        int ry = h / 2;
        int cx = x + rx;
        int cy = y + ry;
        double xStart = (double)x + (double)rx * Math.cos((double)startAngle * (Math.PI / 180)) + (double)rx;
        double yStart = (double)y - (double)ry * Math.sin((double)startAngle * (Math.PI / 180)) + (double)ry;
        double xEnd = (double)x + (double)rx * Math.cos((double)(startAngle + arcAngle) * (Math.PI / 180)) + (double)rx;
        double yEnd = (double)y - (double)ry * Math.sin((double)(startAngle + arcAngle) * (Math.PI / 180)) + (double)ry;
        if (Math.abs(arcAngle) > 180) {
            largeArc = 1;
        }
        if (arcAngle < 0) {
            sweepFlag = 1;
        }
        String fillString = bare ? "" : (fill ? this.getCurFill() : "fill=\"none\" " + this.getCurStroke());
        clip = bare || (clip = this.getCurClipPath()) == null ? "" : clip + " ";
        switch (type) {
            case 2: {
                s = "<path " + clip + "d=\"M" + cx + "," + cy + " L";
                break;
            }
            default: {
                s = "<path " + clip + "d=\"M";
            }
        }
        s = s + xStart + "," + yStart + " A" + rx + "," + ry + " 0 " + largeArc + "," + sweepFlag + " " + xEnd + "," + yEnd;
        s = fill || type == 2 || type == 1 ? s + " z\" " + fillString + " />" : s + "\" " + fillString + " />";
        this.writeString(s);
    }

    protected void handleText(String s, float x, float y) {
        if (s == null) {
            return;
        }
        String clip = this.getCurClipPath();
        clip = clip == null ? "" : clip + " ";
        String out = "<text " + clip;
        if (this.curFontDef != null) {
            out = out + this.curFontDef + " ";
        }
        if (this.curFontTransDef != null) {
            out = out + " transform=\"translate( " + x + ", " + y + " ) " + this.curFontTransDef + " translate( " + -x + ", " + -y + " )\" ";
        }
        out = out + this.getCurFill() + " x=\"" + x + "\" y=\"" + y + "\">" + s + "</text>";
        this.writeString(out);
    }

    protected void closeAllGroups() {
        for (int i = 0; i < this.groupNesting; ++i) {
            this.curIndent = Math.max(this.curIndent - 2, 0);
            this.writeString("</g>");
        }
        this.groupNesting = 0;
    }

    protected void handleTransformMatrix(double[] m) {
        if (m == null || m.length < 6) {
            return;
        }
        if (this.writeString("<g transform=\"matrix(" + m[0] + "," + m[1] + "," + m[2] + "," + m[3] + "," + m[4] + "," + m[5] + ")\">")) {
            ++this.groupNesting;
            this.curIndent += 2;
        }
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.curClip = new Rectangle(0, 0, this.width, this.height);
    }

    public void begin(boolean optimizeForSpeed, boolean includeHeader) {
        if (includeHeader) {
            this.writeString("<?xml version=\"1.0\" ?>");
            this.writeString("<!DOCTYPE svg SYSTEM \"svg.dtd\">");
        }
        String s = "<svg width=\"" + this.width + "\" height=\"" + this.height + "\"";
        if (optimizeForSpeed) {
            s = s + " shape-rendering=\"optimizeSpeed\"";
        }
        s = s + " >";
        this.writeString(s);
        this.curIndent += 2;
        s = "<desc>Copyright SAS Institute, Inc. 2003</desc>";
        this.writeString(s);
        this.handleFont(this.getFont());
    }

    public void end() {
        if (this.writer != null) {
            this.closeAllGroups();
            this.curIndent = 0;
            this.writeString("</svg>");
            if (this.closeWriter && this.writer instanceof Writer) {
                try {
                    ((Writer)this.writer).flush();
                    ((Writer)this.writer).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.writer = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.bi = null;
        this.g = null;
    }

    public Vector getOutput() {
        if (this.writer == null || !(this.writer instanceof Vector)) {
            return null;
        }
        return (Vector)this.writer;
    }

    public boolean openHyperlink(URL link) {
        if (link == null) {
            return false;
        }
        return this.openHyperlink(link.toExternalForm());
    }

    public boolean openHyperlink(String link) {
        if (link == null) {
            return false;
        }
        if (this.linkOpen) {
            this.closeHyperlink();
            if (this.linkOpen) {
                return false;
            }
        }
        link = link.trim();
        this.linkOpen = this.writeString("<a xlink:href=\"" + link + "\" >");
        if (this.linkOpen) {
            this.writeString("<g>");
        }
        return true;
    }

    public void closeHyperlink() {
        if (!this.linkOpen) {
            return;
        }
        this.writeString("</g>");
        this.linkOpen = !this.writeString("</a>");
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        this.handleRect(x, y, w, h, 0.0, 0.0, false, null, false);
    }

    @Override
    public void draw(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Line2D) {
            this.drawLine((int)((Line2D)shape).getX1(), (int)((Line2D)shape).getY1(), (int)((Line2D)shape).getX2(), (int)((Line2D)shape).getY2());
        } else if (shape instanceof Ellipse2D) {
            this.handleOval(shape, false, false);
        } else if (shape instanceof Rectangle2D || shape instanceof RoundRectangle2D) {
            this.handleRect(shape, false, null, false);
        } else if (shape instanceof Polygon) {
            this.drawPolygon(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints);
        } else if (shape instanceof CubicCurve2D || shape instanceof QuadCurve2D) {
            this.handleCurve(shape, false, false);
        } else if (shape instanceof Arc2D) {
            this.handleArc((int)((Arc2D)shape).getX(), (int)((Arc2D)shape).getY(), (int)((Arc2D)shape).getWidth(), (int)((Arc2D)shape).getHeight(), (int)((Arc2D)shape).getAngleStart(), (int)((Arc2D)shape).getAngleExtent(), false, ((Arc2D)shape).getArcType(), false);
        } else {
            this.handlePath(shape, false, false);
        }
    }

    @Override
    public boolean drawImage(Image arg0, AffineTransform arg1, ImageObserver arg2) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage arg0, BufferedImageOp arg1, int arg2, int arg3) {
    }

    @Override
    public void drawRenderedImage(RenderedImage arg0, AffineTransform arg1) {
    }

    @Override
    public void drawRenderableImage(RenderableImage arg0, AffineTransform arg1) {
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.handleText(s, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.handleText(s, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        int n = 0;
        char[] chars = null;
        if (iterator == null) {
            return;
        }
        int start = iterator.getBeginIndex();
        int end = iterator.getEndIndex();
        n = end - start;
        if (n <= 0) {
            return;
        }
        chars = new char[n];
        if (chars == null) {
            return;
        }
        for (int i = start; i < end; ++i) {
            chars[i - start] = i == start ? iterator.first() : iterator.next();
        }
        String s = new String(chars);
        if (s == null) {
            return;
        }
        this.handleText(s, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        if (g == null) {
            return;
        }
        Shape s = g.getOutline(x, y);
        this.draw(s);
    }

    @Override
    public void fill(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape instanceof Ellipse2D) {
            this.handleOval(shape, true, false);
        } else if (shape instanceof Rectangle2D || shape instanceof RoundRectangle2D) {
            this.handleRect(shape, true, null, false);
        } else if (shape instanceof Polygon) {
            this.fillPolygon(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints);
        } else if (shape instanceof CubicCurve2D || shape instanceof QuadCurve2D) {
            this.handleCurve(shape, true, false);
        } else if (shape instanceof Arc2D) {
            this.handleArc((int)((Arc2D)shape).getX(), (int)((Arc2D)shape).getY(), (int)((Arc2D)shape).getWidth(), (int)((Arc2D)shape).getHeight(), (int)((Arc2D)shape).getAngleStart(), (int)((Arc2D)shape).getAngleExtent(), true, ((Arc2D)shape).getArcType(), false);
        } else {
            this.handlePath(shape, true, false);
        }
    }

    @Override
    public boolean hit(Rectangle arg0, Shape arg1, boolean arg2) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.g == null || !(this.g instanceof Graphics2D)) {
            return null;
        }
        return ((Graphics2D)this.g).getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite c) {
        float alpha = 1.0f;
        if (c == null || !(c instanceof AlphaComposite)) {
            return;
        }
        AlphaComposite cIn = (AlphaComposite)c;
        alpha = cIn.getAlpha();
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setComposite(c);
        }
        this.curComposite = (double)alpha < 1.0 ? c : null;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setPaint(paint);
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        this.curPaint = paint;
        if (!(paint instanceof GradientPaint)) {
            return;
        }
        GradientPaint gp = (GradientPaint)paint;
        Color c1 = gp.getColor1();
        Color c2 = gp.getColor2();
        Point2D p1 = gp.getPoint1();
        Point2D p2 = gp.getPoint2();
        String s1 = this.colorToString(c1);
        String s2 = this.colorToString(c2);
        if (s1 == null || s2 == null) {
            return;
        }
        String op1 = c1.getAlpha() < 255 ? " stop-opacity=\"" + (float)c1.getAlpha() / 255.0f + "\" " : "";
        String op2 = c2.getAlpha() < 255 ? " stop-opacity=\"" + (float)c2.getAlpha() / 255.0f + "\" " : "";
        this.curPaintDef = "Gradient" + Long.toString(this.seqNum);
        this.writeString("<defs>");
        this.writeString("  <linearGradient id=\"" + this.curPaintDef + "\" gradientUnits=\"userSpaceOnUse\" x1=\"" + p1.getX() + "\" y1=\"" + p1.getY() + "\" x2=\"" + p2.getX() + "\" y2=\"" + p2.getY() + "\" >");
        this.writeString("    <stop offset=\"0%\" stop-color=\"" + s1 + "\"" + op1 + " />");
        this.writeString("    <stop offset=\"100%\" stop-color=\"" + s2 + "\"" + op2 + " />");
        this.writeString("  </linearGradient>");
        this.writeString("</defs>");
        ++this.seqNum;
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(stroke);
        }
        this.curStroke = stroke;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getRenderingHint(hintKey);
        }
        return null;
    }

    public void setRenderingHints(Map arg0) {
    }

    public void addRenderingHints(Map arg0) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getRenderingHints();
        }
        return null;
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double x, double y) {
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).translate(x, y);
        }
        if (this.writeString("<g transform=\"translate(" + x + "," + y + ")\">")) {
            ++this.groupNesting;
            this.curIndent += 2;
        }
    }

    @Override
    public void rotate(double angle) {
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).rotate(angle);
        }
        if (this.writeString("<g transform=\"rotate(" + angle * 57.29577951308232 + ")\">")) {
            ++this.groupNesting;
            this.curIndent += 2;
        }
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).scale(sx, sy);
        }
        if (this.writeString("<g transform=\"scale(" + sx + "," + sy + ")\">")) {
            ++this.groupNesting;
            this.curIndent += 2;
        }
    }

    @Override
    public void shear(double shx, double shy) {
        if (this.m == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).shear(shx, shy);
        }
        this.m[0] = 1.0;
        this.m[1] = shy;
        this.m[2] = shx;
        this.m[3] = 1.0;
        this.m[4] = 0.0;
        this.m[5] = 0.0;
        this.handleTransformMatrix(this.m);
    }

    @Override
    public void transform(AffineTransform tx) {
        if (tx == null || this.m == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).transform(tx);
        }
        tx.getMatrix(this.m);
        this.handleTransformMatrix(this.m);
    }

    @Override
    public void setTransform(AffineTransform trans) {
        if (trans == null || this.m == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setTransform(trans);
        }
        this.curTransform = trans;
        trans.getMatrix(this.m);
        this.closeAllGroups();
        this.handleTransformMatrix(this.m);
    }

    @Override
    public AffineTransform getTransform() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getTransform();
        }
        return this.curTransform;
    }

    @Override
    public Paint getPaint() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getPaint();
        }
        if (this.curPaint != null) {
            return this.curPaint;
        }
        return this.curColor;
    }

    @Override
    public Composite getComposite() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getComposite();
        }
        if (this.curComposite != null) {
            return this.curComposite;
        }
        return AlphaComposite.getInstance(3, 1.0f);
    }

    @Override
    public void setBackground(Color c) {
        if (c == null) {
            return;
        }
        if (this.g != null && this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setBackground(c);
        }
        this.curBgColor = c;
    }

    @Override
    public Color getBackground() {
        return this.curBgColor;
    }

    @Override
    public Stroke getStroke() {
        if (this.g != null && this.g instanceof Graphics2D) {
            return ((Graphics2D)this.g).getStroke();
        }
        if (this.curStroke != null) {
            return this.curStroke;
        }
        return new BasicStroke();
    }

    @Override
    public void clip(Shape newShape) {
        Shape oldShape = this.getClip();
        String oldClipPath = this.curClipPath;
        if (newShape == null) {
            return;
        }
        if (oldShape == null || oldClipPath == null) {
            this.setClip(newShape);
            return;
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        if (this.g == null || !(this.g instanceof Graphics2D)) {
            return new FontRenderContext(this.curTransform, false, true);
        }
        return ((Graphics2D)this.g).getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        Graphics out = this.create();
        out.translate(x, y);
        out.clipRect(0, 0, width, height);
        return out;
    }

    @Override
    public Color getColor() {
        if (this.g != null) {
            return this.g.getColor();
        }
        return this.curColor;
    }

    @Override
    public void setColor(Color c) {
        String s = null;
        if (c == null) {
            return;
        }
        if (this.g != null) {
            this.g.setColor(c);
        }
        this.curColor = c;
        this.curPaint = null;
        s = this.colorToString(c);
        if (s == null) {
            return;
        }
        this.curColorString = s;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color arg0) {
    }

    @Override
    public Font getFont() {
        if (this.g != null) {
            return this.g.getFont();
        }
        return this.curFont;
    }

    @Override
    public void setFont(Font f) {
        if (f == null) {
            return;
        }
        if (this.g != null) {
            this.g.setFont(f);
        }
        this.curFont = f;
        this.handleFont(f);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        if (this.g != null) {
            return this.g.getFontMetrics(f);
        }
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.g != null) {
            return this.g.getClipBounds();
        }
        if (this.curClip == null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return this.curClip.getBounds();
    }

    @Override
    public void clipRect(int arg0, int arg1, int arg2, int arg3) {
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    @Override
    public Shape getClip() {
        if (this.g != null) {
            return this.g.getClip();
        }
        return this.curClip;
    }

    @Override
    public void setClip(Shape shape) {
        if (this.g != null) {
            this.g.setClip(shape);
        }
        this.curClip = shape;
        if (shape == null) {
            this.curClipPath = null;
            return;
        }
    }

    @Override
    public void copyArea(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        String clip = this.getCurClipPath();
        clip = clip == null ? "" : clip + " ";
        this.writeString("<line " + clip + "x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" " + this.getCurStroke() + " />");
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.handleRect(x, y, w, h, 0.0, 0.0, true, null, false);
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        String s = this.colorToString(this.curBgColor);
        if (s == null) {
            return;
        }
        this.handleRect(x, y, w, h, 0.0, 0.0, true, "fill=\"" + s + "\"", false);
    }

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        this.handleRect(x, y, w, h, arcWidth, arcHeight, false, null, false);
    }

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        this.handleRect(x, y, w, h, arcWidth, arcHeight, true, null, false);
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        this.handleOval(x, y, w, h, false, false);
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.handleOval(x, y, w, h, true, false);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.handleArc(x, y, width, height, startAngle, arcAngle, false, 0, false);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.handleArc(x, y, width, height, startAngle, arcAngle, true, 2, false);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int n) {
        this.handlePolygons(xPoints, yPoints, n, false, false, false);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int n) {
        this.handlePolygons(xPoints, yPoints, n, true, false, false);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int n) {
        this.handlePolygons(xPoints, yPoints, n, true, true, false);
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, ImageObserver arg3) {
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, ImageObserver arg5) {
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, Color arg3, ImageObserver arg4) {
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, Color arg5, ImageObserver arg6) {
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, ImageObserver arg9) {
        return false;
    }

    @Override
    public boolean drawImage(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Color arg9, ImageObserver arg10) {
        return false;
    }

    @Override
    public void dispose() {
        this.closeAllGroups();
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        super.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        super.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        super.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        super.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawPolygon(Polygon p) {
        super.drawPolygon(p);
    }

    @Override
    public void fillPolygon(Polygon p) {
        super.fillPolygon(p);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return super.getClipBounds(r);
    }

    @Override
    public Rectangle getClipRect() {
        return super.getClipRect();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return super.getFontMetrics();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return super.hitClip(x, y, width, height);
    }

    @Override
    public void beginURL(Object context, Object url, String alt) {
        String s;
        if (url == null) {
            return;
        }
        if (url instanceof String) {
            s = (String)url;
        } else if (url instanceof URL) {
            s = ((URL)url).toExternalForm();
        } else {
            return;
        }
        this.openHyperlink(s);
    }

    @Override
    public void endURL(Object context) {
        this.closeHyperlink();
    }
}

