/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.styles.AttributesTable;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.GraphUtilities;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Map;

public class SILKUtilities
extends GraphUtilities {
    private static final String SILK_FAKE_STRING = "__SILK__FAKE__STRING__";

    public static StyleElement getStyleElement(String value, int groupIndex, int type, Style style, String styleReference, StyleElement localOverrides) {
        AttributesTable at;
        StyleElement se;
        if (style == null) {
            style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        }
        if (styleReference == null) {
            styleReference = "GraphDataStyleDefault";
        }
        if ((se = (at = (AttributesTable)SILKGlobal.getInstance().getPropertyValue(50)).getStyleElement(value, type, style)) == null) {
            if (groupIndex >= 0) {
                se = style.getDataStyleElement(groupIndex);
            } else if (styleReference.startsWith("GraphDataStyle")) {
                String s = styleReference.substring("GraphDataStyle".length());
                try {
                    int index = Integer.parseInt(s);
                    if (index >= 1) {
                        se = style.getDataStyleElement(index - 1);
                    }
                }
                catch (NumberFormatException nfe) {
                    se = style.getStyleElement(styleReference);
                }
            } else {
                se = style.getStyleElement(styleReference);
            }
            if (localOverrides != null) {
                se = se.mergeWith(localOverrides);
            }
        }
        return se;
    }

    public static StyleElement getStyleElement(String value, int groupIndex, int type, Style style, StyleElementAttrs styleElementAttrs, StyleElement localOverrides) {
        AttributesTable at;
        StyleElement se;
        String styleReference;
        if (style == null) {
            style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        }
        if ((styleReference = styleElementAttrs.getReference()) == null) {
            styleReference = "GraphDataStyleDefault";
        }
        if ((se = (at = (AttributesTable)SILKGlobal.getInstance().getPropertyValue(50)).getStyleElement(value, type, style)) == null) {
            if (styleElementAttrs.isReferenceUserSet()) {
                se = style.getDataStyleElement(styleReference);
            } else if (groupIndex >= 0) {
                se = style.getDataStyleElement(groupIndex);
            } else if (styleReference.startsWith("GraphDataStyle")) {
                String s = styleReference.substring("GraphDataStyle".length());
                try {
                    int index = Integer.parseInt(s);
                    if (index >= 1) {
                        se = style.getDataStyleElement(index - 1);
                    }
                }
                catch (NumberFormatException nfe) {
                    se = style.getStyleElement(styleReference);
                }
            } else {
                se = style.getStyleElement(styleReference);
            }
            if (localOverrides != null) {
                se = se.mergeWith(localOverrides);
            }
        }
        return se;
    }

    public static Font doDPIScale(Font f) {
        if (f == null) {
            return null;
        }
        int size = f.getSize();
        Object factor = SILKGlobal.getInstance().getPropertyValue(54);
        if (factor instanceof Number) {
            size = (int)((double)size * ((Number)factor).doubleValue());
        }
        if (size == f.getSize()) {
            return f;
        }
        return f.deriveFont((float)size);
    }

    public static int adjustFontSize(int originalSize) {
        int size = originalSize;
        Object factor = SILKGlobal.getInstance().getPropertyValue(54);
        if (factor instanceof Number) {
            size = (int)((double)size * ((Number)factor).doubleValue());
        }
        size = (int)((double)size * SILKGlobal.getInstance().getGlobalDefaults().fontSizeAdjust);
        return size;
    }

    public static Font adjustFontSize(Font font) {
        if (font == null) {
            return null;
        }
        return font.deriveFont((float)SILKUtilities.adjustFontSize(font.getSize()));
    }

    public static double getGapScaleFactor() {
        double rc = 1.0;
        Object factor = SILKGlobal.getInstance().getPropertyValue(67);
        if (factor instanceof Number) {
            rc = ((Number)factor).doubleValue();
        }
        return rc;
    }

    public static double getDPIScaleFactor() {
        double rc = 1.0;
        Object factor = SILKGlobal.getInstance().getPropertyValue(54);
        if (factor instanceof Number) {
            rc = ((Number)factor).doubleValue();
        }
        return rc;
    }

    public static boolean isScaledUp() {
        return SILKUtilities.getDPIScaleFactor() > 1.0;
    }

    public static double getSizeScaleFactor() {
        return 1.0;
    }

    public static int scaleLegendLineLength(int size) {
        if (SILKUtilities.isScaledUp()) {
            return (int)Math.round((double)size * SILKUtilities.getDPIScaleFactor() * SILKUtilities.getSizeScaleFactor());
        }
        return (int)Math.round((double)size * SILKUtilities.getDPIScaleFactor() * SILKUtilities.getSizeScaleFactor() * SILKUtilities.getSizeScaleFactor());
    }

    public static int getMarkerEdgeWidth(double size, int weight) {
        double width;
        double ratio = (size /= SILKUtilities.getDPIScaleFactor()) / 7.0;
        if (weight == 2) {
            double power = 0.7;
            double minWidth = 2.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else if (weight == 1) {
            double power = 0.65;
            double minWidth = 1.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else {
            double power = 0.5;
            double minWidth = 1.0;
            width = ratio <= 3.0 ? minWidth : minWidth + Math.pow(ratio - 3.0, power);
        }
        width = Math.max(1.0, width * SILKUtilities.getDPIScaleFactor());
        return (int)width;
    }

    public static String[] generateFakeStrings(int num) {
        String[] rc = new String[num];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = SILK_FAKE_STRING + i;
        }
        return rc;
    }

    public static boolean isFakeString(String s) {
        if (s == null) {
            return false;
        }
        return s.startsWith(SILK_FAKE_STRING);
    }

    public static DiscreteRange createPaddedRange(DiscreteRange range, int minCount) {
        if (minCount > range.getValuesSize()) {
            String[] fakeStrings = SILKUtilities.generateFakeStrings(minCount - range.getValuesSize());
            int i = 0;
            Enumeration list = range.getEnumeration();
            Object[] values = new Object[minCount];
            while (list.hasMoreElements()) {
                values[i++] = list.nextElement();
            }
            for (i = range.getValuesSize(); i < minCount; ++i) {
                values[i] = fakeStrings[i - range.getValuesSize()];
            }
            if (range instanceof OrdinalRange) {
                OrdinalRange or = (OrdinalRange)range;
                Map m = or.getMap();
                Object[] rawValues = m.values().toArray();
                if (rawValues != null && rawValues.length == range.getValuesSize()) {
                    Object[] newRawValues = new Object[minCount];
                    for (i = 0; i < rawValues.length; ++i) {
                        newRawValues[i] = rawValues[i];
                    }
                    for (i = rawValues.length; i < minCount; ++i) {
                        newRawValues[i] = fakeStrings[i - rawValues.length];
                    }
                    range = new OrdinalRange(values, newRawValues);
                }
            } else {
                range = new DiscreteRange(values);
            }
        }
        return range;
    }

    public static boolean useGraphEngraving() {
        if (SILKGlobal.isFlagSet(4)) {
            return false;
        }
        Object obj = SILKGlobal.getInstance().getPropertyValue(58);
        return obj instanceof Boolean ? (Boolean)obj : true;
    }
}

