/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.event.DiagnosticsEvent;
import com.sas.graphics.silk.event.DiagnosticsInterface;
import com.sas.graphics.silk.event.DiagnosticsListener;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.ColorMapper;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.styles.AttributesTable;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.ui.EditorDialog;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.PropertyMulticaster;
import com.sas.graphics.xml.GraphParserFactory;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SILKGlobal
implements PropertyInterface {
    private Hashtable setProperties = new Hashtable();
    private PropertyList pendingProperties = new PropertyList();
    private PropertyMulticaster charts = new PropertyMulticaster();
    private UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedProperties);
    private EventListenerList changeListeners = null;
    private ChangeEvent changeEvent = null;
    private GlobalDefaults globalDefaults = null;
    private static SILKGlobal instance;
    private static boolean debug;
    private static boolean testMode;
    private static BitSet flags;
    public static final int BUILD_TIME_PERFORMANCE_FLAG = 0;
    public static final int DRAW_TIME_PERFORMANCE_FLAG = 1;
    public static final int SELECTION_DRAW_PERFORMANCE_FLAG = 2;
    public static final int DEBUG_FLAG = 3;
    public static final int STATGRAPH_COMPATABILITY = 4;
    public static final int LAYOUT_DEBUG_FLAG = 5;
    public static final int STATGRAPH_BORDER = 6;
    private static int[] supportedProperties;
    public static final int LOG_TYPE_MESSAGE = 0;
    public static final int LOG_TYPE_WARNING = 1;
    public static final int LOG_TYPE_ERROR = 2;
    public static final int LOG_TYPE_PERFORMANCE = 3;
    public static final String[] silkStyles;
    private DefaultDiagnostics diagnostics = null;
    private static boolean silkParsersAreLoaded;

    public static void loadSILKParsers() {
        if (!silkParsersAreLoaded) {
            Properties parsers = ResourceLoader.loadProperties((String)"com/sas/graphics/silk/xml/parsers.config");
            Properties dataValueParsers = ResourceLoader.loadProperties((String)"com/sas/graphics/silk/xml/data/DataValueParsers.config");
            Properties outParsers = ResourceLoader.loadProperties((String)"com/sas/graphics/silk/xml/parsers_out.config");
            GraphParserFactory.addAllProperties((int)0, (Properties)parsers);
            GraphParserFactory.addAllProperties((int)1, (Properties)outParsers);
            GraphParserFactory.addAllProperties((int)2, (Properties)dataValueParsers);
            silkParsersAreLoaded = true;
        }
    }

    private SILKGlobal() {
        StyleCollection sc = (StyleCollection)this.getPropertyValue(48);
        sc.addChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("currentStyleContentsChanged".equals(evt.getPropertyName())) {
                    SILKGlobal.this.setPropertyValue(29, ((StyleCollection)evt.getSource()).getCurrentStyle());
                } else if ("currentStyleChanged".equals(evt.getPropertyName())) {
                    ((StyleCollection)evt.getSource()).getCurrentStyle().setFallbackEnabled(true);
                }
            }
        });
        Style def = sc.getStyle("SILKDefault");
        sc.setCurrentStyle(def);
        if (def != null) {
            this.setProperties.put(new Integer(0), new ColorScheme(def));
            this.setProperties.put(new Integer(29), def);
        }
    }

    public static SILKGlobal getInstance() {
        if (instance == null) {
            instance = new SILKGlobal();
        }
        return instance;
    }

    public static boolean register(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        SILKGlobal instance = SILKGlobal.getInstance();
        if (instance.charts.contains(prop)) {
            return true;
        }
        boolean rc = instance.charts.addListener(prop);
        if (rc) {
            instance.fireChangeEvent();
        }
        if (SILKGlobal.isTestMode()) {
            System.out.println("There are " + instance.charts.numPropertyInterfaces() + " SILK charts alive.");
        }
        String id = SILKGlobal.getUniqueName(prop);
        prop.setPropertyValue(62, (Object)id);
        prop.applyPropertyChanges();
        return rc;
    }

    public static String getUniqueName(Object graph) {
        SILKChartInfo info;
        String id = null;
        id = graph instanceof BaseElementComponent ? "LayoutOverlay" : ((info = SILKChartInfo.getInstance(graph)) == null ? (graph.getClass().getName().indexOf(46) >= 0 ? graph.getClass().getName().substring(graph.getClass().getName().lastIndexOf(46) + 1) : graph.getClass().getName()) : info.getDisplayName());
        String baseId = id;
        int num = 0;
        while (instance.getChart(id) != null) {
            id = baseId + " " + ++num;
        }
        return id;
    }

    public PropertyInterface getChart(String id) {
        PropertyInterface[] charts = this.getRegisteredPropertyListeners();
        if (charts == null) {
            return null;
        }
        for (int i = 0; i < charts.length; ++i) {
            Object chartid = charts[i].getPropertyValue(62);
            if (chartid == null || !chartid.equals(id)) continue;
            return charts[i];
        }
        return null;
    }

    public static boolean unregister(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        SILKGlobal instance = SILKGlobal.getInstance();
        boolean rc = instance.charts.removeListener(prop);
        if (rc) {
            instance.fireChangeEvent();
        }
        if (SILKGlobal.isTestMode()) {
            System.out.println("There are " + instance.charts.numPropertyInterfaces() + " SILK charts alive.");
        }
        return rc;
    }

    public boolean isPropertySupported(int id) {
        for (int i = 0; i < supportedProperties.length; ++i) {
            if (supportedProperties[i] != id) continue;
            return true;
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pendingProperties.isPending(id);
    }

    public Object getPropertyValue(int id) {
        if (this.isPropertyPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        switch (id) {
            case 47: {
                if (this.setProperties.containsKey(new Integer(47))) break;
                this.setProperties.put(new Integer(47), new EditorDialog((StyleCollection)this.getPropertyValue(48)));
                break;
            }
            case 48: {
                if (this.setProperties.containsKey(new Integer(48))) break;
                StyleCollection sc = new StyleCollection(silkStyles);
                for (int i = 0; i < sc.getNumberStyles(); ++i) {
                    sc.getStyleAt(i).setFallbackEnabled(true);
                }
                this.setProperties.put(new Integer(48), sc);
                break;
            }
            case 50: {
                if (this.setProperties.containsKey(new Integer(50))) break;
                this.setProperties.put(new Integer(50), new AttributesTable("SILK Attributes Table"));
                break;
            }
            case 49: {
                if (this.setProperties.containsKey(new Integer(49))) break;
                Style controlStyle = Style.getStyle((InputStream)SILKGlobal.class.getResourceAsStream("/com/sas/graphics/styles/xml/SILKDEFAULTCONTROL.xml"));
                controlStyle.setFallbackEnabled(true);
                this.setProperties.put(new Integer(49), controlStyle);
                break;
            }
            case 51: {
                if (this.setProperties.containsKey(new Integer(51))) break;
                try {
                    Class.forName("com.sas.graphics.sganno.Annotate");
                    Class<?> cls = Class.forName("com.sas.graphics.silk.util.SILKAnnotate");
                    AnnotateInterface anno = (AnnotateInterface)cls.newInstance();
                    JToolBar annoToolBar = anno.getAnnotationToolBar();
                    if (annoToolBar == null) break;
                    this.setProperties.put(new Integer(51), annoToolBar);
                }
                catch (ClassNotFoundException cls) {
                }
                catch (InstantiationException cls) {
                }
                catch (IllegalAccessException cls) {}
                break;
            }
            case 52: {
                if (this.setProperties.containsKey(new Integer(52))) break;
                this.setProperties.put(new Integer(52), new JColorChooser());
                break;
            }
            case 58: {
                if (this.setProperties.containsKey(new Integer(58))) break;
                this.setProperties.put(new Integer(58), Boolean.TRUE);
                break;
            }
            case 54: {
                if (this.setProperties.containsKey(new Integer(54))) break;
                this.setProperties.put(new Integer(54), new Double(1.0));
                break;
            }
            case 67: {
                if (this.setProperties.containsKey(new Integer(67))) break;
                this.setProperties.put(new Integer(67), new Double(1.0));
                break;
            }
            case 55: {
                if (this.setProperties.containsKey(new Integer(55))) break;
                Font rc = null;
                String defaultFontName = "Dialog";
                int defaultFontStyle = 0;
                int defaultFontSize = 11;
                String fontName = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"DialogFont.FontName.fnt", (String)defaultFontName);
                int fontStyle = defaultFontStyle;
                String style = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"DialogFont.FontName.fnt", (String)"plain");
                if (style.equalsIgnoreCase("bold")) {
                    fontStyle = 1;
                } else if (style.equalsIgnoreCase("italic")) {
                    fontStyle = 2;
                } else if (style.equalsIgnoreCase("bolditalic")) {
                    fontStyle = 3;
                }
                int fontSize = ResourceLoader.getResourceInteger((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"DialogFont.FontSize.fnt", (int)defaultFontSize);
                rc = FontManager.getFont((String)fontName, (int)fontStyle, (int)fontSize);
                this.setProperties.put(new Integer(55), rc);
                break;
            }
            case 56: {
                if (this.setProperties.containsKey(new Integer(56))) break;
                this.setProperties.put(new Integer(56), new Boolean(false));
                break;
            }
            case 57: {
                if (this.setProperties.containsKey(new Integer(57))) break;
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PageFormat pageFormat = printerJob.defaultPage();
                this.setProperties.put(new Integer(57), pageFormat);
                break;
            }
            case 72: {
                if (this.setProperties.containsKey(72)) break;
                this.setProperties.put(72, Boolean.FALSE);
                break;
            }
            case 73: {
                if (this.setProperties.containsKey(73)) break;
                this.setProperties.put(73, Boolean.TRUE);
                break;
            }
            case 74: {
                if (this.setProperties.containsKey(74)) break;
                this.setProperties.put(74, Boolean.TRUE);
            }
        }
        return this.setProperties.get(new Integer(id));
    }

    public boolean setPropertyValue(int id, Object value) {
        if (!this.isPropertySupported(id)) {
            return false;
        }
        if (id == 29) {
            this.pendingProperties.store(0, value);
        }
        return this.pendingProperties.store(id, value);
    }

    public int getNumberPendingProperties() {
        return this.pendingProperties.getNumberPending(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pendingProperties.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            boolean valid = false;
            switch (key) {
                case 0: 
                case 29: {
                    if (value instanceof String) {
                        value = new ColorScheme(value.toString());
                    }
                    if (value instanceof Style) {
                        value = new ColorScheme((Style)value);
                    }
                    if (key == 29 && value instanceof ColorScheme) {
                        value = ((ColorScheme)value).getStyle();
                    }
                    if (value instanceof ColorSchemeInterface || value instanceof Style) {
                        valid = true;
                    }
                    if (!valid) break;
                    StyleCollection sc = (StyleCollection)this.getPropertyValue(48);
                    if (value instanceof ColorScheme) {
                        sc.setCurrentStyle(((ColorScheme)value).getStyle());
                    } else {
                        sc.setCurrentStyle((Style)value);
                    }
                    if (!sc.getCurrentStyle().isFallbackEnabled()) {
                        sc.getCurrentStyle().setFallbackEnabled(true);
                    }
                    String[] colorMappers = ColorMapper.getDefinedColorMappers();
                    for (int j = 0; j < colorMappers.length; ++j) {
                        ColorMapper mapper = ColorMapper.getInstance(colorMappers[j]);
                        mapper.applyStyle(sc.getCurrentStyle(), mapper.getStyleReference());
                    }
                    break;
                }
                case 72: {
                    if (!(value instanceof Boolean)) break;
                    FilterFactory.setCroppedObservationsSelectable((boolean)((Boolean)value));
                    break;
                }
                default: {
                    if (!SILKGlobal.isDebug()) break;
                    System.out.println("Unrecognized property: " + key);
                }
            }
            if (!valid && SILKGlobal.isDebug()) {
                System.out.println("Invalid value for property(" + key + "): " + value);
                continue;
            }
            this.setProperties.put(new Integer(key), value);
            this.userSetProperties.set(key);
            this.charts.setPropertyValue(key, (Object)new PropertyEvent(key, (Object)this, value));
        }
        if (changes.size() > 0) {
            this.charts.applyPropertyChanges((Object)this);
        }
        this.pendingProperties.removeChangesBySource(source);
        this.fireChangeEvent();
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pendingProperties.removeChangesBySource(source);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pendingProperties.getPending(source);
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new EventListenerList();
        }
        this.changeListeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(ChangeListener.class, listener);
        }
    }

    private void fireChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        EventListener[] arr = this.changeListeners.getListeners(ChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            ((ChangeListener)arr[i]).stateChanged(this.changeEvent);
        }
    }

    public PropertyInterface[] getRegisteredPropertyListeners() {
        return this.charts.getPropertyInterfaces();
    }

    public static boolean isFlagSet(int flag) {
        return flags.get(flag);
    }

    public static void setFlag(int flag) {
        flags.set(flag);
    }

    public static void clearFlag(int flag) {
        flags.clear(flag);
    }

    public static void log(int type, Object message) {
        System.out.println(message);
    }

    public void takeDiagnostics(DiagnosticsInterface di) {
        if (di == null) {
            return;
        }
        if (this.diagnostics == null) {
            this.diagnostics = new DefaultDiagnostics();
        }
        di.addDiagnosticsListener(this.diagnostics);
    }

    public void stopDiagnostics(DiagnosticsInterface di) {
        if (di == null || this.diagnostics == null) {
            return;
        }
        di.removeDiagnosticsListener(this.diagnostics);
    }

    public GlobalDefaults getGlobalDefaults() {
        if (this.globalDefaults == null) {
            this.globalDefaults = new GlobalDefaults();
        }
        return this.globalDefaults;
    }

    public static PageFormat getSILKPageFormat() {
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    public static void showPageFormatDialog() {
        PageFormat pf = SILKGlobal.getSILKPageFormat();
        PrinterJob pj = PrinterJob.getPrinterJob();
        pf = pj.pageDialog(pf);
        SILKGlobal.instance.setProperties.put(new Integer(57), pf);
    }

    static {
        String val;
        instance = null;
        debug = false;
        testMode = false;
        flags = new BitSet();
        supportedProperties = new int[]{0, 29, 47, 48, 50, 52, 54, 67, 55, 56, 57, 58, 72, 73, 74};
        silkStyles = new String[]{"Analysis", "Default", "Journal", "Listing", "Statistical", "SILKDefault"};
        Properties p = ResourceLoader.loadProperties((String)"debug.config");
        if (p != null && p.containsKey("debug") && (val = p.getProperty("debug")) != null && val.equalsIgnoreCase("true")) {
            debug = true;
        }
        if ((p = ResourceLoader.loadProperties((String)"SILK.config")) != null && p.containsKey("Global.TestMode") && (val = p.getProperty("Global.TestMode")) != null && val.equalsIgnoreCase("true")) {
            testMode = true;
        }
        SILKGlobal.loadSILKParsers();
        try {
            String s = System.getProperty("SILK.debug");
            if (s != null && s.length() > 0) {
                debug = ParserUtils.getBooleanValue((String)s);
            }
            if ((s = System.getProperty("SILK.testMode")) != null && s.length() > 0) {
                testMode = ParserUtils.getBooleanValue((String)s);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        silkParsersAreLoaded = false;
    }

    private class DefaultDiagnostics
    implements DiagnosticsListener {
        private DefaultDiagnostics() {
        }

        @Override
        public void diagnosticsEvent(DiagnosticsEvent de) {
            switch (de.getType()) {
                case 0: {
                    System.out.print("BUILD TIME: (");
                    break;
                }
                case 1: {
                    System.out.print("DRAW TIME: (");
                    break;
                }
                case 2: {
                    System.out.print("SELECTION DRAW: (");
                    break;
                }
                case 3: {
                    System.out.print("DEBUG: (");
                }
            }
            if (de.getSource() instanceof ComponentInterface) {
                System.out.println(((ComponentInterface)de.getSource()).getId() + ")");
            } else {
                System.out.println(de.getSource() + ")");
            }
            Enumeration e = de.getTable().keys();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                System.out.println("\t" + obj + ":\t" + de.getTable().get(obj));
            }
        }
    }
}

