/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.Style;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SILKAnnotate
implements Annotatable,
MouseListener,
AnnotateInterface {
    protected Annotate annotate;
    protected JComponent component;
    protected Style style;
    protected boolean annoEnabled = false;
    protected Object mouseListeners;
    protected Object mouseMotionListeners;
    protected String currentGraphID;
    protected int actionMode = 0;
    protected Hashtable transforms;
    protected Hashtable dataBounds;
    protected static JToolBar annotationToolBar;
    protected Document document = null;

    public SILKAnnotate() {
        this.transforms = new Hashtable();
        this.dataBounds = new Hashtable();
        this.style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
    }

    public SILKAnnotate(JComponent c) {
        this.setComponent(c);
    }

    @Override
    public void setComponent(JComponent c) {
        this.component = c;
        if (this.annotate == null) {
            this.initAnnotate();
        }
    }

    private void initAnnotate() {
        if (this.document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = factory.newDocumentBuilder();
                this.document = db.newDocument();
                Element e = this.document.createElement("Annotation");
                this.document.appendChild(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.annotate = new Annotate((BaseAnnotatable)this);
        this.annotate.setContainer(this.component == null ? new JPanel() : this.component);
        this.annotate.setInsertPopupEnabled(false);
        Annotate.addAnnotateToToolBar((JToolBar)this.getAnnotationToolBar(), (Annotate)this.annotate);
    }

    @Override
    public void dispose() {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseListener((MouseListener)this.annotate);
            this.component.removeMouseMotionListener((MouseMotionListener)this.annotate);
        }
        Annotate.removeAnnotateFromToolBar((JToolBar)this.getAnnotationToolBar(), (Annotate)this.annotate);
        this.component = null;
        this.annotate = null;
        this.transforms = null;
        this.dataBounds = null;
        this.mouseMotionListeners = null;
        this.mouseListeners = null;
        this.style = null;
    }

    @Override
    public void setStyle(Style style) {
        if (style == null) {
            return;
        }
        this.style = style;
        this.annotate.resetStyle(style);
    }

    @Override
    public TransformInterface getTransform(String graphID) {
        return (TransformInterface)this.transforms.get(graphID);
    }

    @Override
    public void setTransform(TransformInterface transform, String graphID) {
        if (graphID == null) {
            return;
        }
        if (transform == null) {
            this.transforms.remove(graphID);
        } else {
            this.transforms.put(graphID, transform);
        }
        this.annotate.setDirty();
    }

    @Override
    public void setDataBoundingBox(Rectangle r, String graphID) {
        if (graphID == null) {
            return;
        }
        if (r == null) {
            this.dataBounds.remove(graphID);
        } else {
            this.dataBounds.put(graphID, r);
        }
        this.annotate.setDirty();
    }

    public Annotate getAnnotate() {
        return this.annotate;
    }

    @Override
    public void setActionMode(int mode) {
        if (mode == 13) {
            this.setAnnotationEnabled(true);
        } else {
            this.setAnnotationEnabled(false);
        }
        this.actionMode = mode;
    }

    @Override
    public int getActionMode() {
        return this.actionMode;
    }

    @Override
    public void setAnnotationEnabled(boolean enable) {
        if (enable == this.annoEnabled) {
            return;
        }
        this.annoEnabled = enable;
        if (enable) {
            this.mouseListeners = this.component.getMouseListeners();
            Enumeration e = Extract.elements((Object)this.mouseListeners);
            while (e.hasMoreElements()) {
                this.component.removeMouseListener((MouseListener)e.nextElement());
            }
            this.mouseMotionListeners = this.component.getMouseMotionListeners();
            e = Extract.elements((Object)this.mouseMotionListeners);
            while (e.hasMoreElements()) {
                this.component.removeMouseMotionListener((MouseMotionListener)e.nextElement());
            }
            this.component.addMouseListener(this);
            this.component.addMouseListener((MouseListener)this.annotate);
            this.component.addMouseMotionListener((MouseMotionListener)this.annotate);
        } else {
            Enumeration e;
            this.component.removeMouseListener(this);
            this.component.removeMouseListener((MouseListener)this.annotate);
            this.component.removeMouseMotionListener((MouseMotionListener)this.annotate);
            if (this.mouseListeners != null) {
                e = Extract.elements((Object)this.mouseListeners);
                while (e.hasMoreElements()) {
                    this.component.addMouseListener((MouseListener)e.nextElement());
                }
                this.mouseListeners = null;
            }
            if (this.mouseMotionListeners != null) {
                e = Extract.elements((Object)this.mouseMotionListeners);
                while (e.hasMoreElements()) {
                    this.component.addMouseMotionListener((MouseMotionListener)e.nextElement());
                }
                this.mouseMotionListeners = null;
            }
        }
    }

    @Override
    public void setCurrentGraphID(String id) {
        this.currentGraphID = id;
    }

    @Override
    public String getCurrentGraphID() {
        return this.currentGraphID;
    }

    @Override
    public void draw(Graphics2D g) {
        this.annotate.paint(g);
    }

    @Override
    public JToolBar getAnnotationToolBar() {
        if (annotationToolBar == null) {
            annotationToolBar = new JToolBar();
            Annotate.addAnnotateMenuToToolbar((JToolBar)annotationToolBar, null);
        }
        return annotationToolBar;
    }

    @Override
    public Element getAnnotationElement() {
        return this.document.getDocumentElement();
    }

    @Override
    public void readFromXML(Element e) {
        Element current = this.getAnnotationElement();
        NodeList children = e.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Node e2 = this.document.importNode(child, true);
            current.appendChild(e2);
        }
        Annotate.removeAnnotateFromToolBar((JToolBar)this.getAnnotationToolBar(), (Annotate)this.annotate);
        this.initAnnotate();
    }

    public Point2D convertDataToScreen(String overlayID, Object[] data) {
        if (overlayID == null) {
            return null;
        }
        TransformInterface transform = (TransformInterface)this.transforms.get(overlayID);
        if (transform == null || data == null || data.length != 2) {
            return null;
        }
        if (data[0] == null || !(data[0] instanceof Double)) {
            return null;
        }
        double dataX = (Double)data[0];
        if (data[1] == null || !(data[1] instanceof Double)) {
            return null;
        }
        double dataY = (Double)data[1];
        double[] screenPt = transform.project(dataX, dataY, 0.0, null);
        if (screenPt == null) {
            return null;
        }
        Point2D.Double rv = new Point2D.Double(screenPt[0], screenPt[1]);
        return rv;
    }

    public Object[] convertScreenToData(String overlayID, Point2D p, Object[] data) {
        if (overlayID == null) {
            return null;
        }
        TransformInterface transform = (TransformInterface)this.transforms.get(overlayID);
        if (transform == null || p == null) {
            return null;
        }
        double[] dataPt = transform.unProject(p.getX(), p.getY(), 0.0, null);
        if (data == null || data.length != 2) {
            data = new Object[]{new Double(dataPt[0]), new Double(dataPt[1])};
        }
        return data;
    }

    public String getGraphIDAt(int x, int y) {
        Rectangle bounds;
        if (this.currentGraphID != null && (bounds = (Rectangle)this.dataBounds.get(this.currentGraphID)).contains(x, y)) {
            return this.currentGraphID;
        }
        Enumeration keys = this.dataBounds.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Rectangle bounds2 = (Rectangle)this.dataBounds.get(key);
            if (bounds2 == null || !bounds2.contains(x, y)) continue;
            return key.toString();
        }
        return null;
    }

    public Rectangle getDataBoundingBox(String id) {
        Rectangle bounds = (Rectangle)this.dataBounds.get(id);
        if (bounds != null) {
            return bounds;
        }
        return this.component.getBounds();
    }

    public Style getStyle() {
        return this.style;
    }

    public int getDPI() {
        return 0;
    }

    public double getDPIScaleFactor() {
        return 0.0;
    }

    public Dimension getAnnotationSize() {
        return this.component.getSize();
    }

    public void annotateRepaint() {
        this.component.repaint();
    }

    public Document getDocument() {
        return this.document;
    }

    public FontRenderContext getFontRenderContext() {
        Graphics g = this.component.getGraphics();
        if (g instanceof Graphics2D) {
            return ((Graphics2D)g).getFontRenderContext();
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        JPopupMenu menu = null;
        if (this.component instanceof ComponentInterface) {
            menu = ((ComponentInterface)((Object)this.component)).getPopupMenu();
        }
        int flags = me.getModifiers();
        if (menu != null && (flags & 4) != 0) {
            int x = me.getX();
            int y = me.getY();
            menu.show(this.component, x, y);
            me.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

