/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Rubberband {
    private boolean firstStretch;
    protected Point anchor;
    protected Point stretched;
    protected Point last;
    protected Point end;
    private Component component;
    private boolean drawRect = true;

    public abstract void drawLast(Graphics var1);

    public abstract void drawNext(Graphics var1);

    public abstract boolean contains(Point var1);

    public abstract boolean contains(int var1, int var2);

    public abstract boolean contains(Rectangle var1);

    public Rubberband(Component c) {
        this.component = c;
        if (this.component == null) {
            this.drawRect = false;
        }
        this.firstStretch = true;
        this.anchor = new Point(0, 0);
        this.stretched = new Point(0, 0);
        this.last = new Point(0, 0);
        this.end = new Point(0, 0);
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public Point getStretched() {
        return this.stretched;
    }

    public Point getLast() {
        return this.last;
    }

    public Point getEnd() {
        return this.end;
    }

    public void anchor(Point p) {
        this.firstStretch = true;
        this.anchor.x = p.x;
        this.anchor.y = p.y;
        this.stretched.x = this.last.x = this.anchor.x;
        this.stretched.y = this.last.y = this.anchor.y;
    }

    public void stretch(Point p) {
        this.last.x = this.stretched.x;
        this.last.y = this.stretched.y;
        this.stretched.x = p.x;
        this.stretched.y = p.y;
        if (!this.drawRect) {
            return;
        }
        Graphics g = this.component.getGraphics();
        if (g != null) {
            g.setXORMode(this.component.getBackground());
            if (this.firstStretch) {
                this.firstStretch = false;
            } else {
                this.drawLast(g);
            }
            this.drawNext(g);
            g.dispose();
        }
    }

    public void end(Point p) {
        this.last.x = this.end.x = p.x;
        this.last.y = this.end.y = p.y;
        if (!this.drawRect) {
            return;
        }
        Graphics g = this.component.getGraphics();
        if (g != null) {
            g.setXORMode(this.component.getBackground());
            this.drawLast(g);
            g.dispose();
        }
    }

    public Rectangle bounds() {
        return new Rectangle(this.stretched.x < this.anchor.x ? this.stretched.x : this.anchor.x, this.stretched.y < this.anchor.y ? this.stretched.y : this.anchor.y, Math.abs(this.stretched.x - this.anchor.x), Math.abs(this.stretched.y - this.anchor.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.last.x < this.anchor.x ? this.last.x : this.anchor.x, this.last.y < this.anchor.y ? this.last.y : this.anchor.y, Math.abs(this.last.x - this.anchor.x), Math.abs(this.last.y - this.anchor.y));
    }

    public int topLeftX() {
        int ix = this.end.x < this.anchor.x ? this.end.x : this.anchor.x;
        return ix;
    }

    public int topLeftY() {
        int iy = this.end.y < this.anchor.y ? this.end.y : this.anchor.y;
        return iy;
    }

    public int bottomRightX() {
        int ix = this.anchor.x < this.end.x ? this.end.x : this.anchor.x;
        return ix;
    }

    public int bottomRightY() {
        int iy = this.anchor.y < this.end.y ? this.end.y : this.anchor.y;
        return iy;
    }

    public boolean isDrawRect() {
        return this.drawRect;
    }

    public void setDrawRect(boolean drawRect) {
        this.drawRect = drawRect;
    }
}

