/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.RoleEntry;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.StringCompare;
import java.util.Hashtable;
import java.util.Vector;

public class RoleManager
implements RoleInterface {
    public static final String DEFAULT_DATASET = "DEFAULT";
    public static final int ROLE_TYPE_ANY = 0;
    public static final int ROLE_TYPE_CONTINUOUS = 1;
    Vector roleAssignments = null;
    Vector roleListeners = null;
    RoleEvent roleEvent = new RoleEvent();
    Hashtable datasets = new Hashtable();
    Object[][] supportedSortRoles = null;
    static boolean inRoleEvent = false;

    public RoleManager() {
        this.roleAssignments = new Vector();
        this.roleListeners = new Vector();
    }

    public void setDataset(Object name, Object data) {
        if (data == null) {
            return;
        }
        if (name != null) {
            this.datasets.put(name, data);
        } else {
            this.datasets.put(DEFAULT_DATASET, data);
        }
    }

    public boolean newRole(Object role, int numAssignmentsAllowed) {
        return this.newRole(role, null, numAssignmentsAllowed, null);
    }

    public boolean newRole(Object role, Object englishName, int numAssignmentsAllowed) {
        return this.newRole(role, englishName, numAssignmentsAllowed, null);
    }

    public boolean newRole(Object role, Object englishName, int numAssignmentsAllowed, Object dataID) {
        return this.newRole(role, englishName, numAssignmentsAllowed, dataID, -1);
    }

    public boolean newRole(Object role, Object englishName, int numAssignmentsAllowed, Object dataID, int limit) {
        if (role == null || numAssignmentsAllowed < 1) {
            return false;
        }
        RoleEntry re = this.getRoleEntryForName(role);
        if (re != null) {
            return false;
        }
        RoleEntry entry = new RoleEntry(role, englishName, numAssignmentsAllowed > 1, numAssignmentsAllowed, dataID);
        entry.setLimit(limit);
        this.roleAssignments.addElement(entry);
        return true;
    }

    public boolean deleteRole(Object role) {
        RoleEntry re = this.getRoleEntryForName(role);
        if (re == null) {
            return false;
        }
        return this.roleAssignments.removeElement(re);
    }

    public boolean setRoleType(Object roleName, int type) {
        if (roleName == null) {
            return false;
        }
        if (type != 0 && type != 1) {
            return false;
        }
        RoleEntry r = this.getRoleEntryForName(roleName);
        if (r == null) {
            return false;
        }
        r.typeAllowed = type;
        return true;
    }

    public boolean setSortsSupported(Object roleName, int[] supported) {
        if (roleName == null) {
            return false;
        }
        RoleEntry r = this.getRoleEntryForName(roleName);
        if (r == null) {
            return false;
        }
        r.supportedSorts = supported;
        return true;
    }

    public Object getDataID(Object role) {
        RoleEntry r = this.getRoleEntryForName(role);
        if (r == null) {
            return null;
        }
        return r.dataID;
    }

    private RoleEntry getRoleEntryForName(Object name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.roleAssignments.size(); ++i) {
            RoleEntry entry = (RoleEntry)this.roleAssignments.elementAt(i);
            if (entry.roleName.equals(name)) {
                return entry;
            }
            if (entry.englishRoleName == null || !StringCompare.equals((String)entry.englishRoleName.toString(), (String)name.toString())) continue;
            return entry;
        }
        return null;
    }

    private RoleEntry[] getRoleEntrysForVar(Object var) {
        String dataset = null;
        if (var instanceof String && ((String)var).indexOf(".") != -1) {
            dataset = ((String)var).substring(0, ((String)var).indexOf("."));
            var = ((String)var).substring(((String)var).indexOf(".") + 1);
        }
        Vector<RoleEntry> vector = new Vector<RoleEntry>();
        for (int i = 0; i < this.roleAssignments.size(); ++i) {
            RoleEntry entry = (RoleEntry)this.roleAssignments.elementAt(i);
            String s = (String)entry.dataID;
            if (!entry.hasVariableAssigned(var) || dataset != null && (s == null || !s.equalsIgnoreCase(dataset))) continue;
            vector.addElement(entry);
        }
        if (vector.isEmpty()) {
            return null;
        }
        RoleEntry[] rc = new RoleEntry[vector.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (RoleEntry)vector.elementAt(i);
        }
        return rc;
    }

    public void setSupportedSortRoles(Object[][] roles) {
        this.supportedSortRoles = roles;
    }

    public boolean setVariableOrder(Object role, Object variables) {
        if (variables == null) {
            return false;
        }
        int type = Extract.getSourceType((Object)variables);
        int num = Extract.getNumberItems((Object)variables, (int)type);
        if (num < 1) {
            return false;
        }
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || entry.variables.isEmpty()) {
            return false;
        }
        entry.removeAllVariables();
        for (int i = 0; i < num; ++i) {
            entry.addVariable(Extract.getObject((Object)variables, (int)i, (int)type));
        }
        return true;
    }

    @Override
    public Object getVariable(Object role) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || entry.variables.isEmpty()) {
            return null;
        }
        Object[] rc = new Object[entry.variables.size()];
        entry.variables.copyInto(rc);
        return rc;
    }

    public Object getVariable(Object role, int which) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || entry.variables.size() <= which) {
            return null;
        }
        return entry.variables.elementAt(which);
    }

    public int getNumVariablesAssigned(Object role) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return 0;
        }
        return entry.variables.size();
    }

    @Override
    public Object getRole(Object variableId) {
        RoleEntry[] entry = this.getRoleEntrysForVar(variableId);
        if (entry == null) {
            return null;
        }
        Object[] rc = new Object[entry.length];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = entry[i].roleName;
        }
        return rc;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        Object var;
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || variableId == null) {
            return false;
        }
        Object id = null;
        if (entry.dataID != null) {
            id = this.datasets.get(entry.dataID);
        } else if (this.datasets.get(DEFAULT_DATASET) != null) {
            id = this.datasets.get(DEFAULT_DATASET);
        }
        if (id != null) {
            if (!(id instanceof DataFilterReadInterface)) {
                return false;
            }
            var = RoleManager.getVariableIdFromTwoLevelName(variableId.toString());
            if (!entry.isNonVariableRole() && !((DataFilterReadInterface)id).verifyVariable(var)) {
                return false;
            }
            if (entry.typeAllowed == 1 && !((DataFilterReadInterface)id).isNumericVariable(var)) {
                return false;
            }
        }
        if (!this.verifyRole(variableId, role)) {
            return false;
        }
        entry.variables.removeAllElements();
        var = null;
        var = variableId instanceof SILKNumber ? variableId : RoleManager.getVariableIdFromTwoLevelName(variableId.toString());
        boolean rc = entry.addVariable(var);
        this.fireRoleChangeEvent(false, false, 1, entry.getRoleEnum(), this, null, null, null, variableId);
        return rc;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        String var;
        Object id;
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || variableId == null) {
            return false;
        }
        if (entry.dataID != null) {
            id = this.datasets.get(entry.dataID);
            if (!(id instanceof DataFilterReadInterface)) {
                return false;
            }
            var = RoleManager.getVariableIdFromTwoLevelName(variableId.toString());
            if (!entry.isNonVariableRole() && !((DataFilterReadInterface)id).verifyVariable((Object)var)) {
                return false;
            }
            if (entry.typeAllowed == 1 && !((DataFilterReadInterface)id).isNumericVariable((Object)var)) {
                return false;
            }
        } else if (this.datasets.get(DEFAULT_DATASET) != null) {
            id = this.datasets.get(DEFAULT_DATASET);
            if (!(id instanceof DataFilterReadInterface)) {
                return false;
            }
            var = RoleManager.getVariableIdFromTwoLevelName(variableId.toString());
            if (!entry.isNonVariableRole() && !((DataFilterReadInterface)id).verifyVariable((Object)var)) {
                return false;
            }
            if (entry.typeAllowed == 1 && !((DataFilterReadInterface)id).isNumericVariable((Object)var)) {
                return false;
            }
        }
        if (!this.verifyRole(variableId, role)) {
            return false;
        }
        Object var2 = null;
        var2 = variableId instanceof SILKNumber ? variableId : RoleManager.getVariableIdFromTwoLevelName(variableId.toString());
        boolean rc = entry.addVariable(var2);
        this.fireRoleChangeEvent(false, false, 2, entry.getRoleEnum(), this, null, null, null, variableId);
        return rc;
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || variableId == null) {
            return false;
        }
        variableId = RoleManager.getVariableIdFromTwoLevelName(variableId.toString());
        boolean rc = entry.removeVariable(variableId);
        this.fireRoleChangeEvent(false, false, 3, entry.getRoleEnum(), this, null, null, variableId, null);
        return rc;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null || entry.variables.size() - 1 < which) {
            return null;
        }
        return entry.variables.elementAt(which);
    }

    @Override
    public int getMaxAllowed(Object role) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return 0;
        }
        return entry.maxAllowed;
    }

    public boolean setMaxAllowed(Object role, int maxAllowed) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return false;
        }
        if (maxAllowed <= 0) {
            return false;
        }
        entry.maxAllowed = maxAllowed;
        entry.multipleAssigmentsSupported = entry.maxAllowed >= 2;
        return true;
    }

    public void setNonVariableRole(Object role, boolean isNonVariable) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return;
        }
        entry.setNonVariableRole(isNonVariable);
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        if (role != null) {
            RoleEntry entry = this.getRoleEntryForName(role);
            if (entry == null) {
                return false;
            }
            return entry.multipleAssigmentsSupported;
        }
        for (int i = 0; i < this.roleAssignments.size(); ++i) {
            if (!((RoleEntry)this.roleAssignments.elementAt((int)i)).multipleAssigmentsSupported) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getSortOrder(Object role) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return null;
        }
        return entry.sortOrder;
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return false;
        }
        Object oldValue = entry.sortOrder;
        entry.sortOrder = order;
        this.fireRoleChangeEvent(false, false, 5, entry.getRoleEnum(), this, null, null, oldValue, order);
        return true;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        int[] rc = null;
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry != null) {
            return entry.supportedSorts;
        }
        return rc;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        return this.supportedSortRoles;
    }

    @Override
    public boolean isDiscrete(Object role) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return false;
        }
        return entry.discrete;
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return false;
        }
        if (!entry.supportsDiscrete) {
            return false;
        }
        Boolean oldValue = new Boolean(entry.discrete);
        entry.discrete = discrete;
        this.fireRoleChangeEvent(false, false, 4, entry.getRoleEnum(), this, null, null, oldValue, new Boolean(discrete));
        return true;
    }

    @Override
    public void addRoleListener(RoleListenerInterface rli) {
        if (rli != null) {
            this.roleListeners.addElement(rli);
        }
    }

    @Override
    public void removeRoleListener(RoleListenerInterface rli) {
        if (rli != null && this.roleListeners.contains(rli)) {
            this.roleListeners.removeElement(rli);
        }
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Vector<Object> supportedRoles = new Vector<Object>();
        for (int i = 0; i < this.roleAssignments.size(); ++i) {
            RoleEntry re = (RoleEntry)this.roleAssignments.elementAt(i);
            if (id != null && id != re.dataID) continue;
            if (!discrete) {
                if (re.typeAllowed != 1) continue;
                supportedRoles.add(re.roleName);
                continue;
            }
            supportedRoles.add(re.roleName);
        }
        return supportedRoles.toArray();
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (role != null && value instanceof Number) {
            RoleEntry entry = this.getRoleEntryForName(role);
            entry.setLimit(((Number)value).intValue());
            return true;
        }
        return false;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return null;
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public boolean setDataSource(Object source, Object id) {
        return false;
    }

    public boolean setDataSource(Object source) {
        return false;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void fireRoleChangeEvent(boolean isAdjusting, boolean rangeChange, int type, int role, Object source, Object dataSource, Object target, Object oldValue, Object newValue) {
        RoleEvent re = null;
        re = new RoleEvent();
        re.isAdjusting = isAdjusting;
        re.rangeChangeEvent = rangeChange;
        re.type = type;
        re.role = role;
        re.source = source;
        re.dataSource = dataSource;
        re.target = target;
        re.oldValue = oldValue;
        re.newValue = newValue;
        for (int i = 0; i < this.roleListeners.size(); ++i) {
            ((RoleListenerInterface)this.roleListeners.elementAt(i)).roleChanged(re);
        }
    }

    public static boolean isTwoLevelName(String varname) {
        return varname.indexOf(46) > 0;
    }

    public static String getDataIdFromTwoLevelName(String twoLevelName) {
        if (!RoleManager.isTwoLevelName(twoLevelName)) {
            return twoLevelName;
        }
        return twoLevelName.substring(0, twoLevelName.indexOf(46));
    }

    public static String getVariableIdFromTwoLevelName(String twoLevelName) {
        if (!RoleManager.isTwoLevelName(twoLevelName)) {
            return twoLevelName;
        }
        return twoLevelName.substring(twoLevelName.indexOf(46) + 1, twoLevelName.length());
    }

    public void checkRoles() {
        if (this.roleAssignments == null || this.roleAssignments.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.roleAssignments.size(); ++i) {
            RoleEntry entry = (RoleEntry)this.roleAssignments.elementAt(i);
            Object var = null;
            if (entry != null && entry.variables.size() > 0) {
                var = entry.variables.elementAt(0);
            }
            if (this.verifyRole(var, entry.roleName)) continue;
            this.removeRole(var, entry.roleName);
        }
    }

    public boolean verifyRole(Object variableId, Object role) {
        DataFilterInfoInterface info;
        Object[] uniqueValues;
        if (variableId == null || role == null) {
            return false;
        }
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return false;
        }
        Object id = null;
        if (entry.dataID != null) {
            id = this.datasets.get(entry.dataID);
        } else if (this.datasets.get(DEFAULT_DATASET) != null) {
            id = this.datasets.get(DEFAULT_DATASET);
        }
        return entry.getLimit() < 0 || !(id instanceof DataFilterInfoInterface) || (uniqueValues = (info = (DataFilterInfoInterface)id).getUniqueValues(variableId, true)) == null || uniqueValues.length <= entry.getLimit();
    }

    public int getRoleInt(Object role) {
        RoleEntry re;
        if (role instanceof Number) {
            return ((Number)role).intValue();
        }
        if (role instanceof String && (re = this.getRoleEntryForName(role)) != null) {
            return re.getRoleEnum();
        }
        return -1;
    }

    public void setSupportsDiscrete(Object role, boolean supportDiscrete) {
        RoleEntry entry = this.getRoleEntryForName(role);
        if (entry == null) {
            return;
        }
        entry.setSupportsDiscrete(supportDiscrete);
    }
}

