/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.StringCompare;
import java.util.Vector;

public class RoleEntry {
    Vector variables = new Vector();
    Object roleName;
    Object englishRoleName;
    Object dataID;
    int maxAllowed;
    int limit = -1;
    boolean multipleAssigmentsSupported;
    boolean supportsDiscrete;
    Object sortOrder;
    int[] supportedSorts = null;
    boolean discrete = false;
    int typeAllowed = 0;
    boolean nonVariableRole = false;

    public RoleEntry(Object name, Object englishName, boolean multiple, int maxAllowed) {
        this(name, englishName, multiple, maxAllowed, null);
    }

    public RoleEntry(Object name, Object englishName, boolean multiple, int maxAllowed, Object data) {
        this.roleName = name;
        this.englishRoleName = englishName;
        this.maxAllowed = maxAllowed;
        this.multipleAssigmentsSupported = multiple;
        this.supportsDiscrete = true;
        this.dataID = data;
        this.sortOrder = null;
    }

    public boolean hasVariableAssigned(Object variable) {
        if (this.variables != null) {
            for (int i = 0; i < this.variables.size(); ++i) {
                Object obj = this.variables.elementAt(i);
                if (obj instanceof SILKNumber) {
                    return obj.equals(variable);
                }
                if (!(obj instanceof String) || !(variable instanceof String) || !StringCompare.equals((String)((String)obj), (String)((String)variable))) continue;
                return true;
            }
        }
        return false;
    }

    private int getIndexOf(Object variable) {
        if (this.variables != null) {
            for (int i = 0; i < this.variables.size(); ++i) {
                Object obj = this.variables.elementAt(i);
                if (!(obj instanceof String) || !(variable instanceof String) || !StringCompare.equals((String)((String)obj), (String)((String)variable))) continue;
                return i;
            }
        }
        return -1;
    }

    public int getRoleEnum() {
        if (this.roleName instanceof Number) {
            return ((Number)this.roleName).intValue();
        }
        SILKNumber rc = Roles.getInstance(null).getRoleObject(this.roleName.toString());
        if (rc == null) {
            return -1;
        }
        return rc.intValue();
    }

    public boolean addVariable(Object variable) {
        if (variable == null) {
            return false;
        }
        if (!this.multipleAssigmentsSupported) {
            this.variables.removeAllElements();
        }
        if (!this.hasVariableAssigned(variable)) {
            this.variables.addElement(variable);
        }
        return true;
    }

    public boolean removeVariable(Object variable) {
        if (variable == null) {
            return false;
        }
        if (!this.hasVariableAssigned(variable)) {
            return false;
        }
        return this.variables.remove(this.getIndexOf(variable)) != null;
    }

    public void removeAllVariables() {
        if (this.variables != null) {
            this.variables.removeAllElements();
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean supportsDiscrete() {
        return this.supportsDiscrete;
    }

    public void setSupportsDiscrete(boolean supportsDiscrete) {
        this.supportsDiscrete = supportsDiscrete;
    }

    public boolean isNonVariableRole() {
        return this.nonVariableRole;
    }

    public void setNonVariableRole(boolean nonVariableRole) {
        this.nonVariableRole = nonVariableRole;
    }
}

