/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.ReferenceRangeInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.styles.Style;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

public class ReferenceRange
implements ReferenceRangeInterface,
RenderInterface {
    protected Object lowValue;
    protected Object highValue;
    protected boolean lowInclusive;
    protected boolean highInclusive;
    protected SASFormat bestFmt;
    protected TextAttrib label;
    protected LineAttrib lowLine;
    protected LineAttrib highLine;
    protected Line2D line2D;
    private PropertyChangeSupport _changes = new PropertyChangeSupport(this);

    public ReferenceRange(Object lowValue, boolean lowInclusive, Object highValue, boolean highInclusive) {
        this.lowValue = lowValue;
        this.highValue = highValue;
        this.lowInclusive = lowInclusive;
        this.highInclusive = highInclusive;
        this.label = new TextAttrib();
        this.lowLine = new LineAttrib();
        this.highLine = new LineAttrib();
        this.lowInclusive = lowInclusive;
        this.highInclusive = highInclusive;
        this.bestFmt = SASFormat.getInstance((String)"BEST");
    }

    public ReferenceRange() {
        this(new Double(0.0), true, new Double(0.0), true);
    }

    @Override
    public boolean setValueRange(Object lowValue, boolean lowInclusive, Object highValue, boolean highInclusive) {
        if (lowValue == null || highValue == null) {
            return false;
        }
        Object oldLow = this.lowValue;
        Object oldHigh = this.highValue;
        boolean oldLowIncl = this.lowInclusive;
        boolean oldHighIncl = this.highInclusive;
        this.lowValue = lowValue;
        this.highValue = highValue;
        this.lowInclusive = lowInclusive;
        this.highInclusive = highInclusive;
        int lowBit = 1;
        int highBit = 2;
        int lowInclBit = 4;
        int highInclBit = 8;
        int changes = 0;
        changes |= oldLow.equals(lowValue) ? 0 : lowBit;
        changes |= oldHigh.equals(highValue) ? 0 : highBit;
        changes |= oldLowIncl == lowInclusive ? 0 : lowInclBit;
        if ((changes |= oldHighIncl == highInclusive ? 0 : highInclBit) > 0) {
            ArrayList<Object> oldVal = new ArrayList<Object>(5);
            ArrayList<Object> newVal = new ArrayList<Object>(5);
            String propName = null;
            oldVal.add(this);
            newVal.add(this);
            if ((changes & lowBit) > 0) {
                oldVal.add(oldLow);
                newVal.add(lowValue);
                propName = "lowValue";
            }
            if ((changes & highBit) > 0) {
                oldVal.add(oldHigh);
                newVal.add(highValue);
                String string = propName = propName == null ? "highValue" : "multipleValues";
            }
            if ((changes & lowInclBit) > 0) {
                oldVal.add(new Boolean(oldLowIncl));
                newVal.add(new Boolean(lowInclusive));
                String string = propName = propName == null ? "lowInclusive" : "multipleValues";
            }
            if ((changes & highInclBit) > 0) {
                oldVal.add(new Boolean(oldHighIncl));
                newVal.add(new Boolean(highInclusive));
                propName = propName == null ? "highInclusive" : "multipleValues";
            }
            this._changes.firePropertyChange(propName, oldVal.toArray(), newVal.toArray());
        }
        return true;
    }

    @Override
    public Object getValueRange() {
        Double[] db = new Double[]{this.lowValue, this.highValue};
        return db;
    }

    @Override
    public boolean setLowValue(Object value) {
        if (value == null || !(value instanceof Number)) {
            return false;
        }
        Object[] oldObject = new Object[]{this, this.lowValue};
        Object[] newObject = new Object[]{this, value};
        this.lowValue = value;
        this._changes.firePropertyChange("lowValue", oldObject, newObject);
        return true;
    }

    @Override
    public Object getLowValue() {
        return this.lowValue;
    }

    @Override
    public boolean setHighValue(Object value) {
        if (value == null || !(value instanceof Number)) {
            return false;
        }
        Object[] oldObject = new Object[]{this, this.highValue};
        Object[] newObject = new Object[]{this, value};
        this.highValue = value;
        this._changes.firePropertyChange("highValue", oldObject, newObject);
        return true;
    }

    @Override
    public Object getHighValue() {
        return this.highValue;
    }

    @Override
    public boolean setLowLine(Object line) {
        if (this.lowLine == null || line == null) {
            return false;
        }
        if (line instanceof Boolean) {
            this.lowLine.setVisible((Boolean)line);
        } else if (line instanceof Color) {
            this.lowLine.setColor(line);
        } else if (line instanceof Number) {
            this.lowLine.setWidth(((Number)line).intValue());
        } else if (line instanceof LineStyleInterface) {
            this.lowLine = new LineAttrib((LineStyleInterface)line);
        }
        return true;
    }

    @Override
    public LineStyleInterface getLowLine() {
        return this.lowLine;
    }

    @Override
    public boolean setHighLine(Object line) {
        if (this.highLine == null || line == null) {
            return false;
        }
        if (line instanceof Boolean) {
            this.highLine.setVisible((Boolean)line);
        } else if (line instanceof Color) {
            this.highLine.setColor(line);
        } else if (line instanceof Number) {
            this.highLine.setWidth(((Number)line).intValue());
        } else if (line instanceof LineStyleInterface) {
            this.highLine = new LineAttrib((LineStyleInterface)line);
        }
        return true;
    }

    @Override
    public LineStyleInterface getHighLine() {
        return this.highLine;
    }

    @Override
    public boolean getLowInclusive() {
        return this.lowInclusive;
    }

    @Override
    public void setLowInclusive(boolean inclusive) {
        Object[] oldObject = new Object[]{this, new Boolean(this.lowInclusive)};
        Object[] newObject = new Object[]{this, new Boolean(inclusive)};
        this.lowInclusive = inclusive;
        this._changes.firePropertyChange("lowInclusive", oldObject, newObject);
    }

    @Override
    public boolean getHighInclusive() {
        return this.highInclusive;
    }

    @Override
    public void setHighInclusive(boolean inclusive) {
        Object[] oldObject = new Object[]{this, new Boolean(this.highInclusive)};
        Object[] newObject = new Object[]{this, new Boolean(inclusive)};
        this.highInclusive = inclusive;
        this._changes.firePropertyChange("highInclusive", oldObject, newObject);
    }

    @Override
    public void setFillColor(Color color) {
    }

    @Override
    public Color getFillColor() {
        Style style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        Color c = style.getFillStyleElement("RangeFill").getFillColor();
        double d = style.getFillStyleElement("RangeFill").getDoubleAttribute("transparency", 0.5);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * d));
    }

    @Override
    public boolean setLabel(Object labelIn) {
        if (this.label == null) {
            return false;
        }
        if (labelIn == null || labelIn instanceof String) {
            this.label.setText(labelIn);
        } else if (labelIn instanceof Boolean) {
            this.label.setVisible((Boolean)labelIn);
        } else if (labelIn instanceof Color) {
            this.label.setColor(labelIn);
        } else if (labelIn instanceof Font) {
            this.label.setFont(labelIn);
        } else if (labelIn instanceof SASFormat) {
            this.label.setFormat(labelIn);
        } else if (labelIn instanceof TextStyleInterface) {
            this.label = new TextAttrib((TextStyleInterface)labelIn);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public TextStyleInterface getLabel() {
        return this.label;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean viz) {
    }

    @Override
    public Object getOpacityValue() {
        return new Double(1.0);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
    }

    @Override
    public void drawHighlight(Object p) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._changes.removePropertyChangeListener(l);
    }
}

