/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Line2D;

public class ReferenceLine
implements ReferenceLineInterface,
RenderInterface {
    protected boolean sameSide;
    protected Object value;
    protected SASFormat bestFmt;
    protected TextAttrib label = new Text();
    protected LineAttrib line;
    protected boolean labelOutside = true;
    protected Line2D line2D;

    public ReferenceLine(Object valueIn, String labelIn, Color colorIn, Object fmtIn) {
        this.label.setJustification(1, this.label.getVerticalJustification());
        this.label.setPropertyValue(9018, "ValueText");
        this.label.applyPropertyChanges();
        this.line = new LineAttrib(colorIn);
        this.sameSide = false;
        this.value = valueIn;
        this.bestFmt = SASFormat.getInstance((String)"BEST");
        if (this.label != null) {
            this.label.setColor(colorIn);
            this.label.setFormat(fmtIn);
            this.label.setText(labelIn);
        }
        if (this.line != null) {
            this.line.setColor(colorIn);
        }
    }

    public ReferenceLine(Object valueIn, String labelIn, Color colorIn) {
        this(valueIn, labelIn, colorIn, null);
    }

    public ReferenceLine(Object valueIn, String labelIn) {
        this(valueIn, labelIn, null, null);
    }

    public ReferenceLine(Object valueIn) {
        this(valueIn, null, null, null);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(Object value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        return true;
    }

    @Override
    public TextStyleInterface getLabel() {
        return this.label;
    }

    @Override
    public boolean setLabel(Object labelIn) {
        if (this.label == null) {
            return false;
        }
        if (labelIn == null || labelIn instanceof String) {
            this.label.setText(labelIn);
        } else if (labelIn instanceof Boolean) {
            this.label.setVisible((Boolean)labelIn);
        } else if (labelIn instanceof Color) {
            this.label.setColor(labelIn);
        } else if (labelIn instanceof Font) {
            this.label.setFont(labelIn);
        } else if (labelIn instanceof SASFormat) {
            this.label.setFormat(labelIn);
        } else if (labelIn instanceof TextStyleInterface) {
            this.label = new Text((TextStyleInterface)labelIn);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public LineStyleInterface getLine() {
        return this.line;
    }

    @Override
    public boolean setLine(Object line) {
        if (this.line == null || line == null) {
            return false;
        }
        if (line instanceof Boolean) {
            this.line.setVisible((Boolean)line);
        } else if (line instanceof Color) {
            this.line.setColor(line);
        } else if (line instanceof Number) {
            this.line.setWidth(((Number)line).intValue());
        } else if (line instanceof LineStyleInterface) {
            this.line = new LineAttrib((LineStyleInterface)line);
        }
        return true;
    }

    @Override
    public String getLabelString() {
        Object o = null;
        SASFormat fmt = null;
        if (this.label != null) {
            o = this.label.getFormat();
            if (o != null && o instanceof SASFormat) {
                fmt = (SASFormat)o;
            }
            o = this.label.getText();
        }
        if (o != null) {
            return o.toString();
        }
        if (this.value == null) {
            return null;
        }
        if (fmt != null) {
            return fmt.format(this.value);
        }
        if (this.value instanceof Number && this.bestFmt != null) {
            return this.bestFmt.format(this.value).trim();
        }
        return this.value.toString();
    }

    @Override
    public boolean getSameLabelSide() {
        return this.sameSide;
    }

    @Override
    public void setSameLabelSide(boolean same) {
        this.sameSide = same;
    }

    @Override
    public boolean isOutsideLabel() {
        return this.labelOutside;
    }

    @Override
    public void setOutsideLabel(boolean outside) {
        this.labelOutside = outside;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        if (this.value == null || this.line == null) {
            return false;
        }
        return this.line.isVisible();
    }

    @Override
    public void setVisible(boolean viz) {
        if (this.line != null) {
            this.line.setVisible(viz);
        }
    }

    @Override
    public Object getOpacityValue() {
        return new Double(1.0);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
    }

    @Override
    public void drawHighlight(Object p) {
    }

    public void setLine2D(Line2D line) {
        this.line2D = line;
    }

    public Line2D getLine2D() {
        return this.line2D;
    }
}

