/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.util.Markers;
import java.awt.Color;
import java.awt.Graphics;

public class MarkerRenderer {
    public static void drawMarker(Graphics g, int x, int y, Color mkrColor, Color mkrOutlineColor, int mrkrShape, boolean mrkrFilled, boolean markerOutlined, int mkrSize, int halfMkrSize, int markerOutlineThickness) {
        boolean drawOutlines = mkrSize > 4;
        switch (mrkrShape) {
            case 0: {
                if (mkrColor != null) {
                    g.setColor(mkrColor);
                }
                g.fillRect(x, y, 1, 1);
                break;
            }
            case 5: {
                if (mrkrFilled) {
                    if (markerOutlined && drawOutlines) {
                        if (mkrOutlineColor != null) {
                            g.setColor(mkrOutlineColor);
                        }
                        g.fillRect(x - halfMkrSize, y - halfMkrSize, mkrSize, mkrSize);
                        if (mkrColor != null) {
                            g.setColor(mkrColor);
                        }
                        g.fillRect(x - halfMkrSize + markerOutlineThickness, y - halfMkrSize + markerOutlineThickness, mkrSize - 2 * markerOutlineThickness, mkrSize - 2 * markerOutlineThickness);
                        break;
                    }
                    if (drawOutlines) {
                        if (mkrColor != null) {
                            g.setColor(mkrColor);
                        }
                    } else if (mkrOutlineColor != null) {
                        g.setColor(mkrOutlineColor);
                    }
                    g.fillRect(x - halfMkrSize, y - halfMkrSize, mkrSize, mkrSize);
                    break;
                }
                if (mkrOutlineColor != null) {
                    g.setColor(mkrOutlineColor);
                }
                g.drawRect(x - halfMkrSize, y - halfMkrSize, mkrSize, mkrSize);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                MarkerRenderer.drawShape(g, mrkrShape, x, y, mkrSize, mkrColor, mkrOutlineColor, markerOutlineThickness, markerOutlined && drawOutlines, mrkrFilled);
            }
        }
    }

    protected static void drawShape(Graphics g, int shape, int x, int y, int mkrSize, Color color, Color outlineColor, int outlineThickness, boolean outline, boolean fill) {
        boolean weightedMarkers = false;
        if (fill) {
            Color ol = null;
            if (outline) {
                ol = outlineColor;
            }
            switch (shape) {
                case 5: {
                    Markers.draw((Graphics)g, (Color)color, (Color)ol, (int)19, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 2: {
                    Markers.draw((Graphics)g, (Color)color, (Color)ol, (int)17, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 3: {
                    Markers.draw((Graphics)g, (Color)color, (Color)ol, (int)22, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 4: {
                    Markers.draw((Graphics)g, (Color)color, (Color)ol, (int)1, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 6: {
                    Markers.draw((Graphics)g, (Color)color, (Color)ol, (int)18, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 1: {
                    Markers.draw((Graphics)g, (Color)color, (Color)ol, (int)16, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                }
            }
        } else {
            switch (shape) {
                case 5: {
                    Markers.draw((Graphics)g, (Color)outlineColor, null, (int)3, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 2: {
                    Markers.draw((Graphics)g, (Color)outlineColor, null, (int)52, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 3: {
                    Markers.draw((Graphics)g, (Color)outlineColor, null, (int)6, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 4: {
                    Markers.draw((Graphics)g, (Color)outlineColor, null, (int)1, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 6: {
                    Markers.draw((Graphics)g, (Color)outlineColor, null, (int)2, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                    break;
                }
                case 1: {
                    Markers.draw((Graphics)g, (Color)outlineColor, null, (int)0, (int)mkrSize, (int)x, (int)y, (boolean)weightedMarkers, (int)-1, (int)outlineThickness);
                }
            }
        }
    }

    public static void drawStandardMarker(Graphics g, int x, int y, Color mkrColor, Color mkrOutlineColor, int mkrShape, boolean markerOutlined, int mkrSize, int halfMkrSize, int markerOutlineThickness) {
        boolean transparentColor;
        if (mkrColor == null) {
            mkrColor = Color.black;
        }
        boolean bl = transparentColor = mkrColor.getAlpha() < 255 || mkrOutlineColor.getAlpha() < 255;
        if (mkrShape == 19 && !transparentColor) {
            boolean drawOutlines = true;
            if (markerOutlined && drawOutlines) {
                if (mkrOutlineColor != null) {
                    g.setColor(mkrOutlineColor);
                }
                if (markerOutlineThickness > 1) {
                    g.fillRect(x - halfMkrSize - markerOutlineThickness / 2, y - halfMkrSize - markerOutlineThickness / 2, mkrSize + markerOutlineThickness, mkrSize + markerOutlineThickness);
                } else {
                    g.fillRect(x - halfMkrSize, y - halfMkrSize, mkrSize, mkrSize);
                }
                if (mkrColor != null) {
                    g.setColor(mkrColor);
                }
                if (markerOutlineThickness > 1) {
                    g.fillRect(x - halfMkrSize + markerOutlineThickness / 2, y - halfMkrSize + markerOutlineThickness / 2, mkrSize - markerOutlineThickness / 2, mkrSize - markerOutlineThickness / 2);
                } else {
                    g.fillRect(x - halfMkrSize + markerOutlineThickness, y - halfMkrSize + markerOutlineThickness, mkrSize - 2 * markerOutlineThickness, mkrSize - 2 * markerOutlineThickness);
                }
            } else {
                if (drawOutlines) {
                    if (mkrColor != null) {
                        g.setColor(mkrColor);
                    }
                } else if (mkrOutlineColor != null) {
                    g.setColor(mkrOutlineColor);
                }
                g.fillRect(x - halfMkrSize, y - halfMkrSize, mkrSize, mkrSize);
            }
        } else {
            Color markerColor = mkrColor;
            Color outlineColor = mkrOutlineColor;
            if (!Markers.isFilled((int)mkrShape)) {
                markerColor = mkrOutlineColor;
                outlineColor = null;
            }
            if (!markerOutlined) {
                outlineColor = null;
            }
            Markers.draw((Graphics)g, (Color)markerColor, (Color)outlineColor, (int)mkrShape, (int)mkrSize, (int)x, (int)y, (boolean)false, (int)-1, (int)markerOutlineThickness);
        }
    }
}

