/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.Marker3;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;

public class Marker4
extends Marker3 {
    protected int glyphWidth;
    protected int glyphHeight;
    protected Image glyph;

    public Marker4(int indexIn, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        this.init(indexIn, img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
    }

    @Override
    public void init(int indexIn, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        super.init(indexIn, img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
        this.glyph = null;
        this.glyphHeight = -1;
        this.glyphWidth = -1;
        if (img != null) {
            this.glyph = img;
            if (this.glyph != null) {
                this.glyphWidth = this.glyph.getWidth(null);
                this.glyphHeight = this.glyph.getHeight(null);
            }
        }
    }

    @Override
    public void draw(int type, int size, Graphics2D g, FontRenderContext fr, Font f, boolean fill, Color color, boolean outlineOn, Color outlineColor, int grow, Color shadowColor, double softness, int offset, Color labelColor, TextStyleInterface lblAttribs, boolean useSimple, boolean resize) {
        Composite composite = null;
        if (type != 7) {
            super.draw(type, size, g, fr, f, fill, color, outlineOn, outlineColor, grow, shadowColor, softness, offset, labelColor, lblAttribs, useSimple, resize);
        } else {
            if (this.opacity < 1.0) {
                composite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, (float)this.opacity));
            }
            if (this.glyph != null) {
                if (this.glyphWidth > 0 && this.glyphHeight > 0) {
                    g.drawImage(this.glyph, this.screenX + size / 2 - this.glyphWidth / 2, this.screenY + size / 2 - this.glyphHeight / 2, null);
                } else {
                    this.glyphWidth = this.glyph.getWidth(null);
                    this.glyphHeight = this.glyph.getHeight(null);
                }
            }
            if (composite != null) {
                g.setComposite(composite);
            }
        }
    }
}

