/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.UniqueValueMapper;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.SortKeyInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;

public class Marker
implements SortKeyInterface {
    public int screenX;
    public int screenY;
    protected int index;
    protected int iobs;
    protected float x;
    protected float y;

    public Marker() {
        this.init(-1, null, null, null, null, -1, Double.NaN, Double.NaN, 1.0, null, Double.NaN, Double.NaN);
    }

    public Marker(int indexIn, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        this.init(indexIn, img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
    }

    public int projectMarkerSize(TransformInterface transObj, double[] temp) {
        return 0;
    }

    public void init(int indexIn, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        this.iobs = iobs;
        this.index = indexIn;
        this.setX(x);
        this.setY(y);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public void adjustShape(UniqueValueMapper xMapper, UniqueValueMapper yMapper) {
    }

    public int getObsIndex() {
        return this.iobs;
    }

    public String getLabel() {
        return null;
    }

    public boolean projectMarker(TransformInterface transObj, double[] temp) {
        transObj.project(this.x, this.y, 0.0, temp);
        this.screenX = (int)temp[0];
        this.screenY = (int)temp[1];
        return true;
    }

    public Object getX() {
        return new Double(this.x);
    }

    public void setX(Object newX) {
        if (newX != null && newX instanceof Number) {
            this.x = ((Number)newX).floatValue();
        }
    }

    public Object getY() {
        return new Double(this.y);
    }

    protected void setY(Object newY) {
        if (newY != null && newY instanceof Number) {
            this.y = ((Number)newY).floatValue();
        }
    }

    public Object getKnot() {
        return null;
    }

    public double getNumericX() {
        return this.x;
    }

    public double getNumericY() {
        return this.y;
    }

    public double getErrorLow() {
        return Double.NaN;
    }

    public double getErrorHigh() {
        return Double.NaN;
    }

    public static void drawShape(int type, Color color, int x, int y, int size, Graphics2D g, boolean fill, boolean outlineOn, Color outlineColor, Color shadowColor, double softness, int offset, boolean useSimple, boolean resize) {
        int ishape;
        boolean fillableShape = false;
        int s = size;
        Color olc = null;
        Color c = null;
        switch (type) {
            case 1: {
                ishape = fill ? 16 : 0;
                fillableShape = true;
                break;
            }
            case 2: {
                ishape = fill ? 17 : 52;
                fillableShape = true;
                break;
            }
            case 0: {
                ishape = 16;
                s = 1;
                fillableShape = false;
                break;
            }
            case 3: {
                ishape = fill ? 22 : 6;
                fillableShape = true;
                break;
            }
            case 4: {
                ishape = 1;
                fillableShape = false;
                break;
            }
            case 5: {
                ishape = fill ? 19 : 3;
                fillableShape = true;
                break;
            }
            case 6: {
                ishape = fill ? 18 : 2;
                fillableShape = true;
                break;
            }
            default: {
                return;
            }
        }
        if (fillableShape && fill && outlineOn && size > 4) {
            c = g.getColor();
            olc = outlineColor;
        }
        if (shadowColor != null) {
            Color c2 = g.getColor();
            if (useSimple) {
                Markers.drawStroke((Graphics)g, (Color)shadowColor, null, (int)ishape, (int)s, (int)(x + offset), (int)(y + offset), (boolean)resize);
            } else {
                Markers.draw((Graphics)g, (Color)shadowColor, null, (int)ishape, (int)s, (int)(x + offset), (int)(y + offset));
            }
            g.setColor(c2);
        }
        if (useSimple) {
            Markers.drawStroke((Graphics)g, (Color)color, (Color)olc, (int)ishape, (int)s, (int)x, (int)y, (boolean)resize);
        } else {
            Markers.draw((Graphics)g, (Color)color, (Color)olc, (int)ishape, (int)s, (int)x, (int)y);
        }
        if (c != null) {
            g.setColor(c);
        }
    }

    public void draw(int type, int size, Graphics2D g, FontRenderContext fr, Font f, boolean fill, Color color, boolean outlineOn, Color outlineColor, int grow, Color shadowColor, double softness, int offset, Color labelColor, TextStyleInterface lblAttribs, boolean useSimple, boolean resize) {
        Color c = null;
        if (color != null) {
            g.setPaint(color);
        }
        Marker.drawShape(type, null, this.screenX, this.screenY, size + grow, g, fill, outlineOn, outlineColor, shadowColor, softness, offset, useSimple, resize);
        if (c != null) {
            g.setColor(c);
        }
    }

    public boolean pick(int type, int size, int x, int y) {
        boolean picked;
        switch (type) {
            case 0: {
                picked = this.screenX == x && this.screenY == y;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int halfSize = size >> 1;
                picked = x >= this.screenX - halfSize && x <= this.screenX + halfSize && y >= this.screenY - halfSize && y <= this.screenY + halfSize;
                break;
            }
            default: {
                return false;
            }
        }
        return picked;
    }

    public boolean pick(int type, int size, Rectangle userRect) {
        boolean picked;
        if (userRect == null) {
            return false;
        }
        switch (type) {
            case 0: {
                picked = userRect.contains(this.screenX, this.screenY);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int halfSize = size >> 1;
                picked = this.screenX + halfSize >= userRect.x && this.screenX - halfSize <= userRect.x + userRect.width && this.screenY + halfSize >= userRect.y && this.screenY - halfSize <= userRect.y + userRect.height;
                break;
            }
            default: {
                return false;
            }
        }
        return picked;
    }

    public int getCount() {
        return 0;
    }

    public void setCount(int newCount) {
    }

    public double getDataSize() {
        return Double.NaN;
    }

    public void setDataSize(double newDataSize) {
    }

    public double getDataOpacity() {
        return Double.NaN;
    }

    public int getKeyType() {
        return 0;
    }

    public double getNumericKeyValue() {
        return this.iobs;
    }

    public Object getKeyValue() {
        return new Integer(this.iobs);
    }
}

