/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import java.awt.Insets;
import java.util.Collection;
import java.util.Vector;

public class MarginMerger
implements MarginListener {
    boolean mergeInnerMargins = true;
    boolean mergeOuterMargins = true;
    boolean ignoreEvents = false;
    boolean trackEvents = true;
    private Vector marginInterfaces = new Vector();

    public void addMarginItem(CellItemInterface mi) {
        mi.addMarginListener((MarginListener)this);
        this.marginInterfaces.addElement(mi);
    }

    public void addMarginItems(Collection c) {
        for (Object obj : c) {
            if (obj instanceof CellItemInterface) {
                ((CellItemInterface)obj).addMarginListener((MarginListener)this);
            }
            if (!(obj instanceof MarginInterface)) continue;
            this.marginInterfaces.addElement(obj);
        }
    }

    public void mergeMargins() {
        MarginInterface margin;
        int i;
        this.ignoreEvents = true;
        Insets inner = new Insets(0, 0, 0, 0);
        Insets outer = new Insets(0, 0, 0, 0);
        for (i = 0; i < this.marginInterfaces.size(); ++i) {
            margin = (MarginInterface)this.marginInterfaces.elementAt(i);
            if (this.mergeInnerMargins) {
                Insets im = margin.getPreferredInnerMargin();
                if (im.bottom > inner.bottom) {
                    inner.bottom = im.bottom;
                }
                if (im.top > inner.top) {
                    inner.top = im.top;
                }
                if (im.right > inner.right) {
                    inner.right = im.right;
                }
                if (im.left > inner.left) {
                    inner.left = im.left;
                }
            }
            if (!this.mergeOuterMargins) continue;
            Insets om = margin.getPreferredOuterMargin();
            if (om.bottom > outer.bottom) {
                outer.bottom = om.bottom;
            }
            if (om.top > outer.top) {
                outer.top = om.top;
            }
            if (om.right > outer.right) {
                outer.right = om.right;
            }
            if (om.left <= outer.left) continue;
            outer.left = om.left;
        }
        for (i = 0; i < this.marginInterfaces.size(); ++i) {
            margin = (MarginInterface)this.marginInterfaces.elementAt(i);
            if (this.mergeInnerMargins) {
                margin.setInnerMargin(new Insets(inner.top, inner.left, inner.bottom, inner.right));
            }
            if (!this.mergeOuterMargins) continue;
            margin.setOuterMargin(new Insets(outer.top, outer.left, outer.bottom, outer.right));
        }
        this.ignoreEvents = false;
    }

    public void marginChanged(MarginChangeEvent e) {
        if (this.ignoreEvents || !this.trackEvents) {
            return;
        }
        this.mergeMargins();
    }
}

