/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.band.Band;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.BandStyleInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.MarkerRenderer;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class LegendObjectJ2D
extends LegendObject
implements MouseListener,
MouseMotionListener,
DataFilterListenerInterface {
    protected static final int MIN_CONTINUOUS_SIZE = 20;
    protected static final double USAGE_FRACTION = 0.6;
    protected static final int MIN_MARKER_SIZE = 6;
    protected boolean visible = false;
    protected boolean noShow = true;
    protected boolean noShowTitle = false;
    protected boolean hasLines = false;
    protected int width = 0;
    protected int height = 0;
    protected int maxWidth;
    protected int maxHeight;
    protected int titleWidth = 0;
    protected int titleHeight = 0;
    protected int titleDescent;
    protected int fontSize = 12;
    protected int entrySize = 0;
    protected int entryHeight = 0;
    protected int borderMargin = 4;
    protected int titleMargin = 4;
    protected int entryMargin;
    protected int markerSize = 0;
    protected int lineSize = 48;
    protected int markerAndLabelGap = 0;
    protected int ncols = 0;
    protected int nrows = 0;
    protected double opacity = 1.0;
    protected Point start;
    protected Vector entries;
    protected Dimension nullDim;
    protected Hashtable entryBounds;
    protected DataFilterReadInterface filter = null;
    protected String variable = null;
    protected Rectangle mouseOverRect = null;
    private Border mouseOverBorder = new LineBorder(Color.black, 1, true);
    private Vector selectedEntries = null;
    private Border selectedBorder = new LineBorder(Color.yellow, 1, true);
    private JButton dummyComponent = new JButton();
    private boolean inMouseReleased = false;
    private Color selectedColor = Color.yellow;

    public LegendObjectJ2D() {
        this.nullDim = new Dimension(0, 0);
        this.start = new Point(0, 0);
        this.entries = new Vector();
    }

    @Override
    public void applyStyle(Style style) {
        super.applyStyle(style);
        this.mouseOverBorder = new LineBorder(style.getLineStyleElement("Outlines").getLineColor(), 1, true);
        this.selectedBorder = new LineBorder(style.getLineStyleElement("Selection").getLineColor(), 1, true);
        this.selectedColor = style.getFillStyleElement("Selection").getFillColor();
        this.selectedColor = new Color(this.selectedColor.getRed(), this.selectedColor.getGreen(), this.selectedColor.getBlue(), 64);
    }

    protected boolean getBooleanProperty(PropertyInterface prop, int id, boolean defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected LegendEntryInterface getEntry(int idx) {
        if (this.entries == null || idx < 0 || this.entries.size() <= idx) {
            return null;
        }
        Object o = this.entries.elementAt(idx);
        if (o == null || !(o instanceof LegendEntryInterface)) {
            return null;
        }
        return (LegendEntryInterface)o;
    }

    public void setData(DataFilterReadInterface filter, String variable) {
        if (filter != null) {
            filter.removeDataFilterListener((Object)this);
        }
        this.filter = filter;
        if (filter != null) {
            filter.addDataFilterListener((Object)this);
        }
        this.variable = variable;
        if (this.selectedEntries != null) {
            this.selectedEntries.removeAllElements();
        }
    }

    protected Object getValue(int idx) {
        LegendEntryInterface lei = this.getEntry(idx);
        if (lei == null) {
            return null;
        }
        return lei.getValue();
    }

    protected String getValueString(Object v) {
        String s;
        block13: {
            s = null;
            SASFormat fmt = null;
            if (v == null) {
                return null;
            }
            if (this.isContinuous) {
                Object o;
                if (this.label != null && (o = this.label.getFormat()) != null) {
                    if (o instanceof SASFormat) {
                        fmt = (SASFormat)o;
                    }
                } else if (this.variable != null && this.filter != null && this.filter.getFormat((Object)this.variable, SASFormat.class) != null) {
                    fmt = (SASFormat)this.filter.getFormat((Object)this.variable, SASFormat.class);
                } else if (v instanceof Number && this.defaultFormat != null) {
                    fmt = this.defaultFormat;
                }
                try {
                    if (fmt != null) {
                        s = fmt.format(v);
                        break block13;
                    }
                    s = v.toString();
                }
                catch (IllegalArgumentException e) {
                    s = v.toString();
                }
            } else {
                s = v.toString();
            }
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    protected MarkerStyleInterface getMarkerSymbol(int idx) {
        LegendEntryInterface lei = this.getEntry(idx);
        if (lei == null) {
            return null;
        }
        return lei.getSymbolMarkerStyle();
    }

    protected LineStyleInterface getLineSymbol(int idx) {
        LegendEntryInterface lei = this.getEntry(idx);
        if (lei == null) {
            return null;
        }
        return lei.getSymbolLineStyle();
    }

    protected BandStyleInterface getBandSymbol(int idx) {
        LegendEntryInterface lei = this.getEntry(idx);
        if (lei == null) {
            return null;
        }
        return lei.getSymbolBandStyle();
    }

    protected double getNumericValue(Object o) {
        if (o == null || !(o instanceof Number)) {
            return Double.NaN;
        }
        return ((Number)o).doubleValue();
    }

    protected Color getColorValue(Object o) {
        MarkerStyleInterface ms = null;
        if (o == null) {
            return null;
        }
        if (o instanceof LegendEntryInterface) {
            ms = ((LegendEntryInterface)o).getSymbolMarkerStyle();
        } else if (o instanceof MarkerStyleInterface) {
            ms = (MarkerStyleInterface)o;
        } else if (o instanceof Color) {
            return (Color)o;
        }
        if (ms == null) {
            return null;
        }
        return ms.getColor();
    }

    protected void drawShadow(Graphics2D g, String s, int ix, int iy, TextStyleInterface ts) {
        Color c2 = null;
        if (ts == null || !ts.areShadowsOn()) {
            return;
        }
        Color c = ts.getShadowColor();
        if (c == null) {
            c = Color.black;
        }
        double d = ts.getShadowSoftness();
        int a = Math.max(0, Math.min(255, (int)(d * 255.0)));
        int off = ts.getShadowOffset();
        off = Math.max(0, off);
        if (d < 1.0) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        }
        c2 = g.getColor();
        g.setColor(c);
        g.drawString(s, ix + off, iy + off);
        if (c2 != null) {
            g.setColor(c2);
        }
    }

    protected void drawColorBar(Graphics2D g, int midX, int midY, boolean vertical) {
        Color curColor;
        int iy1;
        int ix1;
        int ix2 = 0;
        int iy2 = 0;
        Paint oldPaint = null;
        int n = this.entries == null ? 0 : this.entries.size();
        int startx = ix1 = midX - this.entrySize / 2;
        int starty = iy1 = midY + this.entryHeight / 2;
        if (vertical) {
            ix2 = ix1 + this.entrySize;
        } else {
            iy2 = iy1 - this.entryHeight;
        }
        double low = this.getNumericValue(this.getValue(0));
        double high = this.getNumericValue(this.getValue(n - 1));
        if (Double.isNaN(low) || Double.isNaN(high) || Double.isInfinite(low) || Double.isInfinite(high) || low > high) {
            return;
        }
        oldPaint = g.getPaint();
        double last = low;
        Color lastColor = this.getColorValue(this.getEntry(0));
        for (int i = 1; i < n; ++i) {
            double cur = this.getNumericValue(this.getValue(i));
            curColor = this.getColorValue(this.getEntry(i));
            if (curColor == null || lastColor == null || Double.isNaN(cur) || Double.isInfinite(cur) || cur < last) {
                cur = last;
                lastColor = curColor;
                continue;
            }
            double multiplier = (cur - low) / (high - low);
            if (Double.isNaN(multiplier)) {
                multiplier = 1.0;
            }
            if (vertical) {
                iy2 = starty - (int)(multiplier * (double)this.entryHeight);
            } else {
                ix2 = startx + (int)(multiplier * (double)this.entrySize);
            }
            GradientPaint gp = vertical ? new GradientPaint(ix1, iy1, lastColor, ix1, iy2, curColor) : new GradientPaint(ix1, iy1, lastColor, ix2, iy1, curColor);
            if (gp != null) {
                if (lastColor.equals(curColor)) {
                    g.setPaint(lastColor);
                } else {
                    g.setPaint(gp);
                }
                g.fillRect(ix1, iy2, ix2 - ix1 + 1, iy1 - iy2 + 1);
            }
            if (vertical) {
                iy1 = iy2;
            } else {
                ix1 = ix2;
            }
            last = cur;
            lastColor = curColor;
        }
        curColor = this.getBorderColor();
        if (curColor != null) {
            g.setColor(curColor);
            g.drawRect(midX - this.entrySize / 2, midY - this.entryHeight / 2, this.entrySize, this.entryHeight);
        }
        if (oldPaint != null) {
            g.setPaint(oldPaint);
        }
    }

    @Override
    public boolean isUpdateRequired() {
        return super.isUpdateRequired() && this.entries != null && this.entries.size() > 0 && this.visible;
    }

    @Override
    public LegendEntryInterface[] getValues() {
        int n;
        LegendEntryInterface[] out = null;
        if (this.entries == null || (n = this.entries.size()) <= 0) {
            return null;
        }
        out = new LegendEntryInterface[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            out[i] = this.getEntry(i);
        }
        return out;
    }

    @Override
    public boolean setValues(Color[] colors, int[] shapes, Object[] valuesIn, boolean[] filled, boolean continuous) {
        MarkerStyleInterface[] ms = null;
        if (shapes == null && colors == null || valuesIn == null) {
            return false;
        }
        int n = valuesIn.length;
        if (n <= 0) {
            return false;
        }
        if (shapes != null && continuous) {
            return false;
        }
        if (shapes != null && shapes.length != n) {
            return false;
        }
        if (colors != null && colors.length != n) {
            return false;
        }
        ms = new MarkerAttrib[n];
        if (ms == null) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            ms[i] = new MarkerAttrib();
            if (ms[i] == null) continue;
            if (colors != null && colors[i] != null) {
                ms[i].setColor(colors[i]);
            }
            if (shapes != null) {
                ms[i].setShape(new Integer(shapes[i]));
            }
            if (filled == null || filled.length <= i) continue;
            ms[i].setFilled(filled[i]);
        }
        return this.setValues(valuesIn, ms, null, (BandStyleInterface[])null, continuous);
    }

    @Override
    public boolean setValues(Object[] valuesIn, MarkerStyleInterface[] msIn, LineStyleInterface[] lsIn, boolean continuous) {
        return this.setValues(valuesIn, msIn, lsIn, null, continuous);
    }

    @Override
    public boolean setValues(Object[] valuesIn, MarkerStyleInterface[] msIn, LineStyleInterface[] lsIn, BandStyleInterface[] bsIn, boolean continuous) {
        int largest = 0;
        int n = valuesIn == null ? 0 : valuesIn.length;
        largest = Math.max(largest, n);
        n = msIn == null ? 0 : msIn.length;
        largest = Math.max(largest, n);
        n = lsIn == null ? 0 : lsIn.length;
        largest = Math.max(largest, n);
        n = bsIn == null ? 0 : bsIn.length;
        if ((largest = Math.max(largest, n)) <= 0) {
            return false;
        }
        LegendEntryInterface[] entriesIn = new LegendEntry[largest];
        if (entriesIn == null) {
            return false;
        }
        for (int i = 0; i < largest; ++i) {
            Object v = valuesIn == null || i >= valuesIn.length ? null : valuesIn[i];
            MarkerStyleInterface ms = msIn == null || i >= msIn.length ? null : msIn[i];
            LineStyleInterface ls = lsIn == null || i >= lsIn.length ? null : lsIn[i];
            BandStyleInterface bs = bsIn == null || i >= bsIn.length ? null : bsIn[i];
            entriesIn[i] = new LegendEntry(v, ms, ls, bs);
        }
        return this.setValues(entriesIn, continuous);
    }

    @Override
    public boolean setValues(LegendEntryInterface[] entriesIn, boolean continuous) {
        if (this.entries == null || entriesIn == null) {
            return false;
        }
        int n = entriesIn.length;
        this.isContinuous = continuous;
        this.entries.removeAllElements();
        for (int i = 0; i < n; ++i) {
            if (entriesIn[i] == null) continue;
            this.entries.addElement(entriesIn[i]);
        }
        this.updateRequired = true;
        return true;
    }

    @Override
    public Point getStartPoint() {
        return this.start;
    }

    @Override
    public void setStartPoint(int xIn, int yIn) {
        if (this.start == null) {
            return;
        }
        this.start.x = xIn;
        this.start.y = yIn;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.maxWidth, this.maxHeight);
    }

    @Override
    public void setMaximumSize(int w, int h) {
        if (w != this.maxWidth || h != this.maxHeight) {
            this.updateRequired = true;
        }
        this.maxWidth = w;
        this.maxHeight = h;
    }

    @Override
    public Dimension getRequiredSize() {
        Object v;
        int offset;
        Font f;
        boolean fitting = true;
        boolean vertical = this.maxHeight > this.maxWidth;
        int n = 0;
        int w2 = 0;
        int w = 0;
        int h = 0;
        int longest = 0;
        int tallest = 0;
        int nfit = 0;
        String s = null;
        String s2 = null;
        Dimension dim = this.nullDim;
        FontRenderContext fr = null;
        TextLayout tl = null;
        Rectangle2D rect = null;
        if (!this.updateRequired) {
            return new Dimension(this.width, this.height);
        }
        this.noShow = true;
        this.noShowTitle = false;
        this.hasLines = false;
        this.nrows = 0;
        this.ncols = 0;
        this.titleWidth = 0;
        this.titleHeight = 0;
        if (!this.visible || this.entries == null) {
            return this.nullDim;
        }
        fr = new FontRenderContext(null, false, false);
        if (fr == null) {
            return null;
        }
        n = this.entries.size();
        if (n <= 0) {
            return null;
        }
        if (!this.title.isVisible() || (f = this.getTitleFont()) == null || (s = this.getTitleString()) == null || s.length() <= 0 || (tl = new TextLayout(s, f, fr)) == null) {
            this.titleHeight = 0;
            this.titleWidth = 0;
            this.noShowTitle = true;
        } else {
            this.titleHeight = (int)Math.ceil(tl.getAscent());
            this.titleDescent = (int)Math.ceil(tl.getDescent());
            this.titleWidth = (int)Math.ceil(tl.getBounds().getWidth());
            if (this.title != null && this.title.areShadowsOn()) {
                offset = this.title.getShadowOffset();
                this.titleWidth += offset;
                this.titleHeight += offset;
            }
        }
        int tw = this.titleWidth;
        int th = this.titleHeight + this.titleDescent;
        if (this.titleWidth > this.maxWidth || this.titleHeight > this.maxHeight) {
            this.noShowTitle = true;
            th = 0;
            tw = 0;
        }
        if ((f = this.getLabelFont()) != null) {
            this.fontSize = f.getSize();
        }
        if (this.isContinuous) {
            v = this.getValue(0);
            Object v2 = this.getValue(n - 1);
            if (v == null || v2 == null) {
                return this.nullDim;
            }
            s = this.getValueString(v);
            s2 = this.getValueString(v2);
            while (fitting) {
                if (s != null && s.length() == 0) {
                    s = "X";
                }
                if ((tl = new TextLayout(s, f, fr)) == null) {
                    return null;
                }
                rect = tl.getBounds();
                if (rect == null) {
                    return null;
                }
                longest = (int)Math.ceil(rect.getWidth());
                tallest = (int)Math.ceil(rect.getHeight());
                if (s2 != null && s2.length() == 0) {
                    s2 = "X";
                }
                if ((tl = new TextLayout(s2, f, fr)) == null) {
                    return null;
                }
                rect = tl.getBounds();
                if (rect == null) {
                    return null;
                }
                int longest2 = (int)Math.ceil(rect.getWidth());
                int tallest2 = (int)Math.ceil(rect.getHeight());
                if (this.label != null && this.label.areShadowsOn()) {
                    offset = this.label.getShadowOffset();
                    longest += offset;
                    longest2 += offset;
                    tallest += offset;
                    tallest2 += offset;
                }
                if (vertical) {
                    this.entryHeight = 20;
                    this.entrySize = tallest;
                    this.markerAndLabelGap = (int)((double)tallest * 0.5);
                    w = Math.max(longest, longest2);
                    w = Math.max(tw, w);
                    w = Math.max(this.entrySize, w);
                    w += 2 * this.borderMargin;
                    h = tallest + tallest2 + th + this.entryHeight + 2 * this.markerAndLabelGap + this.titleMargin + 2 * this.borderMargin;
                } else {
                    this.entrySize = 20;
                    h = this.entryHeight = Math.max(tallest, tallest2);
                    this.markerAndLabelGap = (int)((double)h * 0.5);
                    h += th + this.titleMargin + 2 * this.borderMargin;
                    w2 = 2 * Math.max(longest, longest2) + this.entrySize + 2 * this.markerAndLabelGap + 2 * this.borderMargin;
                    w = Math.max(tw, w2);
                }
                if (w > this.maxWidth || h > this.maxHeight) {
                    --this.fontSize;
                    if (this.fontSize < this.minLabelFontSize) {
                        this.updateRequired = false;
                        this.redrawRequired = false;
                        if (vertical) {
                            this.entryHeight = Math.max(this.entryHeight, (int)((double)(this.maxHeight - (h -= this.entryHeight)) * 0.6));
                            h += this.entryHeight;
                        } else {
                            this.entrySize = Math.max(this.entrySize, (int)((double)(this.maxWidth - (w2 -= this.entrySize)) * 0.6));
                            w = Math.max(tw, w2 += this.entrySize);
                        }
                        return new Dimension(w, h);
                    }
                    f = FontManager.getFont((String)f.getName(), (int)f.getStyle(), (int)this.fontSize);
                    continue;
                }
                if (vertical) {
                    this.entryHeight = Math.max(this.entryHeight, (int)((double)(this.maxHeight - (h -= this.entryHeight)) * 0.6));
                    h += this.entryHeight;
                } else {
                    this.entrySize = Math.max(this.entrySize, (int)((double)(this.maxWidth - (w2 -= this.entrySize)) * 0.6));
                    w = Math.max(tw, w2 += this.entrySize);
                }
                fitting = false;
                this.noShow = false;
                this.width = w;
                this.height = h;
                dim = new Dimension(this.width, this.height);
                this.redrawRequired = true;
                this.updateRequired = false;
                return dim;
            }
        }
        while (fitting) {
            boolean fitWidth;
            for (int i = 0; i < n; ++i) {
                int size;
                BandStyleInterface bs;
                LineStyleInterface ls;
                v = this.getValue(i);
                if (v == null || (s = this.getValueString(v)) == null) continue;
                if (s.length() <= 0) {
                    s = "X";
                }
                if ((tl = new TextLayout(s, f, fr)) == null || (rect = tl.getBounds()) == null) continue;
                LegendEntryInterface le = this.getEntry(i);
                if (le != null && ((ls = le.getSymbolLineStyle()) != null && ls.getColor() != null && ls.isVisible() || (bs = le.getSymbolBandStyle()) != null && bs.getColor() != null && bs.isVisible())) {
                    this.hasLines = true;
                }
                if ((size = (int)Math.ceil(rect.getWidth())) > longest) {
                    longest = size;
                }
                if ((size = (int)Math.ceil((rect = new TextLayout("X", f, fr).getBounds()).getHeight())) <= tallest) continue;
                tallest = size;
            }
            this.markerSize = tallest < 6 ? 6 : tallest;
            this.entryHeight = this.markerSize;
            this.markerAndLabelGap = (int)((double)this.markerSize * 0.5);
            this.entryMargin = this.markerSize / 2;
            this.entrySize = this.hasLines ? this.lineSize + this.markerAndLabelGap + longest : this.markerSize + this.markerAndLabelGap + longest;
            w = this.maxWidth - 2 * this.borderMargin;
            h = this.maxHeight - 2 * this.borderMargin;
            if (th > 0) {
                h -= 2 * this.titleMargin + th;
            }
            this.nrows = this.down > 0 ? this.down : (h + this.entryMargin) / (this.entryHeight + this.entryMargin);
            this.ncols = this.across > 0 ? this.across : (w + this.entryMargin) / (this.entrySize + this.entryMargin);
            nfit = this.ncols * this.nrows;
            if (nfit > n) {
                if (this.across <= 0 && this.down <= 0) {
                    if (this.isInside() && this.isInCorner()) {
                        this.ncols = (int)Math.ceil(Math.sqrt(n));
                        this.nrows = (int)Math.floor(Math.sqrt(n));
                        if (this.nrows * this.ncols < n) {
                            ++this.nrows;
                        }
                    } else if (vertical) {
                        this.ncols = (int)Math.ceil((double)n / (double)this.nrows);
                        this.nrows = (int)Math.ceil((double)n / (double)this.ncols);
                    } else {
                        this.nrows = (int)Math.ceil((double)n / (double)this.ncols);
                        this.ncols = (int)Math.ceil((double)n / (double)this.nrows);
                    }
                } else if (this.across > 0) {
                    this.nrows = (int)Math.ceil((double)n / (double)this.ncols);
                } else {
                    this.ncols = (int)Math.ceil((double)n / (double)this.nrows);
                }
            }
            boolean fitHeight = this.nrows * (this.entryHeight + this.entryMargin) - this.entryMargin > h;
            boolean bl = fitWidth = this.ncols * (this.entrySize + this.entryMargin) - this.entryMargin > w;
            if (this.nrows == 1) {
                boolean bl2 = fitWidth = this.ncols * (this.entrySize + this.entryMargin) - this.entryMargin + this.titleWidth > w;
            }
            if (fitHeight || fitWidth || nfit < n) {
                --this.fontSize;
                if (this.fontSize < this.minLabelFontSize) {
                    if (this.across <= 0 && this.down <= 0) {
                        if (this.isInside() && this.isInCorner()) {
                            this.ncols = (int)Math.ceil(Math.sqrt(n));
                            this.nrows = (int)Math.floor(Math.sqrt(n));
                            if (this.nrows * this.ncols < n) {
                                ++this.nrows;
                            }
                        } else if (vertical) {
                            this.ncols = (int)Math.ceil((double)n / (double)this.nrows);
                            this.nrows = (int)Math.ceil((double)n / (double)this.ncols);
                        } else {
                            this.nrows = (int)Math.ceil((double)n / (double)this.ncols);
                            this.ncols = (int)Math.ceil((double)n / (double)this.nrows);
                        }
                    } else if (this.across > 0) {
                        this.nrows = (int)Math.ceil((double)n / (double)this.ncols);
                    } else {
                        this.ncols = (int)Math.ceil((double)n / (double)this.nrows);
                    }
                    this.updateRequired = false;
                    this.redrawRequired = false;
                    this.width = this.nrows == 1 ? this.ncols * (this.entrySize + this.entryMargin) - this.entryMargin + 2 * this.borderMargin : Math.max(tw + 2 * this.borderMargin, this.ncols * (this.entrySize + this.entryMargin) - this.entryMargin + 2 * this.borderMargin);
                    this.height = this.nrows * (this.entryHeight + this.entryMargin) - this.entryMargin + 2 * this.borderMargin;
                    if (th > 0) {
                        if (this.nrows > 1) {
                            this.height += 2 * this.titleMargin + th;
                        } else {
                            this.width += 2 * this.titleMargin + tw;
                            this.height = Math.max(this.height, 2 * this.borderMargin + th);
                        }
                    }
                    dim = new Dimension(this.width, this.height);
                    return dim;
                }
                f = FontManager.getFont((String)f.getName(), (int)f.getStyle(), (int)this.fontSize);
                continue;
            }
            fitting = false;
            this.noShow = false;
            this.width = this.nrows == 1 ? this.ncols * (this.entrySize + this.entryMargin) - this.entryMargin + 2 * this.borderMargin : Math.max(tw + 2 * this.borderMargin, this.ncols * (this.entrySize + this.entryMargin) - this.entryMargin + 2 * this.borderMargin);
            this.height = this.nrows * (this.entryHeight + this.entryMargin) - this.entryMargin + 2 * this.borderMargin;
            if (th > 0) {
                if (this.nrows > 1) {
                    this.height += 2 * this.titleMargin + th;
                } else {
                    this.width += 2 * this.titleMargin + tw;
                    this.height = Math.max(this.height, 2 * this.borderMargin + th);
                }
            }
            dim = new Dimension(this.width, this.height);
            this.redrawRequired = true;
        }
        if (this.title != null) {
            this.title.setJustifySupported(this.nrows != 1);
        }
        this.updateRequired = false;
        return dim;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimOut = this.getRequiredSize();
        if (dimOut == null || dimOut.width > this.maxWidth || dimOut.height > this.maxHeight) {
            return this.nullDim;
        }
        return dimOut;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long a, long b) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean on) {
        this.redrawRequired = this.visible != on;
        this.visible = on;
        this.userSetProperties.set(420);
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean setOpacityValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            this.setVisible((Boolean)value);
        } else if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d) || d < 0.0 || d > 1.0) {
                return false;
            }
            this.opacity = d;
            this.redrawRequired = true;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean drawHighlight) {
        Font f;
        int ix;
        String s;
        Color c;
        int n;
        boolean vertical = this.maxHeight > this.maxWidth;
        int iy = this.start.y + this.borderMargin;
        int xoff = this.hasLines ? this.lineSize / 2 - this.markerSize / 2 : 0;
        int ms = this.hasLines ? this.lineSize : this.markerSize;
        Color bdrColor = null;
        Color c2 = null;
        Composite cp = null;
        Font oldFont = null;
        Rectangle2D rect = null;
        LineStyleInterface olsi = null;
        FontRenderContext fr = null;
        if (this.noShow || !this.visible || p == null || !(p instanceof Graphics2D)) {
            return;
        }
        if (this.entries == null || (n = this.entries.size()) <= 0) {
            return;
        }
        fr = new FontRenderContext(null, false, false);
        if (fr == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        if (drawHighlight) {
            if (this.selectedEntries != null) {
                g.setColor(this.selectedColor);
                for (int i = 0; i < this.selectedEntries.size(); ++i) {
                    Rectangle r = (Rectangle)this.selectedEntries.elementAt(i);
                    g.fillRect(r.x, r.y, r.width, r.height);
                    this.selectedBorder.paintBorder(this.dummyComponent, g, r.x - 1, r.y - 1, r.width + 2, r.height + 2);
                }
            }
            if (this.mouseOverRect != null) {
                this.mouseOverBorder.paintBorder(this.dummyComponent, g, this.mouseOverRect.x - 2, this.mouseOverRect.y - 2, this.mouseOverRect.width + 4, this.mouseOverRect.height + 4);
            }
            return;
        }
        if (this.bgOpacity > 0.0 && (c = this.getBackgroundColor()) != null) {
            if (this.bgOpacity < 1.0) {
                cp = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, (float)this.bgOpacity));
            }
            c2 = g.getColor();
            g.setColor(c);
            g.fillRect(this.start.x, this.start.y, this.width, this.height);
            g.setColor(c2);
            if (SILKGlobal.isFlagSet(5)) {
                g.setColor(Color.GREEN);
                g.drawRect(this.start.x + this.borderMargin, this.start.y + this.borderMargin, this.width - 2 * this.borderMargin, this.height - 2 * this.borderMargin);
            }
            if (cp != null) {
                g.setComposite(cp);
            }
        }
        switch (this.getBorderStyle()) {
            case 101: {
                bdrColor = c = this.getBorderColor();
                if (c == null) break;
                c2 = g.getColor();
                g.setColor(c);
                g.drawRect(this.start.x, this.start.y, this.width, this.height);
                g.setColor(c2);
                break;
            }
        }
        c2 = null;
        if (!this.noShowTitle && this.title.isVisible() && this.titleWidth > 0 && this.titleHeight > 0 && (s = this.getTitleString()) != null) {
            s = s.trim();
            switch (this.getTitleJustification()) {
                default: {
                    ix = this.start.x + this.width / 2;
                    break;
                }
                case 1: {
                    ix = this.start.x + this.borderMargin;
                    break;
                }
                case 2: {
                    ix = this.start.x + this.width - this.borderMargin;
                }
            }
            iy += this.titleHeight;
            if (this.nrows == 1) {
                ix = this.start.x + this.borderMargin;
            }
            this.title.drawText(g, s, new Point(ix, iy));
            iy += this.titleMargin;
            if (this.nrows == 1) {
                iy = this.start.y + this.borderMargin;
            }
        }
        c2 = null;
        c = this.getLabelColor();
        if (c != null) {
            double d;
            c2 = g.getColor();
            double d2 = this.label.getTransparency();
            if (d < 1.0) {
                int a = Math.max(0, Math.min(255, (int)(255.0 * d2)));
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
            }
            g.setColor(c);
        }
        if ((f = this.getLabelFont()) != null) {
            oldFont = g.getFont();
            if (f.getSize() != this.fontSize) {
                f = FontManager.getFont((String)f.getName(), (int)f.getStyle(), (int)this.fontSize);
            }
            g.setFont(f);
        } else {
            f = g.getFont();
        }
        if (this.isContinuous) {
            int midX = this.start.x + this.width / 2;
            int midY = iy + (this.height - (iy - this.start.y)) / 2;
            if (vertical) {
                ix = this.start.x;
                s = this.getValueString(this.getValue(n - 1));
                TextLayout tl = new TextLayout(s, f, fr);
                if (tl != null && (rect = tl.getBounds()) != null) {
                    ix = midX - (int)(rect.getWidth() / 2.0);
                    ix = Math.max(ix, 0);
                    iy = midY - this.entryHeight / 2 - this.markerAndLabelGap;
                }
                this.drawShadow(g, s, ix, iy, this.label);
                g.drawString(s, ix, iy);
                ix = this.start.x;
                s = this.getValueString(this.getValue(0));
                tl = new TextLayout(s, f, fr);
                if (tl != null && (rect = tl.getBounds()) != null) {
                    ix = midX - (int)(rect.getWidth() / 2.0);
                    ix = Math.max(ix, 0);
                    iy = midY + this.entryHeight / 2 + this.markerAndLabelGap + (int)rect.getHeight();
                }
                this.drawShadow(g, s, ix, iy, this.label);
                g.drawString(s, ix, iy);
            } else {
                TextLayout tl;
                ix = this.start.x + this.borderMargin;
                s = this.getValueString(this.getValue(0));
                String str = s;
                if (str != null && str.length() == 0) {
                    str = "X";
                }
                if ((tl = new TextLayout(str, f, fr)) != null && (rect = tl.getBounds()) != null) {
                    ix = (int)((double)(midX - this.entrySize / 2 - this.markerAndLabelGap) - rect.getWidth());
                    iy = midY + (int)rect.getHeight() / 2;
                }
                g.drawString(s, ix, iy);
                ix = midX + this.entrySize / 2 + this.markerAndLabelGap;
                s = this.getValueString(this.getValue(n - 1));
                g.drawString(s, ix, iy);
            }
            this.drawColorBar(g, midX, midY, vertical);
        } else {
            boolean rowMajor = this.down <= 0;
            int startY = iy;
            Object renderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            int irow = 0;
            int icol = 0;
            this.entryBounds = new Hashtable();
            ix = this.start.x + this.borderMargin;
            if (this.nrows == 1 && !this.noShowTitle && this.title.isVisible() && this.titleWidth > 0 && this.titleHeight > 0 && (s = this.getTitleString()) != null) {
                ix += this.titleWidth + 2 * this.titleMargin;
                iy = this.start.y + this.height / 2 - this.entryHeight / 2;
            }
            if ((bdrColor = this.getBorderColor()) == null) {
                bdrColor = Color.black;
            }
            for (int i = 0; i < n; ++i) {
                MarkerStyleInterface msi = this.getMarkerSymbol(i);
                if (msi != null) {
                    olsi = msi.getOutline();
                }
                LineStyleInterface lsi = this.getLineSymbol(i);
                BandStyleInterface bsi = this.getBandSymbol(i);
                if (msi == null && lsi == null && bsi == null || (s = this.getValueString(this.getValue(i))) == null) continue;
                this.entryBounds.put(this.getValue(i), new Rectangle(ix, iy, this.entrySize, this.entryHeight));
                if (this.hasLines) {
                    if (bsi != null && bsi.isVisible() && bsi.getColor() != null) {
                        Band.draw(g, ix, iy, 2 * this.markerSize, this.markerSize, bsi.getOpacity(), bsi.getColor());
                    }
                    if (lsi != null && lsi.isVisible() && lsi.getColor() != null) {
                        g.setColor(lsi.getColor());
                        Stroke oldStroke = g.getStroke();
                        g.setStroke(SASLinePatterns.getStroke((int)lsi.getPattern(), (int)lsi.getWidth()));
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.drawLine(ix, iy + this.markerSize / 2, ix + this.lineSize, iy + this.markerSize / 2);
                        g.setStroke(oldStroke);
                    }
                }
                boolean outlineOn = true;
                Color outlineColor = bdrColor;
                if (olsi != null) {
                    outlineOn = olsi.isVisible();
                    outlineColor = olsi.getColor();
                }
                if (msi != null && msi.isVisible()) {
                    MarkerRenderer.drawStandardMarker(g, ix + this.markerSize / 2 + xoff, iy + this.markerSize / 2, msi.getColor(), outlineColor, msi.getShapeInt(), outlineOn, this.markerSize, this.markerSize / 2, msi.getOutline().getWidth());
                }
                g.setColor(c);
                this.label.drawText(g, s, new Point(ix + ms + this.markerAndLabelGap, iy + this.entryHeight));
                if (rowMajor) {
                    ix += this.entrySize + this.entryMargin;
                    if (++icol < this.ncols) continue;
                    ++irow;
                    icol = 0;
                    ix = this.start.x + this.borderMargin;
                    iy += this.entryHeight + this.entryMargin;
                    continue;
                }
                iy += this.entryHeight + this.entryMargin;
                if (++irow < this.nrows) continue;
                ++icol;
                irow = 0;
                ix += this.entrySize + this.entryMargin;
                iy = this.nrows == 1 && !this.noShowTitle && this.title.isVisible() && this.titleWidth > 0 && this.titleHeight > 0 && (s = this.getTitleString()) != null ? this.start.y + this.height / 2 - this.entryHeight / 2 : startY;
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
        if (c2 != null) {
            g.setColor(c2);
        }
        if (oldFont != null) {
            g.setFont(oldFont);
        }
        this.redrawRequired = false;
    }

    @Override
    public void drawHighlight(Object p) {
    }

    public boolean isPointInLegend(Point p) {
        if (!this.isVisible() || this.noShow) {
            return false;
        }
        if (p.x < this.start.x || p.x > this.start.x + this.width) {
            return false;
        }
        return p.y >= this.start.y && p.y <= this.start.y + this.height;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseOverRect = null;
        if (this.isInside() || !this.isPointInLegend(e.getPoint()) || this.filter == null || this.variable == null) {
            return;
        }
        Enumeration keys = null;
        if (this.entryBounds != null) {
            keys = this.entryBounds.keys();
        }
        while (keys != null && keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Rectangle r = (Rectangle)this.entryBounds.get(key);
            if (!r.contains(e.getPoint())) continue;
            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            this.mouseOverRect = r;
            return;
        }
        e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isInside() || !this.isPointInLegend(e.getPoint())) {
            return;
        }
        if (this.filter != null && !e.isControlDown()) {
            this.filter.unselectAll();
            if (this.selectedEntries != null) {
                this.selectedEntries.removeAllElements();
            }
        }
        if (this.filter == null || this.variable == null) {
            return;
        }
        this.inMouseReleased = true;
        Enumeration keys = null;
        if (this.entryBounds != null) {
            keys = this.entryBounds.keys();
        }
        while (keys != null && keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Rectangle r = (Rectangle)this.entryBounds.get(key);
            if (!r.contains(e.getPoint())) continue;
            DataRange[] arr = new DataRange[]{this.filter.isNumericVariable((Object)this.variable) && key instanceof Number ? new ContinuousRange(((Number)key).doubleValue(), ((Number)key).doubleValue()) : new DiscreteRange(new Object[]{key})};
            this.filter.setSelected(new String[]{this.variable}, arr, true, true);
            if (this.selectedEntries == null) {
                this.selectedEntries = new Vector();
            }
            this.selectedEntries.addElement(r);
            this.inMouseReleased = false;
            return;
        }
        this.inMouseReleased = false;
    }

    @Override
    public Object getPropertyValue(int idx) {
        Object rc = null;
        switch (idx) {
            case 438: {
                rc = new Integer(this.ncols);
                break;
            }
            case 437: {
                rc = new Integer(this.nrows);
                break;
            }
            default: {
                rc = super.getPropertyValue(idx);
            }
        }
        return rc;
    }

    @Override
    public boolean isPropertySupported(int id) {
        if (id == 438 || id == 437) {
            return true;
        }
        return super.isPropertySupported(id);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (!this.inMouseReleased && this.selectedEntries != null) {
            this.selectedEntries.removeAllElements();
        }
    }
}

