/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.silk.util.UniqueValueMapper;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class LegendBuilder {
    private Hashtable legends = new Hashtable();
    private Hashtable legendEntries = new Hashtable();
    private Hashtable legendEntryValues = new Hashtable();
    private ArrayList charts = new ArrayList();
    private Style style = null;
    private boolean enableSelections = true;

    public LegendBuilder() {
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle instanceof ColorScheme) {
            this.style = ((ColorScheme)newStyle).getStyle();
        } else if (newStyle instanceof Style) {
            this.style = (Style)newStyle;
        } else {
            if (!(newStyle instanceof String)) return false;
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            if (sc.getStyle((String)newStyle) == null) return false;
            this.style = sc.getStyle((String)newStyle);
        }
        if (this.style == null) return true;
        Enumeration e = this.legends.elements();
        while (e != null && e.hasMoreElements()) {
            Object leg = e.nextElement();
            if (!(leg instanceof LegendObjectJ2D)) continue;
            LegendObjectJ2D legend = (LegendObjectJ2D)leg;
            legend.applyStyle(this.style);
        }
        return true;
    }

    public void addChart(PropertyInterface g) {
        if (g == null) {
            return;
        }
        if (!this.charts.contains(g)) {
            this.charts.add(g);
        }
        this.buildLegends();
    }

    public void addCharts(Collection c) {
        if (c == null) {
            return;
        }
        boolean build = false;
        Iterator i = c.iterator();
        while (i != null && i.hasNext()) {
            Object o = i.next();
            if (this.charts.contains(o)) continue;
            this.charts.add(o);
            build = true;
        }
        if (build) {
            this.buildLegends();
        }
    }

    public void removeChart(PropertyInterface g) {
        if (g == null) {
            return;
        }
        this.charts.remove(g);
        this.buildLegends();
    }

    public void removeCharts(Collection c) {
        this.charts.removeAll(c);
        this.buildLegends();
    }

    public void removeAllCharts() {
        this.charts.clear();
        this.legends.clear();
        this.legendEntries.clear();
        this.legendEntryValues.clear();
    }

    public void buildLegends() {
        this.legends.clear();
        this.updateLegends();
    }

    public void updateLegends() {
        this.legendEntries.clear();
        this.legendEntryValues.clear();
        this.refreshLegends();
    }

    protected void refreshLegends() {
        Hashtable legendMeta = new Hashtable();
        for (int i = 0; i < this.charts.size(); ++i) {
            PropertyInterface chart;
            Object legNames;
            if (!(this.charts.get(i) instanceof PropertyInterface) || (legNames = (chart = (PropertyInterface)this.charts.get(i)).getPropertyValue(24)) == null) continue;
            Enumeration e = Extract.elements((Object)legNames);
            while (e.hasMoreElements()) {
                Object entries;
                Object vis;
                GraphInterface g;
                LegendMetaData lmd;
                Object name = e.nextElement();
                chart.setPropertyValue(23, name);
                if (!legendMeta.containsKey(name)) {
                    lmd = new LegendMetaData();
                    legendMeta.put(name, lmd);
                }
                lmd = (LegendMetaData)legendMeta.get(name);
                Object title = chart.getPropertyValue(426);
                if (lmd.getTitle() == null) {
                    lmd.setTitle(title);
                }
                Object cont = chart.getPropertyValue(441);
                if (lmd.getContinuous() == null && cont instanceof Boolean) {
                    lmd.setContinuous(cont);
                }
                Object variable = chart.getPropertyValue(434);
                if (lmd.getVariable() == null) {
                    lmd.setVariable(variable);
                }
                if (lmd.getFormat() == null && variable != null && lmd.getVariable() == variable && chart instanceof GraphInterface && (g = (GraphInterface)chart).getFilter() != null) {
                    lmd.setFilter(g.getFilter());
                    Object format = g.getFilter().getFormat(variable, SASFormat.class);
                    lmd.setFormat(format);
                }
                if ((vis = chart.getPropertyValue(420)) != null) {
                    lmd.setVisible(vis);
                }
                if ((entries = chart.getPropertyValue(433)) == null) continue;
                Enumeration legEntries = Extract.elements((Object)entries);
                int numEntries = Extract.getNumberItems((Object)entries, (int)Extract.getSourceType((Object)entries));
                if (numEntries <= 0) continue;
                LinkedHashMap h = null;
                Hashtable h2 = null;
                Object o = this.legendEntries.get(name);
                if (o == null) {
                    h = new LinkedHashMap();
                    this.legendEntries.put(name, h);
                } else if (o instanceof LinkedHashMap) {
                    h = (LinkedHashMap)o;
                }
                o = this.legendEntryValues.get(name);
                if (o == null) {
                    h2 = new Hashtable();
                    this.legendEntryValues.put(name, h2);
                } else if (o instanceof Hashtable) {
                    h2 = (Hashtable)o;
                }
                while (legEntries.hasMoreElements()) {
                    Object o1;
                    Object le = legEntries.nextElement();
                    if (!(le instanceof LegendEntryInterface) || (o1 = ((LegendEntryInterface)le).getValue()) instanceof Number && Double.isNaN(((Number)o1).doubleValue()) || h.containsKey(le)) continue;
                    h.put(le, le);
                    LegendEntryInterface lei = (LegendEntryInterface)le;
                    h2.put(lei.getValue(), lei);
                }
            }
        }
        Enumeration e = legendMeta.keys();
        while (e != null && e.hasMoreElements()) {
            Object leg;
            Object name = e.nextElement();
            Object o = null;
            LegendEntryInterface[] entries = null;
            int entry = 0;
            Object legEntries = this.legendEntries.get(name);
            if (legEntries instanceof LinkedHashMap) {
                LinkedHashMap lhm = (LinkedHashMap)legEntries;
                entries = new LegendEntryInterface[lhm.size()];
                Set keys = lhm.keySet();
                if (keys != null) {
                    Iterator i = keys.iterator();
                    while (i != null && i.hasNext()) {
                        o = i.next();
                        if (!(o instanceof LegendEntryInterface)) continue;
                        entries[entry++] = o;
                    }
                }
            }
            LegendMetaData lmd = null;
            o = legendMeta.get(name);
            if (o instanceof LegendMetaData) {
                lmd = o;
            }
            Object title = lmd.getTitle();
            Object var = lmd.getVariable();
            Object filter = lmd.getFilter();
            Object cont = lmd.getContinuous();
            Object format = lmd.getFormat();
            Object vis = lmd.getVisible();
            boolean continuous = false;
            if (cont instanceof Boolean) {
                continuous = (Boolean)cont;
            }
            if (continuous) {
                entries = this.sortEntries(entries);
            }
            if (!this.legends.containsKey(name)) {
                LegendObjectJ2D legend = new LegendObjectJ2D();
                legend.applyStyle(this.style);
                if (vis instanceof Boolean) {
                    legend.setVisible((Boolean)vis);
                } else {
                    legend.setVisible(true);
                }
                this.legends.put(name, legend);
            }
            if (!((leg = this.legends.get(name)) instanceof LegendObjectJ2D)) continue;
            LegendObjectJ2D legend = (LegendObjectJ2D)leg;
            legend.setValues(entries, continuous);
            if (title != null) {
                legend.setTitle(title);
            }
            if (this.enableSelections && filter != null && var != null) {
                legend.setData((DataFilterReadInterface)filter, var.toString());
            }
            if (format == null) continue;
            legend.getLabel().setFormat(format);
            if (!(legend.getLabel() instanceof TextAttrib)) continue;
            ((TextAttrib)legend.getLabel()).setCurrentValueAsDefault(9008);
        }
    }

    private LegendEntryInterface[] sortEntries(LegendEntryInterface[] entries) {
        if (entries == null) {
            return null;
        }
        Hashtable<Object, LegendEntryInterface> h = new Hashtable<Object, LegendEntryInterface>();
        UniqueValueMapper uvm = new UniqueValueMapper();
        for (int i = 0; i < entries.length; ++i) {
            h.put(entries[i].getValue(), entries[i]);
            uvm.addValue(entries[i].getValue());
        }
        LegendEntryInterface[] sortedEntries = null;
        Object[] values = uvm.getValues(1);
        if (values != null) {
            sortedEntries = new LegendEntryInterface[values.length];
            for (int i = 0; i < values.length; ++i) {
                sortedEntries[i] = (LegendEntryInterface)h.get(values[i]);
            }
        }
        h.clear();
        return sortedEntries;
    }

    public SILKNumber[] getLegendNames() {
        SILKNumber[] names = new SILKNumber[this.legends.size()];
        Enumeration e = this.legends.keys();
        int i = 0;
        while (e != null && e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof SILKNumber)) continue;
            names[i++] = (SILKNumber)((Object)o);
        }
        return names;
    }

    public LegendObjectJ2D getLegend(SILKNumber name) {
        if (name == null) {
            return null;
        }
        Object o = this.legends.get((Object)name);
        if (o instanceof LegendObjectJ2D) {
            return (LegendObjectJ2D)o;
        }
        return null;
    }

    public boolean areSelectionsEnabled() {
        return this.enableSelections;
    }

    public void setEnableSelections(boolean enableSelections) {
        this.enableSelections = enableSelections;
    }

    private class LegendMetaData {
        private Object name;
        private Object title;
        private Object variable;
        private Object format;
        private Object continuous;
        private Object filter;
        private Object visible;

        private LegendMetaData() {
        }

        Object getVisible() {
            return this.visible;
        }

        void setVisible(Object visible) {
            this.visible = visible;
        }

        Object getFilter() {
            return this.filter;
        }

        Object getFormat() {
            return this.format;
        }

        Object getName() {
            return this.name;
        }

        Object getTitle() {
            return this.title;
        }

        Object getVariable() {
            return this.variable;
        }

        Object getContinuous() {
            return this.continuous;
        }

        void setFilter(Object filter) {
            this.filter = filter;
        }

        void setFormat(Object format) {
            this.format = format;
        }

        void setName(Object name) {
            this.name = name;
        }

        void setTitle(Object title) {
            this.title = title;
        }

        void setVariable(Object variable) {
            this.variable = variable;
        }

        void setContinuous(Object continuous) {
            this.continuous = continuous;
        }
    }
}

