/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.util.ImageInfo;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.StringCompare;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class ImageStore
implements FilenameFilter,
ImageListInterface,
ImageObserver {
    protected Component comp;
    protected Vector images;
    protected String textureDirectory;
    protected Toolkit tk;
    protected String[] extensions;
    protected String[] additionalImages;
    protected String[] styleImages;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");

    public ImageStore(Component c) {
        this.comp = c;
        this.images = new Vector();
        this.textureDirectory = null;
        if (this.comp != null) {
            this.tk = this.comp.getToolkit();
        }
        this.extensions = new String[]{".gif", ".jpg", ".jpeg", ".png"};
        Properties props = ResourceLoader.loadProperties((String)"Styles.config");
        this.styleImages = ResourceLoader.getResourceList((Object)props, (String)"Number_Style_Images", (String)"StyleImage");
        this.additionalImages = ResourceLoader.getResourceList((Object)props, (String)"Number_Additional_Images", (String)"AdditionalImage");
    }

    protected static int compareString(String val, ImageInfo vecval, boolean ignoreCase) {
        int ret;
        String s = vecval.getName();
        if (ignoreCase) {
            s = s.toUpperCase();
        }
        if ((ret = StringCompare.compareTo((String)val, (String)s)) < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        return 0;
    }

    protected static int binarylookup(String val, Vector vec, int uselen, boolean ignoreCase) {
        int len = uselen;
        String compareValue = null;
        ImageInfo vecEntry = null;
        if (val == null || vec == null) {
            return -1;
        }
        if (len < 0) {
            len = vec.size();
        }
        compareValue = ignoreCase ? val.toUpperCase() : val;
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = (ImageInfo)vec.elementAt(mi);
            ret = ImageStore.compareString(compareValue, vecEntry, ignoreCase);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    public String[] getAddtionalImages() {
        return this.additionalImages;
    }

    public boolean setAddtionalImages(String[] newImages) {
        int i;
        if (newImages == null) {
            this.additionalImages = null;
            return true;
        }
        int n = newImages.length;
        if (n <= 0) {
            return false;
        }
        for (i = 0; i < newImages.length; ++i) {
            if (newImages[i] != null) continue;
            return false;
        }
        String[] tmp = new String[n];
        if (tmp == null) {
            return false;
        }
        for (i = 0; i < n; ++i) {
            tmp[i] = newImages[i];
        }
        this.additionalImages = tmp;
        return true;
    }

    public String[] getStyleImages() {
        return this.styleImages;
    }

    public boolean setStyleImages(String[] newImages) {
        int i;
        if (newImages == null) {
            this.styleImages = null;
            return true;
        }
        int n = newImages.length;
        if (n <= 0) {
            return false;
        }
        for (i = 0; i < newImages.length; ++i) {
            if (newImages[i] != null) continue;
            return false;
        }
        String[] tmp = new String[n];
        if (tmp == null) {
            return false;
        }
        for (i = 0; i < n; ++i) {
            tmp[i] = newImages[i];
        }
        this.styleImages = tmp;
        return true;
    }

    public boolean setTextureDirectory(String directory) {
        if (directory == null) {
            this.textureDirectory = null;
            return true;
        }
        if (directory.endsWith("/") || directory.endsWith("\\")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        this.textureDirectory = directory;
        return true;
    }

    public boolean loadBundledImages(String[] imageNames) {
        Image img = null;
        ImageInfo info = null;
        if (this.images == null || this.comp == null || imageNames == null || imageNames.length <= 0) {
            return false;
        }
        int n = imageNames.length;
        for (int i = 0; i < n; ++i) {
            int idx = ImageStore.binarylookup(imageNames[i], this.images, -1, false);
            if (idx >= 0 || (img = ResourceLoader.getImage((Component)this.comp, (String)imageNames[i])) == null || (info = new ImageInfo(img, imageNames[i])) == null) continue;
            if ((idx = -idx - 1) >= this.images.size()) {
                this.images.addElement(info);
            } else {
                this.images.insertElementAt(info, idx);
            }
            info.setComplete(this.comp.prepareImage(img, this));
        }
        return true;
    }

    public boolean loadBundledImages() {
        boolean status = this.loadBundledImages(this.styleImages);
        return status & this.loadBundledImages(this.additionalImages);
    }

    public boolean loadImagesFromDirectory() {
        String errMsg = null;
        Image img = null;
        ImageInfo info = null;
        File dir = null;
        String[] imageFiles = null;
        if (this.textureDirectory == null) {
            return false;
        }
        dir = new File(this.textureDirectory);
        if (this.tk == null) {
            errMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.TextureLoadError.txt", (String)"Can not load textures, Toolkit error");
        } else if (!dir.exists()) {
            errMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.TextureDirectory.txt", (String)"Texture directory ") + this.textureDirectory + ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.DoesNotExist.txt", (String)" does not exist");
        } else if (!dir.canRead()) {
            errMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.TextureDirectory.txt", (String)"Texture directory ") + this.textureDirectory + ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.Noread.txt", (String)" can not be read.");
        } else if (!dir.isDirectory()) {
            errMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.Path.txt", (String)"The path ") + this.textureDirectory + ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.BadDir.txt", (String)" is not a valid directory.");
        } else {
            imageFiles = dir.list(this);
            if (imageFiles == null) {
                errMsg = ResourceLoader.getResourceString((Object)this.rb, (String)"ImageStore.NoTextures.txt", (String)"No textures found in directory '") + this.textureDirectory + "'.";
            }
        }
        if (errMsg != null) {
            System.err.println(errMsg);
            return false;
        }
        int n = imageFiles.length;
        for (int i = 0; i < n; ++i) {
            int idx = ImageStore.binarylookup(imageFiles[i], this.images, -1, false);
            if (idx >= 0 || (img = this.tk.getImage(this.textureDirectory + "/" + imageFiles[i])) == null || (info = new ImageInfo(img, imageFiles[i])) == null) continue;
            if ((idx = -idx - 1) >= this.images.size()) {
                this.images.addElement(info);
            } else {
                this.images.insertElementAt(info, idx);
            }
            info.setComplete(this.comp.prepareImage(img, this));
        }
        return true;
    }

    protected ImageInfo getImageInfo(int idx) {
        if (this.images == null || idx < 0 || idx >= this.images.size()) {
            return null;
        }
        return (ImageInfo)this.images.elementAt(idx);
    }

    protected ImageInfo getImageInfo(Image img) {
        int n = this.getNumberImages();
        Image listImg = null;
        ImageInfo info = null;
        if (img == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            info = this.getImageInfo(i);
            if (info == null || (listImg = info.getImage()) == null || !img.equals(listImg)) continue;
            return info;
        }
        return null;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (dir == null || name == null || this.extensions == null) {
            return false;
        }
        int n = this.extensions.length;
        for (int i = 0; i < n; ++i) {
            if (!name.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberImages() {
        if (this.images == null) {
            return 0;
        }
        return this.images.size();
    }

    @Override
    public Image getImageByName(String name, boolean ignoreCase) {
        return this.getImageByIndex(ImageStore.binarylookup(name, this.images, -1, ignoreCase));
    }

    @Override
    public Image getImageByIndex(int idx) {
        ImageInfo info = this.getImageInfo(idx);
        if (info == null) {
            return null;
        }
        return info.getImage();
    }

    @Override
    public String getImageName(int idx) {
        ImageInfo info = this.getImageInfo(idx);
        if (info == null) {
            return null;
        }
        return info.getName();
    }

    @Override
    public String getImageName(Image img) {
        ImageInfo info = this.getImageInfo(img);
        if (info == null) {
            return null;
        }
        return info.getName();
    }

    @Override
    public Image loadImage(String path, ImageObserver observer, boolean addToList) {
        int idx = -1;
        String name = null;
        Image img = null;
        ImageInfo info = null;
        if (path == null) {
            return null;
        }
        if (observer == null) {
            observer = this;
        }
        if ((idx = ImageStore.binarylookup(name = (idx = path.lastIndexOf(47)) >= 0 ? path.substring(idx + 1) : ((idx = path.lastIndexOf(92)) >= 0 ? path.substring(idx + 1) : path), this.images, -1, false)) >= 0) {
            return this.getImageByIndex(idx);
        }
        if (this.tk == null || this.comp == null) {
            return null;
        }
        img = this.tk.getImage(path);
        if (img != null && addToList) {
            info = new ImageInfo(img, name);
            if (info != null) {
                if ((idx = -idx - 1) >= this.images.size()) {
                    this.images.addElement(info);
                } else {
                    this.images.insertElementAt(info, idx);
                }
                info.setComplete(this.comp.prepareImage(img, this));
                if (!info.isComplete() && observer != this) {
                    this.comp.prepareImage(img, observer);
                }
            } else {
                this.comp.prepareImage(img, observer);
            }
        }
        return img;
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        ImageInfo info = null;
        if ((flags & 0xC0) != 0) {
            return false;
        }
        if ((flags & 0x20) != 0) {
            info = this.getImageInfo(img);
            if (info != null) {
                info.setComplete(true);
            }
            return false;
        }
        return true;
    }
}

