/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.Vector;

public class ImagePaginator {
    boolean split = false;
    BufferedImage fullImage = null;
    BufferedImage[] subImages = null;

    public ImagePaginator(BufferedImage image) {
        if (image != null) {
            this.fullImage = image;
        }
    }

    public boolean splitViewToPages(PageFormat pageFormat) {
        this.computeNumberOfPages(pageFormat);
        return true;
    }

    public Image getImage(int pageIndex) {
        if (pageIndex < this.subImages.length) {
            return this.subImages[pageIndex];
        }
        return null;
    }

    private void computeNumberOfPages(PageFormat pageFormat) {
        int wrap = 0;
        if ((double)this.fullImage.getWidth() > pageFormat.getImageableWidth()) {
            wrap |= 1;
        }
        if ((double)this.fullImage.getHeight() > pageFormat.getImageableHeight()) {
            wrap |= 2;
        }
        int x = 0;
        int y = 0;
        int wd = 0;
        int ht = 0;
        switch (wrap) {
            case 0: {
                this.subImages = new BufferedImage[1];
                this.subImages[0] = this.fullImage;
                break;
            }
            case 1: {
                Vector<BufferedImage> v = new Vector<BufferedImage>();
                x = 0;
                y = 0;
                wd = (int)pageFormat.getImageableWidth();
                ht = this.fullImage.getHeight();
                for (double w = (double)this.fullImage.getWidth(); w > pageFormat.getImageableWidth(); w -= pageFormat.getImageableWidth()) {
                    v.add(this.fullImage.getSubimage(x, y, wd, ht));
                    x += wd;
                }
                v.add(this.fullImage.getSubimage(x, y, this.fullImage.getWidth() - x, ht));
                this.subImages = new BufferedImage[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    this.subImages[i] = (BufferedImage)v.get(i);
                }
                break;
            }
            case 2: {
                Vector<BufferedImage> v = new Vector<BufferedImage>();
                x = 0;
                y = 0;
                wd = this.fullImage.getWidth();
                ht = (int)pageFormat.getImageableHeight();
                for (double h = (double)this.fullImage.getHeight(); h > pageFormat.getImageableHeight(); h -= pageFormat.getImageableHeight()) {
                    v.add(this.fullImage.getSubimage(x, y, wd, ht));
                    y += ht;
                }
                v.add(this.fullImage.getSubimage(x, y, wd, this.fullImage.getHeight() - y));
                this.subImages = new BufferedImage[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    this.subImages[i] = (BufferedImage)v.get(i);
                }
                break;
            }
            case 3: {
                int pw = 1;
                int ph = 1;
                for (double w = (double)this.fullImage.getWidth(); w > pageFormat.getImageableWidth(); w -= pageFormat.getImageableWidth()) {
                    ++pw;
                }
                for (double h = (double)this.fullImage.getHeight(); h > pageFormat.getImageableHeight(); h -= pageFormat.getImageableHeight()) {
                    ++ph;
                }
                this.subImages = new BufferedImage[pw * ph];
                for (int i = 0; i < pw; ++i) {
                    for (int j = 0; j < ph; ++j) {
                        int index = i + j * pw;
                        x = (int)((double)i * pageFormat.getImageableWidth());
                        y = (int)((double)j * pageFormat.getImageableHeight());
                        wd = i == pw - 1 ? this.fullImage.getWidth() - x : (int)pageFormat.getImageableWidth();
                        ht = j == ph - 1 ? this.fullImage.getHeight() - y : (int)pageFormat.getImageableHeight();
                        this.subImages[index] = this.fullImage.getSubimage(x, y, wd, ht);
                    }
                }
                break;
            }
        }
    }

    public void disposeImages() {
        this.fullImage = null;
        this.subImages = null;
        this.split = false;
    }

    public boolean isSplit() {
        return this.split;
    }

    public int getNumberOfPages() {
        if (this.subImages != null) {
            return this.subImages.length;
        }
        return 1;
    }
}

