/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.ImageMapGraphicsImpl;
import java.awt.Component;
import java.awt.Image;
import org.w3c.dom.Element;

public class ImageMap {
    public static final String DEFAULT_MAP_NAME = "SILK_IMAGE_MAP";
    private Image image = null;
    private Element html = null;

    private ImageMap() {
    }

    public static ImageMap generateImageMap(Component c, int width, int height, String mapName) {
        if (c == null) {
            return null;
        }
        if (mapName == null) {
            mapName = DEFAULT_MAP_NAME;
        }
        int oldWidth = c.getWidth();
        int oldHeight = c.getHeight();
        int w = width > 0 ? width : c.getWidth();
        int h = height > 0 ? height : c.getHeight();
        c.setSize(w, h);
        ImageMap rc = new ImageMap();
        rc.image = CopyToClipboard.getImage(c);
        if (c instanceof URLSourceInterface) {
            URLSourceInterface urlSource = (URLSourceInterface)((Object)c);
            ImageMapGraphicsImpl imageMapGraphics = new ImageMapGraphicsImpl(c.getGraphics(), urlSource);
            urlSource.addURLConsumer(imageMapGraphics, imageMapGraphics);
            if (c instanceof BaseComponentInterface) {
                boolean oldBB = ((BaseComponentInterface)((Object)c)).isBackBufferDrawEnabled();
                ((BaseComponentInterface)((Object)c)).setBackBufferDrawEnabled(false);
                c.paint(imageMapGraphics);
                ((BaseComponentInterface)((Object)c)).setBackBufferDrawEnabled(oldBB);
            } else {
                c.paint(imageMapGraphics);
            }
            urlSource.removeURLConsumer(imageMapGraphics);
            rc.html = imageMapGraphics.getImageMapHTML();
            rc.html.setAttribute("name", mapName);
            imageMapGraphics.dispose();
        }
        c.setSize(oldWidth, oldHeight);
        return rc;
    }

    public Image getImage() {
        return this.image;
    }

    public Element getHTML() {
        return this.html;
    }
}

