/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.util.GradientPreviewButton;
import com.sas.graphics.silk.util.ImagePreviewButton;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GraphBackground
implements GraphBackgroundInterface,
PropertyInterface,
ComponentListener {
    private JComponent component;
    private Rectangle rect = null;
    Image backImage;
    private String backgroundStyleReference = "Backfill:fillColor";
    private Style style;
    private Object backgroundObject = Color.lightGray;
    public double imageBlend = 1.0;
    Color backgroundGradientBeginColor = null;
    Color backgroundGradientNeutralColor = null;
    Color backgroundGradientEndColor = null;
    boolean gradientBuilt = false;
    boolean isGradient = false;
    int backgroundGradientOrientation = 0;
    int imageFitStyle;
    Image scaledBackImage;
    int imageX = 0;
    int imageY = 0;
    Toolkit tk = null;
    Color backgroundColor = Color.lightGray;
    Vector previews = new Vector();
    PropertyList pending = new PropertyList();
    boolean visible = true;
    UserSetPropertyBitMask userSetProperties = null;

    public GraphBackground() {
        this((JComponent)null);
    }

    public GraphBackground(JComponent comp) {
        this.component = comp;
        if (this.component != null) {
            this.tk = this.component.getToolkit();
            this.component.addComponentListener(this);
        }
        this.userSetProperties = new UserSetPropertyBitMask(this.getSupportedProperties());
    }

    public GraphBackground(GraphBackgroundInterface backgroundIn) {
        this();
        this.copyFromSource(backgroundIn);
    }

    public GraphBackground(GraphBackgroundInterface backgroundIn, JComponent componentIn) {
        this(componentIn);
        this.copyFromSource(backgroundIn);
    }

    public void setDrawingArea(Rectangle r) {
        this.rect = r;
    }

    public void rebuildBackground() {
        this.setupGradientBackground();
    }

    private void copyFromSource(GraphBackgroundInterface back) {
        if (back == null) {
            return;
        }
        this.backgroundColor = back.getSolidBackground();
        Object[] o = back.getGraphBackground();
        if (o[0] instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)o[0];
            int fit = 0;
            if (o.length > 1 && o[1] instanceof Number) {
                fit = ((Number)o[1]).intValue();
            }
            this.setGradientBackground(gp.getColor1(), gp.getColor2(), new Integer(fit));
        } else if (o[0] instanceof Image) {
            Image i = (Image)o[0];
            String fitStyle = "Stretch";
            if (o.length > 1) {
                fitStyle = o[1].toString();
            }
            int x = 0;
            int y = 0;
            double blend = 0.0;
            if (o.length > 2 && o[2] instanceof Number) {
                blend = ((Number)o[2]).doubleValue();
            }
            this.setImageBackground(i, fitStyle, x, y, blend);
        }
    }

    public void dispose() {
        this.component = null;
        this.backImage = null;
        this.backgroundObject = null;
        this.backgroundGradientBeginColor = null;
        this.backgroundGradientNeutralColor = null;
        this.backgroundGradientEndColor = null;
        this.scaledBackImage = null;
        this.tk = null;
        this.backgroundColor = null;
        this.previews = null;
        this.rect = null;
        this.pending = null;
    }

    @Override
    public Object[] getGraphBackground() {
        Object[] o = null;
        if (this.backImage != null) {
            o = new Object[4];
            if (o == null) {
                return null;
            }
            o[0] = this.backgroundObject != null ? this.backgroundObject : null;
            o[1] = this.backImage;
            o[2] = this.getFitStyleAsString();
            o[3] = new Double(this.imageBlend);
            return o;
        }
        o = new Object[]{this.backgroundObject};
        return o;
    }

    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        this.isGradient = true;
        this.backgroundGradientBeginColor = (Color)startColor;
        this.backgroundGradientEndColor = (Color)endColor;
        if (orientation instanceof Number) {
            this.backgroundGradientOrientation = ((Number)orientation).intValue();
        }
        this.setupGradientBackground();
        this.updatePreviews();
        this.userSetProperties.set(13);
        this.userSetProperties.set(14);
        this.userSetProperties.set(15);
        return true;
    }

    public static int getFitStyleFromString(String str) {
        int rc = 0;
        rc = str.equalsIgnoreCase("Stretch") || str.equalsIgnoreCase("Stretch to fit") ? 0 : (str.equalsIgnoreCase("Tile") ? 1 : (str.equalsIgnoreCase("Center") ? 2 : (str.equalsIgnoreCase("Locate") ? 3 : (str.equalsIgnoreCase("Top Center") ? 4 : (str.equalsIgnoreCase("Top Left") ? 6 : (str.equalsIgnoreCase("Bottom Left") ? 7 : (str.equalsIgnoreCase("Bottom Right") ? 5 : 0)))))));
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        int fit = this.imageFitStyle;
        int flags = 0;
        Image tmp = null;
        if (img == null) {
            this.backImage = null;
            this.scaledBackImage = null;
            this.updatePreviews();
            return true;
        }
        if (fitStyle != null) {
            if (fitStyle instanceof String) {
                fit = GraphBackground.getFitStyleFromString((String)fitStyle);
                if (fit == 3) {
                    this.imageX = x;
                    this.imageY = y;
                }
            } else if (fitStyle instanceof Number) {
                fit = ((Number)fitStyle).intValue();
            }
        }
        if (!Double.isNaN(blend) && !Double.isInfinite(blend)) {
            this.imageBlend = blend;
        }
        if (this.imageBlend < 0.0) {
            this.imageBlend = 0.0;
        } else if (this.imageBlend > 1.0) {
            this.imageBlend = 1.0;
        }
        switch (fit) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.backImage = img;
                this.scaledBackImage = null;
                this.imageFitStyle = fit;
                break;
            }
            case 0: {
                if (this.tk == null) {
                    return false;
                }
                GraphBackground graphBackground = this;
                synchronized (graphBackground) {
                    this.imageFitStyle = fit;
                    this.backImage = img;
                    this.scaledBackImage = null;
                }
                if (this.component.getWidth() <= 0 || this.component.getHeight() <= 0 || (tmp = img.getScaledInstance(this.component.getWidth(), this.component.getHeight(), 1)) == null || ((flags = this.tk.checkImage(img, -1, -1, this.component)) & 0x20) == 0) break;
                this.scaledBackImage = tmp;
            }
        }
        this.updatePreviews();
        this.userSetProperties.set(16);
        this.userSetProperties.set(20);
        this.userSetProperties.set(17);
        this.userSetProperties.set(18);
        this.userSetProperties.set(19);
        return true;
    }

    @Override
    public Color getSolidBackground() {
        if (this.backgroundObject instanceof Color) {
            return (Color)this.backgroundObject;
        }
        return this.backgroundColor;
    }

    @Override
    public boolean setSolidBackground(Object o) {
        this.backgroundObject = o;
        this.userSetProperties.set(21);
        this.updatePreviews();
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
        this.component.repaint();
    }

    @Override
    public boolean supportsGradientBackground() {
        return true;
    }

    @Override
    public boolean supportsImageBackground() {
        return true;
    }

    protected String getFitStyleAsString() {
        return GraphBackground.getFitStyleFromInt(this.imageFitStyle);
    }

    public static String getFitStyleFromInt(int style) {
        String s = null;
        switch (style) {
            case 1: {
                s = "Tile";
                break;
            }
            case 2: {
                s = "Center";
                break;
            }
            case 3: {
                s = "Locate";
                break;
            }
            case 0: {
                s = "Stretch";
                break;
            }
            case 4: {
                s = "Top Center";
                break;
            }
            case 5: {
                s = "Bottom Right";
                break;
            }
            case 6: {
                s = "Top Left";
                break;
            }
            case 7: {
                s = "Bottom Left";
            }
        }
        return s;
    }

    public int getGradientTypeForString(String s) {
        int rc = 0;
        if (s.equalsIgnoreCase("LeftToRight")) {
            rc = 0;
        } else if (s.equalsIgnoreCase("RightToLeft")) {
            rc = 1;
        } else if (s.equalsIgnoreCase("TopToBottom")) {
            rc = 2;
        } else if (s.equalsIgnoreCase("BottomToTop")) {
            rc = 3;
        } else if (s.equalsIgnoreCase("Diagonal")) {
            rc = 4;
        }
        return rc;
    }

    public static String getGradientTypeAsString(int type) {
        String rc = "LeftToRight";
        switch (type) {
            case 0: {
                rc = "LeftToRight";
                break;
            }
            case 1: {
                rc = "RightToLeft";
                break;
            }
            case 2: {
                rc = "TopToBottom";
                break;
            }
            case 3: {
                rc = "BottomToTop";
                break;
            }
            case 4: {
                rc = "Diagonal";
            }
        }
        return rc;
    }

    private void setupGradientBackground() {
        this.gradientBuilt = false;
        if (this.backgroundGradientBeginColor == null || this.backgroundGradientEndColor == null) {
            return;
        }
        Rectangle r = null;
        if (this.rect != null) {
            r = this.rect;
        } else if (this.component != null) {
            r = this.component.getBounds();
        }
        if (r == null) {
            return;
        }
        Point a = null;
        Point b = null;
        switch (this.backgroundGradientOrientation) {
            case 0: {
                a = new Point(r.x, r.y);
                b = new Point(r.x + r.width, r.y);
                break;
            }
            case 1: {
                a = new Point(r.x + r.width, r.y);
                b = new Point(r.x, r.y);
                break;
            }
            case 2: {
                a = new Point(r.x, r.y);
                b = new Point(r.x, r.y + r.height);
                break;
            }
            case 3: {
                a = new Point(r.x, r.y + r.height);
                b = new Point(r.x, r.y);
                break;
            }
            case 4: {
                a = new Point(r.x, r.y);
                b = new Point(r.x + r.width, r.y + r.height);
            }
        }
        this.backgroundObject = new GradientPaint(a.x, a.y, this.backgroundGradientBeginColor, b.x, b.y, this.backgroundGradientEndColor);
        if (this.component != null) {
            this.gradientBuilt = true;
        }
    }

    public void drawBackground(Graphics2D g2) {
        this.drawBackground(g2, this.component);
    }

    public void drawBackground(Graphics2D g2, Component component) {
        if (component == null || !this.visible) {
            return;
        }
        Rectangle r = component.getBounds();
        this.drawBackground(g2, component, new Rectangle(0, 0, r.width, r.height));
    }

    public void drawBackground(Graphics2D g2, Component component, Rectangle rect) {
        Composite c;
        block32: {
            Rectangle r;
            block31: {
                c = null;
                if (rect == null) {
                    return;
                }
                r = rect;
                if (!this.visible) {
                    return;
                }
                if (this.isGradient && !this.gradientBuilt) {
                    this.setupGradientBackground();
                }
                if (g2 != null && this.imageBlend > 0.0) {
                    if (this.backgroundObject instanceof Color) {
                        g2.setColor((Color)this.backgroundObject);
                    } else if (this.backgroundObject instanceof GradientPaint) {
                        g2.setPaint((Paint)this.backgroundObject);
                    } else {
                        g2.setColor(this.backgroundColor);
                    }
                    g2.fillRect(r.x, r.y, r.width, r.height);
                    c = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, (float)this.imageBlend));
                }
                if (this.backImage == null) break block31;
                switch (this.imageFitStyle) {
                    default: {
                        break;
                    }
                    case 0: {
                        if (this.scaledBackImage != null) {
                            g2.drawImage(this.scaledBackImage, 0, 0, component);
                            break;
                        }
                        break block32;
                    }
                    case 1: {
                        int w = this.backImage.getWidth(component);
                        int h = this.backImage.getHeight(component);
                        if (w > 0) {
                            if (h <= 0) break;
                            for (int iy = 0; iy < component.getHeight(); iy += h) {
                                for (int ix = 0; ix < component.getWidth(); ix += w) {
                                    g2.drawImage(this.backImage, ix, iy, component);
                                }
                            }
                        }
                        break block32;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        int ix;
                        int iy;
                        int h = this.backImage.getHeight(component);
                        int w = this.backImage.getWidth(component);
                        if (this.imageFitStyle == 4) {
                            iy = 0;
                            ix = w > 0 ? (component.getWidth() - w) / 2 : 0;
                        } else if (this.imageFitStyle == 6) {
                            ix = 0;
                            iy = 0;
                        } else if (this.imageFitStyle == 5) {
                            iy = h > 0 ? component.getHeight() - h : 0;
                            ix = w > 0 ? component.getWidth() - w : 0;
                        } else if (this.imageFitStyle == 7) {
                            iy = h > 0 ? component.getHeight() - h : 0;
                            ix = 0;
                        } else {
                            ix = w > 0 ? (component.getWidth() - w) / 2 : 0;
                            iy = h > 0 ? (component.getHeight() - h) / 2 : 0;
                        }
                        g2.drawImage(this.backImage, ix, iy, component);
                        break;
                    }
                }
                break block32;
            }
            if (this.backgroundObject != null) {
                if (this.backgroundObject instanceof Color) {
                    g2.setColor((Color)this.backgroundObject);
                } else if (this.backgroundObject instanceof GradientPaint) {
                    g2.setPaint((Paint)this.backgroundObject);
                }
                g2.fillRect(r.x, r.y, r.width, r.height);
            } else {
                g2.setColor(this.backgroundColor);
                g2.fillRect(r.x, r.y, r.width, r.height);
            }
        }
        if (c != null && g2 != null) {
            g2.setComposite(c);
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void addPreviewPanel(JPanel p) {
        if (p != null && !this.previews.contains(p)) {
            this.previews.addElement(p);
        }
    }

    public void updatePreviews() {
        for (int i = 0; i < this.previews.size(); ++i) {
            JPanel panel = (JPanel)this.previews.elementAt(i);
            panel.removeAll();
            if (this.backImage != null) {
                ImagePreviewButton b = new ImagePreviewButton();
                panel.setLayout(new BorderLayout());
                panel.add("Center", b);
                b.setImage(this.backImage);
                continue;
            }
            if (this.backgroundObject instanceof GradientPaint) {
                GradientPreviewButton g = new GradientPreviewButton();
                panel.setLayout(new BorderLayout());
                panel.add("Center", g);
                g.setGradientBackground((GradientPaint)this.backgroundObject);
                continue;
            }
            panel.setBackground((Color)this.backgroundObject);
        }
    }

    public int[] getSupportedProperties() {
        return new int[]{9, 13, 14, 15, 16, 17, 20, 18, 19, 10, 22, 21, 11, 12, 0, 66};
    }

    public boolean isPropertySupported(int id) {
        return id == 9 || id == 13 || id == 14 || id == 15 || id == 16 || id == 17 || id == 20 || id == 18 || id == 19 || id == 10 || id == 22 || id == 21 || id == 11 || id == 12 || id == 0 || id == 66;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public Object getPropertyValue(int id) {
        Object rc = null;
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 9: 
            case 10: {
                rc = this.getGraphBackground();
                break;
            }
            case 11: {
                rc = new Boolean(true);
                break;
            }
            case 12: {
                rc = new Boolean(true);
                break;
            }
            case 13: {
                rc = this.backgroundGradientBeginColor;
                break;
            }
            case 14: {
                rc = this.backgroundGradientEndColor;
                break;
            }
            case 15: {
                rc = new Integer(this.backgroundGradientOrientation);
                break;
            }
            case 16: {
                rc = this.backImage;
                break;
            }
            case 17: {
                rc = new Integer(this.imageFitStyle);
                break;
            }
            case 18: {
                rc = new Integer(this.imageX);
                break;
            }
            case 19: {
                rc = new Integer(this.imageY);
                break;
            }
            case 20: {
                rc = new Double(this.imageBlend);
                break;
            }
            case 21: {
                if (this.backgroundObject instanceof Color) {
                    rc = this.backgroundObject;
                    break;
                }
                rc = this.backgroundColor;
                break;
            }
            case 66: {
                rc = new Boolean(this.visible);
            }
        }
        return rc;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (!this.isPropertySupported(id)) {
            return false;
        }
        this.pending.store(id, value);
        return true;
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Integer fit;
        boolean imageParamsChanged = false;
        Object fitStyle = null;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        block12: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 13: {
                    if (value != null && value instanceof Color) {
                        this.backgroundGradientBeginColor = (Color)value;
                    }
                    this.userSetProperties.set(13);
                    this.setupGradientBackground();
                    continue block12;
                }
                case 14: {
                    if (value != null && value instanceof Color) {
                        this.backgroundGradientEndColor = (Color)value;
                    }
                    this.userSetProperties.set(14);
                    this.setupGradientBackground();
                    continue block12;
                }
                case 15: {
                    if (value != null && value instanceof Integer) {
                        this.backgroundGradientOrientation = (Integer)value;
                    } else if (value != null && value instanceof String) {
                        this.backgroundGradientOrientation = this.getGradientTypeForString(value.toString());
                    }
                    this.userSetProperties.set(15);
                    this.setupGradientBackground();
                    continue block12;
                }
                case 16: {
                    this.backImage = (Image)value;
                    imageParamsChanged = true;
                    this.userSetProperties.set(16);
                    continue block12;
                }
                case 17: {
                    if (value != null && value instanceof String) {
                        fitStyle = (String)value;
                    }
                    if (value != null && value instanceof Integer) {
                        this.imageFitStyle = (Integer)value;
                    }
                    this.userSetProperties.set(17);
                    imageParamsChanged = true;
                    continue block12;
                }
                case 18: {
                    if (value != null && value instanceof Integer) {
                        this.imageX = (Integer)value;
                    }
                    this.userSetProperties.set(18);
                    imageParamsChanged = true;
                    continue block12;
                }
                case 19: {
                    if (value != null && value instanceof Integer) {
                        this.imageY = (Integer)value;
                    }
                    this.userSetProperties.set(19);
                    imageParamsChanged = true;
                    continue block12;
                }
                case 20: {
                    if (value != null && value instanceof Double) {
                        this.imageBlend = (Double)value;
                    }
                    this.userSetProperties.set(20);
                    imageParamsChanged = true;
                    continue block12;
                }
                case 21: {
                    if (value instanceof Color) {
                        this.backgroundColor = (Color)value;
                        this.backgroundObject = (Color)value;
                        this.userSetProperties.set(21);
                        continue block12;
                    }
                    if (value == null) continue block12;
                    this.backgroundStyleReference = value.toString();
                    this.backgroundColor = GraphBackground.resolveBackgroundStyleReference(this.style, this.backgroundStyleReference);
                    this.backgroundObject = this.backgroundColor;
                    this.userSetProperties.set(21);
                    continue block12;
                }
                case 66: {
                    if (!(value instanceof Boolean)) continue block12;
                    this.setVisible((Boolean)value);
                    this.userSetProperties.set(66);
                }
            }
        }
        this.pending.removeChangesBySource(source);
        Integer n = fit = fitStyle == null ? new Integer(this.imageFitStyle) : fitStyle;
        if (imageParamsChanged) {
            this.setImageBackground(this.backImage, fit, this.imageX, this.imageY, this.imageBlend);
        }
        return true;
    }

    public static Color resolveBackgroundStyleReference(Style style, String reference) {
        Color rc = null;
        if (style == null) {
            style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        }
        if (reference == null) {
            reference = "Backfill:fillColor";
        }
        if (reference.indexOf(58) < 0) {
            rc = ColorParse.getColorFromString((String)reference);
        } else {
            String context = reference.substring(0, reference.indexOf(58));
            StyleElement se = style.getStyleElement(context);
            if (se != null) {
                rc = se.getColorAttribute(reference.substring(reference.indexOf(58) + 1), null);
            }
        }
        if (rc == null) {
            rc = style.getFillStyleElement("Backfill").getFillColor();
        }
        return rc;
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    public void setCurrentValueAsDefault(int id) {
        this.userSetProperties.clear(id);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.gradientBuilt = false;
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    public String getBackgroundStyleReference() {
        return this.backgroundStyleReference;
    }

    public void setBackgroundStyleReference(String backgroundStyleReference) {
        this.backgroundStyleReference = backgroundStyleReference;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }
}

