/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JButton;

public class GradientPreviewButton
extends JButton {
    private static final long serialVersionUID = -9087797132461188290L;
    public static final int CONSTANT_COLOR = 0;
    public static final int COLOR_TO_DARKER = 1;
    public static final int COLOR_TO_LIGHTER = 2;
    public static final int COLOR_TO_CUSTOM = 3;
    protected Color color1 = this.getBackground();
    protected Color color2 = null;
    protected int direction = 0;
    protected int type = 0;
    protected double shading = 0.5;
    protected GradientPaint gp = null;
    protected float[] hsb1 = new float[3];
    protected float[] hsb2 = new float[3];

    public GradientPreviewButton() {
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setSize(464, 280);
    }

    protected static boolean colorsAreEqual(Color c1, Color c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        return r1 == r2 && g1 == g2 && b1 == b2;
    }

    protected Color getColor(Color start, Color end, int type, double shade) {
        double s = shade;
        Color c = end;
        if (start == null) {
            return null;
        }
        if (Double.isNaN(s)) {
            return start;
        }
        if (s < 0.0) {
            s = 0.0;
        } else if (s > 1.0) {
            s = 1.0;
        }
        int r = start.getRed();
        int g = start.getGreen();
        int b = start.getBlue();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                r -= (int)((double)r * shade);
                g -= (int)((double)g * shade);
                b -= (int)((double)b * shade);
                break;
            }
            case 2: {
                r += (int)((double)r * shade);
                g += (int)((double)g * shade);
                b += (int)((double)b * shade);
                break;
            }
            case 3: {
                if (c == null) {
                    c = start;
                }
                r = c.getRed();
                g = c.getGreen();
                b = c.getBlue();
            }
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    protected int getDirectionFromPoints(Point2D p1, Point2D p2) {
        int direction = 0;
        if (p1 != null && p2 != null) {
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            if (x1 < x2 && y1 < y2) {
                direction = 4;
            } else if (y1 == y2) {
                direction = x1 < x2 ? 0 : 1;
            } else if (x1 == x2) {
                direction = y1 < y2 ? 2 : 3;
            }
        }
        return direction;
    }

    protected int getTypeFromColors(Color c1, Color c2) {
        if (c1 == null || c2 == null) {
            return 0;
        }
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        Color.RGBtoHSB(r1, g1, b1, this.hsb1);
        Color.RGBtoHSB(r2, g2, b2, this.hsb2);
        int hue1 = Math.round(this.hsb1[0] * 100.0f);
        int hue2 = Math.round(this.hsb2[0] * 100.0f);
        int sat1 = Math.round(this.hsb1[1] * 100.0f);
        int sat2 = Math.round(this.hsb2[1] * 100.0f);
        if (hue1 == hue2 && sat1 == sat2) {
            if (this.hsb1[2] < this.hsb2[2]) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    protected void syncWithGradientPaint() {
        Point2D p1 = null;
        Point2D p2 = null;
        if (this.gp == null) {
            this.color1 = this.getBackground();
            this.color2 = null;
            return;
        }
        p1 = this.gp.getPoint1();
        p2 = this.gp.getPoint2();
        this.color1 = this.gp.getColor1();
        this.color2 = this.gp.getColor2();
        this.direction = this.getDirectionFromPoints(p1, p2);
        this.type = this.getTypeFromColors(this.color1, this.color2);
    }

    protected GradientPaint createPaint(Color c1In, Color c2In, int typ, double shade, int dir, int x, int y, int wIn, int hIn) {
        float y2;
        float y1;
        float x1;
        float x2;
        int w = wIn;
        int h = hIn;
        Color c1 = c1In;
        Color c2 = c2In;
        if (w < 0 || h <= 0) {
            return null;
        }
        if (c1 == null && (c1 = this.color1) == null) {
            return null;
        }
        if (c2 == null && (c2 = this.color2) == null) {
            return null;
        }
        if (dir < 0) {
            dir = this.direction;
        }
        if (shade < 0.0) {
            shade = this.shading;
        }
        if ((c2 = this.getColor(c1, c2, typ, shade)) == null) {
            return null;
        }
        switch (dir) {
            case 2: {
                x1 = x2 = (float)(w / 2);
                y1 = y;
                y2 = h;
                break;
            }
            case 3: {
                x1 = x2 = (float)(w / 2);
                y1 = h;
                y2 = y;
                break;
            }
            case 0: {
                x1 = x;
                x2 = w;
                y1 = y2 = (float)(h / 2);
                break;
            }
            case 1: {
                x1 = w;
                x2 = x;
                y1 = y2 = (float)(h / 2);
                break;
            }
            case 4: {
                x1 = x;
                y1 = y;
                x2 = w;
                y2 = h;
                break;
            }
            default: {
                return null;
            }
        }
        GradientPaint rc = new GradientPaint(x1, y1, c1, x2, y2, c2);
        return rc;
    }

    protected GradientPaint createPaint(Color c1In, Color c2In, int typ, double shade, int dir) {
        Rectangle rect = this.getBounds();
        if (rect == null) {
            return null;
        }
        return this.createPaint(c1In, c2In, typ, shade, dir, rect.x, rect.y, rect.width, rect.height);
    }

    protected GradientPaint createPaint(int x, int y, int width, int height, GradientPaint gpNew) {
        int dir = this.direction;
        Color c1 = this.color1;
        Color c2 = this.color2;
        Point2D p1 = null;
        Point2D p2 = null;
        if (gpNew != null) {
            c1 = gpNew.getColor1();
            c2 = gpNew.getColor2();
            p1 = gpNew.getPoint1();
            p2 = gpNew.getPoint2();
            dir = this.getDirectionFromPoints(p1, p2);
            this.type = this.getTypeFromColors(c1, c2);
        }
        GradientPaint rc = this.createPaint(c1, c2, this.type, this.shading, dir, x, y, width, height);
        return rc;
    }

    public boolean setGradientBackground(GradientPaint gpNew) {
        boolean status = false;
        Rectangle rect = null;
        if (gpNew == null) {
            return status;
        }
        rect = this.getBounds();
        if (rect == null) {
            return status;
        }
        Color c1 = gpNew.getColor1();
        this.gp = this.createPaint(rect.x, rect.y, rect.width, rect.height, gpNew);
        if (this.gp == null) {
            this.setBackground(c1);
        } else {
            status = true;
        }
        if (status) {
            this.syncWithGradientPaint();
        }
        return status;
    }

    public Color getColor1() {
        if (this.color1 == null) {
            return this.getBackground();
        }
        return this.color1;
    }

    public boolean setColor1(Color c) {
        if (c == null) {
            return false;
        }
        if (GradientPreviewButton.colorsAreEqual(c, this.color1)) {
            return true;
        }
        this.color1 = c;
        if (this.gp == null) {
            this.setBackground(c);
            return true;
        }
        this.color2 = this.getColor(this.color1, this.color2, this.type, this.shading);
        this.gp = this.createPaint(this.color1, this.color2, this.type, this.shading, this.direction);
        return true;
    }

    public Color getColor2() {
        return this.color2;
    }

    public boolean setColor2(Color c) {
        if (c == null) {
            this.gp = null;
            this.color2 = null;
            this.type = 0;
            return true;
        }
        if (GradientPreviewButton.colorsAreEqual(c, this.color2)) {
            return true;
        }
        this.color2 = c;
        this.type = this.getTypeFromColors(this.color1, this.color2);
        this.gp = this.createPaint(this.color1, this.color2, this.type, this.shading, this.direction);
        return true;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean setDirection(int dir) {
        if (dir == this.direction) {
            return true;
        }
        switch (dir) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        this.direction = dir;
        this.gp = this.createPaint(this.color1, this.color2, this.type, this.shading, dir);
        return true;
    }

    public int getType() {
        return this.type;
    }

    public boolean setType(int typeIn) {
        if (typeIn == this.type) {
            return true;
        }
        switch (typeIn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        this.type = typeIn;
        this.color2 = this.getColor(this.color1, this.color2, this.type, this.shading);
        this.gp = this.createPaint(this.color1, this.color2, this.type, this.shading, this.direction);
        return true;
    }

    public double getShading() {
        return this.shading;
    }

    public boolean setShading(double shadingIn) {
        if (Double.isNaN(shadingIn)) {
            return false;
        }
        this.shading = shadingIn;
        if (this.shading < 0.0) {
            this.shading = 0.0;
        } else if (this.shading > 1.0) {
            this.shading = 1.0;
        }
        if (this.type == 1 || this.type == 2) {
            this.color2 = this.getColor(this.color1, this.color2, this.type, this.shading);
            this.gp = this.createPaint(this.color1, this.color2, this.type, this.shading, this.direction);
        }
        return true;
    }

    GradientPaint getPaint() {
        return this.gp;
    }

    public void setPaint(Object p) {
        if (p == null) {
            this.gp = null;
        } else {
            if (p instanceof Color) {
                this.color1 = (Color)p;
                this.color2 = null;
                this.type = 0;
                this.gp = null;
                this.setBackground((Color)p);
                return;
            }
            if (p instanceof GradientPaint) {
                this.setGradientBackground((GradientPaint)p);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rect = this.getBounds();
        if (g != null && g instanceof Graphics2D && rect != null) {
            if (this.gp != null) {
                ((Graphics2D)g).setPaint(this.gp);
            } else if (this.color1 != null) {
                g.setColor(this.color1);
            }
            g.fillRect(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
        } else {
            super.paintComponent(g);
        }
    }
}

