/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.util.Extract;
import com.sas.text.SASFormat;

public class FormatCheck {
    public static double roundDecimals(double value, int ndecimals) {
        long mult = 1L;
        if (Double.isInfinite(value) || Double.isNaN(value) || ndecimals < 0) {
            return value;
        }
        for (long i = 0L; i < (long)ndecimals; ++i) {
            mult *= 10L;
        }
        long v = (long)(value * (double)mult * 10.0);
        long last = v % 10L;
        if (last >= 5L) {
            v += 5L;
        }
        return (double)(v /= 10L) / (double)mult;
    }

    public static int getNumberDecimals(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return -1;
        }
        String s = Double.toString(d);
        return FormatCheck.getNumberDecimals(s);
    }

    protected static int getMinusExponent(String s) {
        int extra = 0;
        if (s == null) {
            return 0;
        }
        try {
            extra = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            extra = 0;
        }
        if (extra >= 0) {
            return 0;
        }
        return -extra;
    }

    protected static int getNumberDecimals(String s) {
        int n;
        int extra = 0;
        if (s == null || (n = s.length()) <= 0) {
            return -1;
        }
        int i = s.indexOf(46);
        if (i < 0) {
            return 0;
        }
        int i2 = s.indexOf(69);
        if (i2 >= 0) {
            extra = FormatCheck.getMinusExponent(s.substring(i2 + 1));
            n = i2;
        } else {
            i2 = s.indexOf(101);
            if (i2 >= 0) {
                extra = FormatCheck.getMinusExponent(s.substring(i2 + 1));
                n = i2;
            }
        }
        while (s.charAt(n - 1) == '0') {
            --n;
        }
        return n - i - 1 + extra;
    }

    protected static int getNumberPower(String s) {
        int n;
        if (s == null || (n = s.length()) <= 0) {
            return -1;
        }
        int i = s.indexOf(69);
        if (i < 0 && (i = s.indexOf(101)) < 0) {
            return 0;
        }
        return n - i;
    }

    protected static int getNumberWhole(String s) {
        char c;
        int i2;
        int i;
        int n;
        if (s == null || (n = s.length()) <= 0) {
            return -1;
        }
        for (i = 0; i < n && s.charAt(i) == '0'; ++i) {
        }
        if (i == n) {
            return 1;
        }
        for (i2 = i; i2 < n && (c = s.charAt(i2)) != '.' && c != 'E' && c != 'e'; ++i2) {
        }
        return Math.max(i2 - i, 1);
    }

    protected static boolean getValues(double d, int[] out) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return false;
        }
        if (d == 0.0) {
            out[0] = 1;
            out[1] = 0;
            out[2] = 0;
            return true;
        }
        String s = Double.toString(d);
        if (s == null || s.length() <= 0) {
            return false;
        }
        out[1] = FormatCheck.getNumberDecimals(s);
        out[0] = FormatCheck.getNumberWhole(s);
        out[2] = FormatCheck.getNumberPower(s);
        return true;
    }

    public static SASFormat getFormat(Object list, int n, int maxDecimals, int maxWidth, boolean revertToBest) {
        int maxd = 0;
        int maxw = 1;
        int maxp = 0;
        SASFormat fmt = null;
        if (list == null) {
            return null;
        }
        int type = Extract.getSourceType((Object)list);
        int nValues = Extract.getNumberItems((Object)list, (int)type);
        if (nValues <= 0) {
            return null;
        }
        int[] wd = new int[3];
        if (n > 0) {
            nValues = n;
        }
        for (int i = 0; i < nValues; ++i) {
            if (!FormatCheck.getValues(Extract.getNumeric((Object)list, (int)i, (int)type), wd)) continue;
            if (wd[0] > maxw) {
                maxw = wd[0];
            }
            if (wd[1] > maxd) {
                maxd = wd[1];
            }
            if (wd[2] <= maxp) continue;
            maxp = wd[2];
        }
        if (maxDecimals >= 0 && maxd > maxDecimals) {
            if (revertToBest) {
                return SASFormat.getInstance((String)"BEST");
            }
            maxd = maxDecimals;
        }
        maxw = maxw + maxd + 1 + maxp;
        if (maxWidth > 0 && maxw > maxWidth) {
            if (revertToBest) {
                return SASFormat.getInstance((String)"BEST");
            }
            maxw = maxWidth;
        }
        if ((fmt = SASFormat.getInstance((String)"F", (int)maxw, (int)maxd)) == null && revertToBest) {
            fmt = SASFormat.getInstance((String)"BEST");
        }
        return fmt;
    }
}

