/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.text.SASFormat;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ExcelAdapter
implements ActionListener {
    private JTable jTable1;
    public static final int COPY_NON_SELECTED_OBS = -1;
    public static final int COPY_ALL_OBS = 0;
    public static final int COPY_SELECTED_OBS = 1;

    public ExcelAdapter(JTable myJTable) {
        this.jTable1 = myJTable;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.jTable1.registerKeyboardAction(this, "Copy", copy, 0);
    }

    public JTable getJTable() {
        return this.jTable1;
    }

    public void setJTable(JTable jTable1) {
        this.jTable1 = jTable1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ExcelAdapter.toClipboard(this.jTable1);
    }

    public static void toClipboard(Object source) {
        ExcelAdapter.toClipboard(source, true, 0);
    }

    public static void toClipboard(Object source, boolean format, int selected) {
        int i;
        StringBuffer sbf = new StringBuffer();
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)source);
        if (dfri == null && source instanceof SourceInterface) {
            dfri = FilterFactory.getDataSourceFilter((Object)((SourceInterface)source).getDataSource());
        }
        if (dfri == null) {
            return;
        }
        int numcols = dfri.getNumberVariables();
        int numrows = dfri.getNumberObservations(null);
        for (i = 0; i < numcols; ++i) {
            sbf.append(dfri.getVariableId(i));
            if (i >= numcols - 1) continue;
            sbf.append("\t");
        }
        sbf.append("\n");
        for (i = 0; i < numrows; ++i) {
            boolean sel = dfri.isSelected((long)i);
            if (!sel && selected == 1 || sel && selected == -1) continue;
            for (int j = 0; j < numcols; ++j) {
                Object variableId = dfri.getVariableId(j);
                Object fmt = dfri.getFormat(variableId, SASFormat.class);
                if (format) {
                    sbf.append(dfri.getFormattedValue(variableId, (long)i, fmt));
                } else {
                    Object o = dfri.getValue(j, (long)i);
                    if (o instanceof Number && Double.isNaN(((Number)o).doubleValue())) {
                        sbf.append(".");
                    } else {
                        sbf.append(o);
                    }
                }
                if (j >= numcols - 1) continue;
                sbf.append("\t");
            }
            sbf.append("\n");
        }
        StringSelection stsel = new StringSelection(sbf.toString());
        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
        system.setContents(stsel, stsel);
    }
}

