/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class CompoundText
implements TextListenerInterface,
RenderInterface,
PropertyInterface {
    protected static final int TOP_TO_BOTTOM = 0;
    protected static final int BOTTOM_TO_TOP = 1;
    protected Color color;
    protected Rectangle compBounds;
    protected int direction;
    protected TextStyleInterface[] texts;
    protected Rectangle bounds;
    protected boolean updateBounds;
    protected boolean update;
    protected Vector listeners;
    protected boolean visible;
    protected double opacity;
    protected boolean[] userSetFont;
    protected boolean[] hide;
    protected Font[] defaultFonts;
    protected Color backgroundColor = Color.gray;

    public CompoundText(Color c, int maxNum, int dir) {
        int i;
        this.color = c;
        this.direction = dir;
        this.texts = new Text[maxNum];
        for (i = 0; i < this.texts.length; ++i) {
            this.texts[i] = new Text();
            ((Text)this.texts[i]).setPropertyValue(9018, "TitleText");
            ((Text)this.texts[i]).applyPropertyChanges();
            ((Text)this.texts[i]).addTextListener(this);
            if (this.direction == 1) {
                this.texts[i].setJustification(1, 0);
            } else {
                this.texts[i].setJustification(this.texts[i].getHorizontalJustification(), 8);
            }
            ((Text)this.texts[i]).setCurrentValueAsDefault(9006);
            ((Text)this.texts[i]).setCurrentValueAsDefault(9007);
        }
        this.bounds = new Rectangle();
        this.updateBounds = true;
        this.update = true;
        this.listeners = new Vector();
        this.visible = true;
        this.opacity = 1.0;
        this.userSetFont = new boolean[maxNum];
        this.hide = new boolean[maxNum];
        this.defaultFonts = new Font[maxNum];
        for (i = 0; i < maxNum; ++i) {
            this.userSetFont[i] = false;
            this.hide[i] = false;
        }
    }

    public CompoundText(int maxNum, int dir) {
        this(null, maxNum, dir);
    }

    @Override
    public void textUpdated(DvrTextEvent pce) {
        for (int i = 0; i < this.texts.length; ++i) {
            if (this.texts[i] != pce.source || this.defaultFonts[i] == null || this.texts[i].getFont() == null || this.texts[i].getFont().equals(this.defaultFonts[i])) continue;
            this.userSetFont[i] = true;
        }
        this.updateBounds = true;
        this.fireUpdatingEvent();
    }

    public void setColor(Color c) {
        if (c == null) {
            return;
        }
        this.color = c;
        for (int i = 0; i < this.texts.length; ++i) {
            if (this.texts[i] == null) continue;
            this.texts[i].setColor(this.color);
        }
        this.fireUpdatingEvent();
    }

    public void setComponentBounds(Rectangle bounds) {
        if (bounds == null) {
            return;
        }
        this.compBounds = bounds;
        for (int i = 0; i < this.texts.length; ++i) {
            if (this.texts[i] != null && !this.userSetFont[i]) {
                Font ft = this.texts[i].getFont();
                int newSize = this.getFontSize(i, ft.getSize());
                if (newSize > 0) {
                    Font new_ft = FontManager.getFont((String)ft.getName(), (int)ft.getStyle(), (int)newSize);
                    this.texts[i].setFont(new_ft);
                    ((Text)this.texts[i]).setCurrentValueAsDefault(9002);
                    this.hide[i] = false;
                    this.defaultFonts[i] = new_ft;
                    continue;
                }
                this.hide[i] = true;
                continue;
            }
            if (this.texts[i] == null) continue;
            this.hide[i] = false;
        }
        this.updateBounds = true;
    }

    public void setComponentBounds(int x, int y, int width, int height) {
        this.setComponentBounds(new Rectangle(x, y, width, height));
    }

    public TextStyleInterface getText(int idx) {
        if (idx < 0 || idx >= this.texts.length) {
            return null;
        }
        return this.texts[idx];
    }

    public boolean setText(int idx, TextStyleInterface textObj) {
        if (idx < 0 || idx >= this.texts.length) {
            return false;
        }
        this.texts[idx] = textObj;
        if (textObj != null && textObj instanceof Text && ((Text)textObj).isDefaultFont()) {
            this.userSetFont[idx] = false;
            if (this.compBounds != null) {
                Font def_ft = textObj.getFont();
                int newSize = this.getFontSize(idx, def_ft.getSize());
                if (newSize > 0) {
                    Font new_ft = FontManager.getFont((String)def_ft.getName(), (int)def_ft.getStyle(), (int)newSize);
                    textObj.setFont(new_ft);
                    this.hide[idx] = false;
                    this.defaultFonts[idx] = new_ft;
                } else {
                    this.hide[idx] = true;
                }
            }
        } else if (textObj != null) {
            this.hide[idx] = false;
        }
        if (this.texts[idx] instanceof Text) {
            ((Text)this.texts[idx]).removeTextListener(this);
            ((Text)this.texts[idx]).addTextListener(this);
        }
        this.updateBounds = true;
        this.fireUpdatingEvent();
        return true;
    }

    public boolean setText(int idx, String textString) {
        Text textObj = null;
        if (this.texts != null && this.texts.length > idx) {
            textObj = new Text(this.texts[idx]);
            textObj.setVisible(true);
            textObj.setFormatSupported(false);
            textObj.setText(textString);
        } else {
            textObj = new Text(textString);
        }
        if (this.color != null) {
            textObj.setColor(this.color);
        }
        return this.setText(idx, textObj);
    }

    public Rectangle getBounds() {
        if (!this.updateBounds) {
            return this.bounds;
        }
        this.updateBounds = false;
        FontRenderContext frc = new FontRenderContext(null, false, false);
        double wt = 0.0;
        double ht = 0.0;
        for (int i = 0; i < this.texts.length; ++i) {
            if (this.texts[i] == null || this.texts[i].getText() == null || this.texts[i].getTextString().trim().equals("") || !this.texts[i].isVisible() || this.hide[i]) continue;
            Font f = this.texts[i].getFont();
            f = f.deriveFont((float)SILKUtilities.adjustFontSize(f.getSize()));
            TextLayout textString = new TextLayout(this.texts[i].getTextString(), f, frc);
            Rectangle2D b = textString.getBounds();
            wt = Math.max(wt, b.getWidth());
            int height = (int)(textString.getAscent() + textString.getDescent() + textString.getLeading());
            if (this.compBounds != null && b.getWidth() > (double)this.compBounds.width) {
                ht += (double)(2 * height);
                continue;
            }
            ht += (double)height;
        }
        this.bounds.x = 0;
        this.bounds.y = 0;
        this.bounds.width = (int)wt;
        this.bounds.height = (int)ht;
        return this.bounds;
    }

    public boolean isUpdatingEnabled() {
        return this.update;
    }

    public void setUpdatingEnabled(boolean b) {
        this.update = b;
    }

    public void addTextListener(TextListenerInterface listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeTextListener(TextListenerInterface listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.removeElement(listener);
        }
    }

    protected void fireUpdatingEvent() {
        if (!this.update) {
            return;
        }
        DvrTextEvent evt = new DvrTextEvent(this);
        if (this.updateBounds) {
            Rectangle oldB = new Rectangle(this.bounds);
            this.bounds = this.getBounds();
            if (!this.bounds.equals(oldB)) {
                evt.isBoundsChanged = true;
            }
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TextListenerInterface listener = (TextListenerInterface)this.listeners.elementAt(i);
            listener.textUpdated(evt);
        }
    }

    protected int getFontSize(int idx, int originalSize) {
        if (UIUtilities.useStyleFontSizes()) {
            return originalSize;
        }
        return (int)((double)this.compBounds.height * 0.03);
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (!this.visible) {
            return;
        }
        if (p == null || this.compBounds == null || this.compBounds.width <= 0 || this.compBounds.height <= 0) {
            return;
        }
        if (this.updateBounds) {
            this.getBounds();
        }
        if (this.bounds.height == 0 || this.bounds.width == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        FontRenderContext frc = g.getFontRenderContext();
        double tx = 0.0;
        double y = this.direction == 0 ? (double)this.compBounds.y : (double)(this.compBounds.y + this.compBounds.height - this.bounds.height);
        for (int i = 0; i < this.texts.length; ++i) {
            double ty;
            if (this.texts[i] == null || this.texts[i].getText() == null || this.texts[i].getTextString().trim().equals("") || !this.texts[i].isVisible() || this.hide[i]) continue;
            Font original = this.texts[i].getFont();
            Font textFont = original.deriveFont((float)SILKUtilities.adjustFontSize(original.getSize()));
            TextLayout textString = new TextLayout(this.texts[i].getTextString(), textFont, frc);
            int j = this.texts[i].getHorizontalJustification();
            switch (j) {
                case 1: {
                    tx = this.compBounds.x;
                    break;
                }
                case 2: {
                    tx = this.compBounds.x + this.compBounds.width;
                    break;
                }
                case 0: {
                    tx = (double)this.compBounds.x + (double)this.compBounds.width * 0.5;
                }
            }
            if (this.texts[i] instanceof Text) {
                Text t = (Text)this.texts[i];
                Rectangle2D r = textString.getBounds();
                this.texts[i].setJustification(j, 8);
                ty = y + (double)textString.getAscent() - (double)textString.getDescent();
                if ((double)this.compBounds.width < r.getWidth()) {
                    String[] wrapped = t.wrap(t.getTextString(), this.compBounds.width, 2, g.getFontRenderContext());
                    t.drawText(g, wrapped[0], new Point((int)tx, (int)ty), SILKUtilities.useGraphEngraving(), this.backgroundColor);
                    if (wrapped.length > 1) {
                        ty = (y += (double)((int)(textString.getAscent() + textString.getDescent() + textString.getLeading()))) + (double)textString.getAscent() - (double)textString.getDescent();
                        t.drawText(g, wrapped[1], new Point((int)tx, (int)ty), SILKUtilities.useGraphEngraving(), this.backgroundColor);
                    }
                } else {
                    t.drawText(g, this.texts[i].getTextString(), new Point((int)tx, (int)ty), SILKUtilities.useGraphEngraving(), this.backgroundColor);
                }
            } else {
                ty = y + (double)textString.getAscent();
                g.setColor(this.texts[i].getColor());
                textString.draw(g, (int)tx, (int)ty);
            }
            y += (double)((int)(textString.getAscent() + textString.getDescent() + textString.getLeading()));
        }
    }

    @Override
    public void drawHighlight(Object p) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void applyStyle(Style style) {
        if (style == null) {
            return;
        }
        for (int i = 0; i < this.texts.length; ++i) {
            if (this.texts[i] == null) continue;
            ((Text)this.texts[i]).applyStyle(style);
        }
        FillStyleElement fse = style.getFillStyleElement("Backfill");
        this.setBackgroundColor(fse.getFillColor());
    }

    public boolean isTextEngraved() {
        return SILKUtilities.useGraphEngraving();
    }

    public void setTextEngraved(boolean textEngraved) {
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.texts == null) {
            return true;
        }
        boolean rc = false;
        for (int i = 0; i < this.texts.length; ++i) {
            if (!(this.texts[i] instanceof PropertyInterface)) continue;
            rc |= ((PropertyInterface)this.texts[i]).applyPropertyChanges(source);
        }
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        if (this.texts == null) {
            return;
        }
        for (int i = 0; i < this.texts.length; ++i) {
            if (!(this.texts[i] instanceof PropertyInterface)) continue;
            ((PropertyInterface)this.texts[i]).cancelPropertyChanges(source);
        }
    }

    public int getNumberPendingProperties() {
        if (this.texts == null) {
            return 0;
        }
        int numPending = 0;
        for (int i = 0; i < this.texts.length; ++i) {
            if (!(this.texts[i] instanceof PropertyInterface)) continue;
            numPending += ((PropertyInterface)this.texts[i]).getNumberPendingProperties();
        }
        return numPending;
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        if (this.texts == null) {
            return null;
        }
        DynamicIntArray dia = new DynamicIntArray();
        for (int i = 0; i < this.texts.length; ++i) {
            if (!(this.texts[i] instanceof PropertyInterface)) continue;
            dia.add(((PropertyInterface)this.texts[i]).getPendingChanges(source));
        }
        return dia.getValidElements();
    }

    public Object getPropertyValue(int id) {
        return null;
    }

    public boolean hasUserSetValue(int id) {
        return false;
    }

    public boolean isPropertyPending(int id) {
        return false;
    }

    public boolean isPropertySupported(int id) {
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        return false;
    }
}

